/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RefreshJob
extends WorkspaceJob {
    private static final long UPDATE_DELAY = 200L;
    private boolean active = false;
    private final List fRequests;

    public RefreshJob() {
        super(Policy.bind("refresh.jobName"));
        this.setPriority(30);
        this.setSystem(true);
        this.setRule(ResourcesPlugin.getWorkspace().getRoot());
        this.fRequests = new ArrayList(1);
    }

    private synchronized void addRequest(IResource resource) {
        IPath toAdd = resource.getFullPath();
        int size = this.fRequests.size();
        for (int i = 0; i < size; ++i) {
            if (!((IResource)this.fRequests.get(i)).getFullPath().isPrefixOf(toAdd)) continue;
            return;
        }
        Iterator it = this.fRequests.iterator();
        while (it.hasNext()) {
            if (!toAdd.isPrefixOf(((IResource)it.next()).getFullPath())) continue;
            it.remove();
        }
        this.fRequests.add(resource);
    }

    private synchronized IResource[] getRequests() {
        IResource[] toRefresh = this.fRequests.toArray(new IResource[this.fRequests.size()]);
        this.fRequests.clear();
        return toRefresh;
    }

    public void refresh(IResource resource) {
        if (resource == null) {
            return;
        }
        this.addRequest(resource);
        if (this.active) {
            this.schedule(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        String msg = Policy.bind("refresh.refreshErr");
        MultiStatus errors = new MultiStatus("org.eclipse.core.resources", 1, msg, null);
        try {
            if (RefreshManager.DEBUG) {
                System.out.println("Auto-refresh:  starting refresh job");
            }
            IResource[] toRefresh = this.getRequests();
            monitor.beginTask(Policy.bind("refresh.task"), toRefresh.length);
            for (int i = 0; i < toRefresh.length; ++i) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    toRefresh[i].refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                catch (CoreException e) {
                    errors.merge(e.getStatus());
                }
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            monitor.done();
            if (RefreshManager.DEBUG) {
                System.out.println("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
            throw throwable;
        }
        monitor.done();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    public void start() {
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  enabling auto-refresh");
        }
        this.active = true;
    }

    public void stop() {
        if (this.active && RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  disabling auto-refresh");
        }
        this.active = false;
        this.cancel();
    }
}

