/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.help.WorkbenchHelp;

public class FocusOnSelectionAction
extends Action {
    private TypeHierarchyViewPart fViewPart;

    public FocusOnSelectionAction(TypeHierarchyViewPart part) {
        super(TypeHierarchyMessages.getString("FocusOnSelectionAction.label"));
        this.setDescription(TypeHierarchyMessages.getString("FocusOnSelectionAction.description"));
        this.setToolTipText(TypeHierarchyMessages.getString("FocusOnSelectionAction.tooltip"));
        this.fViewPart = part;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.focus_on_selection_action");
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fViewPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof IType) {
            this.fViewPart.setInputElement((IJavaElement)((IType)element));
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof IType) {
            IType type = (IType)element;
            this.setText(TypeHierarchyMessages.getFormattedString("FocusOnSelectionAction.label", JavaElementLabels.getTextLabel(type, 0)));
            return true;
        }
        return false;
    }
}

