/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.getString("DeleteAction.3"));
        this.setDescription(ReorgMessages.getString("DeleteAction.4"));
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.delete_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        try {
            Object[] elements = selection.toArray();
            JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
            this.setEnabled(processor.isApplicable());
        }
        catch (CoreException e) {
            if (JavaModelUtil.filterNotPresentException(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canDelegateToWorkbenchAction(IStructuredSelection selection) {
        return ReorgUtils.containsOnlyProjects(selection.toList());
    }

    private IAction createWorkbenchAction(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            Object[] elements = selection.toArray();
            DeleteRefactoring ref = this.createRefactoring(elements);
            UserInterfaceStarter starter = DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)ref);
            starter.activate((Refactoring)ref, this.getShell(), false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private DeleteRefactoring createRefactoring(Object[] elements) throws CoreException {
        JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
        return new DeleteRefactoring((DeleteProcessor)processor);
    }
}

