/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;

class TextSelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private TextSelectionConverter() {
    }

    public static IJavaElement[] codeResolve(JavaEditor editor, ITextSelection selection) throws JavaModelException {
        return TextSelectionConverter.codeResolve(TextSelectionConverter.getInput(editor), selection);
    }

    public static IJavaElement getElementAtOffset(JavaEditor editor, ITextSelection selection) throws JavaModelException {
        return TextSelectionConverter.getElementAtOffset(TextSelectionConverter.getInput(editor), selection);
    }

    private static IJavaElement getInput(JavaEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            ICompilationUnit cunit;
            if (input instanceof ICompilationUnit && (cunit = (ICompilationUnit)input).isWorkingCopy()) {
                ICompilationUnit iCompilationUnit = cunit;
                synchronized (iCompilationUnit) {
                    cunit.reconcile();
                }
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            IJavaElement ref;
            ICompilationUnit cunit = (ICompilationUnit)input;
            if (cunit.isWorkingCopy()) {
                ICompilationUnit iCompilationUnit = cunit;
                synchronized (iCompilationUnit) {
                    cunit.reconcile();
                }
            }
            if ((ref = cunit.getElementAt(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

