/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

class ImportRewriteManager {
    private final Map fImportRewrites;
    private final CodeGenerationSettings fPreferenceSettings;

    public ImportRewriteManager(CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(preferenceSettings);
        this.fPreferenceSettings = preferenceSettings;
        this.fImportRewrites = new HashMap();
    }

    public boolean hasImportEditFor(ICompilationUnit cu) throws JavaModelException {
        return this.fImportRewrites.containsKey(cu);
    }

    public ImportRewrite getImportRewrite(ICompilationUnit cu) throws CoreException {
        if (this.hasImportEditFor(cu)) {
            return (ImportRewrite)this.fImportRewrites.get(cu);
        }
        ImportRewrite edit = new ImportRewrite(cu);
        this.fImportRewrites.put(cu, edit);
        return edit;
    }

    public void addImportTo(String fullyQualifiedName, ICompilationUnit cu) throws CoreException {
        this.getImportRewrite(cu).addImport(fullyQualifiedName);
    }

    public void addImportTo(IType type, ICompilationUnit cu) throws CoreException {
        this.addImportTo(JavaModelUtil.getFullyQualifiedName(type), cu);
    }

    public void removeImportTo(IType type, ICompilationUnit cu) throws CoreException {
        this.removeImportTo(JavaModelUtil.getFullyQualifiedName(type), cu);
    }

    public void removeImportTo(String fullyQualifiedName, ICompilationUnit cu) throws CoreException {
        this.getImportRewrite(cu).removeImport(fullyQualifiedName);
    }

    public void clear() {
        this.fImportRewrites.clear();
    }
}

