/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class DeadlockDetector {
    private static int NO_STATE = 0;
    private static int WAITING_FOR_LOCK = -1;
    private static final int[][] EMPTY_MATRIX = new int[0][0];
    private int[][] graph = EMPTY_MATRIX;
    private final ArrayList locks = new ArrayList();
    private final ArrayList lockThreads = new ArrayList();
    private boolean resize = false;

    DeadlockDetector() {
    }

    private boolean addCycleThreads(ArrayList deadlockedThreads, Thread next) {
        Thread[] blocking = this.blockingThreads(next);
        if (blocking.length == 0) {
            return false;
        }
        boolean inCycle = false;
        for (int i = 0; i < blocking.length; ++i) {
            if (deadlockedThreads.contains(blocking[i])) {
                inCycle = true;
                continue;
            }
            deadlockedThreads.add(blocking[i]);
            if (this.addCycleThreads(deadlockedThreads, blocking[i])) {
                inCycle = true;
                continue;
            }
            deadlockedThreads.remove(blocking[i]);
        }
        return inCycle;
    }

    private Thread[] blockingThreads(Thread current) {
        ISchedulingRule lock = (ISchedulingRule)this.getWaitingLock(current);
        return this.getThreadsOwningLock(lock);
    }

    private boolean checkWaitCycles(int[] waitingThreads, int lockIndex) {
        for (int i = 0; i < this.graph.length; ++i) {
            if (this.graph[i][lockIndex] <= NO_STATE) continue;
            if (waitingThreads[i] > NO_STATE) {
                return true;
            }
            int n = i;
            waitingThreads[n] = waitingThreads[n] + 1;
            for (int j = 0; j < this.graph[i].length; ++j) {
                if (this.graph[i][j] != WAITING_FOR_LOCK || !this.checkWaitCycles(waitingThreads, j)) continue;
                return true;
            }
            int n2 = i;
            waitingThreads[n2] = waitingThreads[n2] - 1;
        }
        return false;
    }

    boolean contains(Thread t) {
        return this.lockThreads.contains(t);
    }

    private void fillPresentEntries(ISchedulingRule newLock, int lockIndex) {
        int i;
        int j;
        for (j = 0; j < this.locks.size(); ++j) {
            if (j == lockIndex || !newLock.isConflicting((ISchedulingRule)this.locks.get(j))) continue;
            for (i = 0; i < this.graph.length; ++i) {
                if (this.graph[i][j] <= NO_STATE || this.graph[i][lockIndex] != NO_STATE) continue;
                this.graph[i][lockIndex] = this.graph[i][j];
            }
        }
        for (j = 0; j < this.locks.size(); ++j) {
            if (j == lockIndex || !newLock.isConflicting((ISchedulingRule)this.locks.get(j))) continue;
            for (i = 0; i < this.graph.length; ++i) {
                if (this.graph[i][lockIndex] <= NO_STATE || this.graph[i][j] != NO_STATE) continue;
                this.graph[i][j] = this.graph[i][lockIndex];
            }
        }
    }

    private Object[] getOwnedLocks(Thread current) {
        ArrayList ownedLocks = new ArrayList(1);
        int index = this.indexOf(current, false);
        for (int j = 0; j < this.graph[index].length; ++j) {
            if (this.graph[index][j] <= NO_STATE) continue;
            ownedLocks.add(this.locks.get(j));
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no locks is part of a deadlock.");
        }
        return ownedLocks.toArray();
    }

    private Thread[] getThreadsInDeadlock(Thread cause) {
        ArrayList<Thread> deadlockedThreads = new ArrayList<Thread>(2);
        if (this.ownsLocks(cause)) {
            deadlockedThreads.add(cause);
        }
        this.addCycleThreads(deadlockedThreads, cause);
        return deadlockedThreads.toArray(new Thread[deadlockedThreads.size()]);
    }

    private Thread[] getThreadsOwningLock(ISchedulingRule rule) {
        if (rule == null) {
            return new Thread[0];
        }
        int lockIndex = this.indexOf(rule, false);
        ArrayList blocking = new ArrayList(1);
        for (int i = 0; i < this.graph.length; ++i) {
            if (this.graph[i][lockIndex] <= NO_STATE) continue;
            blocking.add(this.lockThreads.get(i));
        }
        if (blocking.size() == 0 && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is involved in deadlock but is not owned by any thread.");
        }
        if (blocking.size() > 1 && rule instanceof ILock && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is owned by more than 1 thread, but it is not a rule.");
        }
        return blocking.toArray(new Thread[blocking.size()]);
    }

    private Object getWaitingLock(Thread current) {
        int index = this.indexOf(current, false);
        for (int j = 0; j < this.graph[index].length; ++j) {
            if (this.graph[index][j] != WAITING_FOR_LOCK) continue;
            return this.locks.get(j);
        }
        return null;
    }

    private int indexOf(ISchedulingRule lock, boolean add) {
        int index = this.locks.indexOf(lock);
        if (index < 0 && add) {
            this.locks.add(lock);
            this.resize = true;
            index = this.locks.size() - 1;
        }
        return index;
    }

    private int indexOf(Thread owner, boolean add) {
        int index = this.lockThreads.indexOf(owner);
        if (index < 0 && add) {
            this.lockThreads.add(owner);
            this.resize = true;
            index = this.lockThreads.size() - 1;
        }
        return index;
    }

    boolean isEmpty() {
        return this.locks.size() == 0 && this.lockThreads.size() == 0 && this.graph.length == 0;
    }

    void lockAcquired(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, true);
        int threadIndex = this.indexOf(owner, true);
        if (this.resize) {
            this.resizeGraph();
        }
        if (this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
        }
        ArrayList<ISchedulingRule> conflicting = new ArrayList<ISchedulingRule>(1);
        int NUM_PASSES = 2;
        conflicting.add(lock);
        int[] nArray = this.graph[threadIndex];
        int n = lockIndex;
        nArray[n] = nArray[n] + 1;
        for (int i = 0; i < NUM_PASSES; ++i) {
            for (int k = 0; k < conflicting.size(); ++k) {
                ISchedulingRule current = (ISchedulingRule)conflicting.get(k);
                for (int j = 0; j < this.locks.size(); ++j) {
                    ISchedulingRule possible = (ISchedulingRule)this.locks.get(j);
                    if (!current.isConflicting(possible) || conflicting.contains(possible)) continue;
                    conflicting.add(possible);
                    int[] nArray2 = this.graph[threadIndex];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] + 1;
                }
            }
        }
    }

    void lockReleased(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Lock " + lock + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Thread " + owner.getName() + " already released lock " + lock);
            }
            return;
        }
        if (lock instanceof ILock && this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
            return;
        }
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            if (!lock.isConflicting((ISchedulingRule)this.locks.get(j)) && (lock instanceof ILock || this.locks.get(j) instanceof ILock || this.graph[threadIndex][j] <= NO_STATE)) continue;
            if (this.graph[threadIndex][j] == NO_STATE) {
                if (!JobManager.DEBUG_LOCKS) continue;
                System.out.println("[lockReleased] More releases than acquires for thread " + owner.getName() + " and lock " + lock);
                continue;
            }
            int[] nArray = this.graph[threadIndex];
            int n = j;
            nArray[n] = nArray[n] - 1;
        }
        if (this.graph[threadIndex][lockIndex] == NO_STATE) {
            this.reduceGraph(threadIndex, lock);
        }
    }

    void lockReleasedCompletely(Thread owner, ISchedulingRule rule) {
        int ruleIndex = this.indexOf(rule, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Lock " + rule + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (ruleIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Thread " + owner.getName() + " already released lock " + rule);
            }
            return;
        }
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            if (this.locks.get(j) instanceof ILock || this.graph[threadIndex][j] <= NO_STATE) continue;
            this.graph[threadIndex][j] = NO_STATE;
        }
        this.reduceGraph(threadIndex, rule);
    }

    Deadlock lockWaitStart(Thread client, ISchedulingRule lock) {
        this.setToWait(client, lock, false);
        int lockIndex = this.indexOf(lock, false);
        int[] temp = new int[this.lockThreads.size()];
        if (!this.checkWaitCycles(temp, lockIndex)) {
            return null;
        }
        Thread[] threads = this.getThreadsInDeadlock(client);
        Thread candidate = this.resolutionCandidate(threads);
        ISchedulingRule[] locks = this.realLocksForThread(candidate);
        Deadlock deadlock = new Deadlock(threads, locks, candidate);
        if (JobManager.DEBUG_LOCKS) {
            this.reportDeadlock(deadlock);
        }
        if (JobManager.DEBUG_DEADLOCK) {
            throw new IllegalStateException("Deadlock detected. Caused by thread " + client.getName() + '.');
        }
        for (int i = 0; i < locks.length; ++i) {
            this.setToWait(deadlock.getCandidate(), locks[i], true);
        }
        return deadlock;
    }

    void lockWaitStop(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Thread " + owner.getName() + " was already removed.");
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Lock " + lock + " was already removed.");
            }
            return;
        }
        if (this.graph[threadIndex][lockIndex] != WAITING_FOR_LOCK) {
            Assert.isTrue(false, "Thread " + owner.getName() + " was not waiting for lock " + lock.toString() + " so it could not time out.");
        }
        this.graph[threadIndex][lockIndex] = NO_STATE;
        this.reduceGraph(threadIndex, lock);
    }

    private boolean ownsLocks(Thread cause) {
        int threadIndex = this.indexOf(cause, false);
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            if (this.graph[threadIndex][j] <= NO_STATE) continue;
            return true;
        }
        return false;
    }

    private boolean ownsRealLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            Object lock;
            if (this.graph[threadIndex][j] <= NO_STATE || !((lock = this.locks.get(j)) instanceof ILock)) continue;
            return true;
        }
        return false;
    }

    private boolean ownsRuleLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            Object lock;
            if (this.graph[threadIndex][j] <= NO_STATE || (lock = this.locks.get(j)) instanceof ILock) continue;
            return true;
        }
        return false;
    }

    private ISchedulingRule[] realLocksForThread(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        ArrayList ownedLocks = new ArrayList(1);
        for (int j = 0; j < this.graph[threadIndex].length; ++j) {
            if (this.graph[threadIndex][j] <= NO_STATE || !(this.locks.get(j) instanceof ILock)) continue;
            ownedLocks.add(this.locks.get(j));
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no real locks was chosen to resolve deadlock.");
        }
        return ownedLocks.toArray(new ISchedulingRule[ownedLocks.size()]);
    }

    private void reduceGraph(int row, ISchedulingRule lock) {
        int j;
        int numLocks = this.locks.size();
        boolean[] emptyColumns = new boolean[numLocks];
        for (int j2 = 0; j2 < numLocks; ++j2) {
            if (!lock.isConflicting((ISchedulingRule)this.locks.get(j2)) && this.locks.get(j2) instanceof ILock) continue;
            emptyColumns[j2] = true;
        }
        boolean rowEmpty = true;
        int numEmpty = 0;
        for (j = 0; j < this.graph[row].length; ++j) {
            if (this.graph[row][j] == NO_STATE) continue;
            rowEmpty = false;
            break;
        }
        for (j = emptyColumns.length - 1; j >= 0; --j) {
            for (int i = 0; i < this.graph.length; ++i) {
                if (!emptyColumns[j] || this.graph[i][j] == NO_STATE) continue;
                emptyColumns[j] = false;
                break;
            }
            if (!emptyColumns[j]) continue;
            this.locks.remove(j);
            ++numEmpty;
        }
        if (numEmpty == 0 && !rowEmpty) {
            return;
        }
        if (rowEmpty) {
            this.lockThreads.remove(row);
        }
        int numThreads = this.lockThreads.size();
        numLocks = this.locks.size();
        if (numThreads == 0 && numLocks == 0) {
            this.graph = EMPTY_MATRIX;
            return;
        }
        int[][] tempGraph = new int[numThreads][numLocks];
        int numRowsSkipped = 0;
        block4: for (int i = 0; !(i >= this.graph.length - numRowsSkipped || i == row && rowEmpty && i >= this.graph.length - ++numRowsSkipped); ++i) {
            int numColsSkipped = 0;
            for (int j3 = 0; j3 < this.graph[i].length - numColsSkipped; ++j3) {
                while (emptyColumns[j3 + numColsSkipped] && j3 < this.graph[i].length - ++numColsSkipped) {
                }
                if (j3 >= this.graph[i].length - numColsSkipped) continue block4;
                tempGraph[i][j3] = this.graph[i + numRowsSkipped][j3 + numColsSkipped];
            }
        }
        this.graph = tempGraph;
        Assert.isTrue(numThreads == this.graph.length, "Rows and threads don't match.");
        Assert.isTrue(numLocks == (this.graph.length > 0 ? this.graph[0].length : 0), "Columns and locks don't match.");
    }

    private void reportDeadlock(Deadlock deadlock) {
        String msg = "Deadlock detected. All locks owned by thread " + deadlock.getCandidate().getName() + " will be suspended.";
        MultiStatus main = new MultiStatus("org.eclipse.core.runtime", 2, msg, new IllegalStateException());
        Thread[] threads = deadlock.getThreads();
        for (int i = 0; i < threads.length; ++i) {
            Object[] ownedLocks = this.getOwnedLocks(threads[i]);
            Object waitLock = this.getWaitingLock(threads[i]);
            StringBuffer buf = new StringBuffer("Thread ");
            buf.append(threads[i].getName());
            buf.append(" has locks: ");
            for (int j = 0; j < ownedLocks.length; ++j) {
                buf.append(ownedLocks[j]);
                buf.append(j < ownedLocks.length - 1 ? ", " : " ");
            }
            buf.append("and is waiting for lock ");
            buf.append(waitLock);
            Status child = new Status(4, "org.eclipse.core.runtime", 2, buf.toString(), null);
            main.add(child);
        }
        InternalPlatform.getDefault().log(main);
    }

    private void resizeGraph() {
        int newRows = this.lockThreads.size();
        int newCols = this.locks.size();
        if (newRows == 0 && newCols == 0) {
            this.graph = EMPTY_MATRIX;
            return;
        }
        int[][] tempGraph = new int[newRows][newCols];
        for (int i = 0; i < this.graph.length; ++i) {
            System.arraycopy(this.graph[i], 0, tempGraph[i], 0, this.graph[i].length);
        }
        this.graph = tempGraph;
        this.resize = false;
    }

    private Thread resolutionCandidate(Thread[] candidates) {
        int i;
        for (i = 0; i < candidates.length; ++i) {
            if (this.ownsRuleLocks(candidates[i])) continue;
            return candidates[i];
        }
        for (i = 0; i < candidates.length; ++i) {
            if (!this.ownsRealLocks(candidates[i])) continue;
            return candidates[i];
        }
        return candidates[0];
    }

    private void setToWait(Thread owner, ISchedulingRule lock, boolean suspend) {
        boolean needTransfer = false;
        if (!suspend && !(lock instanceof ILock)) {
            needTransfer = true;
        }
        int lockIndex = this.indexOf(lock, !suspend);
        int threadIndex = this.indexOf(owner, !suspend);
        if (this.resize) {
            this.resizeGraph();
        }
        this.graph[threadIndex][lockIndex] = WAITING_FOR_LOCK;
        if (needTransfer) {
            this.fillPresentEntries(lock, lockIndex);
        }
    }

    public void toDebugString() {
        System.out.println(" :: ");
        for (int j = 0; j < this.locks.size(); ++j) {
            System.out.print(" " + this.locks.get(j) + ',');
        }
        System.out.println();
        for (int i = 0; i < this.graph.length; ++i) {
            System.out.print(" " + ((Thread)this.lockThreads.get(i)).getName() + " : ");
            for (int j = 0; j < this.graph[i].length; ++j) {
                System.out.print(" " + this.graph[i][j] + ',');
            }
            System.out.println();
        }
        System.out.println("-------");
    }
}

