/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModuleSelectionPage
extends CVSWizardPage {
    Button useProjectNameButton;
    Button useSpecifiedNameButton;
    private Button selectModuleButton;
    Text text;
    TreeViewer moduleList;
    String moduleName;
    private IProject project;
    private ICVSRepositoryLocation location;
    private boolean badLocation = false;
    private String helpContextId;
    private boolean supportsMultiSelection;
    private boolean isFetchingModules = false;
    private Object fetchingModulesLock = new Object();

    public ModuleSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void setHelpContxtId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        if (this.helpContextId != null) {
            WorkbenchHelp.setHelp((Control)composite, (String)this.helpContextId);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ModuleSelectionPage.this.updateEnablements(false);
            }
        };
        if (this.project != null) {
            this.useProjectNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.moduleIsProject"), 2);
            this.useProjectNameButton.addListener(13, listener);
        }
        this.useSpecifiedNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.specifyModule"), 1);
        this.useSpecifiedNameButton.addListener(13, listener);
        this.text = ModuleSelectionPage.createTextField(composite);
        this.text.addListener(24, listener);
        this.selectModuleButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.2"), 2);
        this.selectModuleButton.addListener(13, listener);
        this.moduleList = this.createModuleTree(composite, 2);
        if (this.useProjectNameButton != null) {
            this.useProjectNameButton.setSelection(true);
            this.useSpecifiedNameButton.setSelection(false);
        } else {
            this.useSpecifiedNameButton.setSelection(true);
        }
        this.selectModuleButton.setSelection(false);
        this.updateEnablements(false);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.useProjectNameButton != null && this.useProjectNameButton.getSelection()) {
                this.useProjectNameButton.setFocus();
            } else if (this.useSpecifiedNameButton.getSelection()) {
                this.text.setFocus();
            } else {
                this.moduleList.getControl().setFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateEnablements(boolean updateModulesList) {
        block22: {
            if (this.useProjectNameButton != null && this.useProjectNameButton.getSelection()) {
                this.text.setEnabled(false);
                this.moduleList.getControl().setEnabled(false);
                this.moduleName = null;
                this.setPageComplete(true);
                return;
            }
            if (this.useSpecifiedNameButton.getSelection()) {
                this.text.setEnabled(true);
                this.moduleList.getControl().setEnabled(false);
                this.moduleName = this.text.getText();
                if (this.moduleName.length() == 0) {
                    this.moduleName = null;
                    this.setPageComplete(false);
                    return;
                }
                this.setPageComplete(true);
                return;
            }
            if (this.badLocation) return;
            this.text.setEnabled(false);
            this.moduleList.getControl().setEnabled(true);
            this.moduleName = null;
            if (this.moduleList.getInput() == null || updateModulesList) {
                Object object;
                boolean fetchModules = false;
                try {
                    block21: {
                        try {
                            Object object2 = this.fetchingModulesLock;
                            synchronized (object2) {
                                if (!this.isFetchingModules) {
                                    fetchModules = true;
                                    this.isFetchingModules = true;
                                }
                                if (!fetchModules) break block21;
                            }
                            this.getContainer().run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        ModuleSelectionPage.this.location.validateConnection(monitor);
                                    }
                                    catch (CVSException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            this.setModuleListInput();
                        }
                        catch (InvocationTargetException e) {
                            if (!this.badLocation) {
                                this.badLocation = true;
                                CVSUIPlugin.openError(this.getShell(), null, null, e);
                                this.setModuleListInput();
                            }
                            Object var6_7 = null;
                            Object object2 = this.fetchingModulesLock;
                            synchronized (object2) {
                                if (fetchModules) {
                                    this.isFetchingModules = false;
                                }
                                break block22;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Object var6_8 = null;
                            Object object4 = this.fetchingModulesLock;
                            synchronized (object4) {
                                if (fetchModules) {
                                    this.isFetchingModules = false;
                                }
                                break block22;
                            }
                        }
                    }
                    Object var6_6 = null;
                    object = this.fetchingModulesLock;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    Object object5 = this.fetchingModulesLock;
                    synchronized (object5) {
                        if (!fetchModules) throw throwable;
                        this.isFetchingModules = false;
                        throw throwable;
                    }
                }
                synchronized (object) {
                    if (fetchModules) {
                        this.isFetchingModules = false;
                    }
                }
            }
        }
        this.setPageComplete(this.internalGetSelectedModules().length > 0);
    }

    private ICVSRemoteFolder[] internalGetSelectedModules() {
        if (this.moduleList != null && this.moduleList.getControl().isEnabled()) {
            ISelection selection = this.moduleList.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                ArrayList result = new ArrayList();
                Iterator iter = ss.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof ICVSRemoteFolder)) continue;
                    result.add(element);
                }
                return result.toArray(new ICVSRemoteFolder[result.size()]);
            }
        } else {
            ICVSRemoteFolder folder = null;
            if (this.moduleName != null) {
                folder = this.internalCreateModuleHandle(this.moduleName);
            } else if (this.project != null) {
                folder = this.internalCreateModuleHandle(this.project.getName());
            }
            if (folder != null) {
                return new ICVSRemoteFolder[]{folder};
            }
        }
        return new ICVSRemoteFolder[0];
    }

    private ICVSRemoteFolder internalCreateModuleHandle(String name) {
        ICVSRepositoryLocation location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getRemoteFolder(name, CVSTag.DEFAULT);
    }

    public ICVSRemoteFolder getSelectedModule() {
        ICVSRemoteFolder[] selectedModules = this.getSelectedModules();
        if (selectedModules.length > 0) {
            return selectedModules[0];
        }
        return null;
    }

    public ICVSRemoteFolder[] getSelectedModules() {
        final ICVSRemoteFolder[][] folder = new ICVSRemoteFolder[][]{null};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                folder[0] = ModuleSelectionPage.this.internalGetSelectedModules();
            }
        });
        return folder[0];
    }

    private TreeViewer createModuleTree(Composite composite, int horizontalSpan) {
        Tree tree = new Tree(composite, (this.supportsMultiSelection ? 2 : 4) | 0x800);
        GridData data = new GridData(1808);
        data.horizontalSpan = horizontalSpan;
        tree.setLayoutData((Object)data);
        TreeViewer result = new TreeViewer(tree){

            public boolean isExpandable(Object element) {
                ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
                if (cp == null) {
                    return false;
                }
                return cp.hasChildren(element);
            }
        };
        result.setContentProvider((IContentProvider)new RemoteContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof ICVSRemoteFile);
            }
        });
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleSelectionPage.this.updateEnablements(false);
                ICVSRemoteFolder[] modules = ModuleSelectionPage.this.internalGetSelectedModules();
                if (modules.length == 1) {
                    ICVSRemoteFolder selectedModule = modules[0];
                    String repositoryRelativePath = selectedModule.getRepositoryRelativePath();
                    if (!repositoryRelativePath.equals("CVSROOT/Emptydir")) {
                        ModuleSelectionPage.this.text.setText(repositoryRelativePath);
                    }
                } else {
                    ModuleSelectionPage.this.text.setText("");
                }
            }
        });
        result.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ModuleSelectionPage.this.getSelectedModule() != null) {
                    ModuleSelectionPage.this.getContainer().showPage(ModuleSelectionPage.this.getNextPage());
                }
            }
        });
        result.setSorter((ViewerSorter)new RepositorySorter());
        return result;
    }

    private void setModuleListInput() {
        ICVSRepositoryLocation location = this.getLocation();
        if (location == null || this.badLocation) {
            return;
        }
        this.moduleList.setInput((Object)location.getRemoteFolder("", CVSTag.DEFAULT));
    }

    private ICVSRepositoryLocation getLocation() {
        return this.location;
    }

    public void setLocation(ICVSRepositoryLocation location) {
        boolean refresh = location != null && !location.equals(this.location);
        this.location = location;
        this.badLocation = false;
        if (this.moduleList != null) {
            this.updateEnablements(refresh);
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setSupportsMultiSelection(boolean supportsMultiSelection) {
        this.supportsMultiSelection = supportsMultiSelection;
    }
}

