/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LaunchViewer
extends TreeViewer {
    public void add(Object parentElement, Object childElement) {
        if (this.doFindItem(childElement) == null) {
            super.add(parentElement, childElement);
        }
    }

    public LaunchViewer(Composite parent) {
        super(new Tree(parent, 2));
        this.setUseHashlookup(true);
    }

    protected void updateStackFrameImages(IThread parentThread) {
        Widget parentItem = this.findItem(parentThread);
        if (parentItem != null) {
            Item[] items = this.getItems((Item)parentItem);
            for (int i = 0; i < items.length; ++i) {
                this.updateTreeItemImage((TreeItem)items[i]);
            }
        }
    }

    protected void updateTreeItemImage(TreeItem treeItem) {
        ILabelProvider provider = (ILabelProvider)this.getLabelProvider();
        Image image = provider.getImage(treeItem.getData());
        if (image != null) {
            treeItem.setImage(image);
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        ILabelProvider provider = (ILabelProvider)this.getLabelProvider();
        String text = provider.getText(element);
        if ("".equals(item.getText()) || !"...".equals(text)) {
            item.setText(text);
        }
        Image image = provider.getImage(element);
        if (item.getImage() != image) {
            item.setImage(image);
        }
        if (provider instanceof IColorProvider) {
            IColorProvider cp = (IColorProvider)provider;
            TreeItem treeItem = (TreeItem)item;
            treeItem.setForeground(cp.getForeground(element));
            treeItem.setBackground(cp.getBackground(element));
        }
    }

    public void refresh(Object element) {
        this.getControl().setRedraw(false);
        super.refresh(element);
        this.getControl().setRedraw(true);
    }
}

