/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.osgi.framework.Bundle;

public class MarkerAnnotationPreferences {
    private List fFragments;
    private List fPreferences;
    static /* synthetic */ Class class$org$eclipse$ui$editors$text$EditorsUI;

    public static void initializeDefaultValues(IPreferenceStore store) {
        boolean ignoreAnnotationsPrefPage = store.getBoolean("useAnnotationsPrefPage");
        boolean ignoreQuickDiffPrefPage = store.getBoolean("useQuickDiffPrefPage");
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (ignoreAnnotationsPrefPage && info.isIncludeOnPreferencePage() && MarkerAnnotationPreferences.isComplete(info) || ignoreQuickDiffPrefPage && (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") || info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") || info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion"))) continue;
            store.setDefault(info.getTextPreferenceKey(), info.getTextPreferenceValue());
            store.setDefault(info.getOverviewRulerPreferenceKey(), info.getOverviewRulerPreferenceValue());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setDefault(info.getVerticalRulerPreferenceKey(), info.getVerticalRulerPreferenceValue());
            }
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)info.getColorPreferenceKey(), (RGB)info.getColorPreferenceValue());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setDefault(info.getShowInNextPrevDropdownToolbarActionKey(), info.isShowInNextPrevDropdownToolbarAction());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setDefault(info.getIsGoToNextNavigationTargetKey(), info.isGoToNextNavigationTarget());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setDefault(info.getIsGoToPreviousNavigationTargetKey(), info.isGoToPreviousNavigationTarget());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setDefault(info.getHighlightPreferenceKey(), info.getHighlightPreferenceValue());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setDefault(info.getTextStylePreferenceKey(), info.getTextStyleValue());
        }
    }

    public static void useAnnotationsPreferencePage(IPreferenceStore store) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        store.putValue("useAnnotationsPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.isIncludeOnPreferencePage() || !MarkerAnnotationPreferences.isComplete(info)) continue;
            store.setToDefault(info.getTextPreferenceKey());
            store.setToDefault(info.getOverviewRulerPreferenceKey());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setToDefault(info.getVerticalRulerPreferenceKey());
            }
            store.setToDefault(info.getColorPreferenceKey());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setToDefault(info.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToNextNavigationTargetKey());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToPreviousNavigationTargetKey());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setToDefault(info.getHighlightPreferenceKey());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setToDefault(info.getTextStylePreferenceKey());
        }
    }

    public static void useQuickDiffPreferencePage(IPreferenceStore store) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        store.putValue("useQuickDiffPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            store.setToDefault(info.getTextPreferenceKey());
            store.setToDefault(info.getOverviewRulerPreferenceKey());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setToDefault(info.getVerticalRulerPreferenceKey());
            }
            store.setToDefault(info.getColorPreferenceKey());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setToDefault(info.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToNextNavigationTargetKey());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToPreviousNavigationTargetKey());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setToDefault(info.getHighlightPreferenceKey());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setToDefault(info.getTextStylePreferenceKey());
        }
    }

    private static void checkAccess() throws IllegalStateException {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        if (!elements[2].getClassName().equals((class$org$eclipse$ui$editors$text$EditorsUI == null ? (class$org$eclipse$ui$editors$text$EditorsUI = MarkerAnnotationPreferences.class$("org.eclipse.ui.editors.text.EditorsUI")) : class$org$eclipse$ui$editors$text$EditorsUI).getName()) && !elements[3].getClassName().equals((class$org$eclipse$ui$editors$text$EditorsUI == null ? (class$org$eclipse$ui$editors$text$EditorsUI = MarkerAnnotationPreferences.class$("org.eclipse.ui.editors.text.EditorsUI")) : class$org$eclipse$ui$editors$text$EditorsUI).getName())) {
            throw new IllegalStateException();
        }
    }

    public List getAnnotationPreferences() {
        if (this.fPreferences == null) {
            this.initialize();
        }
        return this.fPreferences;
    }

    public List getAnnotationPreferenceFragments() {
        if (this.fFragments == null) {
            this.initialize();
        }
        return this.fFragments;
    }

    private void initialize() {
        this.fFragments = new ArrayList(2);
        this.fPreferences = new ArrayList(2);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerAnnotationSpecification");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            for (int i = 0; i < elements.length; ++i) {
                AnnotationPreference spec = this.createSpec(elements[i]);
                if (spec != null) {
                    this.fFragments.add(spec);
                }
                if (!MarkerAnnotationPreferences.isComplete(spec)) continue;
                this.fPreferences.add(spec);
            }
        }
        final Collator collator = Collator.getInstance();
        Collections.sort(this.fFragments, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                AnnotationPreference ap1 = (AnnotationPreference)o1;
                AnnotationPreference ap2 = (AnnotationPreference)o2;
                String label1 = ap1.getPreferenceLabel();
                String label2 = ap2.getPreferenceLabel();
                if (label1 == null && label2 == null) {
                    return 0;
                }
                if (label1 == null) {
                    return -1;
                }
                if (label2 == null) {
                    return 1;
                }
                return collator.compare(label1, label2);
            }
        });
    }

    private static boolean isComplete(AnnotationPreference spec) {
        return spec.getColorPreferenceKey() != null && spec.getColorPreferenceValue() != null && spec.getTextPreferenceKey() != null && spec.getOverviewRulerPreferenceKey() != null;
    }

    private AnnotationPreference createSpec(IConfigurationElement element) {
        boolean b;
        int i;
        AnnotationPreference info = new AnnotationPreference();
        String s = element.getAttribute("annotationType");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setAnnotationType((Object)s);
        s = element.getAttribute("label");
        if (s != null && s.trim().length() > 0) {
            info.setPreferenceLabel(s);
        }
        if ((s = element.getAttribute("markerType")) != null && s.trim().length() > 0) {
            info.setMarkerType(s);
        }
        if ((s = element.getAttribute("markerSeverity")) != null && s.trim().length() > 0) {
            i = StringConverter.asInt((String)s, (int)0);
            info.setSeverity(i);
        }
        if ((s = element.getAttribute("textPreferenceKey")) != null && s.trim().length() > 0) {
            info.setTextPreferenceKey(s);
        }
        if ((s = element.getAttribute("textPreferenceValue")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setTextPreferenceValue(b);
        }
        if ((s = element.getAttribute("highlightPreferenceKey")) != null && s.trim().length() > 0) {
            info.setHighlightPreferenceKey(s);
        }
        if ((s = element.getAttribute("highlightPreferenceValue")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setHighlightPreferenceValue(b);
        }
        if ((s = element.getAttribute("overviewRulerPreferenceKey")) != null && s.trim().length() > 0) {
            info.setOverviewRulerPreferenceKey(s);
        }
        if ((s = element.getAttribute("overviewRulerPreferenceValue")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setOverviewRulerPreferenceValue(b);
        }
        if ((s = element.getAttribute("verticalRulerPreferenceKey")) != null && s.trim().length() > 0) {
            info.setVerticalRulerPreferenceKey(s);
        }
        if ((s = element.getAttribute("verticalRulerPreferenceValue")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)true);
            info.setVerticalRulerPreferenceValue(b);
        }
        if ((s = element.getAttribute("colorPreferenceKey")) != null && s.trim().length() > 0) {
            info.setColorPreferenceKey(s);
        }
        if ((s = element.getAttribute("colorPreferenceValue")) != null && s.trim().length() > 0) {
            RGB rgb = StringConverter.asRGB((String)s);
            info.setColorPreferenceValue(rgb == null ? new RGB(0, 0, 0) : rgb);
        }
        if ((s = element.getAttribute("presentationLayer")) != null && s.trim().length() > 0) {
            i = StringConverter.asInt((String)s, (int)0);
            info.setPresentationLayer(i);
        }
        if ((s = element.getAttribute("contributesToHeader")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setContributesToHeader(b);
        }
        if ((s = element.getAttribute("showInNextPrevDropdownToolbarActionKey")) != null && s.trim().length() > 0) {
            info.setShowInNextPrevDropdownToolbarActionKey(s);
        }
        if ((s = element.getAttribute("showInNextPrevDropdownToolbarAction")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setShowInNextPrevDropdownToolbarAction(b);
        }
        if ((s = element.getAttribute("isGoToNextNavigationTargetKey")) != null && s.trim().length() > 0) {
            info.setIsGoToNextNavigationTargetKey(s);
        }
        if ((s = element.getAttribute("isGoToNextNavigationTarget")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setIsGoToNextNavigationTarget(b);
        }
        if ((s = element.getAttribute("isGoToPreviousNavigationTargetKey")) != null && s.trim().length() > 0) {
            info.setIsGoToPreviousNavigationTargetKey(s);
        }
        if ((s = element.getAttribute("isGoToPreviousNavigationTarget")) != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setIsGoToPreviousNavigationTarget(b);
        }
        if ((s = element.getAttribute("symbolicIcon")) != null && s.trim().length() > 0) {
            info.setSymbolicImageName(s);
        }
        if ((s = element.getAttribute("icon")) != null && s.trim().length() > 0) {
            info.setImageDescriptor(this.getImageDescriptor(s, element));
        }
        if ((s = element.getAttribute("annotationImageProvider")) != null && s.trim().length() > 0) {
            info.setAnnotationImageProviderData(element, "annotationImageProvider");
        }
        if ((s = element.getAttribute("textStylePreferenceKey")) != null && s.trim().length() > 0) {
            info.setTextStylePreferenceKey(s);
        }
        if ((s = element.getAttribute("textStylePreferenceValue")) != null && s.trim().length() > 0) {
            if ("BOX".equals(s) || "IBEAM".equals(s) || "SQUIGGLES".equals(s) || "UNDERLINE".equals(s)) {
                info.setTextStyleValue(s);
            } else {
                info.setTextStyleValue("NONE");
            }
        }
        info.setIncludeOnPreferencePage((s = element.getAttribute("includeOnPreferencePage")) == null || StringConverter.asBoolean((String)s, (boolean)true));
        return info;
    }

    private ImageDescriptor getImageDescriptor(String iconPath, IConfigurationElement element) {
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)new URL(bundle.getEntry("/"), iconPath));
        }
        catch (MalformedURLException x) {
            EditorsPlugin.log(x);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

