/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class InitializationFlowContext
extends ExceptionHandlingFlowContext {
    public int exceptionCount;
    public TypeBinding[] thrownExceptions = new TypeBinding[5];
    public ASTNode[] exceptionThrowers = new ASTNode[5];
    public FlowInfo[] exceptionThrowerFlowInfos = new FlowInfo[5];

    public InitializationFlowContext(FlowContext parent, ASTNode associatedNode, BlockScope scope) {
        super(parent, associatedNode, TypeConstants.NoExceptions, scope, FlowInfo.DEAD_END);
    }

    public void checkInitializerExceptions(BlockScope currentScope, FlowContext initializerContext, FlowInfo flowInfo) {
        for (int i = 0; i < this.exceptionCount; ++i) {
            initializerContext.checkExceptionHandlers(this.thrownExceptions[i], this.exceptionThrowers[i], this.exceptionThrowerFlowInfos[i], currentScope);
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Initialization flow context");
        for (int i = 0; i < this.exceptionCount; ++i) {
            buffer.append('[').append(this.thrownExceptions[i].readableName());
            buffer.append('-').append(this.exceptionThrowerFlowInfos[i].toString()).append(']');
        }
        return buffer.toString();
    }

    public void recordHandlingException(ReferenceBinding exceptionType, UnconditionalFlowInfo flowInfo, TypeBinding raisedException, ASTNode invocationSite, boolean wasMasked) {
        int size = this.thrownExceptions.length;
        if (this.exceptionCount == size) {
            this.thrownExceptions = new TypeBinding[size * 2];
            System.arraycopy(this.thrownExceptions, 0, this.thrownExceptions, 0, size);
            this.exceptionThrowers = new ASTNode[size * 2];
            System.arraycopy(this.exceptionThrowers, 0, this.exceptionThrowers, 0, size);
            this.exceptionThrowerFlowInfos = new FlowInfo[size * 2];
            System.arraycopy(this.exceptionThrowerFlowInfos, 0, this.exceptionThrowerFlowInfos, 0, size);
        }
        this.thrownExceptions[this.exceptionCount] = raisedException;
        this.exceptionThrowers[this.exceptionCount] = invocationSite;
        this.exceptionThrowerFlowInfos[this.exceptionCount++] = flowInfo.copy();
    }
}

