/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BatchOperation;
import org.eclipse.jdt.internal.core.BufferFactoryWrapper;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.osgi.framework.BundleContext;

public final class JavaCore
extends Plugin {
    private static Plugin JAVA_CORE_PLUGIN = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.core";
    public static final String BUILDER_ID = "org.eclipse.jdt.core.javabuilder";
    public static final String MODEL_ID = "org.eclipse.jdt.core.javamodel";
    public static final String NATURE_ID = "org.eclipse.jdt.core.javanature";
    protected static final String ATT_HANDLE_ID = "org.eclipse.jdt.internal.core.JavaModelManager.handleId";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.eclipse.jdt.USER_LIBRARY";
    public static final String COMPILER_LOCAL_VARIABLE_ATTR = "org.eclipse.jdt.core.compiler.debug.localVariable";
    public static final String COMPILER_LINE_NUMBER_ATTR = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    public static final String COMPILER_SOURCE_FILE_ATTR = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    public static final String COMPILER_CODEGEN_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    public static final String COMPILER_CODEGEN_TARGET_PLATFORM = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String COMPILER_CODEGEN_INLINE_JSR_BYTECODE = "org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode";
    public static final String COMPILER_DOC_COMMENT_SUPPORT = "org.eclipse.jdt.core.compiler.doc.comment.support";
    public static final String COMPILER_PB_UNREACHABLE_CODE = "org.eclipse.jdt.core.compiler.problem.unreachableCode";
    public static final String COMPILER_PB_INVALID_IMPORT = "org.eclipse.jdt.core.compiler.problem.invalidImport";
    public static final String COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    public static final String COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    public static final String COMPILER_PB_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    public static final String COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    public static final String COMPILER_PB_DEPRECATION_WHEN_OVERRIDING_DEPRECATED_METHOD = "org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod";
    public static final String COMPILER_PB_HIDDEN_CATCH_BLOCK = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    public static final String COMPILER_PB_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String COMPILER_PB_UNUSED_PARAMETER = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String COMPILER_PB_UNUSED_IMPORT = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String COMPILER_PB_SYNTHETIC_ACCESS_EMULATION = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    public static final String COMPILER_PB_NON_NLS_STRING_LITERAL = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String COMPILER_PB_ASSERT_IDENTIFIER = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    public static final String COMPILER_PB_STATIC_ACCESS_RECEIVER = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    public static final String COMPILER_PB_INDIRECT_STATIC_ACCESS = "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess";
    public static final String COMPILER_PB_NO_EFFECT_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    public static final String COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String COMPILER_PB_UNUSED_PRIVATE_MEMBER = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    public static final String COMPILER_PB_LOCAL_VARIABLE_HIDING = "org.eclipse.jdt.core.compiler.problem.localVariableHiding";
    public static final String COMPILER_PB_SPECIAL_PARAMETER_HIDING_FIELD = "org.eclipse.jdt.core.compiler.problem.specialParameterHidingField";
    public static final String COMPILER_PB_FIELD_HIDING = "org.eclipse.jdt.core.compiler.problem.fieldHiding";
    public static final String COMPILER_PB_POSSIBLE_ACCIDENTAL_BOOLEAN_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment";
    public static final String COMPILER_PB_EMPTY_STATEMENT = "org.eclipse.jdt.core.compiler.problem.emptyStatement";
    public static final String COMPILER_PB_BOOLEAN_METHOD_THROWING_EXCEPTION = "org.eclipse.jdt.core.compiler.problem.booleanMethodThrowingException";
    public static final String COMPILER_PB_UNNECESSARY_TYPE_CHECK = "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck";
    public static final String COMPILER_PB_UNNECESSARY_ELSE = "org.eclipse.jdt.core.compiler.problem.unnecessaryElse";
    public static final String COMPILER_PB_UNDOCUMENTED_EMPTY_BLOCK = "org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock";
    public static final String COMPILER_PB_FINALLY_BLOCK_NOT_COMPLETING = "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally";
    public static final String COMPILER_PB_UNUSED_DECLARED_THROWN_EXCEPTION = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException";
    public static final String COMPILER_PB_UNUSED_DECLARED_THROWN_EXCEPTION_WHEN_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding";
    public static final String COMPILER_PB_UNQUALIFIED_FIELD_ACCESS = "org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess";
    public static final String COMPILER_PB_INVALID_JAVADOC = "org.eclipse.jdt.core.compiler.problem.invalidJavadoc";
    public static final String COMPILER_PB_INVALID_JAVADOC_TAGS = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTags";
    public static final String COMPILER_PB_INVALID_JAVADOC_TAGS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility";
    public static final String COMPILER_PB_MISSING_JAVADOC_TAGS = "org.eclipse.jdt.core.compiler.problem.missingJavadocTags";
    public static final String COMPILER_PB_MISSING_JAVADOC_TAGS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility";
    public static final String COMPILER_PB_MISSING_JAVADOC_TAGS_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding";
    public static final String COMPILER_PB_MISSING_JAVADOC_COMMENTS = "org.eclipse.jdt.core.compiler.problem.missingJavadocComments";
    public static final String COMPILER_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility";
    public static final String COMPILER_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding";
    public static final String COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    public static final String COMPILER_PB_MAX_PER_UNIT = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    public static final String COMPILER_SOURCE = "org.eclipse.jdt.core.compiler.source";
    public static final String COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    public static final String COMPILER_TASK_PRIORITIES = "org.eclipse.jdt.core.compiler.taskPriorities";
    public static final String COMPILER_TASK_PRIORITY_HIGH = "HIGH";
    public static final String COMPILER_TASK_PRIORITY_LOW = "LOW";
    public static final String COMPILER_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    public static final String COMPILER_TASK_CASE_SENSITIVE = "org.eclipse.jdt.core.compiler.taskCaseSensitive";
    public static final String CORE_JAVA_BUILD_ORDER = "org.eclipse.jdt.core.computeJavaBuildOrder";
    public static final String CORE_JAVA_BUILD_RESOURCE_COPY_FILTER = "org.eclipse.jdt.core.builder.resourceCopyExclusionFilter";
    public static final String CORE_JAVA_BUILD_DUPLICATE_RESOURCE = "org.eclipse.jdt.core.builder.duplicateResourceTask";
    public static final String CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER = "org.eclipse.jdt.core.builder.cleanOutputFolder";
    public static final String CORE_INCOMPLETE_CLASSPATH = "org.eclipse.jdt.core.incompleteClasspath";
    public static final String CORE_CIRCULAR_CLASSPATH = "org.eclipse.jdt.core.circularClasspath";
    public static final String CORE_INCOMPATIBLE_JDK_LEVEL = "org.eclipse.jdt.core.incompatibleJDKLevel";
    public static final String CORE_JAVA_BUILD_INVALID_CLASSPATH = "org.eclipse.jdt.core.builder.invalidClasspath";
    public static final String CORE_ENCODING = "org.eclipse.jdt.core.encoding";
    public static final String CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS = "org.eclipse.jdt.core.classpath.exclusionPatterns";
    public static final String CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS = "org.eclipse.jdt.core.classpath.multipleOutputLocations";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_PRIORITY = "NORMAL";
    public static final String DEFAULT_TASK_TAGS = "TODO,FIXME,XXX";
    public static final String DEFAULT_TASK_PRIORITIES = "NORMAL,HIGH,NORMAL";
    public static final String FORMATTER_NEWLINE_OPENING_BRACE = "org.eclipse.jdt.core.formatter.newline.openingBrace";
    public static final String FORMATTER_NEWLINE_CONTROL = "org.eclipse.jdt.core.formatter.newline.controlStatement";
    public static final String FORMATTER_NEWLINE_ELSE_IF = "org.eclipse.jdt.core.formatter.newline.elseIf";
    public static final String FORMATTER_NEWLINE_EMPTY_BLOCK = "org.eclipse.jdt.core.formatter.newline.emptyBlock";
    public static final String FORMATTER_CLEAR_BLANK_LINES = "org.eclipse.jdt.core.formatter.newline.clearAll";
    public static final String FORMATTER_LINE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";
    public static final String FORMATTER_COMPACT_ASSIGNMENT = "org.eclipse.jdt.core.formatter.style.assignment";
    public static final String FORMATTER_TAB_CHAR = "org.eclipse.jdt.core.formatter.tabulation.char";
    public static final String FORMATTER_TAB_SIZE = "org.eclipse.jdt.core.formatter.tabulation.size";
    public static final String FORMATTER_SPACE_CASTEXPRESSION = "org.eclipse.jdt.core.formatter.space.castexpression";
    public static final String CODEASSIST_VISIBILITY_CHECK = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    public static final String CODEASSIST_IMPLICIT_QUALIFICATION = "org.eclipse.jdt.core.codeComplete.forceImplicitQualification";
    public static final String CODEASSIST_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.fieldPrefixes";
    public static final String CODEASSIST_STATIC_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldPrefixes";
    public static final String CODEASSIST_LOCAL_PREFIXES = "org.eclipse.jdt.core.codeComplete.localPrefixes";
    public static final String CODEASSIST_ARGUMENT_PREFIXES = "org.eclipse.jdt.core.codeComplete.argumentPrefixes";
    public static final String CODEASSIST_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.fieldSuffixes";
    public static final String CODEASSIST_STATIC_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldSuffixes";
    public static final String CODEASSIST_LOCAL_SUFFIXES = "org.eclipse.jdt.core.codeComplete.localSuffixes";
    public static final String CODEASSIST_ARGUMENT_SUFFIXES = "org.eclipse.jdt.core.codeComplete.argumentSuffixes";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String VERSION_1_5 = "1.5";
    public static final String ABORT = "abort";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String COMPUTE = "compute";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String CLEAN = "clean";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String DEFAULT = "default";
    public static final String PRIVATE = "private";

    public JavaCore() {
        JAVA_CORE_PLUGIN = this;
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        JavaCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        JavaModelManager.getJavaModelManager().deltaState.addElementChangedListener(listener, eventMask);
    }

    public static void addJavaElementMarkerAttributes(Map attributes, IJavaElement element) {
        if (element instanceof IMember) {
            element = ((IMember)element).getClassFile();
        }
        if (attributes != null && element != null) {
            attributes.put(ATT_HANDLE_ID, element.getHandleIdentifier());
        }
    }

    public static void addPreProcessingResourceChangedListener(IResourceChangeListener listener) {
        JavaModelManager.getJavaModelManager().deltaState.addPreResourceChangedListener(listener);
    }

    public void configureJavaElementMarker(IMarker marker, IJavaElement element) throws CoreException {
        if (element instanceof IMember) {
            element = ((IMember)element).getClassFile();
        }
        if (marker != null && element != null) {
            marker.setAttribute(ATT_HANDLE_ID, (Object)element.getHandleIdentifier());
        }
    }

    public static IJavaElement create(String handleIdentifier) {
        return JavaCore.create(handleIdentifier, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        MementoTokenizer memento = new MementoTokenizer(handleIdentifier);
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        return model.getHandleFromMemento(memento, owner);
    }

    public static IJavaElement create(IFile file) {
        return JavaModelManager.create(file, null);
    }

    public static IJavaElement create(IFolder folder) {
        return JavaModelManager.create(folder, null);
    }

    public static IJavaProject create(IProject project) {
        if (project == null) {
            return null;
        }
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        return javaModel.getJavaProject((IResource)project);
    }

    public static IJavaElement create(IResource resource) {
        return JavaModelManager.create(resource, null);
    }

    public static IJavaModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static IClassFile createClassFileFrom(IFile file) {
        return JavaModelManager.createClassFileFrom(file, null);
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaModelManager.createCompilationUnitFrom(file, null);
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file) {
        return JavaModelManager.createJarPackageFragmentRootFrom(file, null);
    }

    public static IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IClasspathContainer container = manager.getClasspathContainer(containerPath, project);
        if (container == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
            return manager.getPreviousSessionContainer(containerPath, project);
        }
        return container;
    }

    public static ClasspathContainerInitializer getClasspathContainerInitializer(String containerID) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "classpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String initializerID = configElements[j].getAttribute("id");
                    if (initializerID == null || !initializerID.equals(containerID)) continue;
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        Util.verbose("CPContainer INIT - found initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"));
                    }
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (!(execExt instanceof ClasspathContainerInitializer)) continue;
                        return (ClasspathContainerInitializer)execExt;
                    }
                    catch (CoreException e) {
                        if (!JavaModelManager.CP_RESOLVE_VERBOSE) continue;
                        Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"), System.err);
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static IPath getClasspathVariable(String variableName) {
        IPath variablePath;
        block18: {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            variablePath = manager.variableGet(variableName);
            if (variablePath == JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                return manager.getPreviousSessionVariable(variableName);
            }
            if (variablePath != null) {
                return variablePath;
            }
            ClasspathVariableInitializer initializer = JavaCore.getClasspathVariableInitializer(variableName);
            if (initializer != null) {
                boolean ok;
                block16: {
                    IPath iPath;
                    block17: {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            Util.verbose("CPVariable INIT - triggering initialization\n\tvariable: " + variableName + '\n' + "\tinitializer: " + initializer + '\n' + "\tinvocation stack trace:");
                            new Exception("<Fake exception>").printStackTrace(System.out);
                        }
                        JavaModelManager.getJavaModelManager().variablePut(variableName, JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS);
                        ok = false;
                        initializer.initialize(variableName);
                        variablePath = JavaModelManager.getJavaModelManager().variableGet(variableName);
                        if (variablePath != JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) break block16;
                        iPath = null;
                        Object var7_8 = null;
                        if (ok) break block17;
                        JavaModelManager.getJavaModelManager().variablePut(variableName, null);
                    }
                    return iPath;
                }
                try {
                    try {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            Util.verbose("CPVariable INIT - after initialization\n\tvariable: " + variableName + '\n' + "\tvariable path: " + variablePath);
                        }
                        ok = true;
                    }
                    catch (RuntimeException e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                    catch (Error e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                    Object var7_9 = null;
                    if (!ok) {
                        JavaModelManager.getJavaModelManager().variablePut(variableName, null);
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (!ok) {
                        JavaModelManager.getJavaModelManager().variablePut(variableName, null);
                    }
                    throw throwable;
                }
            }
            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                Util.verbose("CPVariable INIT - no initializer found\n\tvariable: " + variableName);
            }
        }
        return variablePath;
    }

    public static ClasspathVariableInitializer getClasspathVariableInitializer(String variable) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "classpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    try {
                        Object execExt;
                        String varAttribute = configElements[j].getAttribute("variable");
                        if (!variable.equals(varAttribute)) continue;
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            Util.verbose("CPVariable INIT - found initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElements[j].getAttribute("class"));
                        }
                        if (!((execExt = configElements[j].createExecutableExtension("class")) instanceof ClasspathVariableInitializer)) continue;
                        return (ClasspathVariableInitializer)execExt;
                    }
                    catch (CoreException e) {
                        if (!JavaModelManager.CP_RESOLVE_VERBOSE) continue;
                        Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElements[j].getAttribute("class"), System.err);
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static String[] getClasspathVariableNames() {
        return JavaModelManager.getJavaModelManager().variableNames();
    }

    public static Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        HashSet optionNames = JavaModelManager.getJavaModelManager().optionNames;
        Iterator iterator = optionNames.iterator();
        while (iterator.hasNext()) {
            String propertyName = (String)iterator.next();
            defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
        }
        defaultOptions.put(CORE_ENCODING, JavaCore.getEncoding());
        defaultOptions.put(COMPILER_PB_INVALID_IMPORT, ERROR);
        defaultOptions.put(COMPILER_PB_UNREACHABLE_CODE, ERROR);
        return defaultOptions;
    }

    public static String getEncoding() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            try {
                return workspace.getRoot().getDefaultCharset();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    public static JavaCore getJavaCore() {
        return (JavaCore)JavaCore.getPlugin();
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return JavaCore.getEncoding();
        }
        if (COMPILER_PB_INVALID_IMPORT.equals(optionName) || COMPILER_PB_UNREACHABLE_CODE.equals(optionName)) {
            return ERROR;
        }
        String propertyName = optionName;
        if (JavaModelManager.getJavaModelManager().optionNames.contains(propertyName)) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            return preferences.getString(propertyName).trim();
        }
        return null;
    }

    public static Hashtable getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            HashSet optionNames = JavaModelManager.getJavaModelManager().optionNames;
            Iterator iterator = optionNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                options.put(propertyName, preferences.getDefaultString(propertyName));
            }
            String[] propertyNames = preferences.propertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                String value = preferences.getString(propertyName).trim();
                if (!optionNames.contains(propertyName)) continue;
                options.put(propertyName, value);
            }
            options.put(CORE_ENCODING, JavaCore.getEncoding());
            options.put(COMPILER_PB_INVALID_IMPORT, ERROR);
            options.put(COMPILER_PB_UNREACHABLE_CODE, ERROR);
        }
        return options;
    }

    public static Plugin getPlugin() {
        return JAVA_CORE_PLUGIN;
    }

    public static IClasspathEntry getResolvedClasspathEntry(IClasspathEntry entry) {
        String fileName;
        File externalFile;
        IResource resolvedResource;
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath resolvedPath = JavaCore.getResolvedVariablePath(entry.getPath());
        if (resolvedPath == null) {
            return null;
        }
        Object target = JavaModel.getTarget((IContainer)workspaceRoot, resolvedPath, false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource && (resolvedResource = (IResource)target) != null) {
            switch (resolvedResource.getType()) {
                case 4: {
                    return JavaCore.newProjectEntry(resolvedPath, entry.isExported());
                }
                case 1: {
                    if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resolvedResource.getName())) break;
                    return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
                }
                case 2: {
                    return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
                }
            }
        }
        if (target instanceof File && ((externalFile = (File)target).isFile() ? (fileName = externalFile.getName().toLowerCase()).endsWith(".jar") || fileName.endsWith(".zip") : resolvedPath.isAbsolute())) {
            return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
        }
        return null;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath resolvedPath = JavaCore.getClasspathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        return JavaCore.getWorkingCopies(BufferFactoryWrapper.create(factory));
    }

    public static String[] getUserLibraryNames() {
        return UserLibraryManager.getUserLibraryNames();
    }

    public static ICompilationUnit[] getWorkingCopies(WorkingCopyOwner owner) {
        ICompilationUnit[] result;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (owner == null) {
            owner = DefaultWorkingCopyOwner.PRIMARY;
        }
        if ((result = manager.getWorkingCopies(owner, false)) == null) {
            return JavaModelManager.NO_WORKING_COPY;
        }
        return result;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences preferences = this.getPluginPreferences();
        HashSet optionNames = JavaModelManager.getJavaModelManager().optionNames;
        Map compilerOptionsMap = new CompilerOptions().getMap();
        Iterator iter = compilerOptionsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String optionName = (String)entry.getKey();
            preferences.setDefault(optionName, (String)entry.getValue());
            optionNames.add(optionName);
        }
        preferences.setDefault(COMPILER_LOCAL_VARIABLE_ATTR, GENERATE);
        preferences.setDefault(COMPILER_CODEGEN_UNUSED_LOCAL, PRESERVE);
        preferences.setDefault(COMPILER_TASK_TAGS, DEFAULT_TASK_TAGS);
        preferences.setDefault(COMPILER_TASK_PRIORITIES, DEFAULT_TASK_PRIORITIES);
        preferences.setDefault(COMPILER_TASK_CASE_SENSITIVE, ENABLED);
        preferences.setDefault(COMPILER_DOC_COMMENT_SUPPORT, ENABLED);
        preferences.setDefault(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER, "");
        optionNames.add(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER);
        preferences.setDefault(CORE_JAVA_BUILD_INVALID_CLASSPATH, ABORT);
        optionNames.add(CORE_JAVA_BUILD_INVALID_CLASSPATH);
        preferences.setDefault(CORE_JAVA_BUILD_DUPLICATE_RESOURCE, WARNING);
        optionNames.add(CORE_JAVA_BUILD_DUPLICATE_RESOURCE);
        preferences.setDefault(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER, CLEAN);
        optionNames.add(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER);
        preferences.setDefault(CORE_JAVA_BUILD_ORDER, IGNORE);
        optionNames.add(CORE_JAVA_BUILD_ORDER);
        preferences.setDefault(CORE_INCOMPLETE_CLASSPATH, ERROR);
        optionNames.add(CORE_INCOMPLETE_CLASSPATH);
        preferences.setDefault(CORE_CIRCULAR_CLASSPATH, ERROR);
        optionNames.add(CORE_CIRCULAR_CLASSPATH);
        preferences.setDefault(CORE_INCOMPATIBLE_JDK_LEVEL, IGNORE);
        optionNames.add(CORE_INCOMPATIBLE_JDK_LEVEL);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS);
        optionNames.add(CORE_ENCODING);
        Map codeFormatterOptionsMap = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        Iterator iter2 = codeFormatterOptionsMap.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            String optionName = (String)entry.getKey();
            preferences.setDefault(optionName, (String)entry.getValue());
            optionNames.add(optionName);
        }
        preferences.setDefault(FORMATTER_NEWLINE_OPENING_BRACE, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_OPENING_BRACE);
        preferences.setDefault(FORMATTER_NEWLINE_CONTROL, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_CONTROL);
        preferences.setDefault(FORMATTER_CLEAR_BLANK_LINES, PRESERVE_ONE);
        optionNames.add(FORMATTER_CLEAR_BLANK_LINES);
        preferences.setDefault(FORMATTER_NEWLINE_ELSE_IF, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_ELSE_IF);
        preferences.setDefault(FORMATTER_NEWLINE_EMPTY_BLOCK, INSERT);
        optionNames.add(FORMATTER_NEWLINE_EMPTY_BLOCK);
        preferences.setDefault(FORMATTER_LINE_SPLIT, "80");
        optionNames.add(FORMATTER_LINE_SPLIT);
        preferences.setDefault(FORMATTER_COMPACT_ASSIGNMENT, NORMAL);
        optionNames.add(FORMATTER_COMPACT_ASSIGNMENT);
        preferences.setDefault(FORMATTER_TAB_CHAR, TAB);
        optionNames.add(FORMATTER_TAB_CHAR);
        preferences.setDefault(FORMATTER_TAB_SIZE, "4");
        optionNames.add(FORMATTER_TAB_SIZE);
        preferences.setDefault(FORMATTER_SPACE_CASTEXPRESSION, INSERT);
        optionNames.add(FORMATTER_SPACE_CASTEXPRESSION);
        preferences.setDefault(CODEASSIST_VISIBILITY_CHECK, DISABLED);
        optionNames.add(CODEASSIST_VISIBILITY_CHECK);
        preferences.setDefault(CODEASSIST_IMPLICIT_QUALIFICATION, DISABLED);
        optionNames.add(CODEASSIST_IMPLICIT_QUALIFICATION);
        preferences.setDefault(CODEASSIST_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_PREFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_PREFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_PREFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_PREFIXES);
        preferences.setDefault(CODEASSIST_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_SUFFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_SUFFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_SUFFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_SUFFIXES);
    }

    public static boolean isReferencedBy(IJavaElement element, IMarker marker) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (marker == null) {
            return false;
        }
        String markerHandleId = (String)marker.getAttribute(ATT_HANDLE_ID);
        if (markerHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerHandleId);
        while (true) {
            IType enclosingType;
            if (element.equals(markerElement)) {
                return true;
            }
            if (!(markerElement instanceof IClassFile) || (enclosingType = ((IClassFile)markerElement).getType().getDeclaringType()) == null) break;
            markerElement = enclosingType.getClassFile();
        }
        return false;
    }

    public static boolean isReferencedBy(IJavaElement element, IMarkerDelta markerDelta) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (markerDelta == null) {
            return false;
        }
        String markerDeltarHandleId = (String)markerDelta.getAttribute(ATT_HANDLE_ID);
        if (markerDeltarHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerDeltarHandleId);
        while (true) {
            IType enclosingType;
            if (element.equals(markerElement)) {
                return true;
            }
            if (!(markerElement instanceof IClassFile) || (enclosingType = ((IClassFile)markerElement).getType().getDeclaringType()) == null) break;
            markerElement = enclosingType.getClassFile();
        }
        return false;
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath) {
        return JavaCore.newContainerEntry(containerPath, false);
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath, boolean isExported) {
        if (containerPath == null) {
            Assert.isTrue(false, "Container path cannot be null");
        }
        if (containerPath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal classpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new ClasspathEntry(1, 5, containerPath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return JavaCore.newLibraryEntry(path, sourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, boolean isExported) {
        if (path == null) {
            Assert.isTrue(false, "Library path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        if (sourceAttachmentPath != null) {
            if (sourceAttachmentPath.isEmpty()) {
                sourceAttachmentPath = null;
            } else if (!sourceAttachmentPath.isAbsolute()) {
                Assert.isTrue(false, "Source attachment path '" + sourceAttachmentPath + "' for IClasspathEntry must be absolute");
            }
        }
        return new ClasspathEntry(2, 1, JavaProject.canonicalizedPath(path), ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, sourceAttachmentPath, sourceAttachmentRootPath, null, isExported);
    }

    public static IClasspathEntry newProjectEntry(IPath path) {
        return JavaCore.newProjectEntry(path, false);
    }

    public static IClasspathEntry newProjectEntry(IPath path, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        return new ClasspathEntry(1, 2, path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static IClasspathEntry newSourceEntry(IPath path) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, exclusionPatterns, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, exclusionPatterns, specificOutputLocation);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        if (path == null) {
            Assert.isTrue(false, "Source path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue(false, "Exclusion pattern set cannot be null");
        }
        if (inclusionPatterns == null) {
            Assert.isTrue(false, "Inclusion pattern set cannot be null");
        }
        return new ClasspathEntry(1, 3, path, inclusionPatterns, exclusionPatterns, null, null, specificOutputLocation, false);
    }

    public static IClasspathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return JavaCore.newVariableEntry(variablePath, variableSourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IClasspathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath variableSourceAttachmentRootPath, boolean isExported) {
        if (variablePath == null) {
            Assert.isTrue(false, "Variable path cannot be null");
        }
        if (variablePath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal classpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment");
        }
        return new ClasspathEntry(1, 4, variablePath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, variableSourceAttachmentPath, variableSourceAttachmentRootPath, null, isExported);
    }

    public static void removeClasspathVariable(String variableName) {
        JavaCore.removeClasspathVariable(variableName, null);
    }

    public static void removeClasspathVariable(String variableName, IProgressMonitor monitor) {
        try {
            JavaModelManager.getJavaModelManager().updateVariableValues(new String[]{variableName}, new IPath[]{null}, monitor);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        JavaModelManager.getJavaModelManager().deltaState.removeElementChangedListener(listener);
    }

    public static void removePreProcessingResourceChangedListener(IResourceChangeListener listener) {
        JavaModelManager.getJavaModelManager().deltaState.removePreResourceChangedListener(listener);
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        JavaCore.run(action, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
    }

    public static void run(IWorkspaceRunnable action, ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), rule, 1, monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setClasspathContainer(final IPath containerPath, IJavaProject[] affectedProjects, IClasspathContainer[] respectiveContainers, IProgressMonitor monitor) throws JavaModelException {
        int i3;
        if (affectedProjects.length != respectiveContainers.length) {
            Assert.isTrue(false, "Projects and containers collections should have the same size");
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
            Util.verbose("CPContainer SET  - setting container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + org.eclipse.jdt.internal.compiler.util.Util.toString(affectedProjects, new Util.Displayable(){

                public String displayString(Object o) {
                    return ((IJavaProject)o).getElementName();
                }
            }) + "}\n\tvalues: {\n" + org.eclipse.jdt.internal.compiler.util.Util.toString(respectiveContainers, new Util.Displayable(){

                public String displayString(Object o) {
                    StringBuffer buffer = new StringBuffer("\t\t");
                    if (o == null) {
                        buffer.append("<null>");
                        return buffer.toString();
                    }
                    IClasspathContainer container = (IClasspathContainer)o;
                    buffer.append(container.getDescription());
                    buffer.append(" {\n");
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    if (entries != null) {
                        for (int i = 0; i < entries.length; ++i) {
                            buffer.append(" \t\t\t");
                            buffer.append(entries[i]);
                            buffer.append('\n');
                        }
                    }
                    buffer.append(" \t\t}");
                    return buffer.toString();
                }
            }) + "\n\t}\n\tinvocation stack trace:");
            new Exception("<Fake exception>").printStackTrace(System.out);
        }
        final int projectLength = affectedProjects.length;
        final IJavaProject[] modifiedProjects = new IJavaProject[projectLength];
        System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
        final IClasspathEntry[][] oldResolvedPaths = new IClasspathEntry[projectLength][];
        int remaining = 0;
        for (int i2 = 0; i2 < projectLength; ++i2) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            JavaProject affectedProject = (JavaProject)affectedProjects[i2];
            IClasspathContainer newContainer = respectiveContainers[i2];
            if (newContainer == null) {
                newContainer = JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS;
            }
            boolean found = false;
            if (JavaProject.hasJavaNature(affectedProject.getProject())) {
                IClasspathEntry[] rawClasspath = affectedProject.getRawClasspath();
                int cpLength = rawClasspath.length;
                for (int j = 0; j < cpLength; ++j) {
                    IClasspathEntry entry = rawClasspath[j];
                    if (entry.getEntryKind() != 5 || !entry.getPath().equals(containerPath)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                modifiedProjects[i2] = null;
                JavaModelManager.getJavaModelManager().containerPut(affectedProject, containerPath, newContainer);
                continue;
            }
            IClasspathContainer oldContainer = JavaModelManager.getJavaModelManager().containerGet(affectedProject, containerPath);
            if (oldContainer == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                oldContainer = null;
            }
            if (oldContainer != null && oldContainer.equals(respectiveContainers[i2])) {
                modifiedProjects[i2] = null;
                continue;
            }
            ++remaining;
            oldResolvedPaths[i2] = affectedProject.getResolvedClasspath(true, false, false);
            JavaModelManager.getJavaModelManager().containerPut(affectedProject, containerPath, newContainer);
        }
        if (remaining == 0) {
            return;
        }
        try {
            try {
                final boolean canChangeResources = !ResourcesPlugin.getWorkspace().isTreeLocked();
                JavaCore.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        for (int i = 0; i < projectLength; ++i) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            JavaProject affectedProject = (JavaProject)modifiedProjects[i];
                            if (affectedProject == null) continue;
                            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                Util.verbose("CPContainer SET  - updating affected project due to setting container\n\tproject: " + affectedProject.getElementName() + '\n' + "\tcontainer path: " + containerPath);
                            }
                            affectedProject.setRawClasspath(affectedProject.getRawClasspath(), SetClasspathOperation.ReuseOutputLocation, progressMonitor, canChangeResources, oldResolvedPaths[i], false, false);
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPContainer SET  - FAILED DUE TO EXCEPTION\n\tcontainer path: " + containerPath, System.err);
                    e.printStackTrace();
                }
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
            Object var17_17 = null;
            i3 = 0;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            int i3 = 0;
            while (true) {
                if (i3 >= projectLength) {
                    throw throwable;
                }
                if (respectiveContainers[i3] == null) {
                    JavaModelManager.getJavaModelManager().containerPut(affectedProjects[i3], containerPath, null);
                }
                ++i3;
            }
        }
        while (i3 < projectLength) {
            if (respectiveContainers[i3] == null) {
                JavaModelManager.getJavaModelManager().containerPut(affectedProjects[i3], containerPath, null);
            }
            ++i3;
        }
        return;
    }

    public static void setClasspathVariable(String variableName, IPath path) throws JavaModelException {
        JavaCore.setClasspathVariable(variableName, path, null);
    }

    public static void setClasspathVariable(String variableName, IPath path, IProgressMonitor monitor) throws JavaModelException {
        if (path == null) {
            Assert.isTrue(false, "Variable path cannot be null");
        }
        JavaCore.setClasspathVariables(new String[]{variableName}, new IPath[]{path}, monitor);
    }

    public static void setClasspathVariables(String[] variableNames, IPath[] paths, IProgressMonitor monitor) throws JavaModelException {
        if (variableNames.length != paths.length) {
            Assert.isTrue(false, "Variable names and paths collections should have the same size");
        }
        JavaModelManager.getJavaModelManager().updateVariableValues(variableNames, paths, monitor);
    }

    public static void setOptions(Hashtable newOptions) {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        if (newOptions == null) {
            newOptions = JavaCore.getDefaultOptions();
        }
        Enumeration keys = newOptions.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!JavaModelManager.getJavaModelManager().optionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        JavaCore.getPlugin().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.savePluginPreferences();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)JavaModelManager.getJavaModelManager().deltaState);
            workspace.removeSaveParticipant((Plugin)this);
            JavaModelManager.getJavaModelManager().shutdown();
        }
        finally {
            super.stop(context);
        }
    }

    private void startIndexing() {
        JavaModelManager.getJavaModelManager().getIndexManager().reset();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.configurePluginDebugOptions();
            JavaCore.getPlugin().getStateLocation();
            JavaCore.getPlugin().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new JavaModelManager.PluginPreferencesListener());
            manager.loadVariablesAndContainers();
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)manager.deltaState, 31);
            this.startIndexing();
            Job processSavedState = new Job(Util.bind("savedState.jobName")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(IProgressMonitor progress) throws CoreException {
                                ISavedState savedState = 4.access$200(this.this$1).addSaveParticipant((Plugin)4.access$000(this.this$1), (ISaveParticipant)4.access$100(this.this$1));
                                if (savedState != null) {
                                    4.access$100(this.this$1).deltaState.getDeltaProcessor().overridenEventType = 1;
                                    savedState.processResourceChangeEvents((IResourceChangeListener)4.access$100(this.this$1).deltaState);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }

                static /* synthetic */ JavaCore access$000(4 x0) {
                    return x0.JavaCore.this;
                }

                static /* synthetic */ JavaModelManager access$100(4 x0) {
                    return x0.manager;
                }

                static /* synthetic */ IWorkspace access$200(4 x0) {
                    return x0.workspace;
                }
            };
            processSavedState.setSystem(true);
            processSavedState.setPriority(20);
            processSavedState.schedule();
        }
        catch (RuntimeException e) {
            manager.shutdown();
            throw e;
        }
    }
}

