/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyAnalysisSection;
import org.eclipse.pde.internal.ui.editor.plugin.MatchSection;
import org.eclipse.pde.internal.ui.editor.plugin.RequiresSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DependenciesPage
extends PDEFormPage
implements IInputContextListener {
    public static final String PAGE_ID = "dependencies";
    private RequiresSection requiresSection;
    private MatchSection matchSection;

    public DependenciesPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEPlugin.getResourceString("DependenciesPage.tabName"));
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(PDEPlugin.getResourceString("DependenciesPage.title"));
        Composite body = form.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        body.setLayout((Layout)layout);
        this.requiresSection = new RequiresSection(this, body);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.requiresSection.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.requiresSection);
        this.matchSection = new MatchSection((PDEFormPage)this, body, true);
        gd = new GridData(770);
        this.matchSection.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.matchSection);
        this.matchSection.setOsgiMode(this.isOsgiMode());
        DependencyAnalysisSection analysisSection = new DependencyAnalysisSection(this, body);
        gd = new GridData(770);
        analysisSection.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)analysisSection);
        InputContextManager contextManager = this.getPDEEditor().getContextManager();
        contextManager.addInputContextListener(this);
    }

    public void contextMenuAboutToShow(IMenuManager manager) {
        IResource resource = ((IPluginModelBase)this.getModel()).getUnderlyingResource();
        if (resource != null && WorkspaceModelManager.isJavaPluginProject((IProject)resource.getProject())) {
            manager.add((IAction)this.requiresSection.getBuildpathAction());
            manager.add((IContributionItem)new Separator());
        }
    }

    private boolean isOsgiMode() {
        return this.getModel() instanceof IBundlePluginModelBase;
    }

    public void contextAdded(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.matchSection.setOsgiMode(true);
        }
    }

    public void contextRemoved(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.matchSection.setOsgiMode(false);
        }
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }
}

