/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLSourceViewerConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;

public abstract class XMLSourcePage
extends PDESourcePage {
    public static final String ERROR_MESSAGE = "SourcePage.errorMessage";
    protected IColorManager colorManager;

    public XMLSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        this.setSourceViewerConfiguration(this.createXMLConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    protected XMLSourceViewerConfiguration createXMLConfiguration() {
        if (this.colorManager != null) {
            this.colorManager.dispose();
        }
        this.colorManager = ColorManager.getDefault();
        return new XMLSourceViewerConfiguration(this, this.colorManager);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public boolean canLeaveThePage() {
        boolean cleanModel = this.getInputContext().isModelCorrect();
        if (!cleanModel) {
            Display.getCurrent().beep();
            String title = this.getEditor().getSite().getRegisteredName();
            MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)PDEPlugin.getResourceString(ERROR_MESSAGE));
        }
        return cleanModel;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("editor.color.default") || property.equals("editor.color.instr") || property.equals("editor.color.string") || property.equals("editor.color.tag") || property.equals("editor.color.xml_comment");
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        XMLSourceViewerConfiguration sourceViewerConfiguration = (XMLSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (this.affectsTextPresentation(event)) {
            sourceViewerConfiguration.adaptToPreferenceChange(event);
            this.setSourceViewerConfiguration(sourceViewerConfiguration);
        }
        super.handlePreferenceStoreChanged(event);
    }
}

