/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.a;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.internal.aa;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.av;
import com.google.android.gms.internal.cm;
import com.google.android.gms.internal.cn;
import com.google.android.gms.internal.t;
import com.google.android.gms.internal.u;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.x;
import com.google.android.gms.internal.z;

public final class AdView
extends ViewGroup {
    private final av dS = new av();
    private AdListener dT;
    private ac dU;
    private AdSize c;
    private String dV;
    private a dW;

    public AdView(Context context) {
        super(context);
    }

    public AdView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        try {
            aa aa2 = new aa(context, attrs);
            this.c = aa2.getAdSize();
            this.dV = aa2.getAdUnitId();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cm.a(this, new x(context, AdSize.BANNER), illegalArgumentException.getMessage());
            return;
        }
        if (this.isInEditMode()) {
            cm.b(this, new x(context, this.c), "Ads by Google");
            return;
        }
    }

    public void destroy() {
        try {
            if (this.dU != null) {
                this.dU.destroy();
            }
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.dT;
    }

    public AdSize getAdSize() {
        return this.c;
    }

    public String getAdUnitId() {
        return this.dV;
    }

    public void loadAd(AdRequest adRequest) {
        try {
            if (this.dU == null) {
                this.c("loadAd");
            }
            if (this.dU.a(new v(this.getContext(), adRequest))) {
                this.dS.c(adRequest.v());
            }
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.dU != null) {
                this.dU.pause();
            }
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to call pause.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.dU != null) {
                this.dU.resume();
            }
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.dT = adListener;
            if (this.dU != null) {
                this.dU.a(adListener != null ? new t(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to set the AdListener.", remoteException);
        }
    }

    public void setAdSize(AdSize adSize) {
        if (this.c != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.c = adSize;
        this.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.dV != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.dV = adUnitId;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = 0;
        int n3 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n2 = view.getMeasuredWidth();
            n3 = view.getMeasuredHeight();
        } else if (this.c != null) {
            Context context = this.getContext();
            n2 = this.c.getWidthInPixels(context);
            n3 = this.c.getHeightInPixels(context);
        }
        n2 = Math.max(n2, this.getSuggestedMinimumWidth());
        n3 = Math.max(n3, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(AdView.resolveSize((int)n2, (int)widthMeasureSpec), AdView.resolveSize((int)n3, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            int n4 = (right - left - n2) / 2;
            int n5 = (bottom - top - n3) / 2;
            view.layout(n4, n5, n4 + n2, n5 + n3);
        }
    }

    private void x() {
        try {
            b b2 = this.dU.z();
            if (b2 == null) {
                return;
            }
            this.addView((View)com.google.android.gms.dynamic.c.b(b2));
        }
        catch (RemoteException remoteException) {
            cn.b("Failed to get an ad frame.", remoteException);
        }
    }

    private void c(String string2) throws RemoteException {
        if (this.c == null || this.dV == null) {
            this.d(string2);
        }
        Context context = this.getContext();
        this.dU = u.a(context, new x(context, this.c), this.dV, this.dS);
        if (this.dT != null) {
            this.dU.a(new t(this.dT));
        }
        if (this.dW != null) {
            this.dU.a(new z(this.dW));
        }
        this.x();
    }

    private void d(String string2) {
        if (this.dU == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set on AdView before " + string2 + " is called.");
        }
    }
}

