/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.imageio.spi.FilterIterator;
import javax.imageio.spi.SubRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    private Map categoryMap = new HashMap();

    public ServiceRegistry(Iterator<Class<?>> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("categories == null!");
        }
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            SubRegistry subRegistry = new SubRegistry(this, clazz);
            this.categoryMap.put(clazz, subRegistry);
        }
    }

    public static <T> Iterator<T> lookupProviders(Class<T> clazz, ClassLoader classLoader) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return ServiceLoader.load(clazz, classLoader).iterator();
    }

    public static <T> Iterator<T> lookupProviders(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        return ServiceLoader.load(clazz).iterator();
    }

    public Iterator<Class<?>> getCategories() {
        Set set = this.categoryMap.keySet();
        return set.iterator();
    }

    private Iterator getSubRegistries(Object object) {
        ArrayList<SubRegistry> arrayList = new ArrayList<SubRegistry>();
        for (Class clazz : this.categoryMap.keySet()) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            arrayList.add((SubRegistry)this.categoryMap.get(clazz));
        }
        return arrayList.iterator();
    }

    public <T> boolean registerServiceProvider(T t, Class<T> clazz) {
        if (t == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!clazz.isAssignableFrom(t.getClass())) {
            throw new ClassCastException();
        }
        return subRegistry.registerServiceProvider(t);
    }

    public void registerServiceProvider(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            subRegistry.registerServiceProvider(object);
        }
    }

    public void registerServiceProviders(Iterator<?> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        while (iterator.hasNext()) {
            this.registerServiceProvider(iterator.next());
        }
    }

    public <T> boolean deregisterServiceProvider(T t, Class<T> clazz) {
        if (t == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!clazz.isAssignableFrom(t.getClass())) {
            throw new ClassCastException();
        }
        return subRegistry.deregisterServiceProvider(t);
    }

    public void deregisterServiceProvider(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            subRegistry.deregisterServiceProvider(object);
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator iterator = this.getSubRegistries(object);
        while (iterator.hasNext()) {
            SubRegistry subRegistry = (SubRegistry)iterator.next();
            if (!subRegistry.contains(object)) continue;
            return true;
        }
        return false;
    }

    public <T> Iterator<T> getServiceProviders(Class<T> clazz, boolean bl) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        return subRegistry.getServiceProviders(bl);
    }

    public <T> Iterator<T> getServiceProviders(Class<T> clazz, Filter filter, boolean bl) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        Iterator<T> iterator = this.getServiceProviders(clazz, bl);
        return new FilterIterator<T>(iterator, filter);
    }

    public <T> T getServiceProviderByClass(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        for (Class clazz2 : this.categoryMap.keySet()) {
            SubRegistry subRegistry;
            T t;
            if (!clazz2.isAssignableFrom(clazz) || (t = (subRegistry = (SubRegistry)this.categoryMap.get(clazz2)).getServiceProviderByClass(clazz)) == null) continue;
            return t;
        }
        return null;
    }

    public <T> boolean setOrdering(Class<T> clazz, T t, T t2) {
        if (t == null || t2 == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (t == t2) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (subRegistry.contains(t) && subRegistry.contains(t2)) {
            return subRegistry.setOrdering(t, t2);
        }
        return false;
    }

    public <T> boolean unsetOrdering(Class<T> clazz, T t, T t2) {
        if (t == null || t2 == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (t == t2) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (subRegistry.contains(t) && subRegistry.contains(t2)) {
            return subRegistry.unsetOrdering(t, t2);
        }
        return false;
    }

    public void deregisterAll(Class<?> clazz) {
        SubRegistry subRegistry = (SubRegistry)this.categoryMap.get(clazz);
        if (subRegistry == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        subRegistry.clear();
    }

    public void deregisterAll() {
        for (SubRegistry subRegistry : this.categoryMap.values()) {
            subRegistry.clear();
        }
    }

    public void finalize() throws Throwable {
        this.deregisterAll();
        super.finalize();
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

