/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VMState {
    private final VirtualMachineImpl vm;
    private final List<WeakReference> listeners = new ArrayList<WeakReference>();
    private boolean notifyingListeners = false;
    private int lastCompletedCommandId = 0;
    private int lastResumeCommandId = 0;
    private Cache cache = null;
    private static final Cache markerCache = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = markerCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache() {
        VMState vMState = this;
        synchronized (vMState) {
            if (this.cache == markerCache) {
                this.cache = new Cache();
            }
            return this.cache;
        }
    }

    VMState(VirtualMachineImpl virtualMachineImpl) {
        this.vm = virtualMachineImpl;
    }

    boolean isSuspended() {
        return this.cache != null;
    }

    synchronized void notifyCommandComplete(int n) {
        this.lastCompletedCommandId = n;
    }

    synchronized void freeze() {
        if (this.cache == null && this.lastCompletedCommandId >= this.lastResumeCommandId) {
            this.processVMAction(new VMAction(this.vm, 1));
            this.enableCache();
        }
    }

    synchronized PacketStream thawCommand(CommandSender commandSender) {
        PacketStream packetStream = commandSender.send();
        this.lastResumeCommandId = packetStream.id();
        this.thaw();
        return packetStream;
    }

    void thaw() {
        this.thaw(null);
    }

    synchronized void thaw(ThreadReference threadReference) {
        if (this.cache != null) {
            if ((this.vm.traceFlags & 0x10) != 0) {
                this.vm.printTrace("Clearing VM suspended cache");
            }
            this.disableCache();
        }
        this.processVMAction(new VMAction(this.vm, threadReference, 2));
    }

    private synchronized void processVMAction(VMAction vMAction) {
        if (!this.notifyingListeners) {
            this.notifyingListeners = true;
            Iterator<WeakReference> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = iterator.next();
                VMListener vMListener = (VMListener)weakReference.get();
                if (vMListener != null) {
                    boolean bl = true;
                    switch (vMAction.id()) {
                        case 1: {
                            bl = vMListener.vmSuspended(vMAction);
                            break;
                        }
                        case 2: {
                            bl = vMListener.vmNotSuspended(vMAction);
                        }
                    }
                    if (bl) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
            this.notifyingListeners = false;
        }
    }

    synchronized void addListener(VMListener vMListener) {
        this.listeners.add(new WeakReference<VMListener>(vMListener));
    }

    synchronized boolean hasListener(VMListener vMListener) {
        return this.listeners.contains(vMListener);
    }

    synchronized void removeListener(VMListener vMListener) {
        Iterator<WeakReference> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = iterator.next();
            if (!vMListener.equals(weakReference.get())) continue;
            iterator.remove();
            break;
        }
    }

    List<ThreadReference> allThreads() {
        List<ThreadReference> list = null;
        try {
            Cache cache = this.getCache();
            if (cache != null) {
                list = cache.threads;
            }
            if (list == null) {
                list = Arrays.asList((ThreadReference[])JDWP.VirtualMachine.AllThreads.process((VirtualMachineImpl)this.vm).threads);
                if (cache != null) {
                    cache.threads = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching all threads (count = " + list.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    List<ThreadGroupReference> topLevelThreadGroups() {
        List<ThreadGroupReference> list = null;
        try {
            Cache cache = this.getCache();
            if (cache != null) {
                list = cache.groups;
            }
            if (list == null) {
                list = Arrays.asList((ThreadGroupReference[])JDWP.VirtualMachine.TopLevelThreadGroups.process((VirtualMachineImpl)this.vm).groups);
                if (cache != null) {
                    cache.groups = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching top level thread groups (count = " + list.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    private static class Cache {
        List<ThreadGroupReference> groups = null;
        List<ThreadReference> threads = null;

        private Cache() {
        }
    }
}

