/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.util.xml.NullEntityResolver;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.Binding;
import com.sun.tools.internal.ws.wsdl.document.BindingFault;
import com.sun.tools.internal.ws.wsdl.document.BindingInput;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.BindingOutput;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Import;
import com.sun.tools.internal.ws.wsdl.document.Input;
import com.sun.tools.internal.ws.wsdl.document.Message;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.OperationStyle;
import com.sun.tools.internal.ws.wsdl.document.Output;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.Types;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocument;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.Extensible;
import com.sun.tools.internal.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.internal.ws.wsdl.framework.ParseException;
import com.sun.tools.internal.ws.wsdl.framework.ParserContext;
import com.sun.tools.internal.ws.wsdl.framework.ParserListener;
import com.sun.tools.internal.ws.wsdl.parser.ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Internalizer;
import com.sun.tools.internal.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAP12ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SchemaExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLParser {
    private WSDLModelInfo modelInfo;
    private EntityResolver entityResolver;
    private final Set<String> imports = new HashSet<String>();
    private final Map<String, Document> wsdlDocuments = new HashMap<String, Document>();
    private List _elements = new ArrayList();
    private boolean _followImports;
    private String _targetNamespaceURI;
    private Map _extensionHandlers = new HashMap();
    private ArrayList _listeners;
    private boolean _useWSIBasicProfile = true;
    private LocalizableMessageFactory _messageFactory = null;
    private Localizer _localizer;
    private HashSet hSet = new HashSet();

    private WSDLParser() {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
        this.register(new JAXWSBindingExtensionHandler());
        this.register(new SOAP12ExtensionHandler());
    }

    public WSDLParser(WSDLModelInfo wSDLModelInfo) {
        this();
        assert (wSDLModelInfo != null);
        this.modelInfo = wSDLModelInfo;
        this.entityResolver = wSDLModelInfo.getEntityResolver();
    }

    public void register(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), extensionHandler);
        extensionHandler.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler extensionHandler) {
        this._extensionHandlers.put(extensionHandler.getNamespaceURI(), null);
        extensionHandler.setExtensionHandlers(null);
    }

    public void unregister(String string) {
        this._extensionHandlers.put(string, null);
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean bl) {
        this._followImports = bl;
    }

    public void addParserListener(ParserListener parserListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(parserListener);
    }

    public void removeParserListener(ParserListener parserListener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(parserListener);
    }

    public WSDLDocument parse() {
        String string = this.modelInfo.getLocation();
        assert (string != null);
        this._messageFactory = new LocalizableMessageFactory("com.sun.tools.internal.ws.resources.wsdl");
        this._localizer = new Localizer();
        WSDLDocument wSDLDocument = new WSDLDocument();
        InputSource inputSource = null;
        String string2 = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)string));
        if (this.entityResolver != null) {
            try {
                inputSource = this.entityResolver.resolveEntity(null, string2);
            }
            catch (SAXException sAXException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", inputSource.getSystemId(), sAXException);
                }
                throw new ParseException("parsing.saxException", sAXException);
            }
            catch (IOException iOException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", inputSource.getSystemId(), iOException);
                }
                throw new ParseException("parsing.ioException", iOException);
            }
        }
        if (inputSource == null) {
            inputSource = new InputSource(string2);
        }
        wSDLDocument.setSystemId(string2);
        ParserContext parserContext = new ParserContext(wSDLDocument, this._listeners);
        parserContext.setFollowImports(this._followImports);
        wSDLDocument.setDefinitions(this.parseDefinitions(parserContext, inputSource, null));
        return wSDLDocument;
    }

    protected Definitions parseDefinitions(ParserContext parserContext, InputSource inputSource, String string) {
        parserContext.pushWSDLLocation();
        parserContext.setWSDLLocation(parserContext.getDocument().getSystemId());
        String string2 = parserContext.getDocument().getSystemId();
        this.buildDocumentFromWSDL(string2, inputSource, string);
        Document document = this.wsdlDocuments.get(string2);
        new Internalizer().transform(this.modelInfo.getJAXWSBindings(), this.wsdlDocuments, this.modelInfo.getParent().getEnvironment());
        Definitions definitions = this.parseDefinitionsNoImport(parserContext, document, string);
        this.processImports(parserContext, inputSource, definitions);
        parserContext.popWSDLLocation();
        return definitions;
    }

    private void buildDocumentFromWSDL(String string, InputSource inputSource, String string2) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                }
            });
            if (this.entityResolver != null) {
                documentBuilder.setEntityResolver(this.entityResolver);
            } else {
                documentBuilder.setEntityResolver(new NullEntityResolver());
            }
            try {
                Element element;
                Document document = documentBuilder.parse(inputSource);
                this.wsdlDocuments.put(string, document);
                Element element2 = document.getDocumentElement();
                Util.verifyTagNSRootElement(element2, WSDLConstants.QNAME_DEFINITIONS);
                String string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                String string4 = XmlUtil.getAttributeOrNull((Element)element2, (String)"targetNamespace");
                if (string2 == null || !string2.equals(string4)) {
                    // empty if block
                }
                Iterator iterator = XmlUtil.getAllChildren((Element)element2);
                while (iterator.hasNext() && (element = Util.nextElement(iterator)) != null) {
                    if (!XmlUtil.matchesTagNS(element, WSDLConstants.QNAME_IMPORT)) continue;
                    String string5 = Util.getRequiredAttribute(element, "namespace");
                    String string6 = Util.getRequiredAttribute(element, "location");
                    if ((string6 = this.getAdjustedLocation(inputSource, string6)) == null || string6.equals("") || this.imports.contains(string6)) continue;
                    this.imports.add(string6);
                    InputSource inputSource2 = null;
                    if (this.entityResolver != null) {
                        inputSource2 = this.entityResolver.resolveEntity(null, string6);
                    }
                    if (inputSource2 == null) {
                        inputSource2 = new InputSource(string6);
                    }
                    this.buildDocumentFromWSDL(string6, inputSource2, string5);
                }
            }
            catch (IOException iOException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", inputSource.getSystemId(), iOException);
                }
                throw new ParseException("parsing.ioException", iOException);
            }
            catch (SAXException sAXException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", inputSource.getSystemId(), sAXException);
                }
                throw new ParseException("parsing.saxException", sAXException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("parsing.parserConfigException", parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ParseException("parsing.factoryConfigException", factoryConfigurationError);
        }
    }

    private String getAdjustedLocation(InputSource inputSource, String string) {
        return inputSource.getSystemId() == null ? string : Util.processSystemIdWithBase(inputSource.getSystemId(), string);
    }

    public void dump(OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = XmlUtil.newTransformer();
            for (Map.Entry<String, Document> entry : this.wsdlDocuments.entrySet()) {
                outputStream.write(("---<< " + entry.getKey() + "\n").getBytes());
                transformer.transform(new DOMSource(entry.getValue()), new StreamResult(outputStream));
                outputStream.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    protected void processImports(ParserContext parserContext, InputSource inputSource, Definitions definitions) {
        for (String string : this.imports) {
            Definitions definitions2;
            if (parserContext.getDocument().isImportedDocument(string) || (definitions2 = this.parseDefinitionsNoImport(parserContext, this.wsdlDocuments.get(string), string)) == null) continue;
            parserContext.getDocument().addImportedEntity(definitions2);
            parserContext.getDocument().addImportedDocument(string);
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, InputSource inputSource, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                }
            });
            documentBuilder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = documentBuilder.parse(inputSource);
                return this.parseDefinitionsNoImport(parserContext, document, string);
            }
            catch (IOException iOException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", inputSource.getSystemId(), iOException);
                }
                throw new ParseException("parsing.ioException", iOException);
            }
            catch (SAXException sAXException) {
                if (inputSource.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", inputSource.getSystemId(), sAXException);
                }
                throw new ParseException("parsing.saxException", sAXException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("parsing.parserConfigException", parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ParseException("parsing.factoryConfigException", factoryConfigurationError);
        }
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, Document document, String string) {
        this._targetNamespaceURI = null;
        Element element = document.getDocumentElement();
        Util.verifyTagNSRootElement(element, WSDLConstants.QNAME_DEFINITIONS);
        return this.parseDefinitionsNoImport(parserContext, element, string);
    }

    protected Definitions parseDefinitionsNoImport(ParserContext parserContext, Element element, String string) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Definitions definitions = new Definitions(parserContext.getDocument());
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        definitions.setName(string2);
        this._targetNamespaceURI = XmlUtil.getAttributeOrNull((Element)element, (String)"targetNamespace");
        definitions.setTargetNamespaceURI(this._targetNamespaceURI);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            GlobalEntity globalEntity;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                if (definitions.getDocumentation() != null) continue;
                definitions.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_TYPES)) {
                if (bl2) {
                    Util.fail("parsing.onlyOneTypesAllowed", "definitions");
                }
                this.addSchemaElements(element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_MESSAGE)) {
                globalEntity = this.parseMessage(parserContext, definitions, element2);
                definitions.add((Message)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PORT_TYPE)) {
                globalEntity = this.parsePortType(parserContext, definitions, element2);
                definitions.add((PortType)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_BINDING)) {
                globalEntity = this.parseBinding(parserContext, definitions, element2);
                definitions.add((Binding)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_SERVICE)) {
                globalEntity = this.parseService(parserContext, definitions, element2);
                definitions.add((Service)globalEntity);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(parserContext, definitions, element2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(element2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, definitions, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    protected Message parseMessage(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Message message = new Message(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        message.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                message.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PART)) {
                MessagePart messagePart = this.parseMessagePart(parserContext, element2);
                message.add(messagePart);
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    protected MessagePart parseMessagePart(ParserContext parserContext, Element element) {
        parserContext.push();
        parserContext.registerNamespaces(element);
        MessagePart messagePart = new MessagePart();
        String string = Util.getRequiredAttribute(element, "name");
        messagePart.setName(string);
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"element");
        String string3 = XmlUtil.getAttributeOrNull((Element)element, (String)"type");
        if (string2 != null) {
            if (string3 != null) {
                Util.fail("parsing.onlyOneOfElementOrTypeRequired", string);
            }
            messagePart.setDescriptor(parserContext.translateQualifiedName(string2));
            messagePart.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (string3 != null) {
            messagePart.setDescriptor(parserContext.translateQualifiedName(string3));
            messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            Util.fail("parsing.elementOrTypeRequired", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PART, messagePart);
        return messagePart;
    }

    protected PortType parsePortType(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        PortType portType = new PortType(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        portType.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                if (portType.getDocumentation() != null) continue;
                portType.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                Operation operation = this.parsePortTypeOperation(parserContext, element2);
                portType.add(operation);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, portType, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    protected Operation parsePortTypeOperation(ParserContext parserContext, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Operation operation = new Operation();
        String string = Util.getRequiredAttribute(element, "name");
        operation.setName(string);
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"parameterOrder");
        operation.setParameterOrder(string2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            Element element3;
            Iterator iterator2;
            boolean bl6;
            String string3;
            String string4;
            Entity entity;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                if (operation.getDocumentation() != null) continue;
                operation.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_INPUT)) {
                if (bl2) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element2);
                entity = new Input();
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Input)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Input)entity).setName(string3);
                operation.setInput((Input)entity);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren((Element)element2);
                while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((Input)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", element3.getTagName(), element3.getNamespaceURI());
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OUTPUT)) {
                if (bl3) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element2);
                entity = new Output();
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Output)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Output)entity).setName(string3);
                operation.setOutput((Output)entity);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren((Element)element2);
                while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        ((Output)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", element3.getTagName(), element3.getNamespaceURI());
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_FAULT)) {
                parserContext.push();
                parserContext.registerNamespaces(element2);
                entity = new Fault();
                string4 = Util.getRequiredAttribute(element2, "message");
                ((Fault)entity).setMessage(parserContext.translateQualifiedName(string4));
                string3 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((Fault)entity).setName(string3);
                operation.addFault((Fault)entity);
                bl4 = true;
                bl6 = false;
                iterator2 = XmlUtil.getAllChildren((Element)element2);
                while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        if (((Fault)entity).getDocumentation() != null) continue;
                        ((Fault)entity).setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.checkNotWsdlElement(element3);
                    if (this.handleExtension(parserContext, (Extensible)((Object)entity), element3)) continue;
                    this.checkNotWsdlRequired(element3);
                }
                parserContext.pop();
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, operation, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        if (bl2 && !bl3 && !bl4) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Binding parseBinding(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Binding binding = new Binding(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        binding.setName(string);
        String string2 = Util.getRequiredAttribute(element, "type");
        binding.setPortType(parserContext.translateQualifiedName(string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                binding.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation bindingOperation = this.parseBindingOperation(parserContext, element2);
                binding.add(bindingOperation);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, binding, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(ParserContext parserContext, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        BindingOperation bindingOperation = new BindingOperation();
        String string = Util.getRequiredAttribute(element, "name");
        bindingOperation.setName(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            Object object;
            Object object2;
            Object object3;
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                bindingOperation.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_INPUT)) {
                Element element3;
                if (bl2) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", string});
                }
                object3 = XmlUtil.getAllChildren((Element)element2);
                object2 = Util.nextElement((Iterator)object3);
                if (this.hSet.isEmpty()) {
                    this.hSet.add(object2.getAttribute("use"));
                } else if (!this.hSet.contains(object2.getAttribute("use")) && object2.getAttribute("use") != "") {
                    this.hSet.add(object2.getAttribute("use"));
                }
                parserContext.push();
                parserContext.registerNamespaces(element2);
                BindingInput bindingInput = new BindingInput();
                object = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                bindingInput.setName((String)object);
                bindingOperation.setInput(bindingInput);
                bl2 = true;
                if (bl3) {
                    bl5 = false;
                }
                boolean bl6 = false;
                Iterator iterator2 = XmlUtil.getAllChildren((Element)element2);
                while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                    if (XmlUtil.matchesTagNS(element3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl6) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl6 = true;
                        bindingInput.setDocumentation(this.getDocumentationFor(element3));
                        continue;
                    }
                    this.checkNotWsdlElement(element3);
                    if (this.handleExtension(parserContext, bindingInput, element3)) continue;
                    this.checkNotWsdlRequired(element3);
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_OUTPUT)) {
                Element element4;
                if (bl3) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", string});
                }
                parserContext.push();
                parserContext.registerNamespaces(element2);
                object3 = new BindingOutput();
                object2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                ((BindingOutput)object3).setName((String)object2);
                bindingOperation.setOutput((BindingOutput)object3);
                bl3 = true;
                if (bl2) {
                    bl5 = true;
                }
                boolean bl7 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element4 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element4, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl7) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl7 = true;
                        ((BindingOutput)object3).setDocumentation(this.getDocumentationFor(element4));
                        continue;
                    }
                    this.checkNotWsdlElement(element4);
                    if (this.handleExtension(parserContext, (Extensible)object3, element4)) continue;
                    this.checkNotWsdlRequired(element4);
                }
                parserContext.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_FAULT)) {
                Element element5;
                parserContext.push();
                parserContext.registerNamespaces(element2);
                object3 = new BindingFault();
                object2 = Util.getRequiredAttribute(element2, "name");
                ((BindingFault)object3).setName((String)object2);
                bindingOperation.addFault((BindingFault)object3);
                bl4 = true;
                boolean bl8 = false;
                object = XmlUtil.getAllChildren((Element)element2);
                while (object.hasNext() && (element5 = Util.nextElement((Iterator)object)) != null) {
                    if (XmlUtil.matchesTagNS(element5, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (bl8) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                        }
                        bl8 = true;
                        if (((BindingFault)object3).getDocumentation() != null) continue;
                        ((BindingFault)object3).setDocumentation(this.getDocumentationFor(element5));
                        continue;
                    }
                    this.checkNotWsdlElement(element5);
                    if (this.handleExtension(parserContext, (Extensible)object3, element5)) continue;
                    this.checkNotWsdlRequired(element5);
                }
                parserContext.pop();
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, bindingOperation, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        if (bl2 && !bl3 && !bl4) {
            bindingOperation.setStyle(OperationStyle.ONE_WAY);
        } else if (bl2 && bl3 && bl5) {
            bindingOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (bl2 && bl3 && !bl5) {
            bindingOperation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (bl3 && !bl2 && !bl4) {
            bindingOperation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", string);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, bindingOperation);
        return bindingOperation;
    }

    protected Import parseImport(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Import import_ = new Import();
        String string = Util.getRequiredAttribute(element, "namespace");
        import_.setNamespace(string);
        String string2 = Util.getRequiredAttribute(element, "location");
        import_.setLocation(string2);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                import_.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, import_);
        return import_;
    }

    protected Service parseService(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Service service = new Service(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        service.setName(string);
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                if (service.getDocumentation() != null) continue;
                service.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(parserContext, definitions, element2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, service, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    protected Port parsePort(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Port port = new Port(definitions);
        String string = Util.getRequiredAttribute(element, "name");
        port.setName(string);
        String string2 = Util.getRequiredAttribute(element, "binding");
        port.setBinding(parserContext.translateQualifiedName(string2));
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                if (port.getDocumentation() != null) continue;
                port.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            this.checkNotWsdlElement(element2);
            if (this.handleExtension(parserContext, port, element2)) continue;
            this.checkNotWsdlRequired(element2);
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    protected Types parseTypes(ParserContext parserContext, Definitions definitions, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        Types types = new Types();
        boolean bl = false;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (bl) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", element.getLocalName());
                }
                bl = true;
                types.setDocumentation(this.getDocumentationFor(element2));
                continue;
            }
            if (this._useWSIBasicProfile && XmlUtil.matchesTagNS(element2, SchemaConstants.QNAME_IMPORT)) {
                this.warn("warning.wsi.r2003");
                continue;
            }
            this.checkNotWsdlElement(element2);
            try {
                if (this.handleExtension(parserContext, types, element2)) continue;
                this.checkNotWsdlRequired(element2);
            }
            catch (ParseException parseException) {
                if (!parseException.getKey().equals("parsing.incorrectRootElement")) continue;
                if (this._useWSIBasicProfile) {
                    this.warn("warning.wsi.r2004");
                }
                throw parseException;
            }
        }
        parserContext.pop();
        parserContext.fireDoneParsingEntity(WSDLConstants.QNAME_TYPES, types);
        return types;
    }

    public void addSchemaElements(Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, SchemaConstants.QNAME_SCHEMA)) {
                this._elements.add(element2);
                continue;
            }
            this.checkNotWsdlElement(element2);
        }
    }

    public List getSchemaElements() {
        return this._elements;
    }

    protected boolean handleExtension(ParserContext parserContext, Extensible extensible, Element element) {
        ExtensionHandler extensionHandler = (ExtensionHandler)this._extensionHandlers.get(element.getNamespaceURI());
        if (extensionHandler == null) {
            parserContext.fireIgnoringExtension(new QName(element.getNamespaceURI(), element.getLocalName()), ((Entity)((Object)extensible)).getElementName());
            return false;
        }
        return extensionHandler.doHandleExtension(parserContext, extensible, element);
    }

    protected void checkNotWsdlElement(Element element) {
        if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", element.getTagName());
        }
    }

    protected void checkNotWsdlRequired(Element element) {
        String string = XmlUtil.getAttributeNSOrNull((Element)element, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/");
        if (string != null && string.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", element.getTagName(), element.getNamespaceURI());
        }
    }

    protected Documentation getDocumentationFor(Element element) {
        String string = XmlUtil.getTextForNode((Node)element);
        if (string == null) {
            return null;
        }
        return new Documentation(string);
    }

    protected void error(String string) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(string, new Object[0])));
    }

    public HashSet getUse() {
        return this.hSet;
    }

    protected void warn(String string) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(string, new Object[0])));
    }

    protected void warn(String string, String string2) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(string, new Object[]{string2})));
    }

    protected void warn(String string, Object[] objectArray) {
        System.err.println(this._localizer.localize(this._messageFactory.getMessage(string, objectArray)));
    }
}

