/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Message;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Request;
import com.sun.tools.internal.ws.processor.model.Response;
import com.sun.tools.internal.ws.processor.model.Service;
import java.util.Iterator;

public class ExtendedModelVisitor {
    public void visit(Model model) throws Exception {
        this.preVisit(model);
        for (Service service : model.getServices()) {
            this.preVisit(service);
            for (Port port : service.getPorts()) {
                this.preVisit(port);
                if (this.shouldVisit(port)) {
                    for (Operation operation : port.getOperations()) {
                        ModelObject modelObject;
                        Object object;
                        Iterator<ModelObject> iterator;
                        this.preVisit(operation);
                        Request request = operation.getRequest();
                        if (request != null) {
                            this.preVisit(request);
                            iterator = request.getHeaderBlocks();
                            while (iterator.hasNext()) {
                                object = (Block)iterator.next();
                                this.visitHeaderBlock((Block)object);
                            }
                            iterator = request.getBodyBlocks();
                            while (iterator.hasNext()) {
                                object = iterator.next();
                                this.visitBodyBlock((Block)object);
                            }
                            iterator = request.getParameters();
                            while (iterator.hasNext()) {
                                object = (Parameter)iterator.next();
                                this.visit((Parameter)object);
                            }
                            this.postVisit(request);
                        }
                        if ((iterator = operation.getResponse()) != null) {
                            this.preVisit((Response)((Object)iterator));
                            object = ((Message)((Object)iterator)).getHeaderBlocks();
                            while (object.hasNext()) {
                                modelObject = (Block)object.next();
                                this.visitHeaderBlock((Block)modelObject);
                            }
                            object = ((Message)((Object)iterator)).getBodyBlocks();
                            while (object.hasNext()) {
                                modelObject = (Block)object.next();
                                this.visitBodyBlock((Block)modelObject);
                            }
                            object = ((Message)((Object)iterator)).getParameters();
                            while (object.hasNext()) {
                                modelObject = (Parameter)object.next();
                                this.visit((Parameter)modelObject);
                            }
                            this.postVisit((Response)((Object)iterator));
                        }
                        object = operation.getFaults();
                        while (object.hasNext()) {
                            modelObject = (Fault)object.next();
                            this.preVisit((Fault)modelObject);
                            this.visitFaultBlock(((Fault)modelObject).getBlock());
                            this.postVisit((Fault)modelObject);
                        }
                        this.postVisit(operation);
                    }
                }
                this.postVisit(port);
            }
            this.postVisit(service);
        }
        this.postVisit(model);
    }

    protected boolean shouldVisit(Port port) {
        return true;
    }

    protected void preVisit(Model model) throws Exception {
    }

    protected void postVisit(Model model) throws Exception {
    }

    protected void preVisit(Service service) throws Exception {
    }

    protected void postVisit(Service service) throws Exception {
    }

    protected void preVisit(Port port) throws Exception {
    }

    protected void postVisit(Port port) throws Exception {
    }

    protected void preVisit(Operation operation) throws Exception {
    }

    protected void postVisit(Operation operation) throws Exception {
    }

    protected void preVisit(Request request) throws Exception {
    }

    protected void postVisit(Request request) throws Exception {
    }

    protected void preVisit(Response response) throws Exception {
    }

    protected void postVisit(Response response) throws Exception {
    }

    protected void preVisit(Fault fault) throws Exception {
    }

    protected void postVisit(Fault fault) throws Exception {
    }

    protected void visitBodyBlock(Block block) throws Exception {
    }

    protected void visitHeaderBlock(Block block) throws Exception {
    }

    protected void visitFaultBlock(Block block) throws Exception {
    }

    protected void visit(Parameter parameter) throws Exception {
    }
}

