/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat;

import com.sun.tools.hat.internal.model.ReachableExcludesImpl;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.parser.Reader;
import com.sun.tools.hat.internal.server.QueryListener;
import java.io.File;
import java.io.IOException;

public class Main {
    private static String VERSION_STRING = "jhat version 2.0";

    private static void usage(String string) {
        if (string != null) {
            System.err.println("ERROR: " + string);
        }
        System.err.println("Usage:  jhat [-stack <bool>] [-refs <bool>] [-port <port>] [-baseline <file>] [-debug <int>] [-version] [-h|-help] <file>");
        System.err.println();
        System.err.println("\t-J<flag>          Pass <flag> directly to the runtime system. For");
        System.err.println("\t\t\t  example, -J-mx512m to use a maximum heap size of 512MB");
        System.err.println("\t-stack false:     Turn off tracking object allocation call stack.");
        System.err.println("\t-refs false:      Turn off tracking of references to objects");
        System.err.println("\t-port <port>:     Set the port for the HTTP server.  Defaults to 7000");
        System.err.println("\t-exclude <file>:  Specify a file that lists data members that should");
        System.err.println("\t\t\t  be excluded from the reachableFrom query.");
        System.err.println("\t-baseline <file>: Specify a baseline object dump.  Objects in");
        System.err.println("\t\t\t  both heap dumps with the same ID and same class will");
        System.err.println("\t\t\t  be marked as not being \"new\".");
        System.err.println("\t-debug <int>:     Set debug level.");
        System.err.println("\t\t\t    0:  No debug output");
        System.err.println("\t\t\t    1:  Debug hprof file parsing");
        System.err.println("\t\t\t    2:  Debug hprof file parsing, no server");
        System.err.println("\t-version          Report version number");
        System.err.println("\t-h|-help          Print this help and exit");
        System.err.println("\t<file>            The file to read");
        System.err.println();
        System.err.println("For a dump file that contains multiple heap dumps,");
        System.err.println("you may specify which dump in the file");
        System.err.println("by appending \"#<number>\" to the file name, i.e. \"foo.hprof#3\".");
        System.err.println();
        System.err.println("All boolean options default to \"true\"");
        System.exit(1);
    }

    private static boolean booleanValue(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        Main.usage("Boolean value must be true or false");
        return false;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length < 1) {
            Main.usage("No arguments supplied");
        }
        boolean bl = false;
        int n = 7000;
        boolean bl2 = true;
        boolean bl3 = true;
        Object object4 = null;
        Object object5 = null;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 > stringArray.length - 1) {
                Main.usage("Option parsing error");
            }
            if ("-version".equals(stringArray[n3])) {
                System.out.print(VERSION_STRING);
                System.out.println(" (java version " + System.getProperty("java.version") + ")");
                System.exit(0);
            }
            if ("-h".equals(stringArray[n3]) || "-help".equals(stringArray[n3])) {
                Main.usage(null);
            }
            if (n3 == stringArray.length - 1) break;
            object3 = stringArray[n3];
            object2 = stringArray[n3 + 1];
            if ("-stack".equals(object3)) {
                bl2 = Main.booleanValue((String)object2);
            } else if ("-refs".equals(object3)) {
                bl3 = Main.booleanValue((String)object2);
            } else if ("-port".equals(object3)) {
                n = Integer.parseInt((String)object2, 10);
            } else if ("-exclude".equals(object3)) {
                object5 = object2;
            } else if ("-baseline".equals(object3)) {
                object4 = object2;
            } else if ("-debug".equals(object3)) {
                n2 = Integer.parseInt((String)object2, 10);
            } else if ("-parseonly".equals(object3)) {
                bl = Main.booleanValue((String)object2);
            }
            n3 += 2;
        }
        String string = stringArray[stringArray.length - 1];
        object3 = null;
        object2 = null;
        if (object5 != null && !((File)(object2 = new File((String)object5))).exists()) {
            System.out.println("Exclude file " + object2 + " does not exist.  Aborting.");
            System.exit(1);
        }
        System.out.println("Reading from " + string + "...");
        try {
            object3 = Reader.readFile(string, bl2, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.exit(1);
        }
        System.out.println("Snapshot read, resolving...");
        ((Snapshot)object3).resolve(bl3);
        System.out.println("Snapshot resolved.");
        if (object2 != null) {
            ((Snapshot)object3).setReachableExcludes(new ReachableExcludesImpl((File)object2));
        }
        if (object4 != null) {
            System.out.println("Reading baseline snapshot...");
            object = null;
            try {
                object = Reader.readFile((String)object4, false, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                System.exit(1);
            }
            ((Snapshot)object).resolve(false);
            System.out.println("Discovering new objects...");
            ((Snapshot)object3).markNewRelativeTo((Snapshot)object);
            object = null;
        }
        if (n2 == 2) {
            System.out.println("No server, -debug 2 was used.");
            System.exit(0);
        }
        if (bl) {
            System.out.println("-parseonly is true, exiting..");
            System.exit(0);
        }
        object = new QueryListener(n);
        ((QueryListener)object).setModel((Snapshot)object3);
        Thread thread = new Thread((Runnable)object, "Query Listener");
        thread.setPriority(6);
        thread.start();
        System.out.println("Started HTTP server on port " + n);
        System.out.println("Server is ready.");
    }
}

