/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.BuilderFactory;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.PackageListWriter;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.util.StringTokenizer;

public abstract class AbstractDoclet {
    public Configuration configuration;
    private static final String TOOLKIT_DOCLET_NAME = new HtmlDoclet().getClass().getName();

    private boolean isValidDoclet(AbstractDoclet abstractDoclet) {
        if (!abstractDoclet.getClass().getName().equals(TOOLKIT_DOCLET_NAME)) {
            this.configuration.message.error("doclet.Toolkit_Usage_Violation", TOOLKIT_DOCLET_NAME);
            return false;
        }
        return true;
    }

    public boolean start(AbstractDoclet abstractDoclet, RootDoc rootDoc) {
        this.configuration = this.configuration();
        this.configuration.root = rootDoc;
        if (!this.isValidDoclet(abstractDoclet)) {
            return false;
        }
        try {
            abstractDoclet.startGeneration(rootDoc);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public abstract Configuration configuration();

    private void startGeneration(RootDoc rootDoc) throws Exception {
        if (rootDoc.classes().length == 0) {
            this.configuration.message.error("doclet.No_Public_Classes_To_Document");
            return;
        }
        this.configuration.setOptions();
        this.configuration.getDocletSpecificMsg().notice("doclet.build_version", this.configuration.getDocletSpecificBuildDate());
        ClassTree classTree = new ClassTree(this.configuration, this.configuration.nodeprecated);
        this.generateClassFiles(rootDoc, classTree);
        if (this.configuration.sourcepath != null && this.configuration.sourcepath.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.configuration.sourcepath, String.valueOf(File.pathSeparatorChar));
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                Util.copyDocFiles(this.configuration, stringTokenizer.nextToken() + File.separator, "doc-files", bl);
                bl = false;
            }
        }
        PackageListWriter.generate(this.configuration);
        this.generatePackageFiles(classTree);
        this.generateOtherFiles(rootDoc, classTree);
        this.configuration.tagletManager.printReport();
    }

    protected void generateOtherFiles(RootDoc rootDoc, ClassTree classTree) throws Exception {
        BuilderFactory builderFactory = this.configuration.getBuilderFactory();
        AbstractBuilder abstractBuilder = builderFactory.getConstantsSummaryBuider();
        abstractBuilder.build();
        AbstractBuilder abstractBuilder2 = builderFactory.getSerializedFormBuilder();
        abstractBuilder2.build();
    }

    protected abstract void generatePackageFiles(ClassTree var1) throws Exception;

    protected abstract void generateClassFiles(ClassDoc[] var1, ClassTree var2);

    protected void generateClassFiles(RootDoc rootDoc, ClassTree classTree) {
        this.generateClassFiles(classTree);
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        for (int i = 0; i < packageDocArray.length; ++i) {
            this.generateClassFiles(packageDocArray[i].allClasses(), classTree);
        }
    }

    private void generateClassFiles(ClassTree classTree) {
        String[] stringArray = this.configuration.classDocCatalog.packageNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.generateClassFiles(this.configuration.classDocCatalog.allClasses(stringArray[i]), classTree);
        }
    }
}

