/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.AttributeException;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code_attribute
extends Attribute {
    public final int max_stack;
    public final int max_locals;
    public final int code_length;
    public final byte[] code;
    public final int exception_table_langth;
    public final Exception_data[] exception_table;
    public final Attributes attributes;

    Code_attribute(ClassReader classReader, int n, int n2) throws IOException, ConstantPoolException {
        super(n, n2);
        this.max_stack = classReader.readUnsignedShort();
        this.max_locals = classReader.readUnsignedShort();
        this.code_length = classReader.readInt();
        this.code = new byte[this.code_length];
        classReader.readFully(this.code);
        this.exception_table_langth = classReader.readUnsignedShort();
        this.exception_table = new Exception_data[this.exception_table_langth];
        for (int i = 0; i < this.exception_table_langth; ++i) {
            this.exception_table[i] = new Exception_data(classReader);
        }
        this.attributes = new Attributes(classReader);
    }

    public int getByte(int n) throws InvalidIndex {
        if (n < 0 || n >= this.code.length) {
            throw new InvalidIndex(n);
        }
        return this.code[n];
    }

    public int getUnsignedByte(int n) throws InvalidIndex {
        if (n < 0 || n >= this.code.length) {
            throw new InvalidIndex(n);
        }
        return this.code[n] & 0xFF;
    }

    public int getShort(int n) throws InvalidIndex {
        if (n < 0 || n + 1 >= this.code.length) {
            throw new InvalidIndex(n);
        }
        return this.code[n] << 8 | this.code[n + 1] & 0xFF;
    }

    public int getUnsignedShort(int n) throws InvalidIndex {
        if (n < 0 || n + 1 >= this.code.length) {
            throw new InvalidIndex(n);
        }
        return (this.code[n] << 8 | this.code[n + 1] & 0xFF) & 0xFFFF;
    }

    public int getInt(int n) throws InvalidIndex {
        if (n < 0 || n + 3 >= this.code.length) {
            throw new InvalidIndex(n);
        }
        return this.getShort(n) << 16 | this.getShort(n + 2) & 0xFFFF;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D d) {
        return visitor.visitCode(this, d);
    }

    public class Exception_data {
        public final int start_pc;
        public final int end_pc;
        public final int handler_pc;
        public final int catch_type;

        Exception_data(ClassReader classReader) throws IOException {
            this.start_pc = classReader.readUnsignedShort();
            this.end_pc = classReader.readUnsignedShort();
            this.handler_pc = classReader.readUnsignedShort();
            this.catch_type = classReader.readUnsignedShort();
        }
    }

    public class InvalidIndex
    extends AttributeException {
        public final int index;

        InvalidIndex(int n) {
            this.index = n;
        }

        public String getMessage() {
            return "invalid index " + this.index + " in Code attribute";
        }
    }
}

