/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.apt;

import com.sun.mirror.apt.Filer;
import com.sun.tools.apt.main.JavaCompiler;
import com.sun.tools.apt.mirror.declaration.DeclarationMaker;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.SyncFailedException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilerImpl
implements Filer {
    private final Options opts;
    private final DeclarationMaker declMaker;
    private final JavaCompiler comp;
    private static final String DEFAULT_ENCODING = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    private String encoding;
    private final EnumMap<Filer.Location, File> locations;
    private static final Context.Key<FilerImpl> filerKey = new Context.Key();
    private Collection<Flushable> wc;
    private Bark bark;
    private final Set<File> filesCreated;
    private HashSet<String> sourceFileNames = new HashSet();
    private HashSet<String> classFileNames = new HashSet();
    private boolean roundOver;

    public static FilerImpl instance(Context context) {
        FilerImpl filerImpl = context.get(filerKey);
        if (filerImpl == null) {
            filerImpl = new FilerImpl(context);
        }
        return filerImpl;
    }

    public void flush() {
        for (Flushable flushable : this.wc) {
            try {
                flushable.flush();
                if (!(flushable instanceof FileOutputStream)) continue;
                try {
                    ((FileOutputStream)flushable).getFD().sync();
                }
                catch (SyncFailedException syncFailedException) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    private FilerImpl(Context context) {
        context.put(filerKey, this);
        this.opts = Options.instance(context);
        this.declMaker = DeclarationMaker.instance(context);
        this.bark = Bark.instance(context);
        this.comp = JavaCompiler.instance(context);
        this.roundOver = false;
        this.filesCreated = this.comp.getAggregateGenFiles();
        this.encoding = this.opts.get("-encoding");
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        this.wc = new HashSet<Flushable>();
        this.locations = new EnumMap(Filer.Location.class);
        String string = this.opts.get("-s");
        String string2 = this.opts.get("-d");
        this.locations.put(Filer.Location.SOURCE_TREE, new File(string != null ? string : "."));
        this.locations.put(Filer.Location.CLASS_TREE, new File(string2 != null ? string2 : "."));
    }

    @Override
    public PrintWriter createSourceFile(String string) throws IOException {
        String string2 = this.nameToPath(string, ".java");
        File file = new File(this.locations.get((Object)Filer.Location.SOURCE_TREE), string2);
        PrintWriter printWriter = this.getPrintWriter(file, this.encoding, string, FileKind.SOURCE);
        return printWriter;
    }

    @Override
    public OutputStream createClassFile(String string) throws IOException {
        String string2 = this.nameToPath(string, ".class");
        File file = new File(this.locations.get((Object)Filer.Location.CLASS_TREE), string2);
        OutputStream outputStream = this.getOutputStream(file, string, FileKind.CLASS);
        return outputStream;
    }

    @Override
    public PrintWriter createTextFile(Filer.Location location, String string, File file, String string2) throws IOException {
        File file2;
        File file3 = file2 = string.length() == 0 ? file : new File(this.nameToPath(string), file.getPath());
        if (string2 == null) {
            string2 = this.encoding;
        }
        return this.getPrintWriter(location, file2.getPath(), string2, null, FileKind.OTHER);
    }

    @Override
    public OutputStream createBinaryFile(Filer.Location location, String string, File file) throws IOException {
        File file2 = string.length() == 0 ? file : new File(this.nameToPath(string), file.getPath());
        return this.getOutputStream(location, file2.getPath(), null, FileKind.OTHER);
    }

    private String nameToPath(String string, String string2) throws IOException {
        if (!DeclarationMaker.isJavaIdentifier(string.replace('.', '_'))) {
            this.bark.aptWarning("IllegalFileName", string);
            throw new IOException();
        }
        return string.replace('.', File.separatorChar) + string2;
    }

    private String nameToPath(String string) throws IOException {
        return this.nameToPath(string, "");
    }

    private PrintWriter getPrintWriter(Filer.Location location, String string, String string2, String string3, FileKind fileKind) throws IOException {
        File file = new File(this.locations.get((Object)location), string);
        return this.getPrintWriter(file, string2, string3, fileKind);
    }

    private PrintWriter getPrintWriter(File file, String string, String string2, FileKind fileKind) throws IOException {
        this.prepareFile(file, string2, fileKind);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)));
        this.wc.add(printWriter);
        return printWriter;
    }

    private OutputStream getOutputStream(Filer.Location location, String string, String string2, FileKind fileKind) throws IOException {
        File file = new File(this.locations.get((Object)location), string);
        return this.getOutputStream(file, string2, fileKind);
    }

    private OutputStream getOutputStream(File file, String string, FileKind fileKind) throws IOException {
        this.prepareFile(file, string, fileKind);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.wc.add(fileOutputStream);
        return fileOutputStream;
    }

    public Set<String> getSourceFileNames() {
        return this.sourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.classFileNames;
    }

    public void roundOver() {
        this.roundOver = true;
    }

    private void prepareFile(File file, String string, FileKind fileKind) throws IOException {
        if (this.roundOver) {
            this.bark.aptWarning("NoNewFilesAfterRound", file.toString());
            throw new IOException();
        }
        if (this.filesCreated.contains(file)) {
            this.bark.aptWarning("FileReopening", file.toString());
            throw new IOException();
        }
        if (file.exists()) {
            file.delete();
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                this.bark.aptWarning("BadParentDirectory", file.toString());
                throw new IOException();
            }
        }
        fileKind.register(file, string, this);
        this.filesCreated.add(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileKind {
        SOURCE{

            void register(File file, String string, FilerImpl filerImpl) throws IOException {
                if (filerImpl.filesCreated.contains(new File((File)filerImpl.locations.get((Object)Filer.Location.CLASS_TREE), filerImpl.nameToPath(string, ".class")))) {
                    filerImpl.bark.aptWarning("CorrespondingClassFile", string);
                    if (filerImpl.opts.get("-XclassesAsDecls") != null) {
                        throw new IOException();
                    }
                }
                filerImpl.sourceFileNames.add(file.getPath());
            }
        }
        ,
        CLASS{

            void register(File file, String string, FilerImpl filerImpl) throws IOException {
                if (filerImpl.filesCreated.contains(new File((File)filerImpl.locations.get((Object)Filer.Location.SOURCE_TREE), filerImpl.nameToPath(string, ".java")))) {
                    filerImpl.bark.aptWarning("CorrespondingSourceFile", string);
                    if (filerImpl.opts.get("-XclassesAsDecls") != null) {
                        throw new IOException();
                    }
                }
                filerImpl.classFileNames.add(string);
            }
        }
        ,
        OTHER{

            void register(File file, String string, FilerImpl filerImpl) throws IOException {
            }
        };


        abstract void register(File var1, String var2, FilerImpl var3) throws IOException;
    }
}

