/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidityDateExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "InvalidityDate";
    public static final String DATE = "date";
    private Date date;

    private void encodeThis() throws IOException {
        if (this.date == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.date);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public InvalidityDateExtension(Date date) throws IOException {
        this(false, date);
    }

    public InvalidityDateExtension(boolean bl, Date date) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = bl;
        this.date = date;
        this.encodeThis();
    }

    public InvalidityDateExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.date = derValue.getGeneralizedTime();
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Date)) {
            throw new IOException("Attribute must be of type Date.");
        }
        if (!string.equalsIgnoreCase(DATE)) {
            throw new IOException("Name not supported by InvalidityDateExtension");
        }
        this.date = (Date)object;
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DATE)) {
            return this.date;
        }
        throw new IOException("Name not supported by InvalidityDateExtension");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(DATE)) {
            throw new IOException("Name not supported by InvalidityDateExtension");
        }
        this.date = null;
        this.encodeThis();
    }

    @Override
    public String toString() {
        return super.toString() + "    Invalidity Date: " + String.valueOf(this.date);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DATE);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static InvalidityDateExtension toImpl(java.security.cert.Extension extension) throws IOException {
        if (extension instanceof InvalidityDateExtension) {
            return (InvalidityDateExtension)extension;
        }
        return new InvalidityDateExtension((Boolean)extension.isCritical(), extension.getValue());
    }
}

