/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LauncherHelper {
    INSTANCE;

    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static ResourceBundle javarb;
    private static final String MAIN_CLASS = "Main-Class";
    private static StringBuilder outBuf;

    private static String getLocalizedMessage(String string, Object ... objectArray) {
        String string2 = javarb.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static void initHelpMessage(String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", string == null ? "java" : string));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", string, string2));
    }

    static void appendVmSynonymMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", string, string2));
    }

    static void appendVmErgoMessage(boolean bl, String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.ergo.message1", string));
        outBuf = bl ? outBuf.append(",\n" + LauncherHelper.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        printStream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassFromJar(String string) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new IOException("manifest not found in " + string);
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                throw new IOException("no main mainifest attributes, in " + string);
            }
            String string2 = attributes.getValue(MAIN_CLASS).trim();
            return string2;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public static Object checkAndLoadMain(boolean bl, boolean bl2, String string) throws IOException {
        String string2 = bl2 ? LauncherHelper.getMainClassFromJar(string) : string;
        string2 = string2.replace('/', '.');
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = null;
        PrintStream printStream = bl ? System.err : System.out;
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.cls.error1", string2));
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(string2);
            noClassDefFoundError.initCause(classNotFoundException);
            throw noClassDefFoundError;
        }
        LauncherHelper.signatureDiagnostic(printStream, clazz);
        return clazz;
    }

    static void signatureDiagnostic(PrintStream printStream, Class<?> clazz) {
        String string = clazz.getName();
        Method method = null;
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (Exception exception) {
            printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.cls.error4", string));
            throw new RuntimeException("Main method not found in " + string);
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n)) {
            printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.cls.error2", "static", string));
            throw new RuntimeException("Main method is not static in class " + string);
        }
        Class<?> clazz2 = method.getReturnType();
        if (!clazz2.isPrimitive() || !clazz2.getName().equals("void")) {
            printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.cls.error3", string));
            throw new RuntimeException("Main method must return a value of type void in class " + string);
        }
    }

    static {
        javarb = ResourceBundle.getBundle(defaultBundleName);
        outBuf = new StringBuilder();
    }
}

