/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.tools.jstat.Arguments;
import sun.tools.jstat.JStatLogger;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.OptionLister;
import sun.tools.jstat.OptionOutputFormatter;
import sun.tools.jstat.OutputFormatter;
import sun.tools.jstat.RawOutputFormatter;

public class Jstat {
    private static Arguments arguments;

    public static void main(String[] stringArray) {
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            Arguments.printUsage(System.err);
            System.exit(1);
        }
        if (arguments.isHelp()) {
            Arguments.printUsage(System.out);
            System.exit(0);
        }
        if (arguments.isOptions()) {
            OptionLister optionLister = new OptionLister(arguments.optionsSources());
            optionLister.print(System.out);
            System.exit(0);
        }
        try {
            if (arguments.isList()) {
                Jstat.logNames();
            } else if (arguments.isSnap()) {
                Jstat.logSnapShot();
            } else {
                Jstat.logSamples();
            }
        }
        catch (MonitorException monitorException) {
            if (monitorException.getMessage() != null) {
                System.err.println(monitorException.getMessage());
            } else {
                Throwable throwable = monitorException.getCause();
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(throwable.getMessage());
                } else {
                    monitorException.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    static void logNames() throws MonitorException {
        VmIdentifier vmIdentifier = arguments.vmId();
        int n = arguments.sampleInterval();
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, n);
        JStatLogger jStatLogger = new JStatLogger(monitoredVm);
        jStatLogger.printNames(arguments.counterNames(), arguments.comparator(), arguments.showUnsupported(), System.out);
        monitoredHost.detach(monitoredVm);
    }

    static void logSnapShot() throws MonitorException {
        VmIdentifier vmIdentifier = arguments.vmId();
        int n = arguments.sampleInterval();
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, n);
        JStatLogger jStatLogger = new JStatLogger(monitoredVm);
        jStatLogger.printSnapShot(arguments.counterNames(), arguments.comparator(), arguments.isVerbose(), arguments.showUnsupported(), System.out);
        monitoredHost.detach(monitoredVm);
    }

    static void logSamples() throws MonitorException {
        Object object;
        final VmIdentifier vmIdentifier = arguments.vmId();
        int n = arguments.sampleInterval();
        final MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmIdentifier);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, n);
        final JStatLogger jStatLogger = new JStatLogger(monitoredVm);
        OutputFormatter outputFormatter = null;
        if (arguments.isSpecialOption()) {
            object = arguments.optionFormat();
            outputFormatter = new OptionOutputFormatter(monitoredVm, (OptionFormat)object);
        } else {
            object = monitoredVm.findByPattern(arguments.counterNames());
            Collections.sort(object, arguments.comparator());
            ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Monitor monitor2 = (Monitor)iterator.next();
                if (!monitor2.isSupported() && !arguments.showUnsupported()) {
                    iterator.remove();
                    continue;
                }
                if (monitor2.getVariability() == Variability.CONSTANT) {
                    iterator.remove();
                    if (!arguments.printConstants()) continue;
                    arrayList.add(monitor2);
                    continue;
                }
                if (monitor2.getUnits() != Units.STRING || arguments.printStrings()) continue;
                iterator.remove();
            }
            if (!arrayList.isEmpty()) {
                jStatLogger.printList(arrayList, arguments.isVerbose(), arguments.showUnsupported(), System.out);
                if (!object.isEmpty()) {
                    System.out.println();
                }
            }
            if (object.isEmpty()) {
                monitoredHost.detach(monitoredVm);
                return;
            }
            outputFormatter = new RawOutputFormatter((List)object, arguments.printStrings());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                jStatLogger.stopLogging();
            }
        });
        object = new HostListener(){

            public void vmStatusChanged(VmStatusChangeEvent vmStatusChangeEvent) {
                Integer n = new Integer(vmIdentifier.getLocalVmId());
                if (vmStatusChangeEvent.getTerminated().contains(n)) {
                    jStatLogger.stopLogging();
                } else if (!vmStatusChangeEvent.getActive().contains(n)) {
                    jStatLogger.stopLogging();
                }
            }

            public void disconnected(HostEvent hostEvent) {
                if (monitoredHost == hostEvent.getMonitoredHost()) {
                    jStatLogger.stopLogging();
                }
            }
        };
        if (vmIdentifier.getLocalVmId() != 0) {
            monitoredHost.addHostListener((HostListener)object);
        }
        jStatLogger.logSamples(outputFormatter, arguments.headerRate(), arguments.sampleInterval(), arguments.sampleCount(), System.out);
        if (object != null) {
            monitoredHost.removeHostListener((HostListener)object);
        }
        monitoredHost.detach(monitoredVm);
    }
}

