/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;

public class MonitoredVmUtil {
    private static int IS_ATTACHABLE = 0;
    private static int IS_KERNEL_VM = 1;

    private MonitoredVmUtil() {
    }

    public static String vmVersion(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("java.property.java.vm.version");
        return stringMonitor == null ? "Unknown" : stringMonitor.stringValue();
    }

    public static String commandLine(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("sun.rt.javaCommand");
        return stringMonitor == null ? "Unknown" : stringMonitor.stringValue();
    }

    public static String mainArgs(MonitoredVm monitoredVm) throws MonitorException {
        String string = MonitoredVmUtil.commandLine(monitoredVm);
        int n = string.indexOf(32);
        if (n > 0) {
            return string.substring(n + 1);
        }
        if (string.compareTo("Unknown") == 0) {
            return string;
        }
        return null;
    }

    public static String mainClass(MonitoredVm monitoredVm, boolean bl) throws MonitorException {
        String string;
        String string2 = string = MonitoredVmUtil.commandLine(monitoredVm);
        int n = string.indexOf(32);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if (!bl) {
            int n2 = string2.lastIndexOf(47);
            if (n2 > 0) {
                return string2.substring(n2 + 1);
            }
            n2 = string2.lastIndexOf(92);
            if (n2 > 0) {
                return string2.substring(n2 + 1);
            }
            int n3 = string2.lastIndexOf(46);
            if (n3 > 0) {
                return string2.substring(n3 + 1);
            }
        }
        return string2;
    }

    public static String jvmArgs(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("java.rt.vmArgs");
        return stringMonitor == null ? "Unknown" : stringMonitor.stringValue();
    }

    public static String jvmFlags(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("java.rt.vmFlags");
        return stringMonitor == null ? "Unknown" : stringMonitor.stringValue();
    }

    public static boolean isAttachable(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("sun.rt.jvmCapabilities");
        if (stringMonitor == null) {
            return false;
        }
        return stringMonitor.stringValue().charAt(IS_ATTACHABLE) == '1';
    }

    public static boolean isKernelVM(MonitoredVm monitoredVm) throws MonitorException {
        StringMonitor stringMonitor = (StringMonitor)monitoredVm.findByName("sun.rt.jvmCapabilities");
        if (stringMonitor == null) {
            return false;
        }
        return stringMonitor.stringValue().charAt(IS_KERNEL_VM) == '1';
    }
}

