/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchive
implements JavacFileManager.Archive {
    protected JavacFileManager fileManager;
    protected final Map<RelativePath.RelativeDirectory, List<String>> map;
    protected final ZipFile zdir;

    public ZipArchive(JavacFileManager javacFileManager, ZipFile zipFile) throws IOException {
        this(javacFileManager, zipFile, true);
    }

    protected ZipArchive(JavacFileManager javacFileManager, ZipFile zipFile, boolean bl) throws IOException {
        this.fileManager = javacFileManager;
        this.zdir = zipFile;
        this.map = new HashMap<RelativePath.RelativeDirectory, List<String>>();
        if (bl) {
            this.initMap();
        }
    }

    protected void initMap() throws IOException {
        Enumeration<? extends ZipEntry> enumeration = this.zdir.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry;
            try {
                zipEntry = enumeration.nextElement();
            }
            catch (InternalError internalError) {
                IOException iOException = new IOException();
                iOException.initCause(internalError);
                throw iOException;
            }
            this.addZipEntry(zipEntry);
        }
    }

    void addZipEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        int n = string.lastIndexOf(47);
        RelativePath.RelativeDirectory relativeDirectory = new RelativePath.RelativeDirectory(string.substring(0, n + 1));
        String string2 = string.substring(n + 1);
        if (string2.length() == 0) {
            return;
        }
        List<String> list = this.map.get(relativeDirectory);
        if (list == null) {
            list = List.nil();
        }
        list = list.prepend(string2);
        this.map.put(relativeDirectory, list);
    }

    @Override
    public boolean contains(RelativePath relativePath) {
        RelativePath.RelativeDirectory relativeDirectory = relativePath.dirname();
        String string = relativePath.basename();
        if (string.length() == 0) {
            return false;
        }
        List<String> list = this.map.get(relativeDirectory);
        return list != null && list.contains(string);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        return this.map.get(relativeDirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
        ZipEntry zipEntry = new RelativePath.RelativeFile(relativeDirectory, string).getZipEntry(this.zdir);
        return new ZipFileObject(this, string, zipEntry);
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.map.keySet();
    }

    @Override
    public void close() throws IOException {
        this.zdir.close();
    }

    public String toString() {
        return "ZipArchive[" + this.zdir.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFileObject
    extends BaseFileObject {
        private String name;
        ZipArchive zarch;
        ZipEntry entry;

        protected ZipFileObject(ZipArchive zipArchive, String string, ZipEntry zipEntry) {
            super(zipArchive.fileManager);
            this.zarch = zipArchive;
            this.name = string;
            this.entry = zipEntry;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.zarch.zdir.getInputStream(this.entry);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CharsetDecoder getDecoder(boolean bl) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            return this.name.equals(string + kind.extension);
        }

        @Override
        @Deprecated
        public String getPath() {
            return this.zarch.zdir.getName() + "(" + this.entry + ")";
        }

        @Override
        public long getLastModified() {
            return this.entry.getTime();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer = this.fileManager.getCachedContent(this);
            if (charBuffer == null) {
                InputStream inputStream = this.zarch.zdir.getInputStream(this.entry);
                try {
                    ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(inputStream);
                    JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                    try {
                        charBuffer = this.fileManager.decode(byteBuffer, bl);
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.fileManager.log.useSource(javaFileObject);
                        throw throwable;
                    }
                    this.fileManager.log.useSource(javaFileObject);
                    this.fileManager.recycleByteBuffer(byteBuffer);
                    if (!bl) {
                        this.fileManager.cache(this, charBuffer);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            return charBuffer;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ZipFileObject)) {
                return false;
            }
            ZipFileObject zipFileObject = (ZipFileObject)object;
            return this.zarch.zdir.equals(zipFileObject.zarch.zdir) || this.name.equals(zipFileObject.name);
        }

        public int hashCode() {
            return this.zarch.zdir.hashCode() + this.name.hashCode();
        }

        public String getZipName() {
            return this.zarch.zdir.getName();
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        @Override
        public URI toUri() {
            String string = new File(this.getZipName()).toURI().normalize().getPath();
            String string2 = this.getZipEntryName();
            return URI.create("jar:" + string + "!" + string2);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            String string = this.getZipEntryName();
            return ZipFileObject.removeExtension(string).replace('/', '.');
        }
    }
}

