/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.model;

public final class Multiplicity {
    public final int min;
    public final Integer max;
    public static final Multiplicity ZERO = new Multiplicity(0, 0);
    public static final Multiplicity ONE = new Multiplicity(1, 1);
    public static final Multiplicity OPTIONAL = new Multiplicity(0, 1);
    public static final Multiplicity STAR = new Multiplicity(0, null);
    public static final Multiplicity PLUS = new Multiplicity(1, null);

    public static Multiplicity create(int n, Integer n2) {
        if (n == 0 && n2 == null) {
            return STAR;
        }
        if (n == 1 && n2 == null) {
            return PLUS;
        }
        if (n2 != null) {
            if (n == 0 && n2 == 0) {
                return ZERO;
            }
            if (n == 0 && n2 == 1) {
                return OPTIONAL;
            }
            if (n == 1 && n2 == 1) {
                return ONE;
            }
        }
        return new Multiplicity(n, n2);
    }

    private Multiplicity(int n, Integer n2) {
        this.min = n;
        this.max = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Multiplicity)) {
            return false;
        }
        Multiplicity multiplicity = (Multiplicity)object;
        if (this.min != multiplicity.min) {
            return false;
        }
        return !(this.max != null ? !this.max.equals(multiplicity.max) : multiplicity.max != null);
    }

    public int hashCode() {
        int n = this.min;
        n = 29 * n + (this.max != null ? this.max.hashCode() : 0);
        return n;
    }

    public boolean isUnique() {
        if (this.max == null) {
            return false;
        }
        return this.min == 1 && this.max == 1;
    }

    public boolean isOptional() {
        if (this.max == null) {
            return false;
        }
        return this.min == 0 && this.max == 1;
    }

    public boolean isAtMostOnce() {
        if (this.max == null) {
            return false;
        }
        return this.max <= 1;
    }

    public boolean isZero() {
        if (this.max == null) {
            return false;
        }
        return this.max == 0;
    }

    public boolean includes(Multiplicity multiplicity) {
        if (multiplicity.min < this.min) {
            return false;
        }
        if (this.max == null) {
            return true;
        }
        if (multiplicity.max == null) {
            return false;
        }
        return multiplicity.max <= this.max;
    }

    public String getMaxString() {
        if (this.max == null) {
            return "unbounded";
        }
        return this.max.toString();
    }

    public String toString() {
        return "(" + this.min + ',' + this.getMaxString() + ')';
    }

    public static Multiplicity choice(Multiplicity multiplicity, Multiplicity multiplicity2) {
        return Multiplicity.create(Math.min(multiplicity.min, multiplicity2.min), multiplicity.max == null || multiplicity2.max == null ? null : Integer.valueOf(Math.max(multiplicity.max, multiplicity2.max)));
    }

    public static Multiplicity group(Multiplicity multiplicity, Multiplicity multiplicity2) {
        return Multiplicity.create(multiplicity.min + multiplicity2.min, multiplicity.max == null || multiplicity2.max == null ? null : Integer.valueOf(multiplicity.max + multiplicity2.max));
    }

    public static Multiplicity multiply(Multiplicity multiplicity, Multiplicity multiplicity2) {
        int n = multiplicity.min * multiplicity2.min;
        Object object = Multiplicity.isZero(multiplicity.max) || Multiplicity.isZero(multiplicity2.max) ? Integer.valueOf(0) : (multiplicity.max == null || multiplicity2.max == null ? null : Integer.valueOf(multiplicity.max * multiplicity2.max));
        return Multiplicity.create(n, (Integer)object);
    }

    private static boolean isZero(Integer n) {
        return n != null && n == 0;
    }

    public static Multiplicity oneOrMore(Multiplicity multiplicity) {
        if (multiplicity.max == null) {
            return multiplicity;
        }
        if (multiplicity.max == 0) {
            return multiplicity;
        }
        return Multiplicity.create(multiplicity.min, null);
    }

    public Multiplicity makeOptional() {
        if (this.min == 0) {
            return this;
        }
        return Multiplicity.create(0, this.max);
    }

    public Multiplicity makeRepeated() {
        if (this.max == null || this.max == 0) {
            return this;
        }
        return Multiplicity.create(this.min, null);
    }
}

