/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message
extends ModelObject {
    private Map<QName, Block> _attachmentBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _bodyBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _headerBlocks = new HashMap<QName, Block>();
    private Map<QName, Block> _unboundBlocks = new HashMap<QName, Block>();
    private List<Parameter> _parameters = new ArrayList<Parameter>();
    private Map<String, Parameter> _parametersByName = new HashMap<String, Parameter>();

    public void addBodyBlock(Block block) {
        if (this._bodyBlocks.containsKey(block.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._bodyBlocks.put(block.getName(), block);
        block.setLocation(1);
    }

    public Iterator<Block> getBodyBlocks() {
        return this._bodyBlocks.values().iterator();
    }

    public int getBodyBlockCount() {
        return this._bodyBlocks.size();
    }

    public Map<QName, Block> getBodyBlocksMap() {
        return this._bodyBlocks;
    }

    public void setBodyBlocksMap(Map<QName, Block> map) {
        this._bodyBlocks = map;
    }

    public boolean isBodyEmpty() {
        return this.getBodyBlocks().hasNext();
    }

    public boolean isBodyEncoded() {
        boolean bl = false;
        Iterator<Block> iterator = this.getBodyBlocks();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!block.getType().isSOAPType()) continue;
            bl = true;
        }
        return bl;
    }

    public void addHeaderBlock(Block block) {
        if (this._headerBlocks.containsKey(block.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._headerBlocks.put(block.getName(), block);
        block.setLocation(2);
    }

    public Iterator<Block> getHeaderBlocks() {
        return this._headerBlocks.values().iterator();
    }

    public Collection<Block> getHeaderBlockCollection() {
        return this._headerBlocks.values();
    }

    public int getHeaderBlockCount() {
        return this._headerBlocks.size();
    }

    public Map<QName, Block> getHeaderBlocksMap() {
        return this._headerBlocks;
    }

    public void setHeaderBlocksMap(Map<QName, Block> map) {
        this._headerBlocks = map;
    }

    public void addAttachmentBlock(Block block) {
        if (this._attachmentBlocks.containsKey(block.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._attachmentBlocks.put(block.getName(), block);
        block.setLocation(3);
    }

    public void addUnboundBlock(Block block) {
        if (this._unboundBlocks.containsKey(block.getName())) {
            return;
        }
        this._unboundBlocks.put(block.getName(), block);
        block.setLocation(0);
    }

    public Iterator<Block> getUnboundBlocks() {
        return this._unboundBlocks.values().iterator();
    }

    public Map<QName, Block> getUnboundBlocksMap() {
        return this._unboundBlocks;
    }

    public int getUnboundBlocksCount() {
        return this._unboundBlocks.size();
    }

    public void setUnboundBlocksMap(Map<QName, Block> map) {
        this._unboundBlocks = map;
    }

    public Iterator<Block> getAttachmentBlocks() {
        return this._attachmentBlocks.values().iterator();
    }

    public int getAttachmentBlockCount() {
        return this._attachmentBlocks.size();
    }

    public Map<QName, Block> getAttachmentBlocksMap() {
        return this._attachmentBlocks;
    }

    public void setAttachmentBlocksMap(Map<QName, Block> map) {
        this._attachmentBlocks = map;
    }

    public void addParameter(Parameter parameter) {
        if (this._parametersByName.containsKey(parameter.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._parameters.add(parameter);
        this._parametersByName.put(parameter.getName(), parameter);
    }

    public Parameter getParameterByName(String string) {
        if (this._parametersByName.size() != this._parameters.size()) {
            this.initializeParametersByName();
        }
        return this._parametersByName.get(string);
    }

    public Iterator<Parameter> getParameters() {
        return this._parameters.iterator();
    }

    public List<Parameter> getParametersList() {
        return this._parameters;
    }

    public void setParametersList(List<Parameter> list) {
        this._parameters = list;
    }

    private void initializeParametersByName() {
        this._parametersByName = new HashMap<String, Parameter>();
        if (this._parameters != null) {
            for (Parameter parameter : this._parameters) {
                if (parameter.getName() != null && this._parametersByName.containsKey(parameter.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this._parametersByName.put(parameter.getName(), parameter);
            }
        }
    }

    public Set<Block> getAllBlocks() {
        HashSet<Block> hashSet = new HashSet<Block>();
        hashSet.addAll(this._bodyBlocks.values());
        hashSet.addAll(this._headerBlocks.values());
        hashSet.addAll(this._attachmentBlocks.values());
        return hashSet;
    }
}

