/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.parser;

import com.sun.tools.hat.internal.model.ArrayTypeCodes;
import com.sun.tools.hat.internal.model.JavaBoolean;
import com.sun.tools.hat.internal.model.JavaByte;
import com.sun.tools.hat.internal.model.JavaChar;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaDouble;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaFloat;
import com.sun.tools.hat.internal.model.JavaInt;
import com.sun.tools.hat.internal.model.JavaLong;
import com.sun.tools.hat.internal.model.JavaObject;
import com.sun.tools.hat.internal.model.JavaObjectArray;
import com.sun.tools.hat.internal.model.JavaObjectRef;
import com.sun.tools.hat.internal.model.JavaShort;
import com.sun.tools.hat.internal.model.JavaStatic;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.JavaValueArray;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.model.StackFrame;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.parser.MappedReadBuffer;
import com.sun.tools.hat.internal.parser.PositionDataInputStream;
import com.sun.tools.hat.internal.parser.Reader;
import com.sun.tools.hat.internal.util.Misc;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;

public class HprofReader
extends Reader
implements ArrayTypeCodes {
    static final int MAGIC_NUMBER = 1245795905;
    private static final String[] VERSIONS = new String[]{" PROFILE 1.0\u0000", " PROFILE 1.0.1\u0000", " PROFILE 1.0.2\u0000"};
    private static final int VERSION_JDK12BETA3 = 0;
    private static final int VERSION_JDK12BETA4 = 1;
    private static final int VERSION_JDK6 = 2;
    static final int HPROF_UTF8 = 1;
    static final int HPROF_LOAD_CLASS = 2;
    static final int HPROF_UNLOAD_CLASS = 3;
    static final int HPROF_FRAME = 4;
    static final int HPROF_TRACE = 5;
    static final int HPROF_ALLOC_SITES = 6;
    static final int HPROF_HEAP_SUMMARY = 7;
    static final int HPROF_START_THREAD = 10;
    static final int HPROF_END_THREAD = 11;
    static final int HPROF_HEAP_DUMP = 12;
    static final int HPROF_CPU_SAMPLES = 13;
    static final int HPROF_CONTROL_SETTINGS = 14;
    static final int HPROF_LOCKSTATS_WAIT_TIME = 16;
    static final int HPROF_LOCKSTATS_HOLD_TIME = 17;
    static final int HPROF_GC_ROOT_UNKNOWN = 255;
    static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    static final int HPROF_GC_CLASS_DUMP = 32;
    static final int HPROF_GC_INSTANCE_DUMP = 33;
    static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    static final int HPROF_HEAP_DUMP_END = 44;
    private static final int T_CLASS = 2;
    private int version;
    private int debugLevel;
    private long currPos;
    private int dumpsToSkip;
    private boolean callStack;
    private int identifierSize;
    private Hashtable<Long, String> names;
    private Hashtable<Integer, ThreadObject> threadObjects;
    private Hashtable<Long, String> classNameFromObjectID;
    private Hashtable<Integer, String> classNameFromSerialNo;
    private Hashtable<Long, StackFrame> stackFrames;
    private Hashtable<Integer, StackTrace> stackTraces;
    private Snapshot snapshot;

    public HprofReader(String string, PositionDataInputStream positionDataInputStream, int n, boolean bl, int n2) throws IOException {
        super(positionDataInputStream);
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        this.snapshot = new Snapshot(MappedReadBuffer.create(randomAccessFile));
        this.dumpsToSkip = n - 1;
        this.callStack = bl;
        this.debugLevel = n2;
        this.names = new Hashtable();
        this.threadObjects = new Hashtable(43);
        this.classNameFromObjectID = new Hashtable();
        if (bl) {
            this.stackFrames = new Hashtable(43);
            this.stackTraces = new Hashtable(43);
            this.classNameFromSerialNo = new Hashtable();
        }
    }

    public Snapshot read() throws IOException {
        this.currPos = 4L;
        this.version = this.readVersionHeader();
        this.identifierSize = this.in.readInt();
        this.snapshot.setIdentifierSize(this.identifierSize);
        if (this.version >= 1) {
            this.snapshot.setNewStyleArrayClass(true);
        } else {
            this.snapshot.setNewStyleArrayClass(false);
        }
        this.currPos += 4L;
        if (this.identifierSize != 4 && this.identifierSize != 8) {
            throw new IOException("I'm sorry, but I can't deal with an identifier size of " + this.identifierSize + ".  I can only deal with 4 or 8.");
        }
        System.out.println("Dump file created " + new Date(this.in.readLong()));
        this.currPos += 8L;
        block16: while (true) {
            int n;
            try {
                n = this.in.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                break;
            }
            this.in.readInt();
            long l = (long)this.in.readInt() & 0xFFFFFFFFL;
            if (this.debugLevel > 0) {
                System.out.println("Read record type " + n + ", length " + l + " at position " + this.toHex(this.currPos));
            }
            if (l < 0L) {
                throw new IOException("Bad record length of " + l + " at byte " + this.toHex(this.currPos + 5L) + " of file.");
            }
            this.currPos += 9L + l;
            switch (n) {
                case 1: {
                    long l2 = this.readID();
                    Object object = new byte[(int)l - this.identifierSize];
                    this.in.readFully((byte[])object);
                    this.names.put(new Long(l2), new String((byte[])object));
                    continue block16;
                }
                case 2: {
                    int n2 = this.in.readInt();
                    long l3 = this.readID();
                    int n3 = this.in.readInt();
                    long l4 = this.readID();
                    Object object2 = new Long(l3);
                    String string = this.getNameFromID(l4).replace('/', '.');
                    this.classNameFromObjectID.put((Long)object2, string);
                    if (this.classNameFromSerialNo == null) continue block16;
                    this.classNameFromSerialNo.put(new Integer(n2), string);
                    continue block16;
                }
                case 12: {
                    if (this.dumpsToSkip <= 0) {
                        try {
                            this.readHeapDump(l, this.currPos);
                        }
                        catch (EOFException eOFException) {
                            this.handleEOF(eOFException, this.snapshot);
                        }
                        if (this.debugLevel > 0) {
                            System.out.println("    Finished processing instances in heap dump.");
                        }
                        return this.snapshot;
                    }
                    --this.dumpsToSkip;
                    this.skipBytes(l);
                    continue block16;
                }
                case 44: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            this.skipBytes(l);
                            return this.snapshot;
                        }
                        --this.dumpsToSkip;
                    } else {
                        this.warn("Ignoring unrecognized record type " + n);
                    }
                    this.skipBytes(l);
                    continue block16;
                }
                case 28: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            try {
                                this.readHeapDump(l, this.currPos);
                            }
                            catch (EOFException eOFException) {
                                this.handleEOF(eOFException, this.snapshot);
                            }
                            continue block16;
                        }
                        this.skipBytes(l);
                        continue block16;
                    }
                    this.warn("Ignoring unrecognized record type " + n);
                    this.skipBytes(l);
                    continue block16;
                }
                case 4: {
                    if (this.stackFrames == null) {
                        this.skipBytes(l);
                        continue block16;
                    }
                    long l5 = this.readID();
                    Object object = this.getNameFromID(this.readID());
                    String string = this.getNameFromID(this.readID());
                    String string2 = this.getNameFromID(this.readID());
                    int n4 = this.in.readInt();
                    Object object2 = this.classNameFromSerialNo.get(new Integer(n4));
                    int n5 = this.in.readInt();
                    if (n5 < -3) {
                        this.warn("Weird stack frame line number:  " + n5);
                        n5 = -1;
                    }
                    this.stackFrames.put(new Long(l5), new StackFrame((String)object, string, (String)object2, string2, n5));
                    continue block16;
                }
                case 5: {
                    long l4;
                    int n3;
                    if (this.stackTraces == null) {
                        this.skipBytes(l);
                        continue block16;
                    }
                    int n6 = this.in.readInt();
                    int n7 = this.in.readInt();
                    Object object = new StackFrame[this.in.readInt()];
                    for (n3 = 0; n3 < ((byte[])object).length; ++n3) {
                        l4 = this.readID();
                        object[n3] = (byte)this.stackFrames.get(new Long(l4));
                        if (object[n3] != null) continue;
                        throw new IOException("Stack frame " + this.toHex(l4) + " not found");
                    }
                    this.stackTraces.put(new Integer(n6), new StackTrace((StackFrame[])object));
                    continue block16;
                }
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    this.skipBytes(l);
                    continue block16;
                }
            }
            this.skipBytes(l);
            this.warn("Ignoring unrecognized record type " + n);
        }
        return this.snapshot;
    }

    private void skipBytes(long l) throws IOException {
        this.in.skipBytes((int)l);
    }

    private int readVersionHeader() throws IOException {
        int n;
        int n2 = VERSIONS.length;
        boolean[] blArray = new boolean[VERSIONS.length];
        for (n = 0; n < n2; ++n) {
            blArray[n] = true;
        }
        n = 0;
        while (n2 > 0) {
            char c = (char)this.in.readByte();
            ++this.currPos;
            for (int i = 0; i < VERSIONS.length; ++i) {
                if (!blArray[i]) continue;
                if (c != VERSIONS[i].charAt(n)) {
                    blArray[i] = false;
                    --n2;
                    continue;
                }
                if (n != VERSIONS[i].length() - 1) continue;
                return i;
            }
            ++n;
        }
        throw new IOException("Version string not recognized at byte " + (n + 3));
    }

    private void readHeapDump(long l, long l2) throws IOException {
        block15: while (l > 0L) {
            int n = this.in.readUnsignedByte();
            if (this.debugLevel > 0) {
                System.out.println("    Read heap sub-record type " + n + " at position " + this.toHex(l2 - l));
            }
            --l;
            switch (n) {
                case 255: {
                    long l3 = this.readID();
                    l -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(l3, 0L, 1, ""));
                    continue block15;
                }
                case 8: {
                    long l4 = this.readID();
                    int n2 = this.in.readInt();
                    int n3 = this.in.readInt();
                    l -= (long)(this.identifierSize + 8);
                    this.threadObjects.put(new Integer(n2), new ThreadObject(l4, n3));
                    continue block15;
                }
                case 1: {
                    long l5 = this.readID();
                    long l6 = this.readID();
                    l -= (long)(2 * this.identifierSize);
                    this.snapshot.addRoot(new Root(l5, 0L, 4, ""));
                    continue block15;
                }
                case 2: {
                    long l7 = this.readID();
                    int n2 = this.in.readInt();
                    int n4 = this.in.readInt();
                    l -= (long)(this.identifierSize + 8);
                    Object object = this.getThreadObjectFromSequence(n2);
                    StackTrace stackTrace = this.getStackTraceFromSerial(((ThreadObject)object).stackSeq);
                    if (stackTrace != null) {
                        stackTrace = stackTrace.traceForDepth(n4 + 1);
                    }
                    this.snapshot.addRoot(new Root(l7, ((ThreadObject)object).threadId, 3, "", stackTrace));
                    continue block15;
                }
                case 3: {
                    long l8 = this.readID();
                    int n2 = this.in.readInt();
                    int n5 = this.in.readInt();
                    l -= (long)(this.identifierSize + 8);
                    Object object = this.getThreadObjectFromSequence(n2);
                    StackTrace stackTrace = this.getStackTraceFromSerial(((ThreadObject)object).stackSeq);
                    if (stackTrace != null) {
                        stackTrace = stackTrace.traceForDepth(n5 + 1);
                    }
                    this.snapshot.addRoot(new Root(l8, ((ThreadObject)object).threadId, 7, "", stackTrace));
                    continue block15;
                }
                case 4: {
                    long l9 = this.readID();
                    int n2 = this.in.readInt();
                    l -= (long)(this.identifierSize + 4);
                    ThreadObject threadObject = this.getThreadObjectFromSequence(n2);
                    Object object = this.getStackTraceFromSerial(threadObject.stackSeq);
                    this.snapshot.addRoot(new Root(l9, threadObject.threadId, 8, "", (StackTrace)object));
                    continue block15;
                }
                case 5: {
                    long l10 = this.readID();
                    l -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(l10, 0L, 2, ""));
                    continue block15;
                }
                case 6: {
                    long l11 = this.readID();
                    int n2 = this.in.readInt();
                    l -= (long)(this.identifierSize + 4);
                    ThreadObject threadObject = this.getThreadObjectFromSequence(n2);
                    Object object = this.getStackTraceFromSerial(threadObject.stackSeq);
                    this.snapshot.addRoot(new Root(l11, threadObject.threadId, 5, "", (StackTrace)object));
                    continue block15;
                }
                case 7: {
                    long l12 = this.readID();
                    l -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(l12, 0L, 6, ""));
                    continue block15;
                }
                case 32: {
                    int n6 = this.readClass();
                    l -= (long)n6;
                    continue block15;
                }
                case 33: {
                    int n7 = this.readInstance();
                    l -= (long)n7;
                    continue block15;
                }
                case 34: {
                    int n8 = this.readArray(false);
                    l -= (long)n8;
                    continue block15;
                }
                case 35: {
                    int n9 = this.readArray(true);
                    l -= (long)n9;
                    continue block15;
                }
            }
            throw new IOException("Unrecognized heap dump sub-record type:  " + n);
        }
        if (l != 0L) {
            this.warn("Error reading heap dump or heap dump segment:  Byte count is " + l + " instead of 0");
            this.skipBytes(l);
        }
        if (this.debugLevel > 0) {
            System.out.println("    Finished heap sub-records.");
        }
    }

    private long readID() throws IOException {
        return this.identifierSize == 4 ? Snapshot.SMALL_ID_MASK & (long)this.in.readInt() : this.in.readLong();
    }

    private int readValue(JavaThing[] javaThingArray) throws IOException {
        byte by = this.in.readByte();
        return 1 + this.readValueForType(by, javaThingArray);
    }

    private int readValueForType(byte by, JavaThing[] javaThingArray) throws IOException {
        if (this.version >= 1) {
            by = this.signatureFromTypeId(by);
        }
        return this.readValueForTypeSignature(by, javaThingArray);
    }

    private int readValueForTypeSignature(byte by, JavaThing[] javaThingArray) throws IOException {
        switch (by) {
            case 76: 
            case 91: {
                long l = this.readID();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaObjectRef(l);
                }
                return this.identifierSize;
            }
            case 90: {
                byte by2 = this.in.readByte();
                if (by2 != 0 && by2 != 1) {
                    this.warn("Illegal boolean value read");
                }
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaBoolean(by2 != 0);
                }
                return 1;
            }
            case 66: {
                byte by3 = this.in.readByte();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaByte(by3);
                }
                return 1;
            }
            case 83: {
                short s = this.in.readShort();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaShort(s);
                }
                return 2;
            }
            case 67: {
                char c = this.in.readChar();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaChar(c);
                }
                return 2;
            }
            case 73: {
                int n = this.in.readInt();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaInt(n);
                }
                return 4;
            }
            case 74: {
                long l = this.in.readLong();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaLong(l);
                }
                return 8;
            }
            case 70: {
                float f = this.in.readFloat();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaFloat(f);
                }
                return 4;
            }
            case 68: {
                double d = this.in.readDouble();
                if (javaThingArray != null) {
                    javaThingArray[0] = new JavaDouble(d);
                }
                return 8;
            }
        }
        throw new IOException("Bad value signature:  " + by);
    }

    private ThreadObject getThreadObjectFromSequence(int n) throws IOException {
        ThreadObject threadObject = this.threadObjects.get(new Integer(n));
        if (threadObject == null) {
            throw new IOException("Thread " + n + " not found for JNI local ref");
        }
        return threadObject;
    }

    private String getNameFromID(long l) throws IOException {
        return this.getNameFromID(new Long(l));
    }

    private String getNameFromID(Long l) throws IOException {
        if (l == 0L) {
            return "";
        }
        String string = this.names.get(l);
        if (string == null) {
            this.warn("Name not found at " + this.toHex(l));
            return "unresolved name " + this.toHex(l);
        }
        return string;
    }

    private StackTrace getStackTraceFromSerial(int n) throws IOException {
        if (this.stackTraces == null) {
            return null;
        }
        StackTrace stackTrace = this.stackTraces.get(new Integer(n));
        if (stackTrace == null) {
            this.warn("Stack trace not found for serial # " + n);
        }
        return stackTrace;
    }

    private int readClass() throws IOException {
        Object object;
        int n;
        int n2;
        long l = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        long l2 = this.readID();
        long l3 = this.readID();
        long l4 = this.readID();
        long l5 = this.readID();
        long l6 = this.readID();
        long l7 = this.readID();
        int n3 = this.in.readInt();
        int n4 = 7 * this.identifierSize + 8;
        int n5 = this.in.readUnsignedShort();
        n4 += 2;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6 = this.in.readUnsignedShort();
            n4 += 2;
            n4 += this.readValue(null);
        }
        n2 = this.in.readUnsignedShort();
        n4 += 2;
        JavaThing[] javaThingArray = new JavaThing[1];
        JavaStatic[] javaStaticArray = new JavaStatic[n2];
        for (n = 0; n < n2; ++n) {
            long l8 = this.readID();
            n4 += this.identifierSize;
            byte by = this.in.readByte();
            ++n4;
            n4 += this.readValueForType(by, javaThingArray);
            String string = this.getNameFromID(l8);
            if (this.version >= 1) {
                by = this.signatureFromTypeId(by);
            }
            String string2 = "" + (char)by;
            object = new JavaField(string, string2);
            javaStaticArray[n] = new JavaStatic((JavaField)object, javaThingArray[0]);
        }
        n = this.in.readUnsignedShort();
        n4 += 2;
        JavaField[] javaFieldArray = new JavaField[n];
        for (int i = 0; i < n; ++i) {
            long l9 = this.readID();
            n4 += this.identifierSize;
            byte by = this.in.readByte();
            ++n4;
            object = this.getNameFromID(l9);
            if (this.version >= 1) {
                by = this.signatureFromTypeId(by);
            }
            String string = "" + (char)by;
            javaFieldArray[i] = new JavaField((String)object, string);
        }
        String string = this.classNameFromObjectID.get(new Long(l));
        if (string == null) {
            this.warn("Class name not found for " + this.toHex(l));
            string = "unknown-name@" + this.toHex(l);
        }
        JavaClass javaClass = new JavaClass(l, string, l2, l3, l4, l5, javaFieldArray, javaStaticArray, n3);
        this.snapshot.addClass(l, javaClass);
        this.snapshot.setSiteTrace(javaClass, stackTrace);
        return n4;
    }

    private String toHex(long l) {
        return Misc.toHex(l);
    }

    private int readInstance() throws IOException {
        long l = this.in.position();
        long l2 = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        long l3 = this.readID();
        int n = this.in.readInt();
        int n2 = 2 * this.identifierSize + 8 + n;
        JavaObject javaObject = new JavaObject(l3, l);
        this.skipBytes(n);
        this.snapshot.addHeapObject(l2, javaObject);
        this.snapshot.setSiteTrace(javaObject, stackTrace);
        return n2;
    }

    private int readArray(boolean bl) throws IOException {
        long l;
        long l2 = this.in.position();
        long l3 = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        int n = this.in.readInt();
        int n2 = this.identifierSize + 8;
        if (bl) {
            l = this.in.readByte();
            ++n2;
        } else {
            l = this.readID();
            n2 += this.identifierSize;
        }
        byte by = 0;
        int n3 = 0;
        if (bl || this.version < 1) {
            switch ((int)l) {
                case 4: {
                    by = 90;
                    n3 = 1;
                    break;
                }
                case 5: {
                    by = 67;
                    n3 = 2;
                    break;
                }
                case 6: {
                    by = 70;
                    n3 = 4;
                    break;
                }
                case 7: {
                    by = 68;
                    n3 = 8;
                    break;
                }
                case 8: {
                    by = 66;
                    n3 = 1;
                    break;
                }
                case 9: {
                    by = 83;
                    n3 = 2;
                    break;
                }
                case 10: {
                    by = 73;
                    n3 = 4;
                    break;
                }
                case 11: {
                    by = 74;
                    n3 = 8;
                }
            }
            if (this.version >= 1 && by == 0) {
                throw new IOException("Unrecognized typecode:  " + l);
            }
        }
        if (by != 0) {
            int n4 = n3 * n;
            n2 += n4;
            JavaValueArray javaValueArray = new JavaValueArray(by, l2);
            this.skipBytes(n4);
            this.snapshot.addHeapObject(l3, javaValueArray);
            this.snapshot.setSiteTrace(javaValueArray, stackTrace);
        } else {
            int n5 = n * this.identifierSize;
            n2 += n5;
            JavaObjectArray javaObjectArray = new JavaObjectArray(l, l2);
            this.skipBytes(n5);
            this.snapshot.addHeapObject(l3, javaObjectArray);
            this.snapshot.setSiteTrace(javaObjectArray, stackTrace);
        }
        return n2;
    }

    private byte signatureFromTypeId(byte by) throws IOException {
        switch (by) {
            case 2: {
                return 76;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 67;
            }
            case 6: {
                return 70;
            }
            case 7: {
                return 68;
            }
            case 8: {
                return 66;
            }
            case 9: {
                return 83;
            }
            case 10: {
                return 73;
            }
            case 11: {
                return 74;
            }
        }
        throw new IOException("Invalid type id of " + by);
    }

    private void handleEOF(EOFException eOFException, Snapshot snapshot) {
        if (this.debugLevel > 0) {
            eOFException.printStackTrace();
        }
        this.warn("Unexpected EOF. Will miss information...");
        snapshot.setUnresolvedObjectsOK(true);
    }

    private void warn(String string) {
        System.out.println("WARNING: " + string);
    }

    private class ThreadObject {
        long threadId;
        int stackSeq;

        ThreadObject(long l, int n) {
            this.threadId = l;
            this.stackSeq = n;
        }
    }
}

