/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.plaf.synth.SynthIcon;

class SynthMenuItemLayoutHelper
extends MenuItemLayoutHelper {
    public static final StringUIClientPropertyKey MAX_ACC_OR_ARROW_WIDTH = new StringUIClientPropertyKey("maxAccOrArrowWidth");
    public static final MenuItemLayoutHelper.ColumnAlignment LTR_ALIGNMENT_1 = new MenuItemLayoutHelper.ColumnAlignment(2, 2, 2, 4, 4);
    public static final MenuItemLayoutHelper.ColumnAlignment LTR_ALIGNMENT_2 = new MenuItemLayoutHelper.ColumnAlignment(2, 2, 2, 2, 4);
    public static final MenuItemLayoutHelper.ColumnAlignment RTL_ALIGNMENT_1 = new MenuItemLayoutHelper.ColumnAlignment(4, 4, 4, 2, 2);
    public static final MenuItemLayoutHelper.ColumnAlignment RTL_ALIGNMENT_2 = new MenuItemLayoutHelper.ColumnAlignment(4, 4, 4, 4, 2);
    private SynthContext context;
    private SynthContext accContext;
    private SynthStyle style;
    private SynthStyle accStyle;
    private SynthGraphicsUtils gu;
    private SynthGraphicsUtils accGu;
    private boolean alignAcceleratorText;
    private int maxAccOrArrowWidth;

    public SynthMenuItemLayoutHelper(SynthContext synthContext, SynthContext synthContext2, JMenuItem jMenuItem, Icon icon, Icon icon2, Rectangle rectangle, int n, String string, boolean bl, boolean bl2, String string2) {
        this.context = synthContext;
        this.accContext = synthContext2;
        this.style = synthContext.getStyle();
        this.accStyle = synthContext2.getStyle();
        this.gu = this.style.getGraphicsUtils(synthContext);
        this.accGu = this.accStyle.getGraphicsUtils(synthContext2);
        this.alignAcceleratorText = this.getAlignAcceleratorText(string2);
        this.reset(jMenuItem, icon, icon2, rectangle, n, string, bl, this.style.getFont(synthContext), this.accStyle.getFont(synthContext2), bl2, string2);
        this.setLeadingGap(0);
    }

    private boolean getAlignAcceleratorText(String string) {
        return this.style.getBoolean(this.context, string + ".alignAcceleratorText", true);
    }

    protected void calcWidthsAndHeights() {
        if (this.getIcon() != null) {
            this.getIconSize().setWidth(SynthIcon.getIconWidth(this.getIcon(), this.context));
            this.getIconSize().setHeight(SynthIcon.getIconHeight(this.getIcon(), this.context));
        }
        if (!this.getAccText().equals("")) {
            this.getAccSize().setWidth(this.accGu.computeStringWidth(this.getAccContext(), this.getAccFontMetrics().getFont(), this.getAccFontMetrics(), this.getAccText()));
            this.getAccSize().setHeight(this.getAccFontMetrics().getHeight());
        }
        if (this.getText() == null) {
            this.setText("");
        } else if (!this.getText().equals("")) {
            if (this.getHtmlView() != null) {
                this.getTextSize().setWidth((int)this.getHtmlView().getPreferredSpan(0));
                this.getTextSize().setHeight((int)this.getHtmlView().getPreferredSpan(1));
            } else {
                this.getTextSize().setWidth(this.gu.computeStringWidth(this.context, this.getFontMetrics().getFont(), this.getFontMetrics(), this.getText()));
                this.getTextSize().setHeight(this.getFontMetrics().getHeight());
            }
        }
        if (this.useCheckAndArrow()) {
            if (this.getCheckIcon() != null) {
                this.getCheckSize().setWidth(SynthIcon.getIconWidth(this.getCheckIcon(), this.context));
                this.getCheckSize().setHeight(SynthIcon.getIconHeight(this.getCheckIcon(), this.context));
            }
            if (this.getArrowIcon() != null) {
                this.getArrowSize().setWidth(SynthIcon.getIconWidth(this.getArrowIcon(), this.context));
                this.getArrowSize().setHeight(SynthIcon.getIconHeight(this.getArrowIcon(), this.context));
            }
        }
        if (this.isColumnLayout()) {
            this.getLabelSize().setWidth(this.getIconSize().getWidth() + this.getTextSize().getWidth() + this.getGap());
            this.getLabelSize().setHeight(MenuItemLayoutHelper.max(this.getCheckSize().getHeight(), this.getIconSize().getHeight(), this.getTextSize().getHeight(), this.getAccSize().getHeight(), this.getArrowSize().getHeight()));
        } else {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            this.gu.layoutText(this.context, this.getFontMetrics(), this.getText(), this.getIcon(), this.getHorizontalAlignment(), this.getVerticalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), this.getViewRect(), rectangle2, rectangle, this.getGap());
            rectangle.width += this.getLeftTextExtraWidth() + this.getRightTextExtraWidth();
            Rectangle rectangle3 = rectangle2.union(rectangle);
            this.getLabelSize().setHeight(rectangle3.height);
            this.getLabelSize().setWidth(rectangle3.width);
        }
    }

    protected void calcMaxWidths() {
        this.calcMaxWidth(this.getCheckSize(), MAX_CHECK_WIDTH);
        this.maxAccOrArrowWidth = this.calcMaxValue(MAX_ACC_OR_ARROW_WIDTH, this.getArrowSize().getWidth());
        this.maxAccOrArrowWidth = this.calcMaxValue(MAX_ACC_OR_ARROW_WIDTH, this.getAccSize().getWidth());
        if (this.isColumnLayout()) {
            this.calcMaxWidth(this.getIconSize(), MAX_ICON_WIDTH);
            this.calcMaxWidth(this.getTextSize(), MAX_TEXT_WIDTH);
            int n = this.getGap();
            if (this.getIconSize().getMaxWidth() == 0 || this.getTextSize().getMaxWidth() == 0) {
                n = 0;
            }
            this.getLabelSize().setMaxWidth(this.calcMaxValue(MAX_LABEL_WIDTH, this.getIconSize().getMaxWidth() + this.getTextSize().getMaxWidth() + n));
        } else {
            this.getIconSize().setMaxWidth(this.getParentIntProperty(MAX_ICON_WIDTH));
            this.calcMaxWidth(this.getLabelSize(), MAX_LABEL_WIDTH);
            int n = this.getLabelSize().getMaxWidth() - this.getIconSize().getMaxWidth();
            if (this.getIconSize().getMaxWidth() > 0) {
                n -= this.getGap();
            }
            this.getTextSize().setMaxWidth(this.calcMaxValue(MAX_TEXT_WIDTH, n));
        }
    }

    public SynthContext getContext() {
        return this.context;
    }

    public SynthContext getAccContext() {
        return this.accContext;
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    public SynthStyle getAccStyle() {
        return this.accStyle;
    }

    public SynthGraphicsUtils getGraphicsUtils() {
        return this.gu;
    }

    public SynthGraphicsUtils getAccGraphicsUtils() {
        return this.accGu;
    }

    public boolean alignAcceleratorText() {
        return this.alignAcceleratorText;
    }

    public int getMaxAccOrArrowWidth() {
        return this.maxAccOrArrowWidth;
    }

    protected void prepareForLayout(MenuItemLayoutHelper.LayoutResult layoutResult) {
        layoutResult.getCheckRect().width = this.getCheckSize().getMaxWidth();
        if (this.useCheckAndArrow() && !"".equals(this.getAccText())) {
            layoutResult.getAccRect().width = this.maxAccOrArrowWidth;
        } else {
            layoutResult.getArrowRect().width = this.maxAccOrArrowWidth;
        }
    }

    public MenuItemLayoutHelper.ColumnAlignment getLTRColumnAlignment() {
        if (this.alignAcceleratorText()) {
            return LTR_ALIGNMENT_2;
        }
        return LTR_ALIGNMENT_1;
    }

    public MenuItemLayoutHelper.ColumnAlignment getRTLColumnAlignment() {
        if (this.alignAcceleratorText()) {
            return RTL_ALIGNMENT_2;
        }
        return RTL_ALIGNMENT_1;
    }

    protected void layoutIconAndTextInLabelRect(MenuItemLayoutHelper.LayoutResult layoutResult) {
        layoutResult.setTextRect(new Rectangle());
        layoutResult.setIconRect(new Rectangle());
        this.gu.layoutText(this.context, this.getFontMetrics(), this.getText(), this.getIcon(), this.getHorizontalAlignment(), this.getVerticalAlignment(), this.getHorizontalTextPosition(), this.getVerticalTextPosition(), layoutResult.getLabelRect(), layoutResult.getIconRect(), layoutResult.getTextRect(), this.getGap());
    }
}

