/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.relation.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleList
extends ArrayList<Object> {
    private transient boolean typeSafe;
    private transient boolean tainted;
    private static final long serialVersionUID = 5568344346499649313L;

    public RoleList() {
    }

    public RoleList(int n) {
        super(n);
    }

    public RoleList(List<Role> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        RoleList.checkTypeSafe(list);
        super.addAll(list);
    }

    public List<Role> asList() {
        if (!this.typeSafe) {
            if (this.tainted) {
                RoleList.checkTypeSafe(this);
            }
            this.typeSafe = true;
        }
        return (List)Util.cast(this);
    }

    public void add(Role role) throws IllegalArgumentException {
        if (role == null) {
            String string = "Invalid parameter";
            throw new IllegalArgumentException(string);
        }
        super.add(role);
    }

    @Override
    public void add(int n, Role role) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (role == null) {
            String string = "Invalid parameter";
            throw new IllegalArgumentException(string);
        }
        super.add(n, role);
    }

    @Override
    public void set(int n, Role role) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (role == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        super.set(n, role);
    }

    public boolean addAll(RoleList roleList) throws IndexOutOfBoundsException {
        if (roleList == null) {
            return true;
        }
        return super.addAll(roleList);
    }

    public boolean addAll(int n, RoleList roleList) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (roleList == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        return super.addAll(n, roleList);
    }

    @Override
    public boolean add(Object object) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(object);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(object);
        }
        return super.add(object);
    }

    @Override
    public void add(int n, Object object) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(object);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(object);
        }
        super.add(n, object);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(collection);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(collection);
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<?> collection) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(collection);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(collection);
        }
        return super.addAll(n, collection);
    }

    @Override
    public Object set(int n, Object object) {
        if (!this.tainted) {
            this.tainted = RoleList.isTainted(object);
        }
        if (this.typeSafe) {
            RoleList.checkTypeSafe(object);
        }
        return super.set(n, object);
    }

    private static void checkTypeSafe(Object object) {
        try {
            object = (Role)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    private static void checkTypeSafe(Collection<?> collection) {
        try {
            for (Object obj : collection) {
                Role role = (Role)obj;
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    private static boolean isTainted(Object object) {
        try {
            RoleList.checkTypeSafe(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return false;
    }

    private static boolean isTainted(Collection<?> collection) {
        try {
            RoleList.checkTypeSafe(collection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return false;
    }
}

