/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class EllipseIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    AffineTransform affine;
    int index;
    public static final double CtrlVal = 0.5522847498307933;
    private static final double pcv = 0.7761423749153966;
    private static final double ncv = 0.22385762508460333;
    private static double[][] ctrlpts = new double[][]{{1.0, 0.7761423749153966, 0.7761423749153966, 1.0, 0.5, 1.0}, {0.22385762508460333, 1.0, 0.0, 0.7761423749153966, 0.0, 0.5}, {0.0, 0.22385762508460333, 0.22385762508460333, 0.0, 0.5, 0.0}, {0.7761423749153966, 0.0, 1.0, 0.22385762508460333, 1.0, 0.5}};

    EllipseIterator(Ellipse2D ellipse2D, AffineTransform affineTransform) {
        this.x = ellipse2D.getX();
        this.y = ellipse2D.getY();
        this.w = ellipse2D.getWidth();
        this.h = ellipse2D.getHeight();
        this.affine = affineTransform;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index > 5;
    }

    public void next() {
        ++this.index;
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] dArray = ctrlpts[3];
            fArray[0] = (float)(this.x + dArray[4] * this.w);
            fArray[1] = (float)(this.y + dArray[5] * this.h);
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 0;
        }
        double[] dArray = ctrlpts[this.index - 1];
        fArray[0] = (float)(this.x + dArray[0] * this.w);
        fArray[1] = (float)(this.y + dArray[1] * this.h);
        fArray[2] = (float)(this.x + dArray[2] * this.w);
        fArray[3] = (float)(this.y + dArray[3] * this.h);
        fArray[4] = (float)(this.x + dArray[4] * this.w);
        fArray[5] = (float)(this.y + dArray[5] * this.h);
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 3);
        }
        return 3;
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("ellipse iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        if (this.index == 0) {
            double[] dArray2 = ctrlpts[3];
            dArray[0] = this.x + dArray2[4] * this.w;
            dArray[1] = this.y + dArray2[5] * this.h;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 0;
        }
        double[] dArray3 = ctrlpts[this.index - 1];
        dArray[0] = this.x + dArray3[0] * this.w;
        dArray[1] = this.y + dArray3[1] * this.h;
        dArray[2] = this.x + dArray3[2] * this.w;
        dArray[3] = this.y + dArray3[3] * this.h;
        dArray[4] = this.x + dArray3[4] * this.w;
        dArray[5] = this.y + dArray3[5] * this.h;
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 3);
        }
        return 3;
    }
}

