/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Window;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowAccessor {
    private static Class windowClass;
    private static Field fieldIsAutoRequestFocus;
    private static Field fieldIsTrayIconWindow;
    private static final Logger log;

    private WindowAccessor() {
    }

    public static boolean isAutoRequestFocus(Window window) {
        try {
            return fieldIsAutoRequestFocus.getBoolean(window);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Window object", illegalAccessException);
            return true;
        }
    }

    public static boolean isTrayIconWindow(Window window) {
        try {
            return fieldIsTrayIconWindow.getBoolean(window);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Window object", illegalAccessException);
            return false;
        }
    }

    public static void setTrayIconWindow(Window window, boolean bl) {
        try {
            fieldIsTrayIconWindow.set(window, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.FINE, "Unable to access the Window object", illegalAccessException);
        }
    }

    static {
        log = Logger.getLogger("sun.awt.WindowAccessor");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    windowClass = Class.forName("java.awt.Window");
                    fieldIsAutoRequestFocus = windowClass.getDeclaredField("autoRequestFocus");
                    fieldIsAutoRequestFocus.setAccessible(true);
                    fieldIsTrayIconWindow = windowClass.getDeclaredField("isTrayIconWindow");
                    fieldIsTrayIconWindow.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    log.log(Level.FINE, "Unable to initialize WindowAccessor: ", noSuchFieldException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.log(Level.FINE, "Unable to initialize WindowAccessor: ", classNotFoundException);
                }
                return null;
            }
        });
    }
}

