/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorPanel;

final class DiagramComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private final ColorPanel panel;
    private final boolean diagram;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private int width;
    private int height;
    private int[] array;
    private BufferedImage image;

    DiagramComponent(ColorPanel colorPanel, boolean bl) {
        this.panel = colorPanel;
        this.diagram = bl;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void paintComponent(Graphics graphics) {
        boolean bl;
        this.getInsets(this.insets);
        this.width = this.getWidth() - this.insets.left - this.insets.right;
        this.height = this.getHeight() - this.insets.top - this.insets.bottom;
        boolean bl2 = bl = this.image == null || this.width != this.image.getWidth() || this.height != this.image.getHeight();
        if (bl) {
            int n = this.width * this.height;
            if (this.array == null || this.array.length < n) {
                this.array = new int[n];
            }
            this.image = new BufferedImage(this.width, this.height, 1);
        }
        float f = 1.0f / (float)(this.width - 1);
        float f2 = 1.0f / (float)(this.height - 1);
        int n = 0;
        float f3 = 0.0f;
        int n2 = 0;
        while (n2 < this.height) {
            int n3;
            if (this.diagram) {
                float f4 = 0.0f;
                n3 = 0;
                while (n3 < this.width) {
                    this.array[n] = this.panel.getColor(f4, f3);
                    ++n3;
                    f4 += f;
                    ++n;
                }
            } else {
                int n4 = this.panel.getColor(f3);
                n3 = 0;
                while (n3 < this.width) {
                    this.array[n] = n4;
                    ++n3;
                    ++n;
                }
            }
            ++n2;
            f3 += f2;
        }
        this.image.setRGB(0, 0, this.width, this.height, this.array, 0, this.width);
        graphics.drawImage(this.image, this.insets.left, this.insets.top, this.width, this.height, this);
        if (this.isEnabled()) {
            --this.width;
            --this.height;
            graphics.setXORMode(Color.WHITE);
            graphics.setColor(Color.BLACK);
            if (this.diagram) {
                int n5 = DiagramComponent.getValue(this.panel.getValueX(), this.insets.left, this.width);
                int n6 = DiagramComponent.getValue(this.panel.getValueY(), this.insets.top, this.height);
                graphics.drawLine(n5 - 8, n6, n5 + 8, n6);
                graphics.drawLine(n5, n6 - 8, n5, n6 + 8);
            } else {
                int n7 = DiagramComponent.getValue(this.panel.getValueZ(), this.insets.top, this.height);
                graphics.drawLine(this.insets.left, n7, this.insets.left + this.width, n7);
            }
            graphics.setPaintMode();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            float f = DiagramComponent.getValue(mouseEvent.getY(), this.insets.top, this.height);
            if (this.diagram) {
                float f2 = DiagramComponent.getValue(mouseEvent.getX(), this.insets.left, this.width);
                this.panel.setValue(f2, f);
            } else {
                this.panel.setValue(f);
            }
        }
    }

    private static int getValue(float f, int n, int n2) {
        return n + (int)(f * (float)n2);
    }

    private static float getValue(int n, int n2, int n3) {
        if (n2 < n) {
            return (n -= n2) < n3 ? (float)n / (float)n3 : 1.0f;
        }
        return 0.0f;
    }
}

