/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final String uiClassID = "ScrollBarUI";
    private ChangeListener fwdAdjustmentEvents = new ModelListener();
    protected BoundedRangeModel model;
    protected int orientation;
    protected int unitIncrement;
    protected int blockIncrement;

    private void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public JScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.checkOrientation(n);
        this.unitIncrement = 1;
        this.blockIncrement = n3 == 0 ? 1 : n3;
        this.orientation = n;
        this.model = new DefaultBoundedRangeModel(n2, n3, n4, n5);
        this.model.addChangeListener(this.fwdAdjustmentEvents);
        this.setRequestFocusEnabled(false);
        this.updateUI();
    }

    public JScrollBar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public JScrollBar() {
        this(1);
    }

    public void setUI(ScrollBarUI scrollBarUI) {
        super.setUI(scrollBarUI);
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        if (n2 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (n != n2) {
            this.revalidate();
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        Integer n = null;
        BoundedRangeModel boundedRangeModel2 = this.model;
        if (this.model != null) {
            this.model.removeChangeListener(this.fwdAdjustmentEvents);
            n = this.model.getValue();
        }
        this.model = boundedRangeModel;
        if (this.model != null) {
            this.model.addChangeListener(this.fwdAdjustmentEvents);
        }
        this.firePropertyChange("model", boundedRangeModel2, this.model);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n, new Integer(this.model.getValue()));
        }
    }

    public int getUnitIncrement(int n) {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int n) {
        int n2 = this.unitIncrement;
        this.unitIncrement = n;
        this.firePropertyChange("unitIncrement", n2, n);
    }

    public int getBlockIncrement(int n) {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int n) {
        int n2 = this.blockIncrement;
        this.blockIncrement = n;
        this.firePropertyChange("blockIncrement", n2, n);
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n2, boundedRangeModel.getValue());
        }
    }

    public int getVisibleAmount() {
        return this.getModel().getExtent();
    }

    public void setVisibleAmount(int n) {
        this.getModel().setExtent(n);
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public boolean getValueIsAdjusting() {
        return this.getModel().getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean bl) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        boolean bl2 = boundedRangeModel.getValueIsAdjusting();
        boundedRangeModel.setValueIsAdjusting(bl);
        if (bl2 != bl && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.BUSY : null, bl ? AccessibleState.BUSY : null);
        }
    }

    public void setValues(int n, int n2, int n3, int n4) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n5 = boundedRangeModel.getValue();
        boundedRangeModel.setRangeProperties(n, n2, n3, n4, boundedRangeModel.getValueIsAdjusting());
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n5, boundedRangeModel.getValue());
        }
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(AdjustmentListener.class, adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(AdjustmentListener.class, adjustmentListener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.listenerList.getListeners(AdjustmentListener.class);
    }

    protected void fireAdjustmentValueChanged(int n, int n2, int n3) {
        this.fireAdjustmentValueChanged(n, n2, n3, this.getValueIsAdjusting());
    }

    private void fireAdjustmentValueChanged(int n, int n2, int n3, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AdjustmentListener.class) continue;
            if (adjustmentEvent == null) {
                adjustmentEvent = new AdjustmentEvent(this, n, n2, n3, bl);
            }
            ((AdjustmentListener)objectArray[i + 1]).adjustmentValueChanged(adjustmentEvent);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.orientation == 1) {
            return new Dimension(dimension.width, 5);
        }
        return new Dimension(5, dimension.height);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getOrientation() == 1) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    public void setEnabled(boolean bl) {
        Component[] componentArray;
        super.setEnabled(bl);
        for (Component component : componentArray = this.getComponents()) {
            component.setEnabled(bl);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",blockIncrement=" + this.blockIncrement + ",orientation=" + string + ",unitIncrement=" + this.unitIncrement;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJScrollBar() {
            super(JScrollBar.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JScrollBar.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JScrollBar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return JScrollBar.this.getValue();
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            JScrollBar.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return JScrollBar.this.getMinimum();
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JScrollBar.this.model.getMaximum() - JScrollBar.this.model.getExtent());
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof BoundedRangeModel) {
                int n = 601;
                int n2 = 5;
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
                int n3 = boundedRangeModel.getValue();
                boolean bl = boundedRangeModel.getValueIsAdjusting();
                JScrollBar.this.fireAdjustmentValueChanged(n, n2, n3, bl);
            }
        }
    }
}

