/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.InterruptedIOException;

public abstract class ClientCommunicatorAdmin {
    private static volatile long threadNo = 1L;
    private final Checker checker;
    private long period;
    private static final int CONNECTED = 0;
    private static final int RE_CONNECTING = 1;
    private static final int FAILED = 2;
    private static final int TERMINATED = 3;
    private int state = 0;
    private final int[] lock = new int[0];
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ClientCommunicatorAdmin");

    public ClientCommunicatorAdmin(long l) {
        this.period = l;
        if (l > 0L) {
            this.checker = new Checker();
            Thread thread = new Thread(this.checker, "JMX client heartbeat " + ++threadNo);
            thread.setDaemon(true);
            thread.start();
        } else {
            this.checker = null;
        }
    }

    public void gotIOException(IOException iOException) throws IOException {
        this.restart(iOException);
    }

    protected abstract void checkConnection() throws IOException;

    protected abstract void doStart() throws IOException;

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 3;
            this.lock.notifyAll();
            if (this.checker != null) {
                this.checker.stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(IOException iOException) throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 3) {
                throw new IOException("The client has been closed.");
            }
            if (this.state == 2) {
                throw iOException;
            }
            if (this.state == 1) {
                while (this.state == 1) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.toString());
                        EnvHelp.initCause(interruptedIOException, interruptedException);
                        throw interruptedIOException;
                    }
                }
                if (this.state == 3) {
                    throw new IOException("The client has been closed.");
                }
                if (this.state != 0) {
                    throw iOException;
                }
            } else {
                this.state = 1;
                this.lock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.doStart();
                nArray = this.lock;
                synchronized (this.lock) {
                    if (this.state == 3) {
                        throw new IOException("The client has been closed.");
                    }
                    this.state = 0;
                    this.lock.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            catch (Exception exception) {
                logger.warning("restart", "Failed to restart: " + exception);
                logger.debug("restart", exception);
                int[] nArray2 = this.lock;
                synchronized (this.lock) {
                    if (this.state == 3) {
                        throw new IOException("The client has been closed.");
                    }
                    this.state = 2;
                    this.lock.notifyAll();
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    try {
                        this.doStop();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.terminate();
                    throw iOException;
                }
            }
        }
    }

    private class Checker
    implements Runnable {
        private Thread myThread;

        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.myThread = Thread.currentThread();
            while (ClientCommunicatorAdmin.this.state != 3 && !this.myThread.isInterrupted()) {
                try {
                    Thread.sleep(ClientCommunicatorAdmin.this.period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ClientCommunicatorAdmin.this.state == 3 || this.myThread.isInterrupted()) break;
                try {
                    ClientCommunicatorAdmin.this.checkConnection();
                }
                catch (Exception exception) {
                    int[] nArray = ClientCommunicatorAdmin.this.lock;
                    synchronized (nArray) {
                        if (ClientCommunicatorAdmin.this.state == 3 || this.myThread.isInterrupted()) {
                            break;
                        }
                    }
                    Exception exception2 = (Exception)EnvHelp.getCause(exception);
                    if (exception2 instanceof IOException && !(exception2 instanceof InterruptedIOException)) {
                        try {
                            ClientCommunicatorAdmin.this.restart((IOException)exception2);
                            continue;
                        }
                        catch (Exception exception3) {
                            logger.warning("Checker-run", "Failed to check connection: " + exception2);
                            logger.warning("Checker-run", "stopping");
                            logger.debug("Checker-run", exception2);
                            break;
                        }
                    }
                    logger.warning("Checker-run", "Failed to check the connection: " + exception2);
                    logger.debug("Checker-run", exception2);
                    break;
                }
            }
            if (logger.traceOn()) {
                logger.trace("Checker-run", "Finished.");
            }
        }

        private void stop() {
            if (this.myThread != null && this.myThread != Thread.currentThread()) {
                this.myThread.interrupt();
            }
        }
    }
}

