/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermissions;
import javax.crypto.JarVerifier;
import sun.security.jca.GetInstance;

final class JceSecurity {
    static final SecureRandom RANDOM = new SecureRandom();
    private static CryptoPermissions defaultPolicy = null;
    private static CryptoPermissions exemptPolicy = null;
    private static final Map verificationResults = new IdentityHashMap();
    private static final Map verifyingProviders = new IdentityHashMap();
    private static boolean isRestricted = true;
    private static final Object PROVIDER_VERIFIED;
    private static final URL NULL_URL;
    private static final Map codeBaseCacheRef;

    private JceSecurity() {
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service service = GetInstance.getService(string, string2, string3);
        Exception exception = JceSecurity.getVerificationResult(service.getProvider());
        if (exception != null) {
            String string4 = "JCE cannot authenticate the provider " + string3;
            throw (NoSuchProviderException)new NoSuchProviderException(string4).initCause(exception);
        }
        return GetInstance.getInstance(service, clazz);
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = GetInstance.getService(string, string2, provider);
        Exception exception = JceSecurity.getVerificationResult(provider);
        if (exception != null) {
            String string3 = "JCE cannot authenticate the provider " + provider.getName();
            throw new SecurityException(string3, exception);
        }
        return GetInstance.getInstance(service, clazz);
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices(string, string2);
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (Provider.Service service : list) {
            if (!JceSecurity.canUseProvider(service.getProvider())) continue;
            try {
                GetInstance.Instance instance = GetInstance.getInstance(service, clazz);
                return instance;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm " + string2 + " not available", noSuchAlgorithmException);
    }

    static CryptoPermissions verifyExemptJar(URL uRL) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(uRL, true);
        jarVerifier.verify();
        return jarVerifier.getPermissions();
    }

    static void verifyProviderJar(URL uRL) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(uRL, false);
        jarVerifier.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Exception getVerificationResult(Provider provider) {
        Object v = verificationResults.get(provider);
        if (v == PROVIDER_VERIFIED) {
            return null;
        }
        if (v != null) {
            return (Exception)v;
        }
        if (verifyingProviders.get(provider) != null) {
            return new NoSuchProviderException("Recursion during verification");
        }
        try {
            verifyingProviders.put(provider, Boolean.FALSE);
            URL uRL = JceSecurity.getCodeBase(provider.getClass());
            JceSecurity.verifyProviderJar(uRL);
            verificationResults.put(provider, PROVIDER_VERIFIED);
            Exception exception = null;
            return exception;
        }
        catch (Exception exception) {
            verificationResults.put(provider, exception);
            Exception exception2 = exception;
            return exception2;
        }
        finally {
            verifyingProviders.remove(provider);
        }
    }

    static boolean canUseProvider(Provider provider) {
        return JceSecurity.getVerificationResult(provider) == null;
    }

    static URL getCodeBase(final Class clazz) {
        URL uRL = (URL)codeBaseCacheRef.get(clazz);
        if (uRL == null) {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CodeSource codeSource;
                    ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                    if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                        return codeSource.getLocation();
                    }
                    return NULL_URL;
                }
            });
            codeBaseCacheRef.put(clazz, uRL);
        }
        return uRL == NULL_URL ? null : uRL;
    }

    private static void setupJurisdictionPolicies() throws Exception {
        String string = System.getProperty("java.home");
        String string2 = File.separator;
        String string3 = string + string2 + "lib" + string2 + "security" + string2;
        File file = new File(string3, "US_export_policy.jar");
        File file2 = new File(string3, "local_policy.jar");
        URL uRL = ClassLoader.getSystemResource("javax/crypto/Cipher.class");
        if (uRL == null || !file.exists() || !file2.exists()) {
            throw new SecurityException("Cannot locate policy or framework files!");
        }
        JarVerifier.verifyFrameworkSigned(uRL);
        CryptoPermissions cryptoPermissions = new CryptoPermissions();
        CryptoPermissions cryptoPermissions2 = new CryptoPermissions();
        JceSecurity.loadPolicies(file, cryptoPermissions, cryptoPermissions2);
        CryptoPermissions cryptoPermissions3 = new CryptoPermissions();
        CryptoPermissions cryptoPermissions4 = new CryptoPermissions();
        JceSecurity.loadPolicies(file2, cryptoPermissions3, cryptoPermissions4);
        if (cryptoPermissions.isEmpty() || cryptoPermissions3.isEmpty()) {
            throw new SecurityException("Missing mandatory jurisdiction policy files");
        }
        defaultPolicy = cryptoPermissions.getMinimum(cryptoPermissions3);
        exemptPolicy = cryptoPermissions2.isEmpty() ? (cryptoPermissions4.isEmpty() ? null : cryptoPermissions4) : cryptoPermissions2.getMinimum(cryptoPermissions4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPolicies(File file, CryptoPermissions cryptoPermissions, CryptoPermissions cryptoPermissions2) throws Exception {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                if (jarEntry.getName().startsWith("default_")) {
                    inputStream = jarFile.getInputStream(jarEntry);
                    cryptoPermissions.load(inputStream);
                } else {
                    if (!jarEntry.getName().startsWith("exempt_")) continue;
                    inputStream = jarFile.getInputStream(jarEntry);
                    cryptoPermissions2.load(inputStream);
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
                continue;
            }
            JarVerifier.verifyPolicySigned(jarEntry.getCertificates());
        }
        jarFile.close();
        jarFile = null;
    }

    static CryptoPermissions getDefaultPolicy() {
        return defaultPolicy;
    }

    static CryptoPermissions getExemptPolicy() {
        return exemptPolicy;
    }

    static boolean isRestricted() {
        return isRestricted;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JceSecurity.setupJurisdictionPolicies();
                    return null;
                }
            });
            isRestricted = !defaultPolicy.implies(CryptoAllPermission.INSTANCE);
        }
        catch (Exception exception) {
            SecurityException securityException = new SecurityException("Can not initialize cryptographic mechanism");
            securityException.initCause(exception);
            throw securityException;
        }
        PROVIDER_VERIFIED = Boolean.TRUE;
        try {
            NULL_URL = new URL("http://null.sun.com/");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        codeBaseCacheRef = new WeakHashMap();
    }
}

