/* $Id: util.c,v 1.2 2008/09/10 12:03:31 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bpgutil.h"
#include "error.h"

/*
 * Gets the bit placed in 'position' from the given octet.
 * 'position' must be a value between 0 (lsb) and 7 (msb).
 * Returns 1 if bit is set, 0 if unset and -1 if an error occurred.
 */  
int
util_getbit(uint8_t octet, unsigned position)
{
	return ((unsigned)octet >> position) & 1;
}

/*
 * Gets an integer with the value of the bit row between 'msb' and 'lsb'
 * inclusive.
 * 'msb' and 'lsb' must be between 0 and 7.
 * Returns the value of the row, or -1 if parameters are not valid.
 * Examples:
 *	util_getbitrow(val, 5, 2), where val=0x89, returns 0x02. 
 *	util_getbitrow(val, 7, 0), where val=0x31, returns 0x31.
 *	util_getbitrow(val, 1, 1), where val=0x03, returns 0x01.
 */
int
util_getbitrow(uint8_t octet, int msb, int lsb)
{
	int i, ret;

	if (msb >= lsb && (msb <= 7 && lsb >= 0)) {
		ret = 0;
		for (i = lsb; i <= msb; i++) {
			ret += util_getbit(octet, (unsigned)i) * pow(2, i - lsb); 
		}
		return ret;
	}
	
	return -1;
}

void
util_uint32_to_str(uint32_t i, unsigned char *s)
{
	s[0] = i >> 24;
	s[1] = i >> 16 & 0xff;
	s[2] = i >> 8 & 0xff;
	s[3] = i & 0xff;
}

void
util_uint16_to_str(uint16_t i, unsigned char *s)
{
	s[0] = (unsigned)i >> 8;
	s[1] = i & 0xff;
}

