/* $Id: error.h,v 1.1.1.1 2008/09/10 09:32:57 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BPG_ERROR_H_
#define _BPG_ERROR_H_

#include <stdio.h>
#include <stdlib.h>

#define ERRSTR_MAXLEN 100

enum {
	BPGERR_MALLOC = 1,
	BPGERR_GET_TIME,
	BPGERR_NULL_POINTER,
	BPGERR_INVALID_ARGUMENT,

	BPGERR_OPENSSL_DIGEST,
	BPGERR_OPENSSL_ENCRYPT,
	BPGERR_OPENSSL_SIGN,

	BPGERR_MPI_TOO_SHORT,
	BPGERR_PKT_TOO_SHORT,
	BPGERR_PKT_PUBKEY_TOO_SHORT,
	BPGERR_PKT_SECKEY_TOO_SHORT,
	BPGERR_PKT_SIG_TOO_SHORT,
	BPGERR_S2K_TOO_SHORT,

	BPGERR_PKT_MALFORMED,
	BPGERR_PKT_SIG_MALFORMED,

	BPGERR_ALGORITHM_UNKNOWN,
	BPGERR_KEYVERSION_UNKNOWN,
	BPGERR_PKTFORMAT_UNKNOWN,
	BPGERR_PKTLENTYPE_UNKNOWN,
	BPGERR_PKTTYPE_UNKNOWN,
	BPGERR_S2K_UNKNOWN,
	BPGERR_SIGVERSION_UNKNOWN,

	BPGERR_ALGORITHM_NOT_SUPPORTED,
	BPGERR_KEYVERSION_2_NOT_SUPPORTED,
	BPGERR_PKTFORMAT_NEW_NOT_SUPPORTED,
	BPGERR_SIGVERSION_4_NOT_SUPPORTED,

	BPGERR_PKTTYPE_UNEXPECTED,

	BPGERR_COULDNT_PARSE_SECKEY,

	BPGERR_NOT_IMPLEMENTED
};

#define BPG_err(n) BPG_err_full(n,__FILE__,__LINE__)
void BPG_err_full(int, const char *, int);

void err_str(int num, char *to);

#endif /* !_BPG_ERROR_H_ */

