/*
 * Copyright (C) 1999 Scott Reynolds.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <fcntl.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <machine/grfioctl.h>

char	*program;

int
info(grfdev)
	char *grfdev;
{
	struct grfmode buf;
	struct grfmode *gm = &buf;
	caddr_t va;
	int fd, err;

	printf("Device %s\n", grfdev);

	err = 0;
	if ((fd = open(grfdev, O_RDWR)) == (-1)) {
		perror("open");
		err = 1;
	} else {
		if (ioctl(fd, GRFIOCGMODE, gm) != (-1)) {
			printf(" mode_id: %d\n", gm->mode_id);
			printf("  fbbase: 0x%x\n", gm->fbbase);
			printf("  fbsize: 0x%x\n", gm->fbsize);
			printf("   fboff: 0x%x\n", gm->fboff);
			printf("rowbytes: %d\n", gm->rowbytes);
			printf("   width: %d\n", gm->width);
			printf("  height: %d\n", gm->height);
			printf("    hres: %d\n", gm->hres);
			printf("    vres: %d\n", gm->vres);
			printf("   ptype: %d\n", gm->ptype);
			printf("   psize: %d\n", gm->psize);

			if ((va = mmap(0, gm->fbsize, PROT_READ | PROT_WRITE,
			    MAP_SHARED, fd, gm->fboff)) == (caddr_t)-1)
				perror("mmap");
			else {
				printf("mmap succeeded, 0x%08lx\n", va);
				munmap(va, gm->fbsize);
			}

			if (ioctl(fd, GRFIOCMAP, &va) == -1)
				perror("ioctl");
			else {
				printf("ioctl succeeded, 0x%08lx\n", va);
				ioctl(fd, GRFIOCUNMAP, &va);
			}
		} else {
			perror("ioctl");
			err = 2;
		}
		close(fd);
	}
	return err;
}

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ec, i;

	if ((program = strrchr(argv[0], '/')) != NULL)
		program++;
	else
		program = argv[0];

	ec = 0;

	if (argc > 1) {
		for (i = 1; i < argc; i++)
			if (info(argv[i]))
				ec++;
	} else {
		fprintf(stderr, "usage:  %s /dev/grf*\n", program);
		ec = -1;
	}
	exit(ec);
}
