/*	$NetBSD: bif_5_1_sh_mask.h,v 1.3 2021/12/18 23:45:09 riastradh Exp $	*/

/*
 * BIF_5_1 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef BIF_5_1_SH_MASK_H
#define BIF_5_1_SH_MASK_H

#define MM_INDEX__MM_OFFSET_MASK 0x7fffffff
#define MM_INDEX__MM_OFFSET__SHIFT 0x0
#define MM_INDEX__MM_APER_MASK 0x80000000
#define MM_INDEX__MM_APER__SHIFT 0x1f
#define MM_INDEX_HI__MM_OFFSET_HI_MASK 0xffffffff
#define MM_INDEX_HI__MM_OFFSET_HI__SHIFT 0x0
#define MM_DATA__MM_DATA_MASK 0xffffffff
#define MM_DATA__MM_DATA__SHIFT 0x0
#define BIF_MM_INDACCESS_CNTL__MM_INDACCESS_DIS_MASK 0x2
#define BIF_MM_INDACCESS_CNTL__MM_INDACCESS_DIS__SHIFT 0x1
#define BUS_CNTL__BIOS_ROM_WRT_EN_MASK 0x1
#define BUS_CNTL__BIOS_ROM_WRT_EN__SHIFT 0x0
#define BUS_CNTL__BIOS_ROM_DIS_MASK 0x2
#define BUS_CNTL__BIOS_ROM_DIS__SHIFT 0x1
#define BUS_CNTL__PMI_IO_DIS_MASK 0x4
#define BUS_CNTL__PMI_IO_DIS__SHIFT 0x2
#define BUS_CNTL__PMI_MEM_DIS_MASK 0x8
#define BUS_CNTL__PMI_MEM_DIS__SHIFT 0x3
#define BUS_CNTL__PMI_BM_DIS_MASK 0x10
#define BUS_CNTL__PMI_BM_DIS__SHIFT 0x4
#define BUS_CNTL__PMI_INT_DIS_MASK 0x20
#define BUS_CNTL__PMI_INT_DIS__SHIFT 0x5
#define BUS_CNTL__VGA_REG_COHERENCY_DIS_MASK 0x40
#define BUS_CNTL__VGA_REG_COHERENCY_DIS__SHIFT 0x6
#define BUS_CNTL__VGA_MEM_COHERENCY_DIS_MASK 0x80
#define BUS_CNTL__VGA_MEM_COHERENCY_DIS__SHIFT 0x7
#define BUS_CNTL__BIF_ERR_RTR_BKPRESSURE_EN_MASK 0x100
#define BUS_CNTL__BIF_ERR_RTR_BKPRESSURE_EN__SHIFT 0x8
#define BUS_CNTL__SET_AZ_TC_MASK 0x1c00
#define BUS_CNTL__SET_AZ_TC__SHIFT 0xa
#define BUS_CNTL__SET_MC_TC_MASK 0xe000
#define BUS_CNTL__SET_MC_TC__SHIFT 0xd
#define BUS_CNTL__ZERO_BE_WR_EN_MASK 0x10000
#define BUS_CNTL__ZERO_BE_WR_EN__SHIFT 0x10
#define BUS_CNTL__ZERO_BE_RD_EN_MASK 0x20000
#define BUS_CNTL__ZERO_BE_RD_EN__SHIFT 0x11
#define BUS_CNTL__RD_STALL_IO_WR_MASK 0x40000
#define BUS_CNTL__RD_STALL_IO_WR__SHIFT 0x12
#define CONFIG_CNTL__CFG_VGA_RAM_EN_MASK 0x1
#define CONFIG_CNTL__CFG_VGA_RAM_EN__SHIFT 0x0
#define CONFIG_CNTL__VGA_DIS_MASK 0x2
#define CONFIG_CNTL__VGA_DIS__SHIFT 0x1
#define CONFIG_CNTL__GENMO_MONO_ADDRESS_B_MASK 0x4
#define CONFIG_CNTL__GENMO_MONO_ADDRESS_B__SHIFT 0x2
#define CONFIG_CNTL__GRPH_ADRSEL_MASK 0x18
#define CONFIG_CNTL__GRPH_ADRSEL__SHIFT 0x3
#define CONFIG_MEMSIZE__CONFIG_MEMSIZE_MASK 0xffffffff
#define CONFIG_MEMSIZE__CONFIG_MEMSIZE__SHIFT 0x0
#define CONFIG_F0_BASE__F0_BASE_MASK 0xffffffff
#define CONFIG_F0_BASE__F0_BASE__SHIFT 0x0
#define CONFIG_APER_SIZE__APER_SIZE_MASK 0xffffffff
#define CONFIG_APER_SIZE__APER_SIZE__SHIFT 0x0
#define CONFIG_REG_APER_SIZE__REG_APER_SIZE_MASK 0xfffff
#define CONFIG_REG_APER_SIZE__REG_APER_SIZE__SHIFT 0x0
#define BIF_SCRATCH0__BIF_SCRATCH0_MASK 0xffffffff
#define BIF_SCRATCH0__BIF_SCRATCH0__SHIFT 0x0
#define BIF_SCRATCH1__BIF_SCRATCH1_MASK 0xffffffff
#define BIF_SCRATCH1__BIF_SCRATCH1__SHIFT 0x0
#define BX_RESET_EN__COR_RESET_EN_MASK 0x1
#define BX_RESET_EN__COR_RESET_EN__SHIFT 0x0
#define BX_RESET_EN__REG_RESET_EN_MASK 0x2
#define BX_RESET_EN__REG_RESET_EN__SHIFT 0x1
#define BX_RESET_EN__STY_RESET_EN_MASK 0x4
#define BX_RESET_EN__STY_RESET_EN__SHIFT 0x2
#define MM_CFGREGS_CNTL__MM_CFG_FUNC_SEL_MASK 0x7
#define MM_CFGREGS_CNTL__MM_CFG_FUNC_SEL__SHIFT 0x0
#define MM_CFGREGS_CNTL__MM_WR_TO_CFG_EN_MASK 0x8
#define MM_CFGREGS_CNTL__MM_WR_TO_CFG_EN__SHIFT 0x3
#define HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define HW_DEBUG__HW_16_DEBUG_MASK 0x10000
#define HW_DEBUG__HW_16_DEBUG__SHIFT 0x10
#define HW_DEBUG__HW_17_DEBUG_MASK 0x20000
#define HW_DEBUG__HW_17_DEBUG__SHIFT 0x11
#define HW_DEBUG__HW_18_DEBUG_MASK 0x40000
#define HW_DEBUG__HW_18_DEBUG__SHIFT 0x12
#define HW_DEBUG__HW_19_DEBUG_MASK 0x80000
#define HW_DEBUG__HW_19_DEBUG__SHIFT 0x13
#define HW_DEBUG__HW_20_DEBUG_MASK 0x100000
#define HW_DEBUG__HW_20_DEBUG__SHIFT 0x14
#define HW_DEBUG__HW_21_DEBUG_MASK 0x200000
#define HW_DEBUG__HW_21_DEBUG__SHIFT 0x15
#define HW_DEBUG__HW_22_DEBUG_MASK 0x400000
#define HW_DEBUG__HW_22_DEBUG__SHIFT 0x16
#define HW_DEBUG__HW_23_DEBUG_MASK 0x800000
#define HW_DEBUG__HW_23_DEBUG__SHIFT 0x17
#define HW_DEBUG__HW_24_DEBUG_MASK 0x1000000
#define HW_DEBUG__HW_24_DEBUG__SHIFT 0x18
#define HW_DEBUG__HW_25_DEBUG_MASK 0x2000000
#define HW_DEBUG__HW_25_DEBUG__SHIFT 0x19
#define HW_DEBUG__HW_26_DEBUG_MASK 0x4000000
#define HW_DEBUG__HW_26_DEBUG__SHIFT 0x1a
#define HW_DEBUG__HW_27_DEBUG_MASK 0x8000000
#define HW_DEBUG__HW_27_DEBUG__SHIFT 0x1b
#define HW_DEBUG__HW_28_DEBUG_MASK 0x10000000
#define HW_DEBUG__HW_28_DEBUG__SHIFT 0x1c
#define HW_DEBUG__HW_29_DEBUG_MASK 0x20000000
#define HW_DEBUG__HW_29_DEBUG__SHIFT 0x1d
#define HW_DEBUG__HW_30_DEBUG_MASK 0x40000000
#define HW_DEBUG__HW_30_DEBUG__SHIFT 0x1e
#define HW_DEBUG__HW_31_DEBUG_MASK 0x80000000
#define HW_DEBUG__HW_31_DEBUG__SHIFT 0x1f
#define MASTER_CREDIT_CNTL__BIF_MC_RDRET_CREDIT_MASK 0x7f
#define MASTER_CREDIT_CNTL__BIF_MC_RDRET_CREDIT__SHIFT 0x0
#define MASTER_CREDIT_CNTL__BIF_AZ_RDRET_CREDIT_MASK 0x3f0000
#define MASTER_CREDIT_CNTL__BIF_AZ_RDRET_CREDIT__SHIFT 0x10
#define SLAVE_REQ_CREDIT_CNTL__BIF_SRBM_REQ_CREDIT_MASK 0x1f
#define SLAVE_REQ_CREDIT_CNTL__BIF_SRBM_REQ_CREDIT__SHIFT 0x0
#define SLAVE_REQ_CREDIT_CNTL__BIF_VGA_REQ_CREDIT_MASK 0x1e0
#define SLAVE_REQ_CREDIT_CNTL__BIF_VGA_REQ_CREDIT__SHIFT 0x5
#define SLAVE_REQ_CREDIT_CNTL__BIF_HDP_REQ_CREDIT_MASK 0x7c00
#define SLAVE_REQ_CREDIT_CNTL__BIF_HDP_REQ_CREDIT__SHIFT 0xa
#define SLAVE_REQ_CREDIT_CNTL__BIF_ROM_REQ_CREDIT_MASK 0x8000
#define SLAVE_REQ_CREDIT_CNTL__BIF_ROM_REQ_CREDIT__SHIFT 0xf
#define SLAVE_REQ_CREDIT_CNTL__BIF_AZ_REQ_CREDIT_MASK 0x100000
#define SLAVE_REQ_CREDIT_CNTL__BIF_AZ_REQ_CREDIT__SHIFT 0x14
#define SLAVE_REQ_CREDIT_CNTL__BIF_XDMA_REQ_CREDIT_MASK 0x7e000000
#define SLAVE_REQ_CREDIT_CNTL__BIF_XDMA_REQ_CREDIT__SHIFT 0x19
#define BX_RESET_CNTL__LINK_TRAIN_EN_MASK 0x1
#define BX_RESET_CNTL__LINK_TRAIN_EN__SHIFT 0x0
#define INTERRUPT_CNTL__IH_DUMMY_RD_OVERRIDE_MASK 0x1
#define INTERRUPT_CNTL__IH_DUMMY_RD_OVERRIDE__SHIFT 0x0
#define INTERRUPT_CNTL__IH_DUMMY_RD_EN_MASK 0x2
#define INTERRUPT_CNTL__IH_DUMMY_RD_EN__SHIFT 0x1
#define INTERRUPT_CNTL__IH_REQ_NONSNOOP_EN_MASK 0x8
#define INTERRUPT_CNTL__IH_REQ_NONSNOOP_EN__SHIFT 0x3
#define INTERRUPT_CNTL__IH_INTR_DLY_CNTR_MASK 0xf0
#define INTERRUPT_CNTL__IH_INTR_DLY_CNTR__SHIFT 0x4
#define INTERRUPT_CNTL__GEN_IH_INT_EN_MASK 0x100
#define INTERRUPT_CNTL__GEN_IH_INT_EN__SHIFT 0x8
#define INTERRUPT_CNTL__GEN_GPIO_INT_EN_MASK 0x1e00
#define INTERRUPT_CNTL__GEN_GPIO_INT_EN__SHIFT 0x9
#define INTERRUPT_CNTL__SELECT_INT_GPIO_OUTPUT_MASK 0x6000
#define INTERRUPT_CNTL__SELECT_INT_GPIO_OUTPUT__SHIFT 0xd
#define INTERRUPT_CNTL__BIF_RB_REQ_NONSNOOP_EN_MASK 0x8000
#define INTERRUPT_CNTL__BIF_RB_REQ_NONSNOOP_EN__SHIFT 0xf
#define INTERRUPT_CNTL2__IH_DUMMY_RD_ADDR_MASK 0xffffffff
#define INTERRUPT_CNTL2__IH_DUMMY_RD_ADDR__SHIFT 0x0
#define BIF_DEBUG_CNTL__DEBUG_EN_MASK 0x1
#define BIF_DEBUG_CNTL__DEBUG_EN__SHIFT 0x0
#define BIF_DEBUG_CNTL__DEBUG_MULTIBLOCKEN_MASK 0x2
#define BIF_DEBUG_CNTL__DEBUG_MULTIBLOCKEN__SHIFT 0x1
#define BIF_DEBUG_CNTL__DEBUG_OUT_EN_MASK 0x4
#define BIF_DEBUG_CNTL__DEBUG_OUT_EN__SHIFT 0x2
#define BIF_DEBUG_CNTL__DEBUG_PAD_SEL_MASK 0x8
#define BIF_DEBUG_CNTL__DEBUG_PAD_SEL__SHIFT 0x3
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK1_MASK 0x10
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK1__SHIFT 0x4
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK2_MASK 0x20
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK2__SHIFT 0x5
#define BIF_DEBUG_CNTL__DEBUG_SYNC_EN_MASK 0x40
#define BIF_DEBUG_CNTL__DEBUG_SYNC_EN__SHIFT 0x6
#define BIF_DEBUG_CNTL__DEBUG_SWAP_MASK 0x80
#define BIF_DEBUG_CNTL__DEBUG_SWAP__SHIFT 0x7
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK1_MASK 0x1f00
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK1__SHIFT 0x8
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK2_MASK 0x1f0000
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK2__SHIFT 0x10
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_XSP_MASK 0x1000000
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_XSP__SHIFT 0x18
#define BIF_DEBUG_CNTL__DEBUG_SYNC_CLKSEL_MASK 0xc0000000
#define BIF_DEBUG_CNTL__DEBUG_SYNC_CLKSEL__SHIFT 0x1e
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK1_MASK 0x3f
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK1__SHIFT 0x0
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK2_MASK 0x3f00
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK2__SHIFT 0x8
#define BIF_DEBUG_OUT__DEBUG_OUTPUT_MASK 0x1ffff
#define BIF_DEBUG_OUT__DEBUG_OUTPUT__SHIFT 0x0
#define HDP_REG_COHERENCY_FLUSH_CNTL__HDP_REG_FLUSH_ADDR_MASK 0x1
#define HDP_REG_COHERENCY_FLUSH_CNTL__HDP_REG_FLUSH_ADDR__SHIFT 0x0
#define HDP_MEM_COHERENCY_FLUSH_CNTL__HDP_MEM_FLUSH_ADDR_MASK 0x1
#define HDP_MEM_COHERENCY_FLUSH_CNTL__HDP_MEM_FLUSH_ADDR__SHIFT 0x0
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_A_MASK 0x1
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_A__SHIFT 0x0
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SEL_MASK 0x2
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SEL__SHIFT 0x1
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_MODE_MASK 0x4
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_MODE__SHIFT 0x2
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SPARE_MASK 0x18
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SPARE__SHIFT 0x3
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN0_MASK 0x20
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN0__SHIFT 0x5
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN1_MASK 0x40
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN1__SHIFT 0x6
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN2_MASK 0x80
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN2__SHIFT 0x7
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN3_MASK 0x100
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN3__SHIFT 0x8
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SLEWN_MASK 0x200
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SLEWN__SHIFT 0x9
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_WAKE_MASK 0x400
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_WAKE__SHIFT 0xa
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SCHMEN_MASK 0x800
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SCHMEN__SHIFT 0xb
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_CNTL_EN_MASK 0x1000
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_CNTL_EN__SHIFT 0xc
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_A_MASK 0x1
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_A__SHIFT 0x0
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SEL_MASK 0x2
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SEL__SHIFT 0x1
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_MODE_MASK 0x4
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_MODE__SHIFT 0x2
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SPARE_MASK 0x18
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SPARE__SHIFT 0x3
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN0_MASK 0x20
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN0__SHIFT 0x5
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN1_MASK 0x40
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN1__SHIFT 0x6
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN2_MASK 0x80
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN2__SHIFT 0x7
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN3_MASK 0x100
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SN3__SHIFT 0x8
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SLEWN_MASK 0x200
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SLEWN__SHIFT 0x9
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_WAKE_MASK 0x400
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_WAKE__SHIFT 0xa
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SCHMEN_MASK 0x800
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_SCHMEN__SHIFT 0xb
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_CNTL_EN_MASK 0x1000
#define SMBDAT_PAD_CNTL__SMBDAT_PAD_CNTL_EN__SHIFT 0xc
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_A_MASK 0x1
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_A__SHIFT 0x0
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SEL_MASK 0x2
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SEL__SHIFT 0x1
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_MODE_MASK 0x4
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_MODE__SHIFT 0x2
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SPARE_MASK 0x18
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SPARE__SHIFT 0x3
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN0_MASK 0x20
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN0__SHIFT 0x5
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN1_MASK 0x40
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN1__SHIFT 0x6
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN2_MASK 0x80
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN2__SHIFT 0x7
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN3_MASK 0x100
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SN3__SHIFT 0x8
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SLEWN_MASK 0x200
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SLEWN__SHIFT 0x9
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_WAKE_MASK 0x400
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_WAKE__SHIFT 0xa
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SCHMEN_MASK 0x800
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_SCHMEN__SHIFT 0xb
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_CNTL_EN_MASK 0x1000
#define SMBCLK_PAD_CNTL__SMBCLK_PAD_CNTL_EN__SHIFT 0xc
#define BIF_XDMA_LO__BIF_XDMA_LOWER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_LO__BIF_XDMA_LOWER_BOUND__SHIFT 0x0
#define BIF_XDMA_LO__BIF_XDMA_APER_EN_MASK 0x80000000
#define BIF_XDMA_LO__BIF_XDMA_APER_EN__SHIFT 0x1f
#define BIF_XDMA_HI__BIF_XDMA_UPPER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_HI__BIF_XDMA_UPPER_BOUND__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC__MST_BIF_REQ_EP_DIS_MASK 0x1
#define BIF_FEATURES_CONTROL_MISC__MST_BIF_REQ_EP_DIS__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC__SLV_BIF_CPL_EP_DIS_MASK 0x2
#define BIF_FEATURES_CONTROL_MISC__SLV_BIF_CPL_EP_DIS__SHIFT 0x1
#define BIF_FEATURES_CONTROL_MISC__BIF_SLV_REQ_EP_DIS_MASK 0x4
#define BIF_FEATURES_CONTROL_MISC__BIF_SLV_REQ_EP_DIS__SHIFT 0x2
#define BIF_FEATURES_CONTROL_MISC__BIF_MST_CPL_EP_DIS_MASK 0x8
#define BIF_FEATURES_CONTROL_MISC__BIF_MST_CPL_EP_DIS__SHIFT 0x3
#define BIF_FEATURES_CONTROL_MISC__UR_PSN_PKT_REPORT_POISON_DIS_MASK 0x10
#define BIF_FEATURES_CONTROL_MISC__UR_PSN_PKT_REPORT_POISON_DIS__SHIFT 0x4
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS_MASK 0x20
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS__SHIFT 0x5
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS_MASK 0x40
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS__SHIFT 0x6
#define BIF_FEATURES_CONTROL_MISC__PLL_SWITCH_IMPCTL_CAL_DONE_DIS_MASK 0x80
#define BIF_FEATURES_CONTROL_MISC__PLL_SWITCH_IMPCTL_CAL_DONE_DIS__SHIFT 0x7
#define BIF_FEATURES_CONTROL_MISC__IGNORE_BE_CHECK_GASKET_COMB_DIS_MASK 0x100
#define BIF_FEATURES_CONTROL_MISC__IGNORE_BE_CHECK_GASKET_COMB_DIS__SHIFT 0x8
#define BIF_FEATURES_CONTROL_MISC__MC_BIF_REQ_ID_ROUTING_DIS_MASK 0x200
#define BIF_FEATURES_CONTROL_MISC__MC_BIF_REQ_ID_ROUTING_DIS__SHIFT 0x9
#define BIF_FEATURES_CONTROL_MISC__AZ_BIF_REQ_ID_ROUTING_DIS_MASK 0x400
#define BIF_FEATURES_CONTROL_MISC__AZ_BIF_REQ_ID_ROUTING_DIS__SHIFT 0xa
#define BIF_FEATURES_CONTROL_MISC__ATC_PRG_RESP_PASID_UR_EN_MASK 0x800
#define BIF_FEATURES_CONTROL_MISC__ATC_PRG_RESP_PASID_UR_EN__SHIFT 0xb
#define BIF_FEATURES_CONTROL_MISC__BIF_RB_SET_OVERFLOW_EN_MASK 0x1000
#define BIF_FEATURES_CONTROL_MISC__BIF_RB_SET_OVERFLOW_EN__SHIFT 0xc
#define BIF_DOORBELL_CNTL__SELF_RING_DIS_MASK 0x1
#define BIF_DOORBELL_CNTL__SELF_RING_DIS__SHIFT 0x0
#define BIF_DOORBELL_CNTL__TRANS_CHECK_DIS_MASK 0x2
#define BIF_DOORBELL_CNTL__TRANS_CHECK_DIS__SHIFT 0x1
#define BIF_DOORBELL_CNTL__UNTRANS_LBACK_EN_MASK 0x4
#define BIF_DOORBELL_CNTL__UNTRANS_LBACK_EN__SHIFT 0x2
#define BIF_DOORBELL_CNTL__NON_CONSECUTIVE_BE_ZERO_DIS_MASK 0x8
#define BIF_DOORBELL_CNTL__NON_CONSECUTIVE_BE_ZERO_DIS__SHIFT 0x3
#define BIF_DOORBELL_CNTL__DOORBELL_MONITOR_EN_MASK 0x10
#define BIF_DOORBELL_CNTL__DOORBELL_MONITOR_EN__SHIFT 0x4
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_STATUS_MASK 0x20
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_STATUS__SHIFT 0x5
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_CLEAR_MASK 0x10000
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_CLEAR__SHIFT 0x10
#define BIF_SLVARB_MODE__SLVARB_MODE_MASK 0x3
#define BIF_SLVARB_MODE__SLVARB_MODE__SHIFT 0x0
#define BIF_FB_EN__FB_READ_EN_MASK 0x1
#define BIF_FB_EN__FB_READ_EN__SHIFT 0x0
#define BIF_FB_EN__FB_WRITE_EN_MASK 0x2
#define BIF_FB_EN__FB_WRITE_EN__SHIFT 0x1
#define BIF_BUSNUM_CNTL1__ID_MASK_MASK 0xff
#define BIF_BUSNUM_CNTL1__ID_MASK__SHIFT 0x0
#define BIF_BUSNUM_LIST0__ID0_MASK 0xff
#define BIF_BUSNUM_LIST0__ID0__SHIFT 0x0
#define BIF_BUSNUM_LIST0__ID1_MASK 0xff00
#define BIF_BUSNUM_LIST0__ID1__SHIFT 0x8
#define BIF_BUSNUM_LIST0__ID2_MASK 0xff0000
#define BIF_BUSNUM_LIST0__ID2__SHIFT 0x10
#define BIF_BUSNUM_LIST0__ID3_MASK 0xff000000
#define BIF_BUSNUM_LIST0__ID3__SHIFT 0x18
#define BIF_BUSNUM_LIST1__ID4_MASK 0xff
#define BIF_BUSNUM_LIST1__ID4__SHIFT 0x0
#define BIF_BUSNUM_LIST1__ID5_MASK 0xff00
#define BIF_BUSNUM_LIST1__ID5__SHIFT 0x8
#define BIF_BUSNUM_LIST1__ID6_MASK 0xff0000
#define BIF_BUSNUM_LIST1__ID6__SHIFT 0x10
#define BIF_BUSNUM_LIST1__ID7_MASK 0xff000000
#define BIF_BUSNUM_LIST1__ID7__SHIFT 0x18
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_SEL_MASK 0xff
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_SEL__SHIFT 0x0
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_EN_MASK 0x100
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_EN__SHIFT 0x8
#define BIF_BUSNUM_CNTL2__HDPREG_CNTL_MASK 0x10000
#define BIF_BUSNUM_CNTL2__HDPREG_CNTL__SHIFT 0x10
#define BIF_BUSNUM_CNTL2__ERROR_MULTIPLE_ID_MATCH_MASK 0x20000
#define BIF_BUSNUM_CNTL2__ERROR_MULTIPLE_ID_MATCH__SHIFT 0x11
#define BIF_BUSY_DELAY_CNTR__DELAY_CNT_MASK 0x3f
#define BIF_BUSY_DELAY_CNTR__DELAY_CNT__SHIFT 0x0
#define BIF_PERFMON_CNTL__PERFCOUNTER_EN_MASK 0x1
#define BIF_PERFMON_CNTL__PERFCOUNTER_EN__SHIFT 0x0
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET0_MASK 0x2
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET0__SHIFT 0x1
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET1_MASK 0x4
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET1__SHIFT 0x2
#define BIF_PERFMON_CNTL__PERF_SEL0_MASK 0x1f00
#define BIF_PERFMON_CNTL__PERF_SEL0__SHIFT 0x8
#define BIF_PERFMON_CNTL__PERF_SEL1_MASK 0x3e000
#define BIF_PERFMON_CNTL__PERF_SEL1__SHIFT 0xd
#define BIF_PERFCOUNTER0_RESULT__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER0_RESULT__PERFCOUNTER_RESULT__SHIFT 0x0
#define BIF_PERFCOUNTER1_RESULT__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER1_RESULT__PERFCOUNTER_RESULT__SHIFT 0x0
#define SLAVE_HANG_PROTECTION_CNTL__HANG_PROTECTION_TIMER_SEL_MASK 0xe
#define SLAVE_HANG_PROTECTION_CNTL__HANG_PROTECTION_TIMER_SEL__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ__CP0_MASK 0x1
#define GPU_HDP_FLUSH_REQ__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_REQ__CP1_MASK 0x2
#define GPU_HDP_FLUSH_REQ__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ__CP2_MASK 0x4
#define GPU_HDP_FLUSH_REQ__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_REQ__CP3_MASK 0x8
#define GPU_HDP_FLUSH_REQ__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_REQ__CP4_MASK 0x10
#define GPU_HDP_FLUSH_REQ__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_REQ__CP5_MASK 0x20
#define GPU_HDP_FLUSH_REQ__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_REQ__CP6_MASK 0x40
#define GPU_HDP_FLUSH_REQ__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_REQ__CP7_MASK 0x80
#define GPU_HDP_FLUSH_REQ__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_REQ__CP8_MASK 0x100
#define GPU_HDP_FLUSH_REQ__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_REQ__CP9_MASK 0x200
#define GPU_HDP_FLUSH_REQ__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_REQ__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_REQ__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_REQ__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_REQ__SDMA1__SHIFT 0xb
#define GPU_HDP_FLUSH_DONE__CP0_MASK 0x1
#define GPU_HDP_FLUSH_DONE__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_DONE__CP1_MASK 0x2
#define GPU_HDP_FLUSH_DONE__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_DONE__CP2_MASK 0x4
#define GPU_HDP_FLUSH_DONE__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_DONE__CP3_MASK 0x8
#define GPU_HDP_FLUSH_DONE__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_DONE__CP4_MASK 0x10
#define GPU_HDP_FLUSH_DONE__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_DONE__CP5_MASK 0x20
#define GPU_HDP_FLUSH_DONE__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_DONE__CP6_MASK 0x40
#define GPU_HDP_FLUSH_DONE__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_DONE__CP7_MASK 0x80
#define GPU_HDP_FLUSH_DONE__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_DONE__CP8_MASK 0x100
#define GPU_HDP_FLUSH_DONE__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_DONE__CP9_MASK 0x200
#define GPU_HDP_FLUSH_DONE__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_DONE__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_DONE__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_DONE__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_DONE__SDMA1__SHIFT 0xb
#define SLAVE_HANG_ERROR__SRBM_HANG_ERROR_MASK 0x1
#define SLAVE_HANG_ERROR__SRBM_HANG_ERROR__SHIFT 0x0
#define SLAVE_HANG_ERROR__HDP_HANG_ERROR_MASK 0x2
#define SLAVE_HANG_ERROR__HDP_HANG_ERROR__SHIFT 0x1
#define SLAVE_HANG_ERROR__VGA_HANG_ERROR_MASK 0x4
#define SLAVE_HANG_ERROR__VGA_HANG_ERROR__SHIFT 0x2
#define SLAVE_HANG_ERROR__ROM_HANG_ERROR_MASK 0x8
#define SLAVE_HANG_ERROR__ROM_HANG_ERROR__SHIFT 0x3
#define SLAVE_HANG_ERROR__AUDIO_HANG_ERROR_MASK 0x10
#define SLAVE_HANG_ERROR__AUDIO_HANG_ERROR__SHIFT 0x4
#define SLAVE_HANG_ERROR__CEC_HANG_ERROR_MASK 0x20
#define SLAVE_HANG_ERROR__CEC_HANG_ERROR__SHIFT 0x5
#define SLAVE_HANG_ERROR__XDMA_HANG_ERROR_MASK 0x80
#define SLAVE_HANG_ERROR__XDMA_HANG_ERROR__SHIFT 0x7
#define SLAVE_HANG_ERROR__DOORBELL_HANG_ERROR_MASK 0x100
#define SLAVE_HANG_ERROR__DOORBELL_HANG_ERROR__SHIFT 0x8
#define SLAVE_HANG_ERROR__GARLIC_HANG_ERROR_MASK 0x200
#define SLAVE_HANG_ERROR__GARLIC_HANG_ERROR__SHIFT 0x9
#define CAPTURE_HOST_BUSNUM__CHECK_EN_MASK 0x1
#define CAPTURE_HOST_BUSNUM__CHECK_EN__SHIFT 0x0
#define HOST_BUSNUM__HOST_ID_MASK 0xffff
#define HOST_BUSNUM__HOST_ID__SHIFT 0x0
#define PEER_REG_RANGE0__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE0__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE0__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE0__END_ADDR__SHIFT 0x10
#define PEER_REG_RANGE1__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE1__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE1__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE1__END_ADDR__SHIFT 0x10
#define PEER0_FB_OFFSET_HI__PEER0_FB_OFFSET_HI_MASK 0xfffff
#define PEER0_FB_OFFSET_HI__PEER0_FB_OFFSET_HI__SHIFT 0x0
#define PEER0_FB_OFFSET_LO__PEER0_FB_OFFSET_LO_MASK 0xfffff
#define PEER0_FB_OFFSET_LO__PEER0_FB_OFFSET_LO__SHIFT 0x0
#define PEER0_FB_OFFSET_LO__PEER0_FB_EN_MASK 0x80000000
#define PEER0_FB_OFFSET_LO__PEER0_FB_EN__SHIFT 0x1f
#define PEER1_FB_OFFSET_HI__PEER1_FB_OFFSET_HI_MASK 0xfffff
#define PEER1_FB_OFFSET_HI__PEER1_FB_OFFSET_HI__SHIFT 0x0
#define PEER1_FB_OFFSET_LO__PEER1_FB_OFFSET_LO_MASK 0xfffff
#define PEER1_FB_OFFSET_LO__PEER1_FB_OFFSET_LO__SHIFT 0x0
#define PEER1_FB_OFFSET_LO__PEER1_FB_EN_MASK 0x80000000
#define PEER1_FB_OFFSET_LO__PEER1_FB_EN__SHIFT 0x1f
#define PEER2_FB_OFFSET_HI__PEER2_FB_OFFSET_HI_MASK 0xfffff
#define PEER2_FB_OFFSET_HI__PEER2_FB_OFFSET_HI__SHIFT 0x0
#define PEER2_FB_OFFSET_LO__PEER2_FB_OFFSET_LO_MASK 0xfffff
#define PEER2_FB_OFFSET_LO__PEER2_FB_OFFSET_LO__SHIFT 0x0
#define PEER2_FB_OFFSET_LO__PEER2_FB_EN_MASK 0x80000000
#define PEER2_FB_OFFSET_LO__PEER2_FB_EN__SHIFT 0x1f
#define PEER3_FB_OFFSET_HI__PEER3_FB_OFFSET_HI_MASK 0xfffff
#define PEER3_FB_OFFSET_HI__PEER3_FB_OFFSET_HI__SHIFT 0x0
#define PEER3_FB_OFFSET_LO__PEER3_FB_OFFSET_LO_MASK 0xfffff
#define PEER3_FB_OFFSET_LO__PEER3_FB_OFFSET_LO__SHIFT 0x0
#define PEER3_FB_OFFSET_LO__PEER3_FB_EN_MASK 0x80000000
#define PEER3_FB_OFFSET_LO__PEER3_FB_EN__SHIFT 0x1f
#define DBG_BYPASS_SRBM_ACCESS__DBG_BYPASS_SRBM_ACCESS_EN_MASK 0x1
#define DBG_BYPASS_SRBM_ACCESS__DBG_BYPASS_SRBM_ACCESS_EN__SHIFT 0x0
#define DBG_BYPASS_SRBM_ACCESS__DBG_APER_AD_MASK 0x1e
#define DBG_BYPASS_SRBM_ACCESS__DBG_APER_AD__SHIFT 0x1
#define SMBUS_BACO_DUMMY__SMBUS_BACO_DUMMY_DATA_MASK 0xffffffff
#define SMBUS_BACO_DUMMY__SMBUS_BACO_DUMMY_DATA__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID0_MASK 0xff
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID0__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID1_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID1__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID2_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID2__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID3_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID3__SHIFT 0x18
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID4_MASK 0xff
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID4__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID5_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID5__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID6_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID6__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID7_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID7__SHIFT 0x18
#define BACO_CNTL__BACO_EN_MASK 0x1
#define BACO_CNTL__BACO_EN__SHIFT 0x0
#define BACO_CNTL__BACO_BCLK_OFF_MASK 0x2
#define BACO_CNTL__BACO_BCLK_OFF__SHIFT 0x1
#define BACO_CNTL__BACO_ISO_DIS_MASK 0x4
#define BACO_CNTL__BACO_ISO_DIS__SHIFT 0x2
#define BACO_CNTL__BACO_POWER_OFF_MASK 0x8
#define BACO_CNTL__BACO_POWER_OFF__SHIFT 0x3
#define BACO_CNTL__BACO_RESET_EN_MASK 0x10
#define BACO_CNTL__BACO_RESET_EN__SHIFT 0x4
#define BACO_CNTL__BACO_HANG_PROTECTION_EN_MASK 0x20
#define BACO_CNTL__BACO_HANG_PROTECTION_EN__SHIFT 0x5
#define BACO_CNTL__BACO_MODE_MASK 0x40
#define BACO_CNTL__BACO_MODE__SHIFT 0x6
#define BACO_CNTL__BACO_ANA_ISO_DIS_MASK 0x80
#define BACO_CNTL__BACO_ANA_ISO_DIS__SHIFT 0x7
#define BACO_CNTL__RCU_BIF_CONFIG_DONE_MASK 0x100
#define BACO_CNTL__RCU_BIF_CONFIG_DONE__SHIFT 0x8
#define BACO_CNTL__PWRGOOD_BF_MASK 0x200
#define BACO_CNTL__PWRGOOD_BF__SHIFT 0x9
#define BACO_CNTL__PWRGOOD_GPIO_MASK 0x400
#define BACO_CNTL__PWRGOOD_GPIO__SHIFT 0xa
#define BACO_CNTL__PWRGOOD_MEM_MASK 0x800
#define BACO_CNTL__PWRGOOD_MEM__SHIFT 0xb
#define BACO_CNTL__PWRGOOD_DVO_MASK 0x1000
#define BACO_CNTL__PWRGOOD_DVO__SHIFT 0xc
#define BACO_CNTL__PWRGOOD_IDSC_MASK 0x2000
#define BACO_CNTL__PWRGOOD_IDSC__SHIFT 0xd
#define BACO_CNTL__BACO_POWER_OFF_DRAM_MASK 0x10000
#define BACO_CNTL__BACO_POWER_OFF_DRAM__SHIFT 0x10
#define BACO_CNTL__BACO_BF_MEM_PHY_ISO_CNTRL_MASK 0x20000
#define BACO_CNTL__BACO_BF_MEM_PHY_ISO_CNTRL__SHIFT 0x11
#define BF_ANA_ISO_CNTL__BF_ANA_ISO_DIS_MASK_MASK 0x1
#define BF_ANA_ISO_CNTL__BF_ANA_ISO_DIS_MASK__SHIFT 0x0
#define BF_ANA_ISO_CNTL__BF_VDDC_ISO_DIS_MASK_MASK 0x2
#define BF_ANA_ISO_CNTL__BF_VDDC_ISO_DIS_MASK__SHIFT 0x1
#define MEM_TYPE_CNTL__BF_MEM_PHY_G5_G3_MASK 0x1
#define MEM_TYPE_CNTL__BF_MEM_PHY_G5_G3__SHIFT 0x0
#define BIF_BACO_DEBUG__BIF_BACO_SCANDUMP_FLG_MASK 0x1
#define BIF_BACO_DEBUG__BIF_BACO_SCANDUMP_FLG__SHIFT 0x0
#define BIF_BACO_DEBUG_LATCH__BIF_BACO_LATCH_FLG_MASK 0x1
#define BIF_BACO_DEBUG_LATCH__BIF_BACO_LATCH_FLG__SHIFT 0x0
#define BACO_CNTL_MISC__BIF_ROM_REQ_DIS_MASK 0x1
#define BACO_CNTL_MISC__BIF_ROM_REQ_DIS__SHIFT 0x0
#define BACO_CNTL_MISC__BIF_AZ_REQ_DIS_MASK 0x2
#define BACO_CNTL_MISC__BIF_AZ_REQ_DIS__SHIFT 0x1
#define BACO_CNTL_MISC__BACO_LINK_RST_WIDTH_SEL_MASK 0xc
#define BACO_CNTL_MISC__BACO_LINK_RST_WIDTH_SEL__SHIFT 0x2
#define SMU_BIF_VDDGFX_PWR_STATUS__VDDGFX_GFX_PWR_OFF_MASK 0x1
#define SMU_BIF_VDDGFX_PWR_STATUS__VDDGFX_GFX_PWR_OFF__SHIFT 0x0
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX0_UPPER__VDDGFX_GFX0_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_UPPER__VDDGFX_GFX0_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX1_UPPER__VDDGFX_GFX1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_UPPER__VDDGFX_GFX1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX2_UPPER__VDDGFX_GFX2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_UPPER__VDDGFX_GFX2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX3_UPPER__VDDGFX_GFX3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_UPPER__VDDGFX_GFX3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX4_UPPER__VDDGFX_GFX4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_UPPER__VDDGFX_GFX4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX5_UPPER__VDDGFX_GFX5_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_UPPER__VDDGFX_GFX5_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV1_UPPER__VDDGFX_RSV1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_UPPER__VDDGFX_RSV1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV2_UPPER__VDDGFX_RSV2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_UPPER__VDDGFX_RSV2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV3_UPPER__VDDGFX_RSV3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_UPPER__VDDGFX_RSV3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV4_UPPER__VDDGFX_RSV4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_UPPER__VDDGFX_RSV4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_CMP_EN_MASK 0x1
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_CMP_EN__SHIFT 0x0
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_STALL_EN_MASK 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_STALL_EN__SHIFT 0x1
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_CMP_EN_MASK 0x4
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_CMP_EN__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_STALL_EN_MASK 0x8
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_STALL_EN__SHIFT 0x3
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_CMP_EN_MASK 0x10
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_CMP_EN__SHIFT 0x4
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_STALL_EN_MASK 0x20
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_STALL_EN__SHIFT 0x5
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER1_UPPER__DOORBELL_GBLAPER1_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_UPPER__DOORBELL_GBLAPER1_UPPER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER2_UPPER__DOORBELL_GBLAPER2_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_UPPER__DOORBELL_GBLAPER2_UPPER__SHIFT 0x2
#define BIF_SMU_INDEX__BIF_SMU_INDEX_MASK 0x7fffc
#define BIF_SMU_INDEX__BIF_SMU_INDEX__SHIFT 0x2
#define BIF_SMU_DATA__BIF_SMU_DATA_MASK 0x7fffc
#define BIF_SMU_DATA__BIF_SMU_DATA__SHIFT 0x2
#define IMPCTL_RESET__IMP_SW_RESET_MASK 0x1
#define IMPCTL_RESET__IMP_SW_RESET__SHIFT 0x0
#define GARLIC_FLUSH_CNTL__CP_RB0_WPTR_MASK 0x1
#define GARLIC_FLUSH_CNTL__CP_RB0_WPTR__SHIFT 0x0
#define GARLIC_FLUSH_CNTL__CP_RB1_WPTR_MASK 0x2
#define GARLIC_FLUSH_CNTL__CP_RB1_WPTR__SHIFT 0x1
#define GARLIC_FLUSH_CNTL__CP_RB2_WPTR_MASK 0x4
#define GARLIC_FLUSH_CNTL__CP_RB2_WPTR__SHIFT 0x2
#define GARLIC_FLUSH_CNTL__UVD_RBC_RB_WPTR_MASK 0x8
#define GARLIC_FLUSH_CNTL__UVD_RBC_RB_WPTR__SHIFT 0x3
#define GARLIC_FLUSH_CNTL__SDMA0_GFX_RB_WPTR_MASK 0x10
#define GARLIC_FLUSH_CNTL__SDMA0_GFX_RB_WPTR__SHIFT 0x4
#define GARLIC_FLUSH_CNTL__SDMA1_GFX_RB_WPTR_MASK 0x20
#define GARLIC_FLUSH_CNTL__SDMA1_GFX_RB_WPTR__SHIFT 0x5
#define GARLIC_FLUSH_CNTL__CP_DMA_ME_COMMAND_MASK 0x40
#define GARLIC_FLUSH_CNTL__CP_DMA_ME_COMMAND__SHIFT 0x6
#define GARLIC_FLUSH_CNTL__CP_DMA_PFP_COMMAND_MASK 0x80
#define GARLIC_FLUSH_CNTL__CP_DMA_PFP_COMMAND__SHIFT 0x7
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBI_WPTR_MASK 0x100
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBI_WPTR__SHIFT 0x8
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBO_WPTR_MASK 0x200
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBO_WPTR__SHIFT 0x9
#define GARLIC_FLUSH_CNTL__VCE_OUT_RB_WPTR_MASK 0x400
#define GARLIC_FLUSH_CNTL__VCE_OUT_RB_WPTR__SHIFT 0xa
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR2_MASK 0x800
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR2__SHIFT 0xb
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR_MASK 0x1000
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR__SHIFT 0xc
#define GARLIC_FLUSH_CNTL__HOST_DOORBELL_MASK 0x2000
#define GARLIC_FLUSH_CNTL__HOST_DOORBELL__SHIFT 0xd
#define GARLIC_FLUSH_CNTL__SELFRING_DOORBELL_MASK 0x4000
#define GARLIC_FLUSH_CNTL__SELFRING_DOORBELL__SHIFT 0xe
#define GARLIC_FLUSH_CNTL__CP_DMA_PIO_COMMAND_MASK 0x8000
#define GARLIC_FLUSH_CNTL__CP_DMA_PIO_COMMAND__SHIFT 0xf
#define GARLIC_FLUSH_CNTL__DISPLAY_MASK 0x10000
#define GARLIC_FLUSH_CNTL__DISPLAY__SHIFT 0x10
#define GARLIC_FLUSH_CNTL__SDMA2_GFX_RB_WPTR_MASK 0x20000
#define GARLIC_FLUSH_CNTL__SDMA2_GFX_RB_WPTR__SHIFT 0x11
#define GARLIC_FLUSH_CNTL__SDMA3_GFX_RB_WPTR_MASK 0x40000
#define GARLIC_FLUSH_CNTL__SDMA3_GFX_RB_WPTR__SHIFT 0x12
#define GARLIC_FLUSH_CNTL__IGNORE_MC_DISABLE_MASK 0x40000000
#define GARLIC_FLUSH_CNTL__IGNORE_MC_DISABLE__SHIFT 0x1e
#define GARLIC_FLUSH_CNTL__DISABLE_ALL_MASK 0x80000000
#define GARLIC_FLUSH_CNTL__DISABLE_ALL__SHIFT 0x1f
#define GARLIC_FLUSH_ADDR_START_0__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_0__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_0__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_0__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_0__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_0__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_1__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_1__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_1__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_1__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_1__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_1__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_2__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_2__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_2__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_2__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_2__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_2__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_3__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_3__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_3__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_3__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_3__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_3__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_4__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_4__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_4__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_4__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_4__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_4__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_5__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_5__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_5__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_5__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_5__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_5__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_6__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_6__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_6__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_6__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_6__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_6__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_7__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_7__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_7__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_7__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_7__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_7__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_0__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_0__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_1__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_1__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_2__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_2__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_3__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_3__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_4__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_4__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_5__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_5__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_6__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_6__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_7__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_7__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_REQ__FLUSH_REQ_MASK 0x1
#define GARLIC_FLUSH_REQ__FLUSH_REQ__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_REQ__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_REQ__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_REQ__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_REQ__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_REQ__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_REQ__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_REQ__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_REQ__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_REQ__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_REQ__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_REQ__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_REQ__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_REQ__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_REQ__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_REQ__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_REQ__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_REQ__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_REQ__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_REQ__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_REQ__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_REQ__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_REQ__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_REQ__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_REQ__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_REQ__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_REQ__SDMA3__SHIFT 0xd
#define GPU_GARLIC_FLUSH_DONE__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_DONE__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_DONE__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_DONE__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_DONE__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_DONE__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_DONE__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_DONE__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_DONE__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_DONE__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_DONE__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_DONE__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_DONE__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_DONE__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_DONE__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_DONE__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_DONE__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_DONE__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_DONE__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_DONE__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_DONE__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_DONE__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_DONE__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_DONE__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_DONE__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_DONE__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_DONE__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_DONE__SDMA3__SHIFT 0xd
#define GARLIC_COHE_CP_RB0_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB0_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_RB1_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB1_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_RB2_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB2_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_UVD_RBC_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_UVD_RBC_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA0_GFX_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA0_GFX_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA1_GFX_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA1_GFX_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_ME_COMMAND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_ME_COMMAND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_PFP_COMMAND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_PFP_COMMAND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SAM_SAB_RBI_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SAM_SAB_RBI_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SAM_SAB_RBO_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SAM_SAB_RBO_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_OUT_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_OUT_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_RB_WPTR2__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_RB_WPTR2__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA2_GFX_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA2_GFX_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA3_GFX_RB_WPTR__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA3_GFX_RB_WPTR__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_PIO_COMMAND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_PIO_COMMAND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_GARLIC_FLUSH_REQ__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_GARLIC_FLUSH_REQ__ADDRESS__SHIFT 0x2
#define REMAP_HDP_MEM_FLUSH_CNTL__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_MEM_FLUSH_CNTL__ADDRESS__SHIFT 0x2
#define REMAP_HDP_REG_FLUSH_CNTL__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_REG_FLUSH_CNTL__ADDRESS__SHIFT 0x2
#define BIOS_SCRATCH_0__BIOS_SCRATCH_0_MASK 0xffffffff
#define BIOS_SCRATCH_0__BIOS_SCRATCH_0__SHIFT 0x0
#define BIOS_SCRATCH_1__BIOS_SCRATCH_1_MASK 0xffffffff
#define BIOS_SCRATCH_1__BIOS_SCRATCH_1__SHIFT 0x0
#define BIOS_SCRATCH_2__BIOS_SCRATCH_2_MASK 0xffffffff
#define BIOS_SCRATCH_2__BIOS_SCRATCH_2__SHIFT 0x0
#define BIOS_SCRATCH_3__BIOS_SCRATCH_3_MASK 0xffffffff
#define BIOS_SCRATCH_3__BIOS_SCRATCH_3__SHIFT 0x0
#define BIOS_SCRATCH_4__BIOS_SCRATCH_4_MASK 0xffffffff
#define BIOS_SCRATCH_4__BIOS_SCRATCH_4__SHIFT 0x0
#define BIOS_SCRATCH_5__BIOS_SCRATCH_5_MASK 0xffffffff
#define BIOS_SCRATCH_5__BIOS_SCRATCH_5__SHIFT 0x0
#define BIOS_SCRATCH_6__BIOS_SCRATCH_6_MASK 0xffffffff
#define BIOS_SCRATCH_6__BIOS_SCRATCH_6__SHIFT 0x0
#define BIOS_SCRATCH_7__BIOS_SCRATCH_7_MASK 0xffffffff
#define BIOS_SCRATCH_7__BIOS_SCRATCH_7__SHIFT 0x0
#define BIOS_SCRATCH_8__BIOS_SCRATCH_8_MASK 0xffffffff
#define BIOS_SCRATCH_8__BIOS_SCRATCH_8__SHIFT 0x0
#define BIOS_SCRATCH_9__BIOS_SCRATCH_9_MASK 0xffffffff
#define BIOS_SCRATCH_9__BIOS_SCRATCH_9__SHIFT 0x0
#define BIOS_SCRATCH_10__BIOS_SCRATCH_10_MASK 0xffffffff
#define BIOS_SCRATCH_10__BIOS_SCRATCH_10__SHIFT 0x0
#define BIOS_SCRATCH_11__BIOS_SCRATCH_11_MASK 0xffffffff
#define BIOS_SCRATCH_11__BIOS_SCRATCH_11__SHIFT 0x0
#define BIOS_SCRATCH_12__BIOS_SCRATCH_12_MASK 0xffffffff
#define BIOS_SCRATCH_12__BIOS_SCRATCH_12__SHIFT 0x0
#define BIOS_SCRATCH_13__BIOS_SCRATCH_13_MASK 0xffffffff
#define BIOS_SCRATCH_13__BIOS_SCRATCH_13__SHIFT 0x0
#define BIOS_SCRATCH_14__BIOS_SCRATCH_14_MASK 0xffffffff
#define BIOS_SCRATCH_14__BIOS_SCRATCH_14__SHIFT 0x0
#define BIOS_SCRATCH_15__BIOS_SCRATCH_15_MASK 0xffffffff
#define BIOS_SCRATCH_15__BIOS_SCRATCH_15__SHIFT 0x0
#define BIF_RB_CNTL__RB_ENABLE_MASK 0x1
#define BIF_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define BIF_RB_CNTL__RB_SIZE_MASK 0x3e
#define BIF_RB_CNTL__RB_SIZE__SHIFT 0x1
#define BIF_RB_CNTL__WPTR_WRITEBACK_ENABLE_MASK 0x100
#define BIF_RB_CNTL__WPTR_WRITEBACK_ENABLE__SHIFT 0x8
#define BIF_RB_CNTL__WPTR_WRITEBACK_TIMER_MASK 0x3e00
#define BIF_RB_CNTL__WPTR_WRITEBACK_TIMER__SHIFT 0x9
#define BIF_RB_CNTL__BIF_RB_TRAN_MASK 0x20000
#define BIF_RB_CNTL__BIF_RB_TRAN__SHIFT 0x11
#define BIF_RB_CNTL__WPTR_OVERFLOW_CLEAR_MASK 0x80000000
#define BIF_RB_CNTL__WPTR_OVERFLOW_CLEAR__SHIFT 0x1f
#define BIF_RB_BASE__ADDR_MASK 0xffffffff
#define BIF_RB_BASE__ADDR__SHIFT 0x0
#define BIF_RB_RPTR__OFFSET_MASK 0x3fffc
#define BIF_RB_RPTR__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR__BIF_RB_OVERFLOW_MASK 0x1
#define BIF_RB_WPTR__BIF_RB_OVERFLOW__SHIFT 0x0
#define BIF_RB_WPTR__OFFSET_MASK 0x3fffc
#define BIF_RB_WPTR__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR_ADDR_HI__ADDR_MASK 0xff
#define BIF_RB_WPTR_ADDR_HI__ADDR__SHIFT 0x0
#define BIF_RB_WPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define BIF_RB_WPTR_ADDR_LO__ADDR__SHIFT 0x2
#define VENDOR_ID__VENDOR_ID_MASK 0xffff
#define VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define DEVICE_ID__DEVICE_ID_MASK 0xffff
#define DEVICE_ID__DEVICE_ID__SHIFT 0x0
#define COMMAND__IO_ACCESS_EN_MASK 0x1
#define COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define COMMAND__MEM_ACCESS_EN_MASK 0x2
#define COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define COMMAND__BUS_MASTER_EN_MASK 0x4
#define COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define COMMAND__PAL_SNOOP_EN_MASK 0x20
#define COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define COMMAND__AD_STEPPING_MASK 0x80
#define COMMAND__AD_STEPPING__SHIFT 0x7
#define COMMAND__SERR_EN_MASK 0x100
#define COMMAND__SERR_EN__SHIFT 0x8
#define COMMAND__FAST_B2B_EN_MASK 0x200
#define COMMAND__FAST_B2B_EN__SHIFT 0x9
#define COMMAND__INT_DIS_MASK 0x400
#define COMMAND__INT_DIS__SHIFT 0xa
#define STATUS__INT_STATUS_MASK 0x8
#define STATUS__INT_STATUS__SHIFT 0x3
#define STATUS__CAP_LIST_MASK 0x10
#define STATUS__CAP_LIST__SHIFT 0x4
#define STATUS__PCI_66_EN_MASK 0x20
#define STATUS__PCI_66_EN__SHIFT 0x5
#define STATUS__FAST_BACK_CAPABLE_MASK 0x80
#define STATUS__FAST_BACK_CAPABLE__SHIFT 0x7
#define STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x100
#define STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x8
#define STATUS__DEVSEL_TIMING_MASK 0x600
#define STATUS__DEVSEL_TIMING__SHIFT 0x9
#define STATUS__SIGNAL_TARGET_ABORT_MASK 0x800
#define STATUS__SIGNAL_TARGET_ABORT__SHIFT 0xb
#define STATUS__RECEIVED_TARGET_ABORT_MASK 0x1000
#define STATUS__RECEIVED_TARGET_ABORT__SHIFT 0xc
#define STATUS__RECEIVED_MASTER_ABORT_MASK 0x2000
#define STATUS__RECEIVED_MASTER_ABORT__SHIFT 0xd
#define STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x4000
#define STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0xe
#define STATUS__PARITY_ERROR_DETECTED_MASK 0x8000
#define STATUS__PARITY_ERROR_DETECTED__SHIFT 0xf
#define REVISION_ID__MINOR_REV_ID_MASK 0xf
#define REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define PROG_INTERFACE__PROG_INTERFACE_MASK 0xff
#define PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x0
#define SUB_CLASS__SUB_CLASS_MASK 0xff
#define SUB_CLASS__SUB_CLASS__SHIFT 0x0
#define BASE_CLASS__BASE_CLASS_MASK 0xff
#define BASE_CLASS__BASE_CLASS__SHIFT 0x0
#define CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define LATENCY__LATENCY_TIMER_MASK 0xff
#define LATENCY__LATENCY_TIMER__SHIFT 0x0
#define HEADER__HEADER_TYPE_MASK 0x7f
#define HEADER__HEADER_TYPE__SHIFT 0x0
#define HEADER__DEVICE_TYPE_MASK 0x80
#define HEADER__DEVICE_TYPE__SHIFT 0x7
#define BIST__BIST_COMP_MASK 0xf
#define BIST__BIST_COMP__SHIFT 0x0
#define BIST__BIST_STRT_MASK 0x40
#define BIST__BIST_STRT__SHIFT 0x6
#define BIST__BIST_CAP_MASK 0x80
#define BIST__BIST_CAP__SHIFT 0x7
#define BASE_ADDR_1__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_1__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_2__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_2__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_3__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_3__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_4__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_4__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_5__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_5__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_6__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_6__BASE_ADDR__SHIFT 0x0
#define ROM_BASE_ADDR__BASE_ADDR_MASK 0xffffffff
#define ROM_BASE_ADDR__BASE_ADDR__SHIFT 0x0
#define CAP_PTR__CAP_PTR_MASK 0xff
#define CAP_PTR__CAP_PTR__SHIFT 0x0
#define INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff
#define INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x0
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define ADAPTER_ID__SUBSYSTEM_ID_MASK 0xffff0000
#define ADAPTER_ID__SUBSYSTEM_ID__SHIFT 0x10
#define MIN_GRANT__MIN_GNT_MASK 0xff
#define MIN_GRANT__MIN_GNT__SHIFT 0x0
#define MAX_LATENCY__MAX_LAT_MASK 0xff
#define MAX_LATENCY__MAX_LAT__SHIFT 0x0
#define VENDOR_CAP_LIST__CAP_ID_MASK 0xff
#define VENDOR_CAP_LIST__CAP_ID__SHIFT 0x0
#define VENDOR_CAP_LIST__NEXT_PTR_MASK 0xff00
#define VENDOR_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define VENDOR_CAP_LIST__LENGTH_MASK 0xff0000
#define VENDOR_CAP_LIST__LENGTH__SHIFT 0x10
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define ADAPTER_ID_W__SUBSYSTEM_ID_MASK 0xffff0000
#define ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT 0x10
#define PMI_CAP_LIST__CAP_ID_MASK 0xff
#define PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define PMI_CAP__VERSION_MASK 0x7
#define PMI_CAP__VERSION__SHIFT 0x0
#define PMI_CAP__PME_CLOCK_MASK 0x8
#define PMI_CAP__PME_CLOCK__SHIFT 0x3
#define PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x20
#define PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x5
#define PMI_CAP__AUX_CURRENT_MASK 0x1c0
#define PMI_CAP__AUX_CURRENT__SHIFT 0x6
#define PMI_CAP__D1_SUPPORT_MASK 0x200
#define PMI_CAP__D1_SUPPORT__SHIFT 0x9
#define PMI_CAP__D2_SUPPORT_MASK 0x400
#define PMI_CAP__D2_SUPPORT__SHIFT 0xa
#define PMI_CAP__PME_SUPPORT_MASK 0xf800
#define PMI_CAP__PME_SUPPORT__SHIFT 0xb
#define PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define PCIE_CAP__VERSION_MASK 0xf
#define PCIE_CAP__VERSION__SHIFT 0x0
#define PCIE_CAP__DEVICE_TYPE_MASK 0xf0
#define PCIE_CAP__DEVICE_TYPE__SHIFT 0x4
#define PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x100
#define PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x8
#define PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e00
#define PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x9
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define DEVICE_CNTL__INITIATE_FLR_MASK 0x8000
#define DEVICE_CNTL__INITIATE_FLR__SHIFT 0xf
#define DEVICE_STATUS__CORR_ERR_MASK 0x1
#define DEVICE_STATUS__CORR_ERR__SHIFT 0x0
#define DEVICE_STATUS__NON_FATAL_ERR_MASK 0x2
#define DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x1
#define DEVICE_STATUS__FATAL_ERR_MASK 0x4
#define DEVICE_STATUS__FATAL_ERR__SHIFT 0x2
#define DEVICE_STATUS__USR_DETECTED_MASK 0x8
#define DEVICE_STATUS__USR_DETECTED__SHIFT 0x3
#define DEVICE_STATUS__AUX_PWR_MASK 0x10
#define DEVICE_STATUS__AUX_PWR__SHIFT 0x4
#define DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x20
#define DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x5
#define LINK_CAP__LINK_SPEED_MASK 0xf
#define LINK_CAP__LINK_SPEED__SHIFT 0x0
#define LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define LINK_CAP__PM_SUPPORT_MASK 0xc00
#define LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define LINK_CNTL__PM_CONTROL_MASK 0x3
#define LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define LINK_CNTL__LINK_DIS_MASK 0x10
#define LINK_CNTL__LINK_DIS__SHIFT 0x4
#define LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf
#define LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x0
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f0
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x4
#define LINK_STATUS__LINK_TRAINING_MASK 0x800
#define LINK_STATUS__LINK_TRAINING__SHIFT 0xb
#define LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x1000
#define LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0xc
#define LINK_STATUS__DL_ACTIVE_MASK 0x2000
#define LINK_STATUS__DL_ACTIVE__SHIFT 0xd
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x4000
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0xe
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x8000
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0xf
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define DEVICE_CNTL2__LTR_EN_MASK 0x400
#define DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define DEVICE_STATUS2__RESERVED_MASK 0xffff
#define DEVICE_STATUS2__RESERVED__SHIFT 0x0
#define LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define LINK_CAP2__RESERVED_MASK 0xfffffe00
#define LINK_CAP2__RESERVED__SHIFT 0x9
#define LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x1
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x0
#define LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x2
#define LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x1
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x4
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x2
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x8
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x3
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x10
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x4
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x20
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x5
#define MSI_CAP_LIST__CAP_ID_MASK 0xff
#define MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define MSI_MSG_CNTL__MSI_EN_MASK 0x1
#define MSI_MSG_CNTL__MSI_EN__SHIFT 0x0
#define MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe
#define MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x1
#define MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x70
#define MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x4
#define MSI_MSG_CNTL__MSI_64BIT_MASK 0x80
#define MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x7
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x2
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x1
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x2
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x1
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR1_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR1_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR1_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR1_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR2_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR2_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR2_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR2_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR3_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR3_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR3_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR3_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR4_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR4_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR4_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR4_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR5_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR5_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR5_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR5_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR6_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR6_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR6_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR6_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK 0xff
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT 0x0
#define PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK 0xff
#define PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT 0x0
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK 0x300
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT 0x8
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK 0x1c00
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT 0xa
#define PCIE_PWR_BUDGET_DATA__PM_STATE_MASK 0x6000
#define PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT 0xd
#define PCIE_PWR_BUDGET_DATA__TYPE_MASK 0x38000
#define PCIE_PWR_BUDGET_DATA__TYPE__SHIFT 0xf
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK 0x1c0000
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT 0x12
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK 0x1
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT 0x0
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_DPA_CAP__SUBSTATE_MAX_MASK 0x1f
#define PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT 0x0
#define PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK 0x300
#define PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT 0x8
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK 0x3000
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT 0xc
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK 0xff0000
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT 0x10
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK 0xff000000
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT 0x18
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK 0xff
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT 0x0
#define PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK 0x1f
#define PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT 0x0
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK 0x100
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT 0x8
#define PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK 0x1f
#define PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x1
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x0
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x2
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x1
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x4
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x2
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x8
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x3
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x10
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x4
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x20
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x5
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x40
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x6
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK 0x1f
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT 0x0
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK 0x20
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT 0x5
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK 0x40
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT 0x6
#define PCIE_ATS_CNTL__STU_MASK 0x1f
#define PCIE_ATS_CNTL__STU__SHIFT 0x0
#define PCIE_ATS_CNTL__ATC_ENABLE_MASK 0x8000
#define PCIE_ATS_CNTL__ATC_ENABLE__SHIFT 0xf
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK 0x1
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT 0x0
#define PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK 0x2
#define PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT 0x1
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK 0x1
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT 0x0
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK 0x2
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT 0x1
#define PCIE_PAGE_REQ_STATUS__STOPPED_MASK 0x100
#define PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT 0x8
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK 0x8000
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT 0xf
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK 0xffffffff
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT 0x0
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK 0xffffffff
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT 0x0
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK 0x2
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT 0x1
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK 0x4
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT 0x2
#define PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK 0x1f00
#define PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT 0x8
#define PCIE_PASID_CNTL__PASID_ENABLE_MASK 0x1
#define PCIE_PASID_CNTL__PASID_ENABLE__SHIFT 0x0
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK 0x2
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT 0x1
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK 0x4
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT 0x2
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED_MASK 0x1
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED__SHIFT 0x0
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED_MASK 0x2
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED__SHIFT 0x1
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED_MASK 0x4
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED__SHIFT 0x2
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED_MASK 0x100
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED__SHIFT 0x8
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION_MASK 0x600
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION__SHIFT 0x9
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE_MASK 0x7ff0000
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE__SHIFT 0x10
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL_MASK 0x7
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL__SHIFT 0x0
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN_MASK 0x300
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN__SHIFT 0x8
#define PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK 0x3f00
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT 0x8
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f
#define PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x0
#define PCIE_MC_CNTL__MC_ENABLE_MASK 0x8000
#define PCIE_MC_CNTL__MC_ENABLE__SHIFT 0xf
#define PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK 0x3ff
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT 0x0
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK 0x1c00
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT 0xa
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK 0x3ff0000
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT 0x10
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK 0x1c000000
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT 0x1a
#define MM_INDEX_IND__MM_OFFSET_MASK 0x7fffffff
#define MM_INDEX_IND__MM_OFFSET__SHIFT 0x0
#define MM_INDEX_IND__MM_APER_MASK 0x80000000
#define MM_INDEX_IND__MM_APER__SHIFT 0x1f
#define MM_INDEX_HI_IND__MM_OFFSET_HI_MASK 0xffffffff
#define MM_INDEX_HI_IND__MM_OFFSET_HI__SHIFT 0x0
#define MM_DATA_IND__MM_DATA_MASK 0xffffffff
#define MM_DATA_IND__MM_DATA__SHIFT 0x0
#define BIF_MM_INDACCESS_CNTL_IND__MM_INDACCESS_DIS_MASK 0x2
#define BIF_MM_INDACCESS_CNTL_IND__MM_INDACCESS_DIS__SHIFT 0x1
#define BUS_CNTL_IND__BIOS_ROM_WRT_EN_MASK 0x1
#define BUS_CNTL_IND__BIOS_ROM_WRT_EN__SHIFT 0x0
#define BUS_CNTL_IND__BIOS_ROM_DIS_MASK 0x2
#define BUS_CNTL_IND__BIOS_ROM_DIS__SHIFT 0x1
#define BUS_CNTL_IND__PMI_IO_DIS_MASK 0x4
#define BUS_CNTL_IND__PMI_IO_DIS__SHIFT 0x2
#define BUS_CNTL_IND__PMI_MEM_DIS_MASK 0x8
#define BUS_CNTL_IND__PMI_MEM_DIS__SHIFT 0x3
#define BUS_CNTL_IND__PMI_BM_DIS_MASK 0x10
#define BUS_CNTL_IND__PMI_BM_DIS__SHIFT 0x4
#define BUS_CNTL_IND__PMI_INT_DIS_MASK 0x20
#define BUS_CNTL_IND__PMI_INT_DIS__SHIFT 0x5
#define BUS_CNTL_IND__VGA_REG_COHERENCY_DIS_MASK 0x40
#define BUS_CNTL_IND__VGA_REG_COHERENCY_DIS__SHIFT 0x6
#define BUS_CNTL_IND__VGA_MEM_COHERENCY_DIS_MASK 0x80
#define BUS_CNTL_IND__VGA_MEM_COHERENCY_DIS__SHIFT 0x7
#define BUS_CNTL_IND__BIF_ERR_RTR_BKPRESSURE_EN_MASK 0x100
#define BUS_CNTL_IND__BIF_ERR_RTR_BKPRESSURE_EN__SHIFT 0x8
#define BUS_CNTL_IND__SET_AZ_TC_MASK 0x1c00
#define BUS_CNTL_IND__SET_AZ_TC__SHIFT 0xa
#define BUS_CNTL_IND__SET_MC_TC_MASK 0xe000
#define BUS_CNTL_IND__SET_MC_TC__SHIFT 0xd
#define BUS_CNTL_IND__ZERO_BE_WR_EN_MASK 0x10000
#define BUS_CNTL_IND__ZERO_BE_WR_EN__SHIFT 0x10
#define BUS_CNTL_IND__ZERO_BE_RD_EN_MASK 0x20000
#define BUS_CNTL_IND__ZERO_BE_RD_EN__SHIFT 0x11
#define BUS_CNTL_IND__RD_STALL_IO_WR_MASK 0x40000
#define BUS_CNTL_IND__RD_STALL_IO_WR__SHIFT 0x12
#define CONFIG_CNTL_IND__CFG_VGA_RAM_EN_MASK 0x1
#define CONFIG_CNTL_IND__CFG_VGA_RAM_EN__SHIFT 0x0
#define CONFIG_CNTL_IND__VGA_DIS_MASK 0x2
#define CONFIG_CNTL_IND__VGA_DIS__SHIFT 0x1
#define CONFIG_CNTL_IND__GENMO_MONO_ADDRESS_B_MASK 0x4
#define CONFIG_CNTL_IND__GENMO_MONO_ADDRESS_B__SHIFT 0x2
#define CONFIG_CNTL_IND__GRPH_ADRSEL_MASK 0x18
#define CONFIG_CNTL_IND__GRPH_ADRSEL__SHIFT 0x3
#define CONFIG_MEMSIZE_IND__CONFIG_MEMSIZE_MASK 0xffffffff
#define CONFIG_MEMSIZE_IND__CONFIG_MEMSIZE__SHIFT 0x0
#define CONFIG_F0_BASE_IND__F0_BASE_MASK 0xffffffff
#define CONFIG_F0_BASE_IND__F0_BASE__SHIFT 0x0
#define CONFIG_APER_SIZE_IND__APER_SIZE_MASK 0xffffffff
#define CONFIG_APER_SIZE_IND__APER_SIZE__SHIFT 0x0
#define CONFIG_REG_APER_SIZE_IND__REG_APER_SIZE_MASK 0xfffff
#define CONFIG_REG_APER_SIZE_IND__REG_APER_SIZE__SHIFT 0x0
#define BIF_SCRATCH0_IND__BIF_SCRATCH0_MASK 0xffffffff
#define BIF_SCRATCH0_IND__BIF_SCRATCH0__SHIFT 0x0
#define BIF_SCRATCH1_IND__BIF_SCRATCH1_MASK 0xffffffff
#define BIF_SCRATCH1_IND__BIF_SCRATCH1__SHIFT 0x0
#define BX_RESET_EN_IND__COR_RESET_EN_MASK 0x1
#define BX_RESET_EN_IND__COR_RESET_EN__SHIFT 0x0
#define BX_RESET_EN_IND__REG_RESET_EN_MASK 0x2
#define BX_RESET_EN_IND__REG_RESET_EN__SHIFT 0x1
#define BX_RESET_EN_IND__STY_RESET_EN_MASK 0x4
#define BX_RESET_EN_IND__STY_RESET_EN__SHIFT 0x2
#define MM_CFGREGS_CNTL_IND__MM_CFG_FUNC_SEL_MASK 0x7
#define MM_CFGREGS_CNTL_IND__MM_CFG_FUNC_SEL__SHIFT 0x0
#define MM_CFGREGS_CNTL_IND__MM_WR_TO_CFG_EN_MASK 0x8
#define MM_CFGREGS_CNTL_IND__MM_WR_TO_CFG_EN__SHIFT 0x3
#define HW_DEBUG_IND__HW_00_DEBUG_MASK 0x1
#define HW_DEBUG_IND__HW_00_DEBUG__SHIFT 0x0
#define HW_DEBUG_IND__HW_01_DEBUG_MASK 0x2
#define HW_DEBUG_IND__HW_01_DEBUG__SHIFT 0x1
#define HW_DEBUG_IND__HW_02_DEBUG_MASK 0x4
#define HW_DEBUG_IND__HW_02_DEBUG__SHIFT 0x2
#define HW_DEBUG_IND__HW_03_DEBUG_MASK 0x8
#define HW_DEBUG_IND__HW_03_DEBUG__SHIFT 0x3
#define HW_DEBUG_IND__HW_04_DEBUG_MASK 0x10
#define HW_DEBUG_IND__HW_04_DEBUG__SHIFT 0x4
#define HW_DEBUG_IND__HW_05_DEBUG_MASK 0x20
#define HW_DEBUG_IND__HW_05_DEBUG__SHIFT 0x5
#define HW_DEBUG_IND__HW_06_DEBUG_MASK 0x40
#define HW_DEBUG_IND__HW_06_DEBUG__SHIFT 0x6
#define HW_DEBUG_IND__HW_07_DEBUG_MASK 0x80
#define HW_DEBUG_IND__HW_07_DEBUG__SHIFT 0x7
#define HW_DEBUG_IND__HW_08_DEBUG_MASK 0x100
#define HW_DEBUG_IND__HW_08_DEBUG__SHIFT 0x8
#define HW_DEBUG_IND__HW_09_DEBUG_MASK 0x200
#define HW_DEBUG_IND__HW_09_DEBUG__SHIFT 0x9
#define HW_DEBUG_IND__HW_10_DEBUG_MASK 0x400
#define HW_DEBUG_IND__HW_10_DEBUG__SHIFT 0xa
#define HW_DEBUG_IND__HW_11_DEBUG_MASK 0x800
#define HW_DEBUG_IND__HW_11_DEBUG__SHIFT 0xb
#define HW_DEBUG_IND__HW_12_DEBUG_MASK 0x1000
#define HW_DEBUG_IND__HW_12_DEBUG__SHIFT 0xc
#define HW_DEBUG_IND__HW_13_DEBUG_MASK 0x2000
#define HW_DEBUG_IND__HW_13_DEBUG__SHIFT 0xd
#define HW_DEBUG_IND__HW_14_DEBUG_MASK 0x4000
#define HW_DEBUG_IND__HW_14_DEBUG__SHIFT 0xe
#define HW_DEBUG_IND__HW_15_DEBUG_MASK 0x8000
#define HW_DEBUG_IND__HW_15_DEBUG__SHIFT 0xf
#define HW_DEBUG_IND__HW_16_DEBUG_MASK 0x10000
#define HW_DEBUG_IND__HW_16_DEBUG__SHIFT 0x10
#define HW_DEBUG_IND__HW_17_DEBUG_MASK 0x20000
#define HW_DEBUG_IND__HW_17_DEBUG__SHIFT 0x11
#define HW_DEBUG_IND__HW_18_DEBUG_MASK 0x40000
#define HW_DEBUG_IND__HW_18_DEBUG__SHIFT 0x12
#define HW_DEBUG_IND__HW_19_DEBUG_MASK 0x80000
#define HW_DEBUG_IND__HW_19_DEBUG__SHIFT 0x13
#define HW_DEBUG_IND__HW_20_DEBUG_MASK 0x100000
#define HW_DEBUG_IND__HW_20_DEBUG__SHIFT 0x14
#define HW_DEBUG_IND__HW_21_DEBUG_MASK 0x200000
#define HW_DEBUG_IND__HW_21_DEBUG__SHIFT 0x15
#define HW_DEBUG_IND__HW_22_DEBUG_MASK 0x400000
#define HW_DEBUG_IND__HW_22_DEBUG__SHIFT 0x16
#define HW_DEBUG_IND__HW_23_DEBUG_MASK 0x800000
#define HW_DEBUG_IND__HW_23_DEBUG__SHIFT 0x17
#define HW_DEBUG_IND__HW_24_DEBUG_MASK 0x1000000
#define HW_DEBUG_IND__HW_24_DEBUG__SHIFT 0x18
#define HW_DEBUG_IND__HW_25_DEBUG_MASK 0x2000000
#define HW_DEBUG_IND__HW_25_DEBUG__SHIFT 0x19
#define HW_DEBUG_IND__HW_26_DEBUG_MASK 0x4000000
#define HW_DEBUG_IND__HW_26_DEBUG__SHIFT 0x1a
#define HW_DEBUG_IND__HW_27_DEBUG_MASK 0x8000000
#define HW_DEBUG_IND__HW_27_DEBUG__SHIFT 0x1b
#define HW_DEBUG_IND__HW_28_DEBUG_MASK 0x10000000
#define HW_DEBUG_IND__HW_28_DEBUG__SHIFT 0x1c
#define HW_DEBUG_IND__HW_29_DEBUG_MASK 0x20000000
#define HW_DEBUG_IND__HW_29_DEBUG__SHIFT 0x1d
#define HW_DEBUG_IND__HW_30_DEBUG_MASK 0x40000000
#define HW_DEBUG_IND__HW_30_DEBUG__SHIFT 0x1e
#define HW_DEBUG_IND__HW_31_DEBUG_MASK 0x80000000
#define HW_DEBUG_IND__HW_31_DEBUG__SHIFT 0x1f
#define MASTER_CREDIT_CNTL_IND__BIF_MC_RDRET_CREDIT_MASK 0x7f
#define MASTER_CREDIT_CNTL_IND__BIF_MC_RDRET_CREDIT__SHIFT 0x0
#define MASTER_CREDIT_CNTL_IND__BIF_AZ_RDRET_CREDIT_MASK 0x3f0000
#define MASTER_CREDIT_CNTL_IND__BIF_AZ_RDRET_CREDIT__SHIFT 0x10
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_SRBM_REQ_CREDIT_MASK 0x1f
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_SRBM_REQ_CREDIT__SHIFT 0x0
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_VGA_REQ_CREDIT_MASK 0x1e0
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_VGA_REQ_CREDIT__SHIFT 0x5
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_HDP_REQ_CREDIT_MASK 0x7c00
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_HDP_REQ_CREDIT__SHIFT 0xa
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_ROM_REQ_CREDIT_MASK 0x8000
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_ROM_REQ_CREDIT__SHIFT 0xf
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_AZ_REQ_CREDIT_MASK 0x100000
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_AZ_REQ_CREDIT__SHIFT 0x14
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_XDMA_REQ_CREDIT_MASK 0x7e000000
#define SLAVE_REQ_CREDIT_CNTL_IND__BIF_XDMA_REQ_CREDIT__SHIFT 0x19
#define BX_RESET_CNTL_IND__LINK_TRAIN_EN_MASK 0x1
#define BX_RESET_CNTL_IND__LINK_TRAIN_EN__SHIFT 0x0
#define INTERRUPT_CNTL_IND__IH_DUMMY_RD_OVERRIDE_MASK 0x1
#define INTERRUPT_CNTL_IND__IH_DUMMY_RD_OVERRIDE__SHIFT 0x0
#define INTERRUPT_CNTL_IND__IH_DUMMY_RD_EN_MASK 0x2
#define INTERRUPT_CNTL_IND__IH_DUMMY_RD_EN__SHIFT 0x1
#define INTERRUPT_CNTL_IND__IH_REQ_NONSNOOP_EN_MASK 0x8
#define INTERRUPT_CNTL_IND__IH_REQ_NONSNOOP_EN__SHIFT 0x3
#define INTERRUPT_CNTL_IND__IH_INTR_DLY_CNTR_MASK 0xf0
#define INTERRUPT_CNTL_IND__IH_INTR_DLY_CNTR__SHIFT 0x4
#define INTERRUPT_CNTL_IND__GEN_IH_INT_EN_MASK 0x100
#define INTERRUPT_CNTL_IND__GEN_IH_INT_EN__SHIFT 0x8
#define INTERRUPT_CNTL_IND__GEN_GPIO_INT_EN_MASK 0x1e00
#define INTERRUPT_CNTL_IND__GEN_GPIO_INT_EN__SHIFT 0x9
#define INTERRUPT_CNTL_IND__SELECT_INT_GPIO_OUTPUT_MASK 0x6000
#define INTERRUPT_CNTL_IND__SELECT_INT_GPIO_OUTPUT__SHIFT 0xd
#define INTERRUPT_CNTL_IND__BIF_RB_REQ_NONSNOOP_EN_MASK 0x8000
#define INTERRUPT_CNTL_IND__BIF_RB_REQ_NONSNOOP_EN__SHIFT 0xf
#define INTERRUPT_CNTL2_IND__IH_DUMMY_RD_ADDR_MASK 0xffffffff
#define INTERRUPT_CNTL2_IND__IH_DUMMY_RD_ADDR__SHIFT 0x0
#define BIF_DEBUG_CNTL_IND__DEBUG_EN_MASK 0x1
#define BIF_DEBUG_CNTL_IND__DEBUG_EN__SHIFT 0x0
#define BIF_DEBUG_CNTL_IND__DEBUG_MULTIBLOCKEN_MASK 0x2
#define BIF_DEBUG_CNTL_IND__DEBUG_MULTIBLOCKEN__SHIFT 0x1
#define BIF_DEBUG_CNTL_IND__DEBUG_OUT_EN_MASK 0x4
#define BIF_DEBUG_CNTL_IND__DEBUG_OUT_EN__SHIFT 0x2
#define BIF_DEBUG_CNTL_IND__DEBUG_PAD_SEL_MASK 0x8
#define BIF_DEBUG_CNTL_IND__DEBUG_PAD_SEL__SHIFT 0x3
#define BIF_DEBUG_CNTL_IND__DEBUG_BYTESEL_BLK1_MASK 0x10
#define BIF_DEBUG_CNTL_IND__DEBUG_BYTESEL_BLK1__SHIFT 0x4
#define BIF_DEBUG_CNTL_IND__DEBUG_BYTESEL_BLK2_MASK 0x20
#define BIF_DEBUG_CNTL_IND__DEBUG_BYTESEL_BLK2__SHIFT 0x5
#define BIF_DEBUG_CNTL_IND__DEBUG_SYNC_EN_MASK 0x40
#define BIF_DEBUG_CNTL_IND__DEBUG_SYNC_EN__SHIFT 0x6
#define BIF_DEBUG_CNTL_IND__DEBUG_SWAP_MASK 0x80
#define BIF_DEBUG_CNTL_IND__DEBUG_SWAP__SHIFT 0x7
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_BLK1_MASK 0x1f00
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_BLK1__SHIFT 0x8
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_BLK2_MASK 0x1f0000
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_BLK2__SHIFT 0x10
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_XSP_MASK 0x1000000
#define BIF_DEBUG_CNTL_IND__DEBUG_IDSEL_XSP__SHIFT 0x18
#define BIF_DEBUG_CNTL_IND__DEBUG_SYNC_CLKSEL_MASK 0xc0000000
#define BIF_DEBUG_CNTL_IND__DEBUG_SYNC_CLKSEL__SHIFT 0x1e
#define BIF_DEBUG_MUX_IND__DEBUG_MUX_BLK1_MASK 0x3f
#define BIF_DEBUG_MUX_IND__DEBUG_MUX_BLK1__SHIFT 0x0
#define BIF_DEBUG_MUX_IND__DEBUG_MUX_BLK2_MASK 0x3f00
#define BIF_DEBUG_MUX_IND__DEBUG_MUX_BLK2__SHIFT 0x8
#define BIF_DEBUG_OUT_IND__DEBUG_OUTPUT_MASK 0x1ffff
#define BIF_DEBUG_OUT_IND__DEBUG_OUTPUT__SHIFT 0x0
#define HDP_REG_COHERENCY_FLUSH_CNTL_IND__HDP_REG_FLUSH_ADDR_MASK 0x1
#define HDP_REG_COHERENCY_FLUSH_CNTL_IND__HDP_REG_FLUSH_ADDR__SHIFT 0x0
#define HDP_MEM_COHERENCY_FLUSH_CNTL_IND__HDP_MEM_FLUSH_ADDR_MASK 0x1
#define HDP_MEM_COHERENCY_FLUSH_CNTL_IND__HDP_MEM_FLUSH_ADDR__SHIFT 0x0
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_A_MASK 0x1
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_A__SHIFT 0x0
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SEL_MASK 0x2
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SEL__SHIFT 0x1
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_MODE_MASK 0x4
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_MODE__SHIFT 0x2
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SPARE_MASK 0x18
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SPARE__SHIFT 0x3
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN0_MASK 0x20
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN0__SHIFT 0x5
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN1_MASK 0x40
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN1__SHIFT 0x6
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN2_MASK 0x80
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN2__SHIFT 0x7
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN3_MASK 0x100
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SN3__SHIFT 0x8
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SLEWN_MASK 0x200
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SLEWN__SHIFT 0x9
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_WAKE_MASK 0x400
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_WAKE__SHIFT 0xa
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SCHMEN_MASK 0x800
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_SCHMEN__SHIFT 0xb
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_CNTL_EN_MASK 0x1000
#define CLKREQB_PAD_CNTL_IND__CLKREQB_PAD_CNTL_EN__SHIFT 0xc
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_A_MASK 0x1
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_A__SHIFT 0x0
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SEL_MASK 0x2
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SEL__SHIFT 0x1
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_MODE_MASK 0x4
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_MODE__SHIFT 0x2
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SPARE_MASK 0x18
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SPARE__SHIFT 0x3
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN0_MASK 0x20
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN0__SHIFT 0x5
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN1_MASK 0x40
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN1__SHIFT 0x6
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN2_MASK 0x80
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN2__SHIFT 0x7
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN3_MASK 0x100
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SN3__SHIFT 0x8
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SLEWN_MASK 0x200
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SLEWN__SHIFT 0x9
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_WAKE_MASK 0x400
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_WAKE__SHIFT 0xa
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SCHMEN_MASK 0x800
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_SCHMEN__SHIFT 0xb
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_CNTL_EN_MASK 0x1000
#define SMBDAT_PAD_CNTL_IND__SMBDAT_PAD_CNTL_EN__SHIFT 0xc
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_A_MASK 0x1
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_A__SHIFT 0x0
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SEL_MASK 0x2
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SEL__SHIFT 0x1
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_MODE_MASK 0x4
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_MODE__SHIFT 0x2
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SPARE_MASK 0x18
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SPARE__SHIFT 0x3
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN0_MASK 0x20
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN0__SHIFT 0x5
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN1_MASK 0x40
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN1__SHIFT 0x6
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN2_MASK 0x80
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN2__SHIFT 0x7
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN3_MASK 0x100
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SN3__SHIFT 0x8
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SLEWN_MASK 0x200
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SLEWN__SHIFT 0x9
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_WAKE_MASK 0x400
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_WAKE__SHIFT 0xa
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SCHMEN_MASK 0x800
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_SCHMEN__SHIFT 0xb
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_CNTL_EN_MASK 0x1000
#define SMBCLK_PAD_CNTL_IND__SMBCLK_PAD_CNTL_EN__SHIFT 0xc
#define BIF_XDMA_LO_IND__BIF_XDMA_LOWER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_LO_IND__BIF_XDMA_LOWER_BOUND__SHIFT 0x0
#define BIF_XDMA_LO_IND__BIF_XDMA_APER_EN_MASK 0x80000000
#define BIF_XDMA_LO_IND__BIF_XDMA_APER_EN__SHIFT 0x1f
#define BIF_XDMA_HI_IND__BIF_XDMA_UPPER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_HI_IND__BIF_XDMA_UPPER_BOUND__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC_IND__MST_BIF_REQ_EP_DIS_MASK 0x1
#define BIF_FEATURES_CONTROL_MISC_IND__MST_BIF_REQ_EP_DIS__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC_IND__SLV_BIF_CPL_EP_DIS_MASK 0x2
#define BIF_FEATURES_CONTROL_MISC_IND__SLV_BIF_CPL_EP_DIS__SHIFT 0x1
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_SLV_REQ_EP_DIS_MASK 0x4
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_SLV_REQ_EP_DIS__SHIFT 0x2
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_MST_CPL_EP_DIS_MASK 0x8
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_MST_CPL_EP_DIS__SHIFT 0x3
#define BIF_FEATURES_CONTROL_MISC_IND__UR_PSN_PKT_REPORT_POISON_DIS_MASK 0x10
#define BIF_FEATURES_CONTROL_MISC_IND__UR_PSN_PKT_REPORT_POISON_DIS__SHIFT 0x4
#define BIF_FEATURES_CONTROL_MISC_IND__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS_MASK 0x20
#define BIF_FEATURES_CONTROL_MISC_IND__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS__SHIFT 0x5
#define BIF_FEATURES_CONTROL_MISC_IND__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS_MASK 0x40
#define BIF_FEATURES_CONTROL_MISC_IND__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS__SHIFT 0x6
#define BIF_FEATURES_CONTROL_MISC_IND__PLL_SWITCH_IMPCTL_CAL_DONE_DIS_MASK 0x80
#define BIF_FEATURES_CONTROL_MISC_IND__PLL_SWITCH_IMPCTL_CAL_DONE_DIS__SHIFT 0x7
#define BIF_FEATURES_CONTROL_MISC_IND__IGNORE_BE_CHECK_GASKET_COMB_DIS_MASK 0x100
#define BIF_FEATURES_CONTROL_MISC_IND__IGNORE_BE_CHECK_GASKET_COMB_DIS__SHIFT 0x8
#define BIF_FEATURES_CONTROL_MISC_IND__MC_BIF_REQ_ID_ROUTING_DIS_MASK 0x200
#define BIF_FEATURES_CONTROL_MISC_IND__MC_BIF_REQ_ID_ROUTING_DIS__SHIFT 0x9
#define BIF_FEATURES_CONTROL_MISC_IND__AZ_BIF_REQ_ID_ROUTING_DIS_MASK 0x400
#define BIF_FEATURES_CONTROL_MISC_IND__AZ_BIF_REQ_ID_ROUTING_DIS__SHIFT 0xa
#define BIF_FEATURES_CONTROL_MISC_IND__ATC_PRG_RESP_PASID_UR_EN_MASK 0x800
#define BIF_FEATURES_CONTROL_MISC_IND__ATC_PRG_RESP_PASID_UR_EN__SHIFT 0xb
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_RB_SET_OVERFLOW_EN_MASK 0x1000
#define BIF_FEATURES_CONTROL_MISC_IND__BIF_RB_SET_OVERFLOW_EN__SHIFT 0xc
#define BIF_DOORBELL_CNTL_IND__SELF_RING_DIS_MASK 0x1
#define BIF_DOORBELL_CNTL_IND__SELF_RING_DIS__SHIFT 0x0
#define BIF_DOORBELL_CNTL_IND__TRANS_CHECK_DIS_MASK 0x2
#define BIF_DOORBELL_CNTL_IND__TRANS_CHECK_DIS__SHIFT 0x1
#define BIF_DOORBELL_CNTL_IND__UNTRANS_LBACK_EN_MASK 0x4
#define BIF_DOORBELL_CNTL_IND__UNTRANS_LBACK_EN__SHIFT 0x2
#define BIF_DOORBELL_CNTL_IND__NON_CONSECUTIVE_BE_ZERO_DIS_MASK 0x8
#define BIF_DOORBELL_CNTL_IND__NON_CONSECUTIVE_BE_ZERO_DIS__SHIFT 0x3
#define BIF_DOORBELL_CNTL_IND__DOORBELL_MONITOR_EN_MASK 0x10
#define BIF_DOORBELL_CNTL_IND__DOORBELL_MONITOR_EN__SHIFT 0x4
#define BIF_DOORBELL_CNTL_IND__DOORBELL_INTERRUPT_STATUS_MASK 0x20
#define BIF_DOORBELL_CNTL_IND__DOORBELL_INTERRUPT_STATUS__SHIFT 0x5
#define BIF_DOORBELL_CNTL_IND__DOORBELL_INTERRUPT_CLEAR_MASK 0x10000
#define BIF_DOORBELL_CNTL_IND__DOORBELL_INTERRUPT_CLEAR__SHIFT 0x10
#define BIF_SLVARB_MODE_IND__SLVARB_MODE_MASK 0x3
#define BIF_SLVARB_MODE_IND__SLVARB_MODE__SHIFT 0x0
#define BIF_FB_EN_IND__FB_READ_EN_MASK 0x1
#define BIF_FB_EN_IND__FB_READ_EN__SHIFT 0x0
#define BIF_FB_EN_IND__FB_WRITE_EN_MASK 0x2
#define BIF_FB_EN_IND__FB_WRITE_EN__SHIFT 0x1
#define BIF_BUSNUM_CNTL1_IND__ID_MASK_MASK 0xff
#define BIF_BUSNUM_CNTL1_IND__ID_MASK__SHIFT 0x0
#define BIF_BUSNUM_LIST0_IND__ID0_MASK 0xff
#define BIF_BUSNUM_LIST0_IND__ID0__SHIFT 0x0
#define BIF_BUSNUM_LIST0_IND__ID1_MASK 0xff00
#define BIF_BUSNUM_LIST0_IND__ID1__SHIFT 0x8
#define BIF_BUSNUM_LIST0_IND__ID2_MASK 0xff0000
#define BIF_BUSNUM_LIST0_IND__ID2__SHIFT 0x10
#define BIF_BUSNUM_LIST0_IND__ID3_MASK 0xff000000
#define BIF_BUSNUM_LIST0_IND__ID3__SHIFT 0x18
#define BIF_BUSNUM_LIST1_IND__ID4_MASK 0xff
#define BIF_BUSNUM_LIST1_IND__ID4__SHIFT 0x0
#define BIF_BUSNUM_LIST1_IND__ID5_MASK 0xff00
#define BIF_BUSNUM_LIST1_IND__ID5__SHIFT 0x8
#define BIF_BUSNUM_LIST1_IND__ID6_MASK 0xff0000
#define BIF_BUSNUM_LIST1_IND__ID6__SHIFT 0x10
#define BIF_BUSNUM_LIST1_IND__ID7_MASK 0xff000000
#define BIF_BUSNUM_LIST1_IND__ID7__SHIFT 0x18
#define BIF_BUSNUM_CNTL2_IND__AUTOUPDATE_SEL_MASK 0xff
#define BIF_BUSNUM_CNTL2_IND__AUTOUPDATE_SEL__SHIFT 0x0
#define BIF_BUSNUM_CNTL2_IND__AUTOUPDATE_EN_MASK 0x100
#define BIF_BUSNUM_CNTL2_IND__AUTOUPDATE_EN__SHIFT 0x8
#define BIF_BUSNUM_CNTL2_IND__HDPREG_CNTL_MASK 0x10000
#define BIF_BUSNUM_CNTL2_IND__HDPREG_CNTL__SHIFT 0x10
#define BIF_BUSNUM_CNTL2_IND__ERROR_MULTIPLE_ID_MATCH_MASK 0x20000
#define BIF_BUSNUM_CNTL2_IND__ERROR_MULTIPLE_ID_MATCH__SHIFT 0x11
#define BIF_BUSY_DELAY_CNTR_IND__DELAY_CNT_MASK 0x3f
#define BIF_BUSY_DELAY_CNTR_IND__DELAY_CNT__SHIFT 0x0
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_EN_MASK 0x1
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_EN__SHIFT 0x0
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_RESET0_MASK 0x2
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_RESET0__SHIFT 0x1
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_RESET1_MASK 0x4
#define BIF_PERFMON_CNTL_IND__PERFCOUNTER_RESET1__SHIFT 0x2
#define BIF_PERFMON_CNTL_IND__PERF_SEL0_MASK 0x1f00
#define BIF_PERFMON_CNTL_IND__PERF_SEL0__SHIFT 0x8
#define BIF_PERFMON_CNTL_IND__PERF_SEL1_MASK 0x3e000
#define BIF_PERFMON_CNTL_IND__PERF_SEL1__SHIFT 0xd
#define BIF_PERFCOUNTER0_RESULT_IND__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER0_RESULT_IND__PERFCOUNTER_RESULT__SHIFT 0x0
#define BIF_PERFCOUNTER1_RESULT_IND__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER1_RESULT_IND__PERFCOUNTER_RESULT__SHIFT 0x0
#define SLAVE_HANG_PROTECTION_CNTL_IND__HANG_PROTECTION_TIMER_SEL_MASK 0xe
#define SLAVE_HANG_PROTECTION_CNTL_IND__HANG_PROTECTION_TIMER_SEL__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ_IND__CP0_MASK 0x1
#define GPU_HDP_FLUSH_REQ_IND__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_REQ_IND__CP1_MASK 0x2
#define GPU_HDP_FLUSH_REQ_IND__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ_IND__CP2_MASK 0x4
#define GPU_HDP_FLUSH_REQ_IND__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_REQ_IND__CP3_MASK 0x8
#define GPU_HDP_FLUSH_REQ_IND__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_REQ_IND__CP4_MASK 0x10
#define GPU_HDP_FLUSH_REQ_IND__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_REQ_IND__CP5_MASK 0x20
#define GPU_HDP_FLUSH_REQ_IND__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_REQ_IND__CP6_MASK 0x40
#define GPU_HDP_FLUSH_REQ_IND__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_REQ_IND__CP7_MASK 0x80
#define GPU_HDP_FLUSH_REQ_IND__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_REQ_IND__CP8_MASK 0x100
#define GPU_HDP_FLUSH_REQ_IND__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_REQ_IND__CP9_MASK 0x200
#define GPU_HDP_FLUSH_REQ_IND__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_REQ_IND__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_REQ_IND__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_REQ_IND__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_REQ_IND__SDMA1__SHIFT 0xb
#define GPU_HDP_FLUSH_DONE_IND__CP0_MASK 0x1
#define GPU_HDP_FLUSH_DONE_IND__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_DONE_IND__CP1_MASK 0x2
#define GPU_HDP_FLUSH_DONE_IND__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_DONE_IND__CP2_MASK 0x4
#define GPU_HDP_FLUSH_DONE_IND__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_DONE_IND__CP3_MASK 0x8
#define GPU_HDP_FLUSH_DONE_IND__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_DONE_IND__CP4_MASK 0x10
#define GPU_HDP_FLUSH_DONE_IND__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_DONE_IND__CP5_MASK 0x20
#define GPU_HDP_FLUSH_DONE_IND__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_DONE_IND__CP6_MASK 0x40
#define GPU_HDP_FLUSH_DONE_IND__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_DONE_IND__CP7_MASK 0x80
#define GPU_HDP_FLUSH_DONE_IND__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_DONE_IND__CP8_MASK 0x100
#define GPU_HDP_FLUSH_DONE_IND__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_DONE_IND__CP9_MASK 0x200
#define GPU_HDP_FLUSH_DONE_IND__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_DONE_IND__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_DONE_IND__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_DONE_IND__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_DONE_IND__SDMA1__SHIFT 0xb
#define SLAVE_HANG_ERROR_IND__SRBM_HANG_ERROR_MASK 0x1
#define SLAVE_HANG_ERROR_IND__SRBM_HANG_ERROR__SHIFT 0x0
#define SLAVE_HANG_ERROR_IND__HDP_HANG_ERROR_MASK 0x2
#define SLAVE_HANG_ERROR_IND__HDP_HANG_ERROR__SHIFT 0x1
#define SLAVE_HANG_ERROR_IND__VGA_HANG_ERROR_MASK 0x4
#define SLAVE_HANG_ERROR_IND__VGA_HANG_ERROR__SHIFT 0x2
#define SLAVE_HANG_ERROR_IND__ROM_HANG_ERROR_MASK 0x8
#define SLAVE_HANG_ERROR_IND__ROM_HANG_ERROR__SHIFT 0x3
#define SLAVE_HANG_ERROR_IND__AUDIO_HANG_ERROR_MASK 0x10
#define SLAVE_HANG_ERROR_IND__AUDIO_HANG_ERROR__SHIFT 0x4
#define SLAVE_HANG_ERROR_IND__CEC_HANG_ERROR_MASK 0x20
#define SLAVE_HANG_ERROR_IND__CEC_HANG_ERROR__SHIFT 0x5
#define SLAVE_HANG_ERROR_IND__XDMA_HANG_ERROR_MASK 0x80
#define SLAVE_HANG_ERROR_IND__XDMA_HANG_ERROR__SHIFT 0x7
#define SLAVE_HANG_ERROR_IND__DOORBELL_HANG_ERROR_MASK 0x100
#define SLAVE_HANG_ERROR_IND__DOORBELL_HANG_ERROR__SHIFT 0x8
#define SLAVE_HANG_ERROR_IND__GARLIC_HANG_ERROR_MASK 0x200
#define SLAVE_HANG_ERROR_IND__GARLIC_HANG_ERROR__SHIFT 0x9
#define CAPTURE_HOST_BUSNUM_IND__CHECK_EN_MASK 0x1
#define CAPTURE_HOST_BUSNUM_IND__CHECK_EN__SHIFT 0x0
#define HOST_BUSNUM_IND__HOST_ID_MASK 0xffff
#define HOST_BUSNUM_IND__HOST_ID__SHIFT 0x0
#define PEER_REG_RANGE0_IND__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE0_IND__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE0_IND__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE0_IND__END_ADDR__SHIFT 0x10
#define PEER_REG_RANGE1_IND__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE1_IND__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE1_IND__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE1_IND__END_ADDR__SHIFT 0x10
#define PEER0_FB_OFFSET_HI_IND__PEER0_FB_OFFSET_HI_MASK 0xfffff
#define PEER0_FB_OFFSET_HI_IND__PEER0_FB_OFFSET_HI__SHIFT 0x0
#define PEER0_FB_OFFSET_LO_IND__PEER0_FB_OFFSET_LO_MASK 0xfffff
#define PEER0_FB_OFFSET_LO_IND__PEER0_FB_OFFSET_LO__SHIFT 0x0
#define PEER0_FB_OFFSET_LO_IND__PEER0_FB_EN_MASK 0x80000000
#define PEER0_FB_OFFSET_LO_IND__PEER0_FB_EN__SHIFT 0x1f
#define PEER1_FB_OFFSET_HI_IND__PEER1_FB_OFFSET_HI_MASK 0xfffff
#define PEER1_FB_OFFSET_HI_IND__PEER1_FB_OFFSET_HI__SHIFT 0x0
#define PEER1_FB_OFFSET_LO_IND__PEER1_FB_OFFSET_LO_MASK 0xfffff
#define PEER1_FB_OFFSET_LO_IND__PEER1_FB_OFFSET_LO__SHIFT 0x0
#define PEER1_FB_OFFSET_LO_IND__PEER1_FB_EN_MASK 0x80000000
#define PEER1_FB_OFFSET_LO_IND__PEER1_FB_EN__SHIFT 0x1f
#define PEER2_FB_OFFSET_HI_IND__PEER2_FB_OFFSET_HI_MASK 0xfffff
#define PEER2_FB_OFFSET_HI_IND__PEER2_FB_OFFSET_HI__SHIFT 0x0
#define PEER2_FB_OFFSET_LO_IND__PEER2_FB_OFFSET_LO_MASK 0xfffff
#define PEER2_FB_OFFSET_LO_IND__PEER2_FB_OFFSET_LO__SHIFT 0x0
#define PEER2_FB_OFFSET_LO_IND__PEER2_FB_EN_MASK 0x80000000
#define PEER2_FB_OFFSET_LO_IND__PEER2_FB_EN__SHIFT 0x1f
#define PEER3_FB_OFFSET_HI_IND__PEER3_FB_OFFSET_HI_MASK 0xfffff
#define PEER3_FB_OFFSET_HI_IND__PEER3_FB_OFFSET_HI__SHIFT 0x0
#define PEER3_FB_OFFSET_LO_IND__PEER3_FB_OFFSET_LO_MASK 0xfffff
#define PEER3_FB_OFFSET_LO_IND__PEER3_FB_OFFSET_LO__SHIFT 0x0
#define PEER3_FB_OFFSET_LO_IND__PEER3_FB_EN_MASK 0x80000000
#define PEER3_FB_OFFSET_LO_IND__PEER3_FB_EN__SHIFT 0x1f
#define DBG_BYPASS_SRBM_ACCESS_IND__DBG_BYPASS_SRBM_ACCESS_EN_MASK 0x1
#define DBG_BYPASS_SRBM_ACCESS_IND__DBG_BYPASS_SRBM_ACCESS_EN__SHIFT 0x0
#define DBG_BYPASS_SRBM_ACCESS_IND__DBG_APER_AD_MASK 0x1e
#define DBG_BYPASS_SRBM_ACCESS_IND__DBG_APER_AD__SHIFT 0x1
#define SMBUS_BACO_DUMMY_IND__SMBUS_BACO_DUMMY_DATA_MASK 0xffffffff
#define SMBUS_BACO_DUMMY_IND__SMBUS_BACO_DUMMY_DATA__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID0_MASK 0xff
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID0__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID1_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID1__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID2_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID2__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID3_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST0_IND__DEVFUNC_ID3__SHIFT 0x18
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID4_MASK 0xff
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID4__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID5_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID5__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID6_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID6__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID7_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST1_IND__DEVFUNC_ID7__SHIFT 0x18
#define BACO_CNTL_IND__BACO_EN_MASK 0x1
#define BACO_CNTL_IND__BACO_EN__SHIFT 0x0
#define BACO_CNTL_IND__BACO_BCLK_OFF_MASK 0x2
#define BACO_CNTL_IND__BACO_BCLK_OFF__SHIFT 0x1
#define BACO_CNTL_IND__BACO_ISO_DIS_MASK 0x4
#define BACO_CNTL_IND__BACO_ISO_DIS__SHIFT 0x2
#define BACO_CNTL_IND__BACO_POWER_OFF_MASK 0x8
#define BACO_CNTL_IND__BACO_POWER_OFF__SHIFT 0x3
#define BACO_CNTL_IND__BACO_RESET_EN_MASK 0x10
#define BACO_CNTL_IND__BACO_RESET_EN__SHIFT 0x4
#define BACO_CNTL_IND__BACO_HANG_PROTECTION_EN_MASK 0x20
#define BACO_CNTL_IND__BACO_HANG_PROTECTION_EN__SHIFT 0x5
#define BACO_CNTL_IND__BACO_MODE_MASK 0x40
#define BACO_CNTL_IND__BACO_MODE__SHIFT 0x6
#define BACO_CNTL_IND__BACO_ANA_ISO_DIS_MASK 0x80
#define BACO_CNTL_IND__BACO_ANA_ISO_DIS__SHIFT 0x7
#define BACO_CNTL_IND__RCU_BIF_CONFIG_DONE_MASK 0x100
#define BACO_CNTL_IND__RCU_BIF_CONFIG_DONE__SHIFT 0x8
#define BACO_CNTL_IND__PWRGOOD_BF_MASK 0x200
#define BACO_CNTL_IND__PWRGOOD_BF__SHIFT 0x9
#define BACO_CNTL_IND__PWRGOOD_GPIO_MASK 0x400
#define BACO_CNTL_IND__PWRGOOD_GPIO__SHIFT 0xa
#define BACO_CNTL_IND__PWRGOOD_MEM_MASK 0x800
#define BACO_CNTL_IND__PWRGOOD_MEM__SHIFT 0xb
#define BACO_CNTL_IND__PWRGOOD_DVO_MASK 0x1000
#define BACO_CNTL_IND__PWRGOOD_DVO__SHIFT 0xc
#define BACO_CNTL_IND__PWRGOOD_IDSC_MASK 0x2000
#define BACO_CNTL_IND__PWRGOOD_IDSC__SHIFT 0xd
#define BACO_CNTL_IND__BACO_POWER_OFF_DRAM_MASK 0x10000
#define BACO_CNTL_IND__BACO_POWER_OFF_DRAM__SHIFT 0x10
#define BACO_CNTL_IND__BACO_BF_MEM_PHY_ISO_CNTRL_MASK 0x20000
#define BACO_CNTL_IND__BACO_BF_MEM_PHY_ISO_CNTRL__SHIFT 0x11
#define BF_ANA_ISO_CNTL_IND__BF_ANA_ISO_DIS_MASK_MASK 0x1
#define BF_ANA_ISO_CNTL_IND__BF_ANA_ISO_DIS_MASK__SHIFT 0x0
#define BF_ANA_ISO_CNTL_IND__BF_VDDC_ISO_DIS_MASK_MASK 0x2
#define BF_ANA_ISO_CNTL_IND__BF_VDDC_ISO_DIS_MASK__SHIFT 0x1
#define MEM_TYPE_CNTL_IND__BF_MEM_PHY_G5_G3_MASK 0x1
#define MEM_TYPE_CNTL_IND__BF_MEM_PHY_G5_G3__SHIFT 0x0
#define BIF_BACO_DEBUG_IND__BIF_BACO_SCANDUMP_FLG_MASK 0x1
#define BIF_BACO_DEBUG_IND__BIF_BACO_SCANDUMP_FLG__SHIFT 0x0
#define BIF_BACO_DEBUG_LATCH_IND__BIF_BACO_LATCH_FLG_MASK 0x1
#define BIF_BACO_DEBUG_LATCH_IND__BIF_BACO_LATCH_FLG__SHIFT 0x0
#define BACO_CNTL_MISC_IND__BIF_ROM_REQ_DIS_MASK 0x1
#define BACO_CNTL_MISC_IND__BIF_ROM_REQ_DIS__SHIFT 0x0
#define BACO_CNTL_MISC_IND__BIF_AZ_REQ_DIS_MASK 0x2
#define BACO_CNTL_MISC_IND__BIF_AZ_REQ_DIS__SHIFT 0x1
#define BACO_CNTL_MISC_IND__BACO_LINK_RST_WIDTH_SEL_MASK 0xc
#define BACO_CNTL_MISC_IND__BACO_LINK_RST_WIDTH_SEL__SHIFT 0x2
#define SMU_BIF_VDDGFX_PWR_STATUS_IND__VDDGFX_GFX_PWR_OFF_MASK 0x1
#define SMU_BIF_VDDGFX_PWR_STATUS_IND__VDDGFX_GFX_PWR_OFF__SHIFT 0x0
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX0_LOWER_IND__VDDGFX_GFX0_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX0_UPPER_IND__VDDGFX_GFX0_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_UPPER_IND__VDDGFX_GFX0_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX1_LOWER_IND__VDDGFX_GFX1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX1_UPPER_IND__VDDGFX_GFX1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_UPPER_IND__VDDGFX_GFX1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX2_LOWER_IND__VDDGFX_GFX2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX2_UPPER_IND__VDDGFX_GFX2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_UPPER_IND__VDDGFX_GFX2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX3_LOWER_IND__VDDGFX_GFX3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX3_UPPER_IND__VDDGFX_GFX3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_UPPER_IND__VDDGFX_GFX3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX4_LOWER_IND__VDDGFX_GFX4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX4_UPPER_IND__VDDGFX_GFX4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_UPPER_IND__VDDGFX_GFX4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX5_LOWER_IND__VDDGFX_GFX5_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX5_UPPER_IND__VDDGFX_GFX5_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_UPPER_IND__VDDGFX_GFX5_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV1_LOWER_IND__VDDGFX_RSV1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV1_UPPER_IND__VDDGFX_RSV1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_UPPER_IND__VDDGFX_RSV1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV2_LOWER_IND__VDDGFX_RSV2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV2_UPPER_IND__VDDGFX_RSV2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_UPPER_IND__VDDGFX_RSV2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV3_LOWER_IND__VDDGFX_RSV3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV3_UPPER_IND__VDDGFX_RSV3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_UPPER_IND__VDDGFX_RSV3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV4_LOWER_IND__VDDGFX_RSV4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV4_UPPER_IND__VDDGFX_RSV4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_UPPER_IND__VDDGFX_RSV4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_HDP_CMP_EN_MASK 0x1
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_HDP_CMP_EN__SHIFT 0x0
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_HDP_STALL_EN_MASK 0x2
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_HDP_STALL_EN__SHIFT 0x1
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_XDMA_CMP_EN_MASK 0x4
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_XDMA_CMP_EN__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_XDMA_STALL_EN_MASK 0x8
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_XDMA_STALL_EN__SHIFT 0x3
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_VGA_CMP_EN_MASK 0x10
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_VGA_CMP_EN__SHIFT 0x4
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_VGA_STALL_EN_MASK 0x20
#define BIF_VDDGFX_FB_CMP_IND__VDDGFX_FB_VGA_STALL_EN__SHIFT 0x5
#define BIF_DOORBELL_GBLAPER1_LOWER_IND__DOORBELL_GBLAPER1_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_LOWER_IND__DOORBELL_GBLAPER1_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER1_LOWER_IND__DOORBELL_GBLAPER1_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER1_LOWER_IND__DOORBELL_GBLAPER1_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER1_UPPER_IND__DOORBELL_GBLAPER1_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_UPPER_IND__DOORBELL_GBLAPER1_UPPER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER_IND__DOORBELL_GBLAPER2_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_LOWER_IND__DOORBELL_GBLAPER2_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER_IND__DOORBELL_GBLAPER2_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER2_LOWER_IND__DOORBELL_GBLAPER2_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER2_UPPER_IND__DOORBELL_GBLAPER2_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_UPPER_IND__DOORBELL_GBLAPER2_UPPER__SHIFT 0x2
#define BIF_SMU_INDEX_IND__BIF_SMU_INDEX_MASK 0x7fffc
#define BIF_SMU_INDEX_IND__BIF_SMU_INDEX__SHIFT 0x2
#define BIF_SMU_DATA_IND__BIF_SMU_DATA_MASK 0x7fffc
#define BIF_SMU_DATA_IND__BIF_SMU_DATA__SHIFT 0x2
#define IMPCTL_RESET_IND__IMP_SW_RESET_MASK 0x1
#define IMPCTL_RESET_IND__IMP_SW_RESET__SHIFT 0x0
#define GARLIC_FLUSH_CNTL_IND__CP_RB0_WPTR_MASK 0x1
#define GARLIC_FLUSH_CNTL_IND__CP_RB0_WPTR__SHIFT 0x0
#define GARLIC_FLUSH_CNTL_IND__CP_RB1_WPTR_MASK 0x2
#define GARLIC_FLUSH_CNTL_IND__CP_RB1_WPTR__SHIFT 0x1
#define GARLIC_FLUSH_CNTL_IND__CP_RB2_WPTR_MASK 0x4
#define GARLIC_FLUSH_CNTL_IND__CP_RB2_WPTR__SHIFT 0x2
#define GARLIC_FLUSH_CNTL_IND__UVD_RBC_RB_WPTR_MASK 0x8
#define GARLIC_FLUSH_CNTL_IND__UVD_RBC_RB_WPTR__SHIFT 0x3
#define GARLIC_FLUSH_CNTL_IND__SDMA0_GFX_RB_WPTR_MASK 0x10
#define GARLIC_FLUSH_CNTL_IND__SDMA0_GFX_RB_WPTR__SHIFT 0x4
#define GARLIC_FLUSH_CNTL_IND__SDMA1_GFX_RB_WPTR_MASK 0x20
#define GARLIC_FLUSH_CNTL_IND__SDMA1_GFX_RB_WPTR__SHIFT 0x5
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_ME_COMMAND_MASK 0x40
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_ME_COMMAND__SHIFT 0x6
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_PFP_COMMAND_MASK 0x80
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_PFP_COMMAND__SHIFT 0x7
#define GARLIC_FLUSH_CNTL_IND__SAM_SAB_RBI_WPTR_MASK 0x100
#define GARLIC_FLUSH_CNTL_IND__SAM_SAB_RBI_WPTR__SHIFT 0x8
#define GARLIC_FLUSH_CNTL_IND__SAM_SAB_RBO_WPTR_MASK 0x200
#define GARLIC_FLUSH_CNTL_IND__SAM_SAB_RBO_WPTR__SHIFT 0x9
#define GARLIC_FLUSH_CNTL_IND__VCE_OUT_RB_WPTR_MASK 0x400
#define GARLIC_FLUSH_CNTL_IND__VCE_OUT_RB_WPTR__SHIFT 0xa
#define GARLIC_FLUSH_CNTL_IND__VCE_RB_WPTR2_MASK 0x800
#define GARLIC_FLUSH_CNTL_IND__VCE_RB_WPTR2__SHIFT 0xb
#define GARLIC_FLUSH_CNTL_IND__VCE_RB_WPTR_MASK 0x1000
#define GARLIC_FLUSH_CNTL_IND__VCE_RB_WPTR__SHIFT 0xc
#define GARLIC_FLUSH_CNTL_IND__HOST_DOORBELL_MASK 0x2000
#define GARLIC_FLUSH_CNTL_IND__HOST_DOORBELL__SHIFT 0xd
#define GARLIC_FLUSH_CNTL_IND__SELFRING_DOORBELL_MASK 0x4000
#define GARLIC_FLUSH_CNTL_IND__SELFRING_DOORBELL__SHIFT 0xe
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_PIO_COMMAND_MASK 0x8000
#define GARLIC_FLUSH_CNTL_IND__CP_DMA_PIO_COMMAND__SHIFT 0xf
#define GARLIC_FLUSH_CNTL_IND__DISPLAY_MASK 0x10000
#define GARLIC_FLUSH_CNTL_IND__DISPLAY__SHIFT 0x10
#define GARLIC_FLUSH_CNTL_IND__SDMA2_GFX_RB_WPTR_MASK 0x20000
#define GARLIC_FLUSH_CNTL_IND__SDMA2_GFX_RB_WPTR__SHIFT 0x11
#define GARLIC_FLUSH_CNTL_IND__SDMA3_GFX_RB_WPTR_MASK 0x40000
#define GARLIC_FLUSH_CNTL_IND__SDMA3_GFX_RB_WPTR__SHIFT 0x12
#define GARLIC_FLUSH_CNTL_IND__IGNORE_MC_DISABLE_MASK 0x40000000
#define GARLIC_FLUSH_CNTL_IND__IGNORE_MC_DISABLE__SHIFT 0x1e
#define GARLIC_FLUSH_CNTL_IND__DISABLE_ALL_MASK 0x80000000
#define GARLIC_FLUSH_CNTL_IND__DISABLE_ALL__SHIFT 0x1f
#define GARLIC_FLUSH_REQ_IND__FLUSH_REQ_MASK 0x1
#define GARLIC_FLUSH_REQ_IND__FLUSH_REQ__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ_IND__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_REQ_IND__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ_IND__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_REQ_IND__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_REQ_IND__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_REQ_IND__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_REQ_IND__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_REQ_IND__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_REQ_IND__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_REQ_IND__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_REQ_IND__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_REQ_IND__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_REQ_IND__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_REQ_IND__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_REQ_IND__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_REQ_IND__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_REQ_IND__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_REQ_IND__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_REQ_IND__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_REQ_IND__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_REQ_IND__SDMA3__SHIFT 0xd
#define GPU_GARLIC_FLUSH_DONE_IND__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_DONE_IND__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_DONE_IND__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_DONE_IND__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_DONE_IND__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_DONE_IND__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_DONE_IND__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_DONE_IND__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_DONE_IND__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_DONE_IND__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_DONE_IND__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_DONE_IND__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_DONE_IND__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_DONE_IND__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_DONE_IND__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_DONE_IND__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_DONE_IND__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_DONE_IND__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_DONE_IND__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_DONE_IND__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_DONE_IND__SDMA3__SHIFT 0xd
#define GARLIC_COHE_CP_RB0_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB0_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_RB1_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB1_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_RB2_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_RB2_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_UVD_RBC_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_UVD_RBC_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA0_GFX_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA0_GFX_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA1_GFX_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA1_GFX_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_ME_COMMAND_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_ME_COMMAND_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_PFP_COMMAND_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_PFP_COMMAND_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SAM_SAB_RBI_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SAM_SAB_RBI_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SAM_SAB_RBO_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SAM_SAB_RBO_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_OUT_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_OUT_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_RB_WPTR2_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_RB_WPTR2_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_VCE_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_VCE_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA2_GFX_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA2_GFX_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_SDMA3_GFX_RB_WPTR_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_SDMA3_GFX_RB_WPTR_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_CP_DMA_PIO_COMMAND_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_CP_DMA_PIO_COMMAND_IND__ADDRESS__SHIFT 0x2
#define GARLIC_COHE_GARLIC_FLUSH_REQ_IND__ADDRESS_MASK 0x7fffc
#define GARLIC_COHE_GARLIC_FLUSH_REQ_IND__ADDRESS__SHIFT 0x2
#define REMAP_HDP_MEM_FLUSH_CNTL_IND__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_MEM_FLUSH_CNTL_IND__ADDRESS__SHIFT 0x2
#define REMAP_HDP_REG_FLUSH_CNTL_IND__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_REG_FLUSH_CNTL_IND__ADDRESS__SHIFT 0x2
#define BIOS_SCRATCH_0_IND__BIOS_SCRATCH_0_MASK 0xffffffff
#define BIOS_SCRATCH_0_IND__BIOS_SCRATCH_0__SHIFT 0x0
#define BIOS_SCRATCH_1_IND__BIOS_SCRATCH_1_MASK 0xffffffff
#define BIOS_SCRATCH_1_IND__BIOS_SCRATCH_1__SHIFT 0x0
#define BIOS_SCRATCH_2_IND__BIOS_SCRATCH_2_MASK 0xffffffff
#define BIOS_SCRATCH_2_IND__BIOS_SCRATCH_2__SHIFT 0x0
#define BIOS_SCRATCH_3_IND__BIOS_SCRATCH_3_MASK 0xffffffff
#define BIOS_SCRATCH_3_IND__BIOS_SCRATCH_3__SHIFT 0x0
#define BIOS_SCRATCH_4_IND__BIOS_SCRATCH_4_MASK 0xffffffff
#define BIOS_SCRATCH_4_IND__BIOS_SCRATCH_4__SHIFT 0x0
#define BIOS_SCRATCH_5_IND__BIOS_SCRATCH_5_MASK 0xffffffff
#define BIOS_SCRATCH_5_IND__BIOS_SCRATCH_5__SHIFT 0x0
#define BIOS_SCRATCH_6_IND__BIOS_SCRATCH_6_MASK 0xffffffff
#define BIOS_SCRATCH_6_IND__BIOS_SCRATCH_6__SHIFT 0x0
#define BIOS_SCRATCH_7_IND__BIOS_SCRATCH_7_MASK 0xffffffff
#define BIOS_SCRATCH_7_IND__BIOS_SCRATCH_7__SHIFT 0x0
#define BIOS_SCRATCH_8_IND__BIOS_SCRATCH_8_MASK 0xffffffff
#define BIOS_SCRATCH_8_IND__BIOS_SCRATCH_8__SHIFT 0x0
#define BIOS_SCRATCH_9_IND__BIOS_SCRATCH_9_MASK 0xffffffff
#define BIOS_SCRATCH_9_IND__BIOS_SCRATCH_9__SHIFT 0x0
#define BIOS_SCRATCH_10_IND__BIOS_SCRATCH_10_MASK 0xffffffff
#define BIOS_SCRATCH_10_IND__BIOS_SCRATCH_10__SHIFT 0x0
#define BIOS_SCRATCH_11_IND__BIOS_SCRATCH_11_MASK 0xffffffff
#define BIOS_SCRATCH_11_IND__BIOS_SCRATCH_11__SHIFT 0x0
#define BIOS_SCRATCH_12_IND__BIOS_SCRATCH_12_MASK 0xffffffff
#define BIOS_SCRATCH_12_IND__BIOS_SCRATCH_12__SHIFT 0x0
#define BIOS_SCRATCH_13_IND__BIOS_SCRATCH_13_MASK 0xffffffff
#define BIOS_SCRATCH_13_IND__BIOS_SCRATCH_13__SHIFT 0x0
#define BIOS_SCRATCH_14_IND__BIOS_SCRATCH_14_MASK 0xffffffff
#define BIOS_SCRATCH_14_IND__BIOS_SCRATCH_14__SHIFT 0x0
#define BIOS_SCRATCH_15_IND__BIOS_SCRATCH_15_MASK 0xffffffff
#define BIOS_SCRATCH_15_IND__BIOS_SCRATCH_15__SHIFT 0x0
#define BIF_RB_CNTL_IND__RB_ENABLE_MASK 0x1
#define BIF_RB_CNTL_IND__RB_ENABLE__SHIFT 0x0
#define BIF_RB_CNTL_IND__RB_SIZE_MASK 0x3e
#define BIF_RB_CNTL_IND__RB_SIZE__SHIFT 0x1
#define BIF_RB_CNTL_IND__WPTR_WRITEBACK_ENABLE_MASK 0x100
#define BIF_RB_CNTL_IND__WPTR_WRITEBACK_ENABLE__SHIFT 0x8
#define BIF_RB_CNTL_IND__WPTR_WRITEBACK_TIMER_MASK 0x3e00
#define BIF_RB_CNTL_IND__WPTR_WRITEBACK_TIMER__SHIFT 0x9
#define BIF_RB_CNTL_IND__BIF_RB_TRAN_MASK 0x20000
#define BIF_RB_CNTL_IND__BIF_RB_TRAN__SHIFT 0x11
#define BIF_RB_CNTL_IND__WPTR_OVERFLOW_CLEAR_MASK 0x80000000
#define BIF_RB_CNTL_IND__WPTR_OVERFLOW_CLEAR__SHIFT 0x1f
#define BIF_RB_BASE_IND__ADDR_MASK 0xffffffff
#define BIF_RB_BASE_IND__ADDR__SHIFT 0x0
#define BIF_RB_RPTR_IND__OFFSET_MASK 0x3fffc
#define BIF_RB_RPTR_IND__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR_IND__BIF_RB_OVERFLOW_MASK 0x1
#define BIF_RB_WPTR_IND__BIF_RB_OVERFLOW__SHIFT 0x0
#define BIF_RB_WPTR_IND__OFFSET_MASK 0x3fffc
#define BIF_RB_WPTR_IND__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR_ADDR_HI_IND__ADDR_MASK 0xff
#define BIF_RB_WPTR_ADDR_HI_IND__ADDR__SHIFT 0x0
#define BIF_RB_WPTR_ADDR_LO_IND__ADDR_MASK 0xfffffffc
#define BIF_RB_WPTR_ADDR_LO_IND__ADDR__SHIFT 0x2
#define NB_GBIF_INDEX__NB_GBIF_IND_ADDR_MASK 0xffffffff
#define NB_GBIF_INDEX__NB_GBIF_IND_ADDR__SHIFT 0x0
#define NB_GBIF_DATA__NB_GBIF_DATA_MASK 0xffffffff
#define NB_GBIF_DATA__NB_GBIF_DATA__SHIFT 0x0
#define PCIE_INDEX__PCIE_INDEX_MASK 0xffffffff
#define PCIE_INDEX__PCIE_INDEX__SHIFT 0x0
#define PCIE_DATA__PCIE_DATA_MASK 0xffffffff
#define PCIE_DATA__PCIE_DATA__SHIFT 0x0
#define PCIE_INDEX_2__PCIE_INDEX_MASK 0xffffffff
#define PCIE_INDEX_2__PCIE_INDEX__SHIFT 0x0
#define PCIE_DATA_2__PCIE_DATA_MASK 0xffffffff
#define PCIE_DATA_2__PCIE_DATA__SHIFT 0x0
#define PCIE_RESERVED__PCIE_RESERVED_MASK 0xffffffff
#define PCIE_RESERVED__PCIE_RESERVED__SHIFT 0x0
#define PCIE_SCRATCH__PCIE_SCRATCH_MASK 0xffffffff
#define PCIE_SCRATCH__PCIE_SCRATCH__SHIFT 0x0
#define PCIE_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PCIE_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PCIE_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PCIE_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PCIE_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PCIE_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PCIE_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PCIE_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PCIE_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PCIE_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PCIE_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PCIE_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PCIE_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PCIE_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PCIE_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PCIE_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PCIE_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PCIE_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PCIE_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PCIE_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PCIE_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PCIE_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PCIE_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PCIE_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PCIE_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PCIE_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PCIE_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PCIE_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PCIE_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PCIE_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PCIE_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PCIE_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PCIE_RX_NUM_NAK__RX_NUM_NAK_MASK 0xffffffff
#define PCIE_RX_NUM_NAK__RX_NUM_NAK__SHIFT 0x0
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED_MASK 0xffffffff
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED__SHIFT 0x0
#define PCIE_CNTL__HWINIT_WR_LOCK_MASK 0x1
#define PCIE_CNTL__HWINIT_WR_LOCK__SHIFT 0x0
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL_MASK 0xe
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL__SHIFT 0x1
#define PCIE_CNTL__UR_ERR_REPORT_DIS_MASK 0x80
#define PCIE_CNTL__UR_ERR_REPORT_DIS__SHIFT 0x7
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS_MASK 0x100
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS__SHIFT 0x8
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE_MASK 0x200
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE__SHIFT 0x9
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE_MASK 0x1c00
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE__SHIFT 0xa
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS_MASK 0x8000
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS__SHIFT 0xf
#define PCIE_CNTL__RX_RCB_REORDER_EN_MASK 0x10000
#define PCIE_CNTL__RX_RCB_REORDER_EN__SHIFT 0x10
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS_MASK 0x20000
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS__SHIFT 0x11
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS_MASK 0x40000
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS__SHIFT 0x12
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE_MASK 0x80000
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE__SHIFT 0x13
#define PCIE_CNTL__RX_RCB_CHANNEL_ORDERING_MASK 0x100000
#define PCIE_CNTL__RX_RCB_CHANNEL_ORDERING__SHIFT 0x14
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS_MASK 0x200000
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS__SHIFT 0x15
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS_MASK 0x400000
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS__SHIFT 0x16
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS_MASK 0x800000
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS__SHIFT 0x17
#define PCIE_CNTL__TX_CPL_DEBUG_MASK 0x3f000000
#define PCIE_CNTL__TX_CPL_DEBUG__SHIFT 0x18
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR_MASK 0x40000000
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR__SHIFT 0x1e
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN_MASK 0x80000000
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN__SHIFT 0x1f
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY_MASK 0xf
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY__SHIFT 0x0
#define PCIE_CONFIG_CNTL__CI_MAX_PAYLOAD_SIZE_MODE_MASK 0x10000
#define PCIE_CONFIG_CNTL__CI_MAX_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_PAYLOAD_SIZE_MASK 0xe0000
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_PAYLOAD_SIZE__SHIFT 0x11
#define PCIE_CONFIG_CNTL__CI_MAX_READ_REQUEST_SIZE_MODE_MASK 0x100000
#define PCIE_CONFIG_CNTL__CI_MAX_READ_REQUEST_SIZE_MODE__SHIFT 0x14
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_READ_REQUEST_SIZE_MASK 0xe00000
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_READ_REQUEST_SIZE__SHIFT 0x15
#define PCIE_CONFIG_CNTL__CI_MAX_READ_SAFE_MODE_MASK 0x1000000
#define PCIE_CONFIG_CNTL__CI_MAX_READ_SAFE_MODE__SHIFT 0x18
#define PCIE_CONFIG_CNTL__CI_EXTENDED_TAG_EN_OVERRIDE_MASK 0x6000000
#define PCIE_CONFIG_CNTL__CI_EXTENDED_TAG_EN_OVERRIDE__SHIFT 0x19
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN_MASK 0xff
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN__SHIFT 0x0
#define PCIE_DEBUG_CNTL__DEBUG_SELECT_MASK 0x100
#define PCIE_DEBUG_CNTL__DEBUG_SELECT__SHIFT 0x8
#define PCIE_DEBUG_CNTL__DEBUG_LANE_EN_MASK 0xffff0000
#define PCIE_DEBUG_CNTL__DEBUG_LANE_EN__SHIFT 0x10
#define PCIE_INT_CNTL__CORR_ERR_INT_EN_MASK 0x1
#define PCIE_INT_CNTL__CORR_ERR_INT_EN__SHIFT 0x0
#define PCIE_INT_CNTL__NON_FATAL_ERR_INT_EN_MASK 0x2
#define PCIE_INT_CNTL__NON_FATAL_ERR_INT_EN__SHIFT 0x1
#define PCIE_INT_CNTL__FATAL_ERR_INT_EN_MASK 0x4
#define PCIE_INT_CNTL__FATAL_ERR_INT_EN__SHIFT 0x2
#define PCIE_INT_CNTL__USR_DETECTED_INT_EN_MASK 0x8
#define PCIE_INT_CNTL__USR_DETECTED_INT_EN__SHIFT 0x3
#define PCIE_INT_CNTL__MISC_ERR_INT_EN_MASK 0x10
#define PCIE_INT_CNTL__MISC_ERR_INT_EN__SHIFT 0x4
#define PCIE_INT_CNTL__POWER_STATE_CHG_INT_EN_MASK 0x40
#define PCIE_INT_CNTL__POWER_STATE_CHG_INT_EN__SHIFT 0x6
#define PCIE_INT_CNTL__LINK_BW_INT_EN_MASK 0x80
#define PCIE_INT_CNTL__LINK_BW_INT_EN__SHIFT 0x7
#define PCIE_INT_CNTL__QUIESCE_RCVD_INT_EN_MASK 0x100
#define PCIE_INT_CNTL__QUIESCE_RCVD_INT_EN__SHIFT 0x8
#define PCIE_INT_STATUS__CORR_ERR_INT_STATUS_MASK 0x1
#define PCIE_INT_STATUS__CORR_ERR_INT_STATUS__SHIFT 0x0
#define PCIE_INT_STATUS__NON_FATAL_ERR_INT_STATUS_MASK 0x2
#define PCIE_INT_STATUS__NON_FATAL_ERR_INT_STATUS__SHIFT 0x1
#define PCIE_INT_STATUS__FATAL_ERR_INT_STATUS_MASK 0x4
#define PCIE_INT_STATUS__FATAL_ERR_INT_STATUS__SHIFT 0x2
#define PCIE_INT_STATUS__USR_DETECTED_INT_STATUS_MASK 0x8
#define PCIE_INT_STATUS__USR_DETECTED_INT_STATUS__SHIFT 0x3
#define PCIE_INT_STATUS__MISC_ERR_INT_STATUS_MASK 0x10
#define PCIE_INT_STATUS__MISC_ERR_INT_STATUS__SHIFT 0x4
#define PCIE_INT_STATUS__POWER_STATE_CHG_INT_STATUS_MASK 0x40
#define PCIE_INT_STATUS__POWER_STATE_CHG_INT_STATUS__SHIFT 0x6
#define PCIE_INT_STATUS__LINK_BW_INT_STATUS_MASK 0x80
#define PCIE_INT_STATUS__LINK_BW_INT_STATUS__SHIFT 0x7
#define PCIE_INT_STATUS__QUIESCE_RCVD_INT_STATUS_MASK 0x100
#define PCIE_INT_STATUS__QUIESCE_RCVD_INT_STATUS__SHIFT 0x8
#define PCIE_CNTL2__TX_ARB_ROUND_ROBIN_EN_MASK 0x1
#define PCIE_CNTL2__TX_ARB_ROUND_ROBIN_EN__SHIFT 0x0
#define PCIE_CNTL2__TX_ARB_SLV_LIMIT_MASK 0x3e
#define PCIE_CNTL2__TX_ARB_SLV_LIMIT__SHIFT 0x1
#define PCIE_CNTL2__TX_ARB_MST_LIMIT_MASK 0x7c0
#define PCIE_CNTL2__TX_ARB_MST_LIMIT__SHIFT 0x6
#define PCIE_CNTL2__TX_BLOCK_TLP_ON_PM_DIS_MASK 0x800
#define PCIE_CNTL2__TX_BLOCK_TLP_ON_PM_DIS__SHIFT 0xb
#define PCIE_CNTL2__SLV_MEM_LS_EN_MASK 0x10000
#define PCIE_CNTL2__SLV_MEM_LS_EN__SHIFT 0x10
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN_MASK 0x20000
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN__SHIFT 0x11
#define PCIE_CNTL2__MST_MEM_LS_EN_MASK 0x40000
#define PCIE_CNTL2__MST_MEM_LS_EN__SHIFT 0x12
#define PCIE_CNTL2__REPLAY_MEM_LS_EN_MASK 0x80000
#define PCIE_CNTL2__REPLAY_MEM_LS_EN__SHIFT 0x13
#define PCIE_CNTL2__SLV_MEM_SD_EN_MASK 0x100000
#define PCIE_CNTL2__SLV_MEM_SD_EN__SHIFT 0x14
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN_MASK 0x200000
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN__SHIFT 0x15
#define PCIE_CNTL2__MST_MEM_SD_EN_MASK 0x400000
#define PCIE_CNTL2__MST_MEM_SD_EN__SHIFT 0x16
#define PCIE_CNTL2__REPLAY_MEM_SD_EN_MASK 0x800000
#define PCIE_CNTL2__REPLAY_MEM_SD_EN__SHIFT 0x17
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING_MASK 0x1f000000
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING__SHIFT 0x18
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR_MASK 0x1
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR__SHIFT 0x0
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR_MASK 0x2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR__SHIFT 0x1
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR_MASK 0x4
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR__SHIFT 0x2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR_MASK 0x8
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR__SHIFT 0x3
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR_MASK 0x10
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR__SHIFT 0x4
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR_MASK 0x20
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR__SHIFT 0x5
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN_MASK 0x100
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN__SHIFT 0x8
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE_MASK 0xe00
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE__SHIFT 0x9
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT_MASK 0x3ff0000
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT__SHIFT 0x10
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P_MASK 0x3
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P__SHIFT 0x0
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP_MASK 0xc
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP__SHIFT 0x2
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL_MASK 0x30
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL__SHIFT 0x4
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P_MASK 0xc0
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P__SHIFT 0x6
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP_MASK 0x300
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP__SHIFT 0x8
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P_MASK 0xc00
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P__SHIFT 0xa
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP_MASK 0x3000
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP__SHIFT 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_P_MASK 0x3
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_P__SHIFT 0x0
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_NP_MASK 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_NP__SHIFT 0x2
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_CPL_MASK 0x30
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_CPL__SHIFT 0x4
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_P_MASK 0xc0
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_P__SHIFT 0x6
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_NP_MASK 0x300
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_NP__SHIFT 0x8
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_P_MASK 0xc00
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_P__SHIFT 0xa
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_NP_MASK 0x3000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_NP__SHIFT 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_P_MASK 0x30000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_P__SHIFT 0x10
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_NP_MASK 0xc0000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_NP__SHIFT 0x12
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_CPL_MASK 0x300000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_CPL__SHIFT 0x14
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_P_MASK 0xc00000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_P__SHIFT 0x16
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_NP_MASK 0x3000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_NP__SHIFT 0x18
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_P_MASK 0xc000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_P__SHIFT 0x1a
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_NP_MASK 0x30000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_NP__SHIFT 0x1c
#define PCIE_CI_CNTL__CI_SLAVE_SPLIT_MODE_MASK 0x4
#define PCIE_CI_CNTL__CI_SLAVE_SPLIT_MODE__SHIFT 0x2
#define PCIE_CI_CNTL__CI_SLAVE_GEN_USR_DIS_MASK 0x8
#define PCIE_CI_CNTL__CI_SLAVE_GEN_USR_DIS__SHIFT 0x3
#define PCIE_CI_CNTL__CI_MST_CMPL_DUMMY_DATA_MASK 0x10
#define PCIE_CI_CNTL__CI_MST_CMPL_DUMMY_DATA__SHIFT 0x4
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE_MASK 0xc0
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE__SHIFT 0x6
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS_MASK 0x100
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS__SHIFT 0x8
#define PCIE_CI_CNTL__CI_RC_ORDERING_DIS_MASK 0x200
#define PCIE_CI_CNTL__CI_RC_ORDERING_DIS__SHIFT 0x9
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS_MASK 0x400
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS__SHIFT 0xa
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE_MASK 0x800
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE__SHIFT 0xb
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR_MASK 0x1000
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR__SHIFT 0xc
#define PCIE_CI_CNTL__CI_MST_IGNORE_PAGE_ALIGNED_REQUEST_MASK 0x2000
#define PCIE_CI_CNTL__CI_MST_IGNORE_PAGE_ALIGNED_REQUEST__SHIFT 0xd
#define PCIE_BUS_CNTL__PMI_INT_DIS_MASK 0x40
#define PCIE_BUS_CNTL__PMI_INT_DIS__SHIFT 0x6
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS_MASK 0x80
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS__SHIFT 0x7
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN_MASK 0x1000
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN__SHIFT 0xc
#define PCIE_LC_STATE6__LC_PREV_STATE24_MASK 0x3f
#define PCIE_LC_STATE6__LC_PREV_STATE24__SHIFT 0x0
#define PCIE_LC_STATE6__LC_PREV_STATE25_MASK 0x3f00
#define PCIE_LC_STATE6__LC_PREV_STATE25__SHIFT 0x8
#define PCIE_LC_STATE6__LC_PREV_STATE26_MASK 0x3f0000
#define PCIE_LC_STATE6__LC_PREV_STATE26__SHIFT 0x10
#define PCIE_LC_STATE6__LC_PREV_STATE27_MASK 0x3f000000
#define PCIE_LC_STATE6__LC_PREV_STATE27__SHIFT 0x18
#define PCIE_LC_STATE7__LC_PREV_STATE28_MASK 0x3f
#define PCIE_LC_STATE7__LC_PREV_STATE28__SHIFT 0x0
#define PCIE_LC_STATE7__LC_PREV_STATE29_MASK 0x3f00
#define PCIE_LC_STATE7__LC_PREV_STATE29__SHIFT 0x8
#define PCIE_LC_STATE7__LC_PREV_STATE30_MASK 0x3f0000
#define PCIE_LC_STATE7__LC_PREV_STATE30__SHIFT 0x10
#define PCIE_LC_STATE7__LC_PREV_STATE31_MASK 0x3f000000
#define PCIE_LC_STATE7__LC_PREV_STATE31__SHIFT 0x18
#define PCIE_LC_STATE8__LC_PREV_STATE32_MASK 0x3f
#define PCIE_LC_STATE8__LC_PREV_STATE32__SHIFT 0x0
#define PCIE_LC_STATE8__LC_PREV_STATE33_MASK 0x3f00
#define PCIE_LC_STATE8__LC_PREV_STATE33__SHIFT 0x8
#define PCIE_LC_STATE8__LC_PREV_STATE34_MASK 0x3f0000
#define PCIE_LC_STATE8__LC_PREV_STATE34__SHIFT 0x10
#define PCIE_LC_STATE8__LC_PREV_STATE35_MASK 0x3f000000
#define PCIE_LC_STATE8__LC_PREV_STATE35__SHIFT 0x18
#define PCIE_LC_STATE9__LC_PREV_STATE36_MASK 0x3f
#define PCIE_LC_STATE9__LC_PREV_STATE36__SHIFT 0x0
#define PCIE_LC_STATE9__LC_PREV_STATE37_MASK 0x3f00
#define PCIE_LC_STATE9__LC_PREV_STATE37__SHIFT 0x8
#define PCIE_LC_STATE9__LC_PREV_STATE38_MASK 0x3f0000
#define PCIE_LC_STATE9__LC_PREV_STATE38__SHIFT 0x10
#define PCIE_LC_STATE9__LC_PREV_STATE39_MASK 0x3f000000
#define PCIE_LC_STATE9__LC_PREV_STATE39__SHIFT 0x18
#define PCIE_LC_STATE10__LC_PREV_STATE40_MASK 0x3f
#define PCIE_LC_STATE10__LC_PREV_STATE40__SHIFT 0x0
#define PCIE_LC_STATE10__LC_PREV_STATE41_MASK 0x3f00
#define PCIE_LC_STATE10__LC_PREV_STATE41__SHIFT 0x8
#define PCIE_LC_STATE10__LC_PREV_STATE42_MASK 0x3f0000
#define PCIE_LC_STATE10__LC_PREV_STATE42__SHIFT 0x10
#define PCIE_LC_STATE10__LC_PREV_STATE43_MASK 0x3f000000
#define PCIE_LC_STATE10__LC_PREV_STATE43__SHIFT 0x18
#define PCIE_LC_STATE11__LC_PREV_STATE44_MASK 0x3f
#define PCIE_LC_STATE11__LC_PREV_STATE44__SHIFT 0x0
#define PCIE_LC_STATE11__LC_PREV_STATE45_MASK 0x3f00
#define PCIE_LC_STATE11__LC_PREV_STATE45__SHIFT 0x8
#define PCIE_LC_STATE11__LC_PREV_STATE46_MASK 0x3f0000
#define PCIE_LC_STATE11__LC_PREV_STATE46__SHIFT 0x10
#define PCIE_LC_STATE11__LC_PREV_STATE47_MASK 0x3f000000
#define PCIE_LC_STATE11__LC_PREV_STATE47__SHIFT 0x18
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR_MASK 0x1
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR__SHIFT 0x0
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT_MASK 0x2
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT__SHIFT 0x1
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH_MASK 0x1c
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH__SHIFT 0x2
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH_MASK 0xe0
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH__SHIFT 0x5
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES_MASK 0xffff
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES__SHIFT 0x0
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE_MASK 0xffff0000
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE__SHIFT 0x10
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN_MASK 0x1
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN__SHIFT 0x0
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN_MASK 0x2
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN__SHIFT 0x1
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN_MASK 0x4
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN__SHIFT 0x2
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN_MASK 0x8
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN__SHIFT 0x3
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN_MASK 0x10
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN__SHIFT 0x4
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN_MASK 0x20
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN__SHIFT 0x5
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN_MASK 0x40
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN__SHIFT 0x6
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0_MASK 0xffffffff
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0__SHIFT 0x0
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1_MASK 0xffffffff
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1__SHIFT 0x0
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2_MASK 0xffffffff
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2__SHIFT 0x0
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3_MASK 0xffffffff
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3__SHIFT 0x0
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0_MASK 0xffffffff
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0__SHIFT 0x0
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1_MASK 0xffffffff
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1__SHIFT 0x0
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2_MASK 0xffffffff
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2__SHIFT 0x0
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3_MASK 0xffffffff
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3__SHIFT 0x0
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR_MASK 0x1ffff
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR__SHIFT 0x0
#define PCIE_I2C_REG_DATA__I2C_REG_DATA_MASK 0xffffffff
#define PCIE_I2C_REG_DATA__I2C_REG_DATA__SHIFT 0x0
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG_MASK 0x1
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG__SHIFT 0x0
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG_MASK 0x2
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG__SHIFT 0x1
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG_MASK 0x4
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG__SHIFT 0x2
#define PCIE_P_CNTL__P_PWRDN_EN_MASK 0x1
#define PCIE_P_CNTL__P_PWRDN_EN__SHIFT 0x0
#define PCIE_P_CNTL__P_SYMALIGN_MODE_MASK 0x2
#define PCIE_P_CNTL__P_SYMALIGN_MODE__SHIFT 0x1
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG_MASK 0x4
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG__SHIFT 0x2
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG_MASK 0x8
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG__SHIFT 0x3
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR_MASK 0x10
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR__SHIFT 0x4
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR_MASK 0x20
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR__SHIFT 0x5
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR_MASK 0x40
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR__SHIFT 0x6
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR_MASK 0x80
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR__SHIFT 0x7
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR_MASK 0x100
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR__SHIFT 0x8
#define PCIE_P_CNTL__P_BLK_LOCK_MODE_MASK 0x1000
#define PCIE_P_CNTL__P_BLK_LOCK_MODE__SHIFT 0xc
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK_MASK 0x2000
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK__SHIFT 0xd
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE_MASK 0xc000
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE__SHIFT 0xe
#define PCIE_P_CNTL__DLP_IGNORE_IN_L1_EN_MASK 0x10000
#define PCIE_P_CNTL__DLP_IGNORE_IN_L1_EN__SHIFT 0x10
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR_MASK 0xffff
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR__SHIFT 0x0
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR_MASK 0xffff0000
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR__SHIFT 0x10
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR_MASK 0xffff
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR__SHIFT 0x0
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR_MASK 0xff
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR__SHIFT 0x0
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR_MASK 0xffff0000
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR__SHIFT 0x10
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN_MASK 0xff
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN__SHIFT 0x0
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX_MASK 0xff00
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX__SHIFT 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_PRIV_DISABLE_MASK 0x1
#define PCIE_OBFF_CNTL__TX_OBFF_PRIV_DISABLE__SHIFT 0x0
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SIMPLE_MODE_EN_MASK 0x2
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SIMPLE_MODE_EN__SHIFT 0x1
#define PCIE_OBFF_CNTL__TX_OBFF_HOSTMEM_TO_ACTIVE_MASK 0x4
#define PCIE_OBFF_CNTL__TX_OBFF_HOSTMEM_TO_ACTIVE__SHIFT 0x2
#define PCIE_OBFF_CNTL__TX_OBFF_SLVCPL_TO_ACTIVE_MASK 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_SLVCPL_TO_ACTIVE__SHIFT 0x3
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_PULSE_WIDTH_MASK 0xf0
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_PULSE_WIDTH__SHIFT 0x4
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_TWO_FALLING_WIDTH_MASK 0xf00
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_TWO_FALLING_WIDTH__SHIFT 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SAMPLING_PERIOD_MASK 0xf000
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SAMPLING_PERIOD__SHIFT 0xc
#define PCIE_OBFF_CNTL__TX_OBFF_INTR_TO_ACTIVE_MASK 0x10000
#define PCIE_OBFF_CNTL__TX_OBFF_INTR_TO_ACTIVE__SHIFT 0x10
#define PCIE_OBFF_CNTL__TX_OBFF_ERR_TO_ACTIVE_MASK 0x20000
#define PCIE_OBFF_CNTL__TX_OBFF_ERR_TO_ACTIVE__SHIFT 0x11
#define PCIE_OBFF_CNTL__TX_OBFF_ANY_MSG_TO_ACTIVE_MASK 0x40000
#define PCIE_OBFF_CNTL__TX_OBFF_ANY_MSG_TO_ACTIVE__SHIFT 0x12
#define PCIE_OBFF_CNTL__TX_OBFF_PENDING_REQ_TO_ACTIVE_MASK 0xf00000
#define PCIE_OBFF_CNTL__TX_OBFF_PENDING_REQ_TO_ACTIVE__SHIFT 0x14
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_SHORT_VALUE_MASK 0x7
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_SHORT_VALUE__SHIFT 0x0
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_LONG_VALUE_MASK 0x38
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_LONG_VALUE__SHIFT 0x3
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_REQUIREMENT_MASK 0x40
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_REQUIREMENT__SHIFT 0x6
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_SHORT_VALUE_MASK 0x380
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_SHORT_VALUE__SHIFT 0x7
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_LONG_VALUE_MASK 0x1c00
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_LONG_VALUE__SHIFT 0xa
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_REQUIREMENT_MASK 0x2000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_REQUIREMENT__SHIFT 0xd
#define PCIE_TX_LTR_CNTL__LTR_PRIV_MSG_DIS_IN_PM_NON_D0_MASK 0x4000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_MSG_DIS_IN_PM_NON_D0__SHIFT 0xe
#define PCIE_TX_LTR_CNTL__LTR_PRIV_RST_LTR_IN_DL_DOWN_MASK 0x8000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_RST_LTR_IN_DL_DOWN__SHIFT 0xf
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN_MASK 0x1
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN__SHIFT 0x0
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR_MASK 0x2
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR__SHIFT 0x1
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET_MASK 0x4
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET__SHIFT 0x2
#define PCIE_PERF_CNTL_TXCLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_TXCLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_TXCLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_TXCLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_TXCLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_TXCLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_TXCLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_TXCLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_TXCLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_TXCLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_TXCLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_TXCLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_MST_R_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_MST_R_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_MST_R_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_MST_R_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_MST_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_MST_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_MST_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_MST_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_R_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_R_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_R_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_R_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_S_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_S_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_S_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_S_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_NS_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_NS_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_NS_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_NS_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK_MASK 0xf
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_R_CLK_MASK 0xf0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_R_CLK__SHIFT 0x4
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_C_CLK_MASK 0xf00
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_C_CLK__SHIFT 0x8
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_R_CLK_MASK 0xf000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_R_CLK__SHIFT 0xc
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_S_C_CLK_MASK 0xf0000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_S_C_CLK__SHIFT 0x10
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_NS_C_CLK_MASK 0xf00000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_NS_C_CLK__SHIFT 0x14
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK2_MASK 0xf000000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK2__SHIFT 0x18
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK_MASK 0xf
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_R_CLK_MASK 0xf0
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_R_CLK__SHIFT 0x4
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_C_CLK_MASK 0xf00
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_C_CLK__SHIFT 0x8
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_R_CLK_MASK 0xf000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_R_CLK__SHIFT 0xc
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_S_C_CLK_MASK 0xf0000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_S_C_CLK__SHIFT 0x10
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_NS_C_CLK_MASK 0xf00000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_NS_C_CLK__SHIFT 0x14
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK2_MASK 0xf000000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK2__SHIFT 0x18
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1__SHIFT 0x0
#define PCIE_STRAP_F0__STRAP_F0_EN_MASK 0x1
#define PCIE_STRAP_F0__STRAP_F0_EN__SHIFT 0x0
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN_MASK 0x4
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F0__STRAP_F0_VC_EN_MASK 0x8
#define PCIE_STRAP_F0__STRAP_F0_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN_MASK 0x10
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F0__STRAP_F0_AER_EN_MASK 0x20
#define PCIE_STRAP_F0__STRAP_F0_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN_MASK 0x40
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN_MASK 0x80
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN_MASK 0x100
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN_MASK 0x200
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN_MASK 0x400
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F0__STRAP_F0_MC_EN_MASK 0x20000
#define PCIE_STRAP_F0__STRAP_F0_MC_EN__SHIFT 0x11
#define PCIE_STRAP_F1__STRAP_F1_EN_MASK 0x1
#define PCIE_STRAP_F1__STRAP_F1_EN__SHIFT 0x0
#define PCIE_STRAP_F1__STRAP_F1_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F1__STRAP_F1_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F1__STRAP_F1_MSI_EN_MASK 0x4
#define PCIE_STRAP_F1__STRAP_F1_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F1__STRAP_F1_VC_EN_MASK 0x8
#define PCIE_STRAP_F1__STRAP_F1_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F1__STRAP_F1_DSN_EN_MASK 0x10
#define PCIE_STRAP_F1__STRAP_F1_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F1__STRAP_F1_AER_EN_MASK 0x20
#define PCIE_STRAP_F1__STRAP_F1_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F1__STRAP_F1_ACS_EN_MASK 0x40
#define PCIE_STRAP_F1__STRAP_F1_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F1__STRAP_F1_BAR_EN_MASK 0x80
#define PCIE_STRAP_F1__STRAP_F1_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F1__STRAP_F1_PWR_EN_MASK 0x100
#define PCIE_STRAP_F1__STRAP_F1_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F1__STRAP_F1_DPA_EN_MASK 0x200
#define PCIE_STRAP_F1__STRAP_F1_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F1__STRAP_F1_ATS_EN_MASK 0x400
#define PCIE_STRAP_F1__STRAP_F1_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F1__STRAP_F1_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F1__STRAP_F1_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F1__STRAP_F1_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F1__STRAP_F1_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F1__STRAP_F1_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F1__STRAP_F1_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F1__STRAP_F1_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F1__STRAP_F1_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F1__STRAP_F1_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F1__STRAP_F1_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F1__STRAP_F1_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F1__STRAP_F1_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F2__STRAP_F2_EN_MASK 0x1
#define PCIE_STRAP_F2__STRAP_F2_EN__SHIFT 0x0
#define PCIE_STRAP_F2__STRAP_F2_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F2__STRAP_F2_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F2__STRAP_F2_MSI_EN_MASK 0x4
#define PCIE_STRAP_F2__STRAP_F2_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F2__STRAP_F2_VC_EN_MASK 0x8
#define PCIE_STRAP_F2__STRAP_F2_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F2__STRAP_F2_DSN_EN_MASK 0x10
#define PCIE_STRAP_F2__STRAP_F2_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F2__STRAP_F2_AER_EN_MASK 0x20
#define PCIE_STRAP_F2__STRAP_F2_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F2__STRAP_F2_ACS_EN_MASK 0x40
#define PCIE_STRAP_F2__STRAP_F2_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F2__STRAP_F2_BAR_EN_MASK 0x80
#define PCIE_STRAP_F2__STRAP_F2_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F2__STRAP_F2_PWR_EN_MASK 0x100
#define PCIE_STRAP_F2__STRAP_F2_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F2__STRAP_F2_DPA_EN_MASK 0x200
#define PCIE_STRAP_F2__STRAP_F2_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F2__STRAP_F2_ATS_EN_MASK 0x400
#define PCIE_STRAP_F2__STRAP_F2_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F2__STRAP_F2_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F2__STRAP_F2_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F2__STRAP_F2_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F2__STRAP_F2_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F2__STRAP_F2_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F2__STRAP_F2_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F2__STRAP_F2_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F2__STRAP_F2_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F2__STRAP_F2_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F2__STRAP_F2_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F2__STRAP_F2_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F2__STRAP_F2_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F3__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F3__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F4__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F4__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F5__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F5__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F6__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F6__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F7__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F7__RESERVED__SHIFT 0x0
#define PCIE_STRAP_MISC__STRAP_LINK_CONFIG_MASK 0xf
#define PCIE_STRAP_MISC__STRAP_LINK_CONFIG__SHIFT 0x0
#define PCIE_STRAP_MISC__STRAP_TL_ALT_BUF_EN_MASK 0x10
#define PCIE_STRAP_MISC__STRAP_TL_ALT_BUF_EN__SHIFT 0x4
#define PCIE_STRAP_MISC__STRAP_MAX_PASID_WIDTH_MASK 0x1f00
#define PCIE_STRAP_MISC__STRAP_MAX_PASID_WIDTH__SHIFT 0x8
#define PCIE_STRAP_MISC__STRAP_PASID_EXE_PERMISSION_SUPPORTED_MASK 0x2000
#define PCIE_STRAP_MISC__STRAP_PASID_EXE_PERMISSION_SUPPORTED__SHIFT 0xd
#define PCIE_STRAP_MISC__STRAP_PASID_PRIV_MODE_SUPPORTED_MASK 0x4000
#define PCIE_STRAP_MISC__STRAP_PASID_PRIV_MODE_SUPPORTED__SHIFT 0xe
#define PCIE_STRAP_MISC__STRAP_PASID_GLOBAL_INVALIDATE_SUPPORTED_MASK 0x8000
#define PCIE_STRAP_MISC__STRAP_PASID_GLOBAL_INVALIDATE_SUPPORTED__SHIFT 0xf
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN_MASK 0x1000000
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN__SHIFT 0x18
#define PCIE_STRAP_MISC__STRAP_ECN1P1_EN_MASK 0x2000000
#define PCIE_STRAP_MISC__STRAP_ECN1P1_EN__SHIFT 0x19
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT_MASK 0x4000000
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT__SHIFT 0x1a
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL_MASK 0x10000000
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL__SHIFT 0x1c
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN_MASK 0x20000000
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN__SHIFT 0x1d
#define PCIE_STRAP_MISC__STRAP_FLR_EN_MASK 0x40000000
#define PCIE_STRAP_MISC__STRAP_FLR_EN__SHIFT 0x1e
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN_MASK 0x80000000
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN__SHIFT 0x1f
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE_MASK 0x2
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE__SHIFT 0x1
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN_MASK 0x4
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN__SHIFT 0x2
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE_MASK 0x8
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE__SHIFT 0x3
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED_MASK 0x10
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED__SHIFT 0x4
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START_MASK 0x1
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START__SHIFT 0x0
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN_MASK 0x10000000
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN__SHIFT 0x1c
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE_MASK 0x20000000
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE__SHIFT 0x1d
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR_MASK 0x7f
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR__SHIFT 0x0
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN_MASK 0x80
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN__SHIFT 0x7
#define PCIE_PRBS_CLR__PRBS_CLR_MASK 0xffff
#define PCIE_PRBS_CLR__PRBS_CLR__SHIFT 0x0
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT_MASK 0xf0000
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT__SHIFT 0x10
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT_MASK 0xffff
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT__SHIFT 0x0
#define PCIE_PRBS_STATUS1__PRBS_LOCKED_MASK 0xffff0000
#define PCIE_PRBS_STATUS1__PRBS_LOCKED__SHIFT 0x10
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE_MASK 0xffff
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE__SHIFT 0x0
#define PCIE_PRBS_FREERUN__PRBS_FREERUN_MASK 0xffff
#define PCIE_PRBS_FREERUN__PRBS_FREERUN__SHIFT 0x0
#define PCIE_PRBS_MISC__PRBS_EN_MASK 0x1
#define PCIE_PRBS_MISC__PRBS_EN__SHIFT 0x0
#define PCIE_PRBS_MISC__PRBS_TEST_MODE_MASK 0x6
#define PCIE_PRBS_MISC__PRBS_TEST_MODE__SHIFT 0x1
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE_MASK 0x8
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE__SHIFT 0x3
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL_MASK 0x10
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL__SHIFT 0x4
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM_MASK 0x60
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM__SHIFT 0x5
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT_MASK 0xf80
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT__SHIFT 0x7
#define PCIE_PRBS_MISC__PRBS_DATA_RATE_MASK 0xc000
#define PCIE_PRBS_MISC__PRBS_DATA_RATE__SHIFT 0xe
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK_MASK 0xffff0000
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK__SHIFT 0x10
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN_MASK 0x3fffffff
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN__SHIFT 0x0
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT_MASK 0xffffffff
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT__SHIFT 0x0
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT_MASK 0xff
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15__SHIFT 0x0
#define PCIE_F0_DPA_CAP__TRANS_LAT_UNIT_MASK 0x300
#define PCIE_F0_DPA_CAP__TRANS_LAT_UNIT__SHIFT 0x8
#define PCIE_F0_DPA_CAP__PWR_ALLOC_SCALE_MASK 0x3000
#define PCIE_F0_DPA_CAP__PWR_ALLOC_SCALE__SHIFT 0xc
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_0_MASK 0xff0000
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_0__SHIFT 0x10
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_1_MASK 0xff000000
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_1__SHIFT 0x18
#define PCIE_F0_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK 0xff
#define PCIE_F0_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT 0x0
#define PCIE_F0_DPA_CNTL__SUBSTATE_STATUS_MASK 0x1f
#define PCIE_F0_DPA_CNTL__SUBSTATE_STATUS__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define PCIE_TX_CNTL__TX_F0_TPH_DIS_MASK 0x1000000
#define PCIE_TX_CNTL__TX_F0_TPH_DIS__SHIFT 0x18
#define PCIE_TX_CNTL__TX_F1_TPH_DIS_MASK 0x2000000
#define PCIE_TX_CNTL__TX_F1_TPH_DIS__SHIFT 0x19
#define PCIE_TX_CNTL__TX_F2_TPH_DIS_MASK 0x4000000
#define PCIE_TX_CNTL__TX_F2_TPH_DIS__SHIFT 0x1a
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define PCIE_FC_P__PD_CREDITS_MASK 0xff
#define PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define PCIE_ERR_CNTL__AER_HDR_LOG_F1_TIMER_EXPIRED_MASK 0x1000
#define PCIE_ERR_CNTL__AER_HDR_LOG_F1_TIMER_EXPIRED__SHIFT 0xc
#define PCIE_ERR_CNTL__AER_HDR_LOG_F2_TIMER_EXPIRED_MASK 0x2000
#define PCIE_ERR_CNTL__AER_HDR_LOG_F2_TIMER_EXPIRED__SHIFT 0xd
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ARBITER_MASK 0x1
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ARBITER__SHIFT 0x0
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ALLMASTER_MASK 0x2
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ALLMASTER__SHIFT 0x1
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstRfeEn_MASK 0x1
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstRfeEn__SHIFT 0x0
#define BIF_RFE_SOFTRST_CNTL__REG_RST_rstTimer_MASK 0xffff
#define BIF_RFE_SOFTRST_CNTL__REG_RST_rstTimer__SHIFT 0x0
#define BIF_RFE_SOFTRST_CNTL__REG_RST_softRstPropEn_MASK 0x40000000
#define BIF_RFE_SOFTRST_CNTL__REG_RST_softRstPropEn__SHIFT 0x1e
#define BIF_RFE_SOFTRST_CNTL__SoftRstReg_MASK 0x80000000
#define BIF_RFE_SOFTRST_CNTL__SoftRstReg__SHIFT 0x1f
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT0_RFE_RFEWGBIF_rst_MASK 0x1
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT0_RFE_RFEWGBIF_rst__SHIFT 0x0
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT1_RFE_RFEWGBIF_rst_MASK 0x2
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT1_RFE_RFEWGBIF_rst__SHIFT 0x1
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT2_RFE_RFEWGBIF_rst_MASK 0x4
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT2_RFE_RFEWGBIF_rst__SHIFT 0x2
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__FBU_rst_MASK 0x1
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__FBU_rst__SHIFT 0x0
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__RWREG_RFEWGBIF_rst_MASK 0x2
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__RWREG_RFEWGBIF_rst__SHIFT 0x1
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BX_rst_MASK 0x4
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BX_rst__SHIFT 0x2
#define BIF_PWDN_COMMAND__REG_FBU_pw_cmd_MASK 0x1
#define BIF_PWDN_COMMAND__REG_FBU_pw_cmd__SHIFT 0x0
#define BIF_PWDN_COMMAND__REG_RWREG_RFEWGBIF_pw_cmd_MASK 0x2
#define BIF_PWDN_COMMAND__REG_RWREG_RFEWGBIF_pw_cmd__SHIFT 0x1
#define BIF_PWDN_COMMAND__REG_BX_pw_cmd_MASK 0x4
#define BIF_PWDN_COMMAND__REG_BX_pw_cmd__SHIFT 0x2
#define BIF_PWDN_STATUS__FBU_REG_pw_status_MASK 0x1
#define BIF_PWDN_STATUS__FBU_REG_pw_status__SHIFT 0x0
#define BIF_PWDN_STATUS__RWREG_RFEWGBIF_REG_pw_status_MASK 0x2
#define BIF_PWDN_STATUS__RWREG_RFEWGBIF_REG_pw_status__SHIFT 0x1
#define BIF_PWDN_STATUS__BX_REG_pw_status_MASK 0x4
#define BIF_PWDN_STATUS__BX_REG_pw_status__SHIFT 0x2
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_FBU_CMDSTATUS__REG_FBU_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_FBU_CMDSTATUS__FBU_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_FBU_CMDSTATUS__FBU_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__REG_RWREG_RFEWGBIF_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__RWREG_RFEWGBIF_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_RWREG_RFEWGBIF_CMDSTATUS__RWREG_RFEWGBIF_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_BX_CMDSTATUS__BX_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_BX_CMDSTATUS__BX_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_TMOUT_STATUS__MstTmoutStatus_MASK 0x1
#define BIF_RFE_MST_TMOUT_STATUS__MstTmoutStatus__SHIFT 0x0
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWGBIF_MM_WR_TO_CFG_EN_MASK 0x1
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWGBIF_MM_WR_TO_CFG_EN__SHIFT 0x0
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWGBIF_MM_CFG_FUNC_SEL_MASK 0xe
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWGBIF_MM_CFG_FUNC_SEL__SHIFT 0x1
#define BIF_RFE_MMCFG_CNTL__CLIENT2_RFE_RFEWGBIF_MM_WR_TO_CFG_EN_MASK 0x10
#define BIF_RFE_MMCFG_CNTL__CLIENT2_RFE_RFEWGBIF_MM_WR_TO_CFG_EN__SHIFT 0x4
#define BIF_RFE_MMCFG_CNTL__CLIENT2_RFE_RFEWGBIF_MM_CFG_FUNC_SEL_MASK 0xe0
#define BIF_RFE_MMCFG_CNTL__CLIENT2_RFE_RFEWGBIF_MM_CFG_FUNC_SEL__SHIFT 0x5
#define BIF_CLOCKS_BITS_IND__OBFF_XSL_FORCE_REFCLK_MASK 0x1
#define BIF_CLOCKS_BITS_IND__OBFF_XSL_FORCE_REFCLK__SHIFT 0x0
#define BIF_LNCNT_RESET_IND__RESET_LNCNT_EN_MASK 0x1
#define BIF_LNCNT_RESET_IND__RESET_LNCNT_EN__SHIFT 0x0
#define LNCNT_CONTROL_IND__LNCNT_ACC_MODE_MASK 0x1
#define LNCNT_CONTROL_IND__LNCNT_ACC_MODE__SHIFT 0x0
#define LNCNT_CONTROL_IND__LNCNT_REF_TIMEBASE_MASK 0x6
#define LNCNT_CONTROL_IND__LNCNT_REF_TIMEBASE__SHIFT 0x1
#define NEW_REFCLKB_TIMER_IND__REG_STOP_REFCLK_EN_MASK 0x1
#define NEW_REFCLKB_TIMER_IND__REG_STOP_REFCLK_EN__SHIFT 0x0
#define NEW_REFCLKB_TIMER_IND__STOP_REFCLK_TIMER_MASK 0x1ffffe
#define NEW_REFCLKB_TIMER_IND__STOP_REFCLK_TIMER__SHIFT 0x1
#define NEW_REFCLKB_TIMER_IND__REFCLK_ON_MASK 0x200000
#define NEW_REFCLKB_TIMER_IND__REFCLK_ON__SHIFT 0x15
#define NEW_REFCLKB_TIMER_1_IND__PHY_PLL_PDWN_TIMER_MASK 0x3ff
#define NEW_REFCLKB_TIMER_1_IND__PHY_PLL_PDWN_TIMER__SHIFT 0x0
#define NEW_REFCLKB_TIMER_1_IND__PLL0_PDNB_EN_MASK 0x400
#define NEW_REFCLKB_TIMER_1_IND__PLL0_PDNB_EN__SHIFT 0xa
#define BIF_CLK_PDWN_DELAY_TIMER_IND__TIMER_MASK 0x3ff
#define BIF_CLK_PDWN_DELAY_TIMER_IND__TIMER__SHIFT 0x0
#define BIF_RESET_EN_IND__SOFT_RST_MODE_MASK 0x2
#define BIF_RESET_EN_IND__SOFT_RST_MODE__SHIFT 0x1
#define BIF_RESET_EN_IND__PHY_RESET_EN_MASK 0x4
#define BIF_RESET_EN_IND__PHY_RESET_EN__SHIFT 0x2
#define BIF_RESET_EN_IND__COR_RESET_EN_MASK 0x8
#define BIF_RESET_EN_IND__COR_RESET_EN__SHIFT 0x3
#define BIF_RESET_EN_IND__REG_RESET_EN_MASK 0x10
#define BIF_RESET_EN_IND__REG_RESET_EN__SHIFT 0x4
#define BIF_RESET_EN_IND__STY_RESET_EN_MASK 0x20
#define BIF_RESET_EN_IND__STY_RESET_EN__SHIFT 0x5
#define BIF_RESET_EN_IND__CFG_RESET_EN_MASK 0x40
#define BIF_RESET_EN_IND__CFG_RESET_EN__SHIFT 0x6
#define BIF_RESET_EN_IND__DRV_RESET_EN_MASK 0x80
#define BIF_RESET_EN_IND__DRV_RESET_EN__SHIFT 0x7
#define BIF_RESET_EN_IND__RESET_CFGREG_ONLY_EN_MASK 0x100
#define BIF_RESET_EN_IND__RESET_CFGREG_ONLY_EN__SHIFT 0x8
#define BIF_RESET_EN_IND__HOT_RESET_EN_MASK 0x200
#define BIF_RESET_EN_IND__HOT_RESET_EN__SHIFT 0x9
#define BIF_RESET_EN_IND__LINK_DISABLE_RESET_EN_MASK 0x400
#define BIF_RESET_EN_IND__LINK_DISABLE_RESET_EN__SHIFT 0xa
#define BIF_RESET_EN_IND__LINK_DOWN_RESET_EN_MASK 0x800
#define BIF_RESET_EN_IND__LINK_DOWN_RESET_EN__SHIFT 0xb
#define BIF_RESET_EN_IND__CFG_RESET_PULSE_WIDTH_MASK 0x3f000
#define BIF_RESET_EN_IND__CFG_RESET_PULSE_WIDTH__SHIFT 0xc
#define BIF_RESET_EN_IND__DRV_RESET_DELAY_SEL_MASK 0xc0000
#define BIF_RESET_EN_IND__DRV_RESET_DELAY_SEL__SHIFT 0x12
#define BIF_RESET_EN_IND__PIF_RSTB_EN_MASK 0x100000
#define BIF_RESET_EN_IND__PIF_RSTB_EN__SHIFT 0x14
#define BIF_RESET_EN_IND__PIF_STRAP_ALLVALID_EN_MASK 0x200000
#define BIF_RESET_EN_IND__PIF_STRAP_ALLVALID_EN__SHIFT 0x15
#define BIF_RESET_EN_IND__BIF_COR_RESET_EN_MASK 0x400000
#define BIF_RESET_EN_IND__BIF_COR_RESET_EN__SHIFT 0x16
#define BIF_RESET_EN_IND__FUNC0_FLR_EN_MASK 0x800000
#define BIF_RESET_EN_IND__FUNC0_FLR_EN__SHIFT 0x17
#define BIF_RESET_EN_IND__FUNC1_FLR_EN_MASK 0x1000000
#define BIF_RESET_EN_IND__FUNC1_FLR_EN__SHIFT 0x18
#define BIF_RESET_EN_IND__FUNC2_FLR_EN_MASK 0x2000000
#define BIF_RESET_EN_IND__FUNC2_FLR_EN__SHIFT 0x19
#define BIF_RESET_EN_IND__FUNC0_RESET_DELAY_SEL_MASK 0xc000000
#define BIF_RESET_EN_IND__FUNC0_RESET_DELAY_SEL__SHIFT 0x1a
#define BIF_RESET_EN_IND__FUNC1_RESET_DELAY_SEL_MASK 0x30000000
#define BIF_RESET_EN_IND__FUNC1_RESET_DELAY_SEL__SHIFT 0x1c
#define BIF_RESET_EN_IND__FUNC2_RESET_DELAY_SEL_MASK 0xc0000000
#define BIF_RESET_EN_IND__FUNC2_RESET_DELAY_SEL__SHIFT 0x1e
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL0_ACK_TIMER_MASK 0x7
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL0_ACK_TIMER__SHIFT 0x0
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL1_ACK_TIMER_MASK 0x38
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL1_ACK_TIMER__SHIFT 0x3
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL_SWITCH_TIMER_MASK 0x3c0
#define BIF_PIF_TXCLK_SWITCH_TIMER_IND__PLL_SWITCH_TIMER__SHIFT 0x6
#define BIF_BACO_MSIC_IND__BIF_XTALIN_SEL_MASK 0x1
#define BIF_BACO_MSIC_IND__BIF_XTALIN_SEL__SHIFT 0x0
#define BIF_BACO_MSIC_IND__BACO_LINK_RST_SEL_MASK 0x6
#define BIF_BACO_MSIC_IND__BACO_LINK_RST_SEL__SHIFT 0x1
#define BIF_BACO_MSIC_IND__ACPI_BACO_MUX_DIS_MASK 0x10
#define BIF_BACO_MSIC_IND__ACPI_BACO_MUX_DIS__SHIFT 0x4
#define BIF_RESET_CNTL_IND__STRAP_EN_MASK 0x1
#define BIF_RESET_CNTL_IND__STRAP_EN__SHIFT 0x0
#define BIF_RESET_CNTL_IND__RST_DONE_MASK 0x2
#define BIF_RESET_CNTL_IND__RST_DONE__SHIFT 0x1
#define BIF_RESET_CNTL_IND__LINK_TRAIN_EN_MASK 0x4
#define BIF_RESET_CNTL_IND__LINK_TRAIN_EN__SHIFT 0x2
#define BIF_RESET_CNTL_IND__STRAP_ALL_VALID_MASK 0x8
#define BIF_RESET_CNTL_IND__STRAP_ALL_VALID__SHIFT 0x3
#define BIF_RESET_CNTL_IND__RECAP_STRAP_WARMRST_MASK 0x100
#define BIF_RESET_CNTL_IND__RECAP_STRAP_WARMRST__SHIFT 0x8
#define BIF_RESET_CNTL_IND__HOLD_LKTRN_WARMRST_DIS_MASK 0x200
#define BIF_RESET_CNTL_IND__HOLD_LKTRN_WARMRST_DIS__SHIFT 0x9
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pif0_bu_reg_accessMode_MASK 0x1
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pif0_bu_reg_accessMode__SHIFT 0x0
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pif1_bu_reg_accessMode_MASK 0x2
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pif1_bu_reg_accessMode__SHIFT 0x1
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pwreg_bu_reg_accessMode_MASK 0x4
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pwreg_bu_reg_accessMode__SHIFT 0x2
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pciecore0_bu_reg_accessMode_MASK 0x8
#define BIF_RFE_CNTL_MISC_IND__ADAPT_pciecore0_bu_reg_accessMode__SHIFT 0x3
#define BIF_MEM_PG_CNTL_IND__BIF_MEM_SD_EN_MASK 0x1
#define BIF_MEM_PG_CNTL_IND__BIF_MEM_SD_EN__SHIFT 0x0
#define BIF_MEM_PG_CNTL_IND__BIF_MEM_SD_TIMER_MASK 0xffff0000
#define BIF_MEM_PG_CNTL_IND__BIF_MEM_SD_TIMER__SHIFT 0x10
#define NB_GBIF_INDEX__NB_GBIF_IND_ADDR_MASK 0xffffffff
#define NB_GBIF_INDEX__NB_GBIF_IND_ADDR__SHIFT 0x0
#define NB_GBIF_DATA__NB_GBIF_DATA_MASK 0xffffffff
#define NB_GBIF_DATA__NB_GBIF_DATA__SHIFT 0x0
#define BIF_CLOCKS_BITS__OBFF_XSL_FORCE_REFCLK_MASK 0x1
#define BIF_CLOCKS_BITS__OBFF_XSL_FORCE_REFCLK__SHIFT 0x0
#define BIF_LNCNT_RESET__RESET_LNCNT_EN_MASK 0x1
#define BIF_LNCNT_RESET__RESET_LNCNT_EN__SHIFT 0x0
#define LNCNT_CONTROL__LNCNT_ACC_MODE_MASK 0x1
#define LNCNT_CONTROL__LNCNT_ACC_MODE__SHIFT 0x0
#define LNCNT_CONTROL__LNCNT_REF_TIMEBASE_MASK 0x6
#define LNCNT_CONTROL__LNCNT_REF_TIMEBASE__SHIFT 0x1
#define NEW_REFCLKB_TIMER__REG_STOP_REFCLK_EN_MASK 0x1
#define NEW_REFCLKB_TIMER__REG_STOP_REFCLK_EN__SHIFT 0x0
#define NEW_REFCLKB_TIMER__STOP_REFCLK_TIMER_MASK 0x1ffffe
#define NEW_REFCLKB_TIMER__STOP_REFCLK_TIMER__SHIFT 0x1
#define NEW_REFCLKB_TIMER__REFCLK_ON_MASK 0x200000
#define NEW_REFCLKB_TIMER__REFCLK_ON__SHIFT 0x15
#define NEW_REFCLKB_TIMER_1__PHY_PLL_PDWN_TIMER_MASK 0x3ff
#define NEW_REFCLKB_TIMER_1__PHY_PLL_PDWN_TIMER__SHIFT 0x0
#define NEW_REFCLKB_TIMER_1__PLL0_PDNB_EN_MASK 0x400
#define NEW_REFCLKB_TIMER_1__PLL0_PDNB_EN__SHIFT 0xa
#define BIF_CLK_PDWN_DELAY_TIMER__TIMER_MASK 0x3ff
#define BIF_CLK_PDWN_DELAY_TIMER__TIMER__SHIFT 0x0
#define BIF_RESET_EN__SOFT_RST_MODE_MASK 0x2
#define BIF_RESET_EN__SOFT_RST_MODE__SHIFT 0x1
#define BIF_RESET_EN__PHY_RESET_EN_MASK 0x4
#define BIF_RESET_EN__PHY_RESET_EN__SHIFT 0x2
#define BIF_RESET_EN__COR_RESET_EN_MASK 0x8
#define BIF_RESET_EN__COR_RESET_EN__SHIFT 0x3
#define BIF_RESET_EN__REG_RESET_EN_MASK 0x10
#define BIF_RESET_EN__REG_RESET_EN__SHIFT 0x4
#define BIF_RESET_EN__STY_RESET_EN_MASK 0x20
#define BIF_RESET_EN__STY_RESET_EN__SHIFT 0x5
#define BIF_RESET_EN__CFG_RESET_EN_MASK 0x40
#define BIF_RESET_EN__CFG_RESET_EN__SHIFT 0x6
#define BIF_RESET_EN__DRV_RESET_EN_MASK 0x80
#define BIF_RESET_EN__DRV_RESET_EN__SHIFT 0x7
#define BIF_RESET_EN__RESET_CFGREG_ONLY_EN_MASK 0x100
#define BIF_RESET_EN__RESET_CFGREG_ONLY_EN__SHIFT 0x8
#define BIF_RESET_EN__HOT_RESET_EN_MASK 0x200
#define BIF_RESET_EN__HOT_RESET_EN__SHIFT 0x9
#define BIF_RESET_EN__LINK_DISABLE_RESET_EN_MASK 0x400
#define BIF_RESET_EN__LINK_DISABLE_RESET_EN__SHIFT 0xa
#define BIF_RESET_EN__LINK_DOWN_RESET_EN_MASK 0x800
#define BIF_RESET_EN__LINK_DOWN_RESET_EN__SHIFT 0xb
#define BIF_RESET_EN__CFG_RESET_PULSE_WIDTH_MASK 0x3f000
#define BIF_RESET_EN__CFG_RESET_PULSE_WIDTH__SHIFT 0xc
#define BIF_RESET_EN__DRV_RESET_DELAY_SEL_MASK 0xc0000
#define BIF_RESET_EN__DRV_RESET_DELAY_SEL__SHIFT 0x12
#define BIF_RESET_EN__PIF_RSTB_EN_MASK 0x100000
#define BIF_RESET_EN__PIF_RSTB_EN__SHIFT 0x14
#define BIF_RESET_EN__PIF_STRAP_ALLVALID_EN_MASK 0x200000
#define BIF_RESET_EN__PIF_STRAP_ALLVALID_EN__SHIFT 0x15
#define BIF_RESET_EN__BIF_COR_RESET_EN_MASK 0x400000
#define BIF_RESET_EN__BIF_COR_RESET_EN__SHIFT 0x16
#define BIF_RESET_EN__FUNC0_FLR_EN_MASK 0x800000
#define BIF_RESET_EN__FUNC0_FLR_EN__SHIFT 0x17
#define BIF_RESET_EN__FUNC1_FLR_EN_MASK 0x1000000
#define BIF_RESET_EN__FUNC1_FLR_EN__SHIFT 0x18
#define BIF_RESET_EN__FUNC2_FLR_EN_MASK 0x2000000
#define BIF_RESET_EN__FUNC2_FLR_EN__SHIFT 0x19
#define BIF_RESET_EN__FUNC0_RESET_DELAY_SEL_MASK 0xc000000
#define BIF_RESET_EN__FUNC0_RESET_DELAY_SEL__SHIFT 0x1a
#define BIF_RESET_EN__FUNC1_RESET_DELAY_SEL_MASK 0x30000000
#define BIF_RESET_EN__FUNC1_RESET_DELAY_SEL__SHIFT 0x1c
#define BIF_RESET_EN__FUNC2_RESET_DELAY_SEL_MASK 0xc0000000
#define BIF_RESET_EN__FUNC2_RESET_DELAY_SEL__SHIFT 0x1e
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL0_ACK_TIMER_MASK 0x7
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL0_ACK_TIMER__SHIFT 0x0
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL1_ACK_TIMER_MASK 0x38
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL1_ACK_TIMER__SHIFT 0x3
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL_SWITCH_TIMER_MASK 0x3c0
#define BIF_PIF_TXCLK_SWITCH_TIMER__PLL_SWITCH_TIMER__SHIFT 0x6
#define BIF_BACO_MSIC__BIF_XTALIN_SEL_MASK 0x1
#define BIF_BACO_MSIC__BIF_XTALIN_SEL__SHIFT 0x0
#define BIF_BACO_MSIC__BACO_LINK_RST_SEL_MASK 0x6
#define BIF_BACO_MSIC__BACO_LINK_RST_SEL__SHIFT 0x1
#define BIF_BACO_MSIC__ACPI_BACO_MUX_DIS_MASK 0x10
#define BIF_BACO_MSIC__ACPI_BACO_MUX_DIS__SHIFT 0x4
#define BIF_RESET_CNTL__STRAP_EN_MASK 0x1
#define BIF_RESET_CNTL__STRAP_EN__SHIFT 0x0
#define BIF_RESET_CNTL__RST_DONE_MASK 0x2
#define BIF_RESET_CNTL__RST_DONE__SHIFT 0x1
#define BIF_RESET_CNTL__LINK_TRAIN_EN_MASK 0x4
#define BIF_RESET_CNTL__LINK_TRAIN_EN__SHIFT 0x2
#define BIF_RESET_CNTL__STRAP_ALL_VALID_MASK 0x8
#define BIF_RESET_CNTL__STRAP_ALL_VALID__SHIFT 0x3
#define BIF_RESET_CNTL__RECAP_STRAP_WARMRST_MASK 0x100
#define BIF_RESET_CNTL__RECAP_STRAP_WARMRST__SHIFT 0x8
#define BIF_RESET_CNTL__HOLD_LKTRN_WARMRST_DIS_MASK 0x200
#define BIF_RESET_CNTL__HOLD_LKTRN_WARMRST_DIS__SHIFT 0x9
#define BIF_RFE_CNTL_MISC__ADAPT_pif0_bu_reg_accessMode_MASK 0x1
#define BIF_RFE_CNTL_MISC__ADAPT_pif0_bu_reg_accessMode__SHIFT 0x0
#define BIF_RFE_CNTL_MISC__ADAPT_pif1_bu_reg_accessMode_MASK 0x2
#define BIF_RFE_CNTL_MISC__ADAPT_pif1_bu_reg_accessMode__SHIFT 0x1
#define BIF_RFE_CNTL_MISC__ADAPT_pwreg_bu_reg_accessMode_MASK 0x4
#define BIF_RFE_CNTL_MISC__ADAPT_pwreg_bu_reg_accessMode__SHIFT 0x2
#define BIF_RFE_CNTL_MISC__ADAPT_pciecore0_bu_reg_accessMode_MASK 0x8
#define BIF_RFE_CNTL_MISC__ADAPT_pciecore0_bu_reg_accessMode__SHIFT 0x3
#define BIF_MEM_PG_CNTL__BIF_MEM_SD_EN_MASK 0x1
#define BIF_MEM_PG_CNTL__BIF_MEM_SD_EN__SHIFT 0x0
#define BIF_MEM_PG_CNTL__BIF_MEM_SD_TIMER_MASK 0xffff0000
#define BIF_MEM_PG_CNTL__BIF_MEM_SD_TIMER__SHIFT 0x10
#define C_PCIE_P_INDEX__PCIE_INDEX_MASK 0xffffffff
#define C_PCIE_P_INDEX__PCIE_INDEX__SHIFT 0x0
#define C_PCIE_P_DATA__PCIE_DATA_MASK 0xffffffff
#define C_PCIE_P_DATA__PCIE_DATA__SHIFT 0x0
#define D2F1_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D2F1_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D2F1_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D2F1_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D2F1_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D2F1_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D2F1_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D2F1_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D2F1_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D2F1_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D2F1_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D2F1_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D2F1_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D2F1_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D2F1_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D2F1_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D2F1_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D2F1_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D2F1_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D2F1_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D2F1_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D2F1_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D2F1_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D2F1_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D2F1_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D2F1_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D2F1_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D2F1_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D2F1_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D2F1_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D2F1_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D2F1_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D2F1_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D2F1_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D2F1_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D2F1_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D2F1_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D2F1_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D2F1_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D2F1_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D2F1_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D2F1_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D2F1_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D2F1_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D2F1_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D2F1_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D2F1_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D2F1_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D2F1_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D2F1_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D2F1_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D2F1_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D2F1_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D2F1_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D2F1_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D2F1_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D2F1_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D2F1_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D2F1_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D2F1_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D2F1_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D2F1_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D2F1_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D2F1_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D2F1_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D2F1_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D2F1_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D2F1_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D2F1_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D2F1_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D2F1_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D2F1_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D2F1_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D2F1_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D2F1_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D2F1_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D2F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D2F1_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D2F1_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D2F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D2F1_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D2F1_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D2F1_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D2F1_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D2F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D2F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D2F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D2F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D2F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D2F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D2F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D2F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D2F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D2F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D2F1_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D2F1_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D2F1_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D2F1_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D2F1_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D2F1_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D2F1_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D2F1_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D2F1_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D2F1_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D2F1_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D2F1_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D2F1_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D2F1_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D2F1_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D2F1_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D2F1_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D2F1_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D2F1_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D2F1_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D2F1_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D2F1_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D2F1_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D2F1_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D2F1_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D2F1_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D2F1_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D2F1_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D2F1_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D2F1_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D2F1_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D2F1_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D2F1_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D2F1_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D2F1_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D2F1_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D2F1_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D2F1_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D2F1_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D2F1_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D2F1_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D2F1_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D2F1_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D2F1_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D2F1_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D2F1_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D2F1_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D2F1_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D2F1_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D2F1_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D2F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D2F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D2F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D2F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D2F1_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D2F1_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D2F1_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D2F1_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D2F1_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D2F1_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D2F1_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D2F1_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D2F1_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D2F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D2F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D2F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D2F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D2F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D2F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D2F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D2F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D2F1_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D2F1_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D2F1_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D2F1_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D2F1_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D2F1_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D2F1_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D2F1_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D2F1_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D2F1_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D2F1_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D2F1_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D2F1_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D2F1_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D2F1_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D2F1_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D2F1_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D2F1_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D2F1_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D2F1_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D2F1_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D2F1_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D2F1_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D2F1_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D2F1_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D2F1_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D2F1_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D2F1_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D2F1_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D2F1_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D2F1_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D2F1_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D2F1_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D2F1_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D2F1_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D2F1_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D2F1_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D2F1_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D2F1_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D2F1_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D2F1_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D2F1_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D2F1_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D2F1_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D2F1_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D2F1_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D2F1_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D2F1_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D2F1_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D2F1_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D2F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D2F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D2F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D2F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D2F1_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D2F1_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D2F1_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D2F1_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D2F1_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D2F1_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D2F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D2F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D2F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D2F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D2F1_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D2F1_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D2F1_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D2F1_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D2F1_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D2F1_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D2F1_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D2F1_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D2F1_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D2F1_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D2F1_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D2F1_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D2F1_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D2F1_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D2F1_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D2F1_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D2F1_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D2F1_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D2F1_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D2F1_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D2F1_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D2F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D2F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D2F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D2F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D2F1_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D2F1_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D2F1_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D2F1_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D2F1_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D2F1_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D2F1_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D2F1_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D2F1_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D2F1_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D2F1_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D2F1_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D2F1_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D2F1_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D2F1_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D2F1_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D2F1_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D2F1_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D2F1_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D2F1_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D2F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D2F1_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D2F1_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D2F1_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D2F1_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D2F1_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D2F1_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D2F1_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D2F1_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D2F1_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D2F1_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D2F1_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D2F1_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D2F1_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D2F1_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D2F1_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D2F1_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D2F1_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D2F1_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D2F1_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D2F1_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D2F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D2F1_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D2F1_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D2F1_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D2F1_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D2F1_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D2F1_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D2F1_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D2F1_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D2F1_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D2F1_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D2F1_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D2F1_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D2F1_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D2F1_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D2F1_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D2F1_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D2F1_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D2F1_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D2F1_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D2F1_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D2F1_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D2F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D2F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D2F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D2F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D2F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D2F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D2F1_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D2F1_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D2F1_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D2F1_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D2F1_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D2F1_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D2F1_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D2F1_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D2F1_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D2F1_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D2F1_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D2F1_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D2F1_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D2F1_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D2F1_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D2F1_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D2F1_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D2F1_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D2F1_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D2F1_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D2F1_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D2F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D2F1_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D2F1_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D2F1_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D2F1_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D2F1_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D2F1_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D2F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D2F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D2F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D2F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D2F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D2F1_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D2F1_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D2F1_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D2F1_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D2F1_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D2F1_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D2F1_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D2F1_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D2F1_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D2F1_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D2F1_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D2F1_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D2F1_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D2F1_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D2F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D2F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D2F1_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D2F1_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D2F1_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D2F1_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D2F1_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D2F1_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D2F1_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D2F1_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D2F1_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D2F1_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D2F1_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D2F1_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D2F1_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D2F1_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D2F1_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D2F1_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D2F1_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D2F1_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D2F1_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D2F1_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D2F1_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D2F1_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D2F1_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D2F1_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D2F1_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D2F1_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D2F1_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D2F1_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D2F1_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D2F1_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D2F1_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D2F1_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D2F1_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D2F1_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D2F1_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D2F1_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D2F1_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D2F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D2F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D2F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D2F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D2F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D2F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D2F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D2F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D2F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D2F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D2F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D2F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D2F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D2F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D2F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D2F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D2F1_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D2F1_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D2F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D2F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D2F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D2F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D2F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D2F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D2F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D2F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D2F1_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D2F1_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D2F1_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D2F1_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D2F1_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D2F1_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D2F1_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D2F1_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D2F1_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D2F1_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D2F1_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D2F1_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D2F1_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D2F1_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D2F1_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D2F1_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D2F1_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D2F1_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D2F1_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D2F1_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D2F1_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D2F1_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D2F1_COMMAND__AD_STEPPING_MASK 0x80
#define D2F1_COMMAND__AD_STEPPING__SHIFT 0x7
#define D2F1_COMMAND__SERR_EN_MASK 0x100
#define D2F1_COMMAND__SERR_EN__SHIFT 0x8
#define D2F1_COMMAND__FAST_B2B_EN_MASK 0x200
#define D2F1_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D2F1_COMMAND__INT_DIS_MASK 0x400
#define D2F1_COMMAND__INT_DIS__SHIFT 0xa
#define D2F1_STATUS__INT_STATUS_MASK 0x80000
#define D2F1_STATUS__INT_STATUS__SHIFT 0x13
#define D2F1_STATUS__CAP_LIST_MASK 0x100000
#define D2F1_STATUS__CAP_LIST__SHIFT 0x14
#define D2F1_STATUS__PCI_66_EN_MASK 0x200000
#define D2F1_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F1_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F1_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F1_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F1_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F1_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F1_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F1_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F1_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F1_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F1_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F1_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F1_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F1_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D2F1_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F1_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F1_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F1_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D2F1_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D2F1_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D2F1_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D2F1_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D2F1_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D2F1_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D2F1_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D2F1_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D2F1_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D2F1_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D2F1_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D2F1_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D2F1_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D2F1_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D2F1_HEADER__HEADER_TYPE__SHIFT 0x10
#define D2F1_HEADER__DEVICE_TYPE_MASK 0x800000
#define D2F1_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D2F1_BIST__BIST_COMP_MASK 0xf000000
#define D2F1_BIST__BIST_COMP__SHIFT 0x18
#define D2F1_BIST__BIST_STRT_MASK 0x40000000
#define D2F1_BIST__BIST_STRT__SHIFT 0x1e
#define D2F1_BIST__BIST_CAP_MASK 0x80000000
#define D2F1_BIST__BIST_CAP__SHIFT 0x1f
#define D2F1_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D2F1_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D2F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D2F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D2F1_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D2F1_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D2F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D2F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D2F1_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D2F1_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D2F1_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D2F1_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D2F1_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D2F1_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D2F1_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D2F1_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D2F1_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D2F1_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D2F1_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D2F1_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F1_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F1_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F1_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F1_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F1_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F1_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F1_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F1_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F1_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F1_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F1_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F1_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F1_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D2F1_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F1_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F1_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F1_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D2F1_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D2F1_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D2F1_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D2F1_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F1_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F1_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F1_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D2F1_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D2F1_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D2F1_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D2F1_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D2F1_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D2F1_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D2F1_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D2F1_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D2F1_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D2F1_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D2F1_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D2F1_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D2F1_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D2F1_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D2F1_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D2F1_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D2F1_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D2F1_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D2F1_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D2F1_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D2F1_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D2F1_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D2F1_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D2F1_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D2F1_CAP_PTR__CAP_PTR_MASK 0xff
#define D2F1_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D2F1_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D2F1_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D2F1_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D2F1_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D2F1_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D2F1_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D2F1_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F1_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F1_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F1_PMI_CAP__VERSION_MASK 0x70000
#define D2F1_PMI_CAP__VERSION__SHIFT 0x10
#define D2F1_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D2F1_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D2F1_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D2F1_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D2F1_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D2F1_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D2F1_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D2F1_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D2F1_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D2F1_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D2F1_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D2F1_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D2F1_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D2F1_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D2F1_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D2F1_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D2F1_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D2F1_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D2F1_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D2F1_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D2F1_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D2F1_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D2F1_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D2F1_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D2F1_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D2F1_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D2F1_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D2F1_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D2F1_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D2F1_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D2F1_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D2F1_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F1_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F1_PCIE_CAP__VERSION_MASK 0xf0000
#define D2F1_PCIE_CAP__VERSION__SHIFT 0x10
#define D2F1_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D2F1_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D2F1_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D2F1_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D2F1_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D2F1_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D2F1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D2F1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D2F1_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D2F1_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D2F1_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D2F1_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D2F1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D2F1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D2F1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D2F1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D2F1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D2F1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D2F1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D2F1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D2F1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D2F1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D2F1_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D2F1_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D2F1_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D2F1_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D2F1_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D2F1_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D2F1_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D2F1_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D2F1_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D2F1_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D2F1_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D2F1_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D2F1_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D2F1_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D2F1_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D2F1_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D2F1_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D2F1_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D2F1_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D2F1_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D2F1_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D2F1_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D2F1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D2F1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D2F1_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D2F1_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D2F1_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D2F1_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D2F1_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D2F1_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D2F1_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D2F1_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D2F1_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D2F1_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D2F1_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D2F1_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D2F1_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D2F1_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D2F1_LINK_CAP__LINK_SPEED_MASK 0xf
#define D2F1_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D2F1_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D2F1_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D2F1_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D2F1_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D2F1_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D2F1_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D2F1_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D2F1_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D2F1_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D2F1_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D2F1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D2F1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D2F1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D2F1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D2F1_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D2F1_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D2F1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D2F1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D2F1_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D2F1_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D2F1_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D2F1_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D2F1_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D2F1_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D2F1_LINK_CNTL__LINK_DIS_MASK 0x10
#define D2F1_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D2F1_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D2F1_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D2F1_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D2F1_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D2F1_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D2F1_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D2F1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D2F1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D2F1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D2F1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D2F1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D2F1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D2F1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D2F1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D2F1_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D2F1_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D2F1_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D2F1_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D2F1_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D2F1_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D2F1_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D2F1_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D2F1_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D2F1_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D2F1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D2F1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D2F1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D2F1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D2F1_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D2F1_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D2F1_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D2F1_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D2F1_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D2F1_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D2F1_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D2F1_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D2F1_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D2F1_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D2F1_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D2F1_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D2F1_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D2F1_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D2F1_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D2F1_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D2F1_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D2F1_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D2F1_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D2F1_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D2F1_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D2F1_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D2F1_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D2F1_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D2F1_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D2F1_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D2F1_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D2F1_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D2F1_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D2F1_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D2F1_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D2F1_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D2F1_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D2F1_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D2F1_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D2F1_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D2F1_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D2F1_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D2F1_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D2F1_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D2F1_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D2F1_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D2F1_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D2F1_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D2F1_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D2F1_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D2F1_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D2F1_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D2F1_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D2F1_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D2F1_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D2F1_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D2F1_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D2F1_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D2F1_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D2F1_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D2F1_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D2F1_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D2F1_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D2F1_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D2F1_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D2F1_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D2F1_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D2F1_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D2F1_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D2F1_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D2F1_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D2F1_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D2F1_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D2F1_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D2F1_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D2F1_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D2F1_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D2F1_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D2F1_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D2F1_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D2F1_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D2F1_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D2F1_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D2F1_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D2F1_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D2F1_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D2F1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D2F1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D2F1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D2F1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D2F1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D2F1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D2F1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D2F1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D2F1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D2F1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D2F1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D2F1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D2F1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D2F1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D2F1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D2F1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D2F1_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D2F1_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D2F1_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D2F1_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D2F1_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D2F1_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D2F1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D2F1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D2F1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D2F1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D2F1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D2F1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D2F1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D2F1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D2F1_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D2F1_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D2F1_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D2F1_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D2F1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D2F1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D2F1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D2F1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D2F1_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D2F1_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D2F1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D2F1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D2F1_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D2F1_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D2F1_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D2F1_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D2F1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D2F1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D2F1_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D2F1_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D2F1_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D2F1_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D2F1_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D2F1_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D2F1_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D2F1_LINK_CAP2__RESERVED__SHIFT 0x9
#define D2F1_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D2F1_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D2F1_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D2F1_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D2F1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D2F1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D2F1_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D2F1_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D2F1_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D2F1_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D2F1_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D2F1_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D2F1_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D2F1_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D2F1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D2F1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D2F1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D2F1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D2F1_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D2F1_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D2F1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D2F1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D2F1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D2F1_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D2F1_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D2F1_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D2F1_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D2F1_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D2F1_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D2F1_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F1_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F1_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F1_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D2F1_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D2F1_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D2F1_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D2F1_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D2F1_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D2F1_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D2F1_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D2F1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D2F1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D2F1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D2F1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D2F1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D2F1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D2F1_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D2F1_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D2F1_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D2F1_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D2F1_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D2F1_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F1_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F1_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D2F1_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D2F1_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D2F1_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D2F1_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D2F1_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F1_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F1_MSI_MAP_CAP__EN_MASK 0x10000
#define D2F1_MSI_MAP_CAP__EN__SHIFT 0x10
#define D2F1_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D2F1_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D2F1_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D2F1_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D2F1_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D2F1_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D2F1_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D2F1_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D2F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D2F1_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D2F1_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D2F1_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D2F1_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D2F1_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D2F1_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D2F1_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D2F1_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D2F1_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D2F1_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D2F1_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D2F1_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D2F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D2F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D2F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F1_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D2F1_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D2F1_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D2F1_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D2F1_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D2F1_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F1_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F1_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F1_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F1_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F1_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F1_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F1_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F1_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F1_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F1_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F1_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F1_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F1_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F1_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F1_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F1_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F1_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F1_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F1_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F1_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F1_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F1_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F1_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F1_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F1_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F1_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F1_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F1_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F1_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F1_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F1_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F1_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D2F1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D2F1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D2F1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D2F1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D2F1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D2F1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D2F1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D2F1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D2F1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D2F1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D2F1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D2F1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D2F1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D2F1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D2F1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D2F1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D2F1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D2F1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D2F1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D2F1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D2F1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D2F1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D2F1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D2F1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D2F1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D2F1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D2F1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D2F1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D2F1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D2F1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D2F1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D2F1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D2F1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D2F1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D2F1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D2F1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D2F1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D2F1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D2F1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D2F1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D2F1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D2F1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D2F1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D2F1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D2F1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D2F1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D2F1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D2F1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D2F1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D2F1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D2F1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D2F1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D2F1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D2F1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D2F1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D2F1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D2F1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D2F1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D2F1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D2F1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D2F1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D2F1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D2F1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D2F1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D2F1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D2F1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D2F1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D2F1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D2F1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D2F1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D2F1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D2F1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D2F1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D2F1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D2F1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D2F1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D2F1_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D2F1_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D2F1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D2F1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D2F1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D2F1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D2F1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D2F1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D2F1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D2F1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D2F1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D2F1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D2F1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D2F1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D2F1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D2F1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D2F1_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D2F1_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D2F1_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D2F1_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D2F1_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D2F1_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D2F1_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D2F1_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D2F1_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D2F1_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D2F1_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D2F1_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D2F1_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D2F1_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D2F1_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D2F1_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D2F1_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D2F1_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D2F1_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D2F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D2F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D2F1_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D2F1_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D2F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D2F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D2F1_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D2F1_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D2F1_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D2F1_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D2F1_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D2F1_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D2F1_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D2F1_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D2F1_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D2F1_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D2F1_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D2F1_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D2F1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D2F1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D2F1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D2F1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D2F1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D2F1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D2F1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D2F1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D2F1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D2F1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D2F1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D2F1_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D2F1_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D2F1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D2F1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D2F1_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D2F1_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F1_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F1_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F1_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define D2F1_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define D2F1_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define D2F1_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define D2F1_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define D2F1_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define D2F1_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define D2F1_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define D2F1_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define D2F1_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define D2F1_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define D2F1_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define D2F1_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define D2F1_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define D2F1_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define D2F1_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define D2F1_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x10000
#define D2F1_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x10
#define D2F1_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x20000
#define D2F1_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x11
#define D2F1_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x40000
#define D2F1_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x12
#define D2F1_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x80000
#define D2F1_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x13
#define D2F1_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x100000
#define D2F1_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x14
#define D2F1_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x200000
#define D2F1_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x15
#define D2F1_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x400000
#define D2F1_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x16
#define D2F1_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F1_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F1_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F1_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F1_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F1_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F1_PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define D2F1_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define D2F1_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define D2F1_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define D2F1_PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f0000
#define D2F1_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x10
#define D2F1_PCIE_MC_CNTL__MC_ENABLE_MASK 0x80000000
#define D2F1_PCIE_MC_CNTL__MC_ENABLE__SHIFT 0x1f
#define D2F1_PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define D2F1_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define D2F1_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define D2F1_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define D2F1_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define D2F1_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define D2F1_PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define D2F1_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define D2F1_PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define D2F1_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define D2F1_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define D2F1_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define D2F1_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define D2F1_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define D2F1_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define D2F1_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define D2F1_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define D2F1_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define D2F1_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE_MASK 0x3f
#define D2F1_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE__SHIFT 0x0
#define D2F1_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0_MASK 0xffffffc0
#define D2F1_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0__SHIFT 0x6
#define D2F1_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1_MASK 0xffffffff
#define D2F1_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1__SHIFT 0x0
#define D2F2_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D2F2_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D2F2_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D2F2_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D2F2_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D2F2_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D2F2_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D2F2_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D2F2_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D2F2_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D2F2_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D2F2_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D2F2_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D2F2_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D2F2_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D2F2_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D2F2_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D2F2_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D2F2_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D2F2_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D2F2_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D2F2_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D2F2_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D2F2_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D2F2_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D2F2_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D2F2_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D2F2_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D2F2_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D2F2_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D2F2_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D2F2_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D2F2_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D2F2_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D2F2_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D2F2_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D2F2_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D2F2_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D2F2_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D2F2_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D2F2_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D2F2_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D2F2_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D2F2_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D2F2_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D2F2_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D2F2_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D2F2_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D2F2_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D2F2_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D2F2_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D2F2_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D2F2_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D2F2_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D2F2_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D2F2_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D2F2_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D2F2_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D2F2_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D2F2_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D2F2_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D2F2_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D2F2_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D2F2_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D2F2_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D2F2_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D2F2_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D2F2_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D2F2_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D2F2_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D2F2_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D2F2_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D2F2_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D2F2_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D2F2_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D2F2_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D2F2_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D2F2_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D2F2_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D2F2_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D2F2_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D2F2_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D2F2_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D2F2_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D2F2_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D2F2_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D2F2_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D2F2_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D2F2_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D2F2_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D2F2_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D2F2_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D2F2_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D2F2_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D2F2_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D2F2_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D2F2_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D2F2_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D2F2_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D2F2_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D2F2_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D2F2_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D2F2_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D2F2_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D2F2_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D2F2_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D2F2_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D2F2_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D2F2_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D2F2_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D2F2_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D2F2_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D2F2_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D2F2_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D2F2_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D2F2_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D2F2_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D2F2_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D2F2_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D2F2_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D2F2_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D2F2_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D2F2_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D2F2_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D2F2_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D2F2_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D2F2_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D2F2_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D2F2_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D2F2_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D2F2_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D2F2_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D2F2_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D2F2_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D2F2_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D2F2_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D2F2_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D2F2_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D2F2_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D2F2_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D2F2_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D2F2_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D2F2_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D2F2_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D2F2_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D2F2_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D2F2_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D2F2_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D2F2_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D2F2_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D2F2_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D2F2_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D2F2_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D2F2_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D2F2_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D2F2_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D2F2_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D2F2_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D2F2_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D2F2_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D2F2_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D2F2_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D2F2_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D2F2_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D2F2_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D2F2_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D2F2_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D2F2_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D2F2_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D2F2_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D2F2_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D2F2_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D2F2_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D2F2_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D2F2_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D2F2_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D2F2_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D2F2_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D2F2_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D2F2_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D2F2_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D2F2_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D2F2_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D2F2_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D2F2_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D2F2_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D2F2_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D2F2_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D2F2_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D2F2_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D2F2_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D2F2_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D2F2_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D2F2_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D2F2_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D2F2_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D2F2_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D2F2_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D2F2_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D2F2_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D2F2_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D2F2_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D2F2_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D2F2_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D2F2_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D2F2_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D2F2_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D2F2_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D2F2_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D2F2_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D2F2_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D2F2_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D2F2_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D2F2_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D2F2_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D2F2_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D2F2_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D2F2_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D2F2_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D2F2_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D2F2_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D2F2_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D2F2_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D2F2_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D2F2_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D2F2_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D2F2_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D2F2_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D2F2_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D2F2_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D2F2_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D2F2_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D2F2_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D2F2_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D2F2_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D2F2_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D2F2_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D2F2_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D2F2_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D2F2_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D2F2_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D2F2_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D2F2_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D2F2_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D2F2_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D2F2_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D2F2_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D2F2_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D2F2_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D2F2_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D2F2_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D2F2_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D2F2_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D2F2_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D2F2_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D2F2_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D2F2_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D2F2_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D2F2_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D2F2_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D2F2_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D2F2_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D2F2_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D2F2_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D2F2_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D2F2_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D2F2_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D2F2_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D2F2_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D2F2_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D2F2_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D2F2_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D2F2_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D2F2_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D2F2_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D2F2_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D2F2_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D2F2_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D2F2_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D2F2_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D2F2_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D2F2_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D2F2_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D2F2_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D2F2_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D2F2_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D2F2_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D2F2_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D2F2_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D2F2_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D2F2_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D2F2_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D2F2_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D2F2_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D2F2_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D2F2_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D2F2_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D2F2_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D2F2_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D2F2_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D2F2_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D2F2_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D2F2_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D2F2_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D2F2_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D2F2_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D2F2_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D2F2_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D2F2_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D2F2_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D2F2_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D2F2_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D2F2_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D2F2_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D2F2_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D2F2_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D2F2_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D2F2_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D2F2_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D2F2_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D2F2_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D2F2_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D2F2_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D2F2_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D2F2_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D2F2_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D2F2_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D2F2_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D2F2_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D2F2_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D2F2_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D2F2_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D2F2_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D2F2_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D2F2_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D2F2_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D2F2_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D2F2_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D2F2_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D2F2_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D2F2_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D2F2_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D2F2_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D2F2_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D2F2_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D2F2_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D2F2_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D2F2_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D2F2_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D2F2_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D2F2_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D2F2_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D2F2_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D2F2_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D2F2_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D2F2_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D2F2_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D2F2_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D2F2_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D2F2_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D2F2_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D2F2_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D2F2_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D2F2_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D2F2_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D2F2_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D2F2_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D2F2_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D2F2_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D2F2_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D2F2_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D2F2_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D2F2_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D2F2_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D2F2_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D2F2_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D2F2_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D2F2_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D2F2_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D2F2_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D2F2_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D2F2_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D2F2_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D2F2_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D2F2_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D2F2_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D2F2_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D2F2_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D2F2_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D2F2_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D2F2_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D2F2_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D2F2_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D2F2_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D2F2_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D2F2_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D2F2_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D2F2_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D2F2_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D2F2_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D2F2_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D2F2_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D2F2_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D2F2_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D2F2_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D2F2_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D2F2_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D2F2_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D2F2_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D2F2_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D2F2_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D2F2_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D2F2_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D2F2_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D2F2_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D2F2_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D2F2_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D2F2_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D2F2_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D2F2_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D2F2_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D2F2_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D2F2_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D2F2_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D2F2_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D2F2_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D2F2_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D2F2_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D2F2_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D2F2_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D2F2_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D2F2_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D2F2_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D2F2_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D2F2_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D2F2_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D2F2_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D2F2_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D2F2_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D2F2_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D2F2_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D2F2_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D2F2_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D2F2_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D2F2_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D2F2_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D2F2_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D2F2_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D2F2_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D2F2_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D2F2_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D2F2_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D2F2_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D2F2_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D2F2_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D2F2_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D2F2_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D2F2_COMMAND__AD_STEPPING_MASK 0x80
#define D2F2_COMMAND__AD_STEPPING__SHIFT 0x7
#define D2F2_COMMAND__SERR_EN_MASK 0x100
#define D2F2_COMMAND__SERR_EN__SHIFT 0x8
#define D2F2_COMMAND__FAST_B2B_EN_MASK 0x200
#define D2F2_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D2F2_COMMAND__INT_DIS_MASK 0x400
#define D2F2_COMMAND__INT_DIS__SHIFT 0xa
#define D2F2_STATUS__INT_STATUS_MASK 0x80000
#define D2F2_STATUS__INT_STATUS__SHIFT 0x13
#define D2F2_STATUS__CAP_LIST_MASK 0x100000
#define D2F2_STATUS__CAP_LIST__SHIFT 0x14
#define D2F2_STATUS__PCI_66_EN_MASK 0x200000
#define D2F2_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F2_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F2_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F2_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F2_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F2_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F2_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F2_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F2_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F2_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F2_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F2_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F2_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F2_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D2F2_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F2_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F2_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F2_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D2F2_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D2F2_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D2F2_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D2F2_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D2F2_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D2F2_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D2F2_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D2F2_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D2F2_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D2F2_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D2F2_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D2F2_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D2F2_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D2F2_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D2F2_HEADER__HEADER_TYPE__SHIFT 0x10
#define D2F2_HEADER__DEVICE_TYPE_MASK 0x800000
#define D2F2_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D2F2_BIST__BIST_COMP_MASK 0xf000000
#define D2F2_BIST__BIST_COMP__SHIFT 0x18
#define D2F2_BIST__BIST_STRT_MASK 0x40000000
#define D2F2_BIST__BIST_STRT__SHIFT 0x1e
#define D2F2_BIST__BIST_CAP_MASK 0x80000000
#define D2F2_BIST__BIST_CAP__SHIFT 0x1f
#define D2F2_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D2F2_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D2F2_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D2F2_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D2F2_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D2F2_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D2F2_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D2F2_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D2F2_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D2F2_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D2F2_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D2F2_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D2F2_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D2F2_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D2F2_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D2F2_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D2F2_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D2F2_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D2F2_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D2F2_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F2_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F2_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F2_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F2_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F2_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F2_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F2_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F2_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F2_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F2_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F2_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F2_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F2_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D2F2_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F2_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F2_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F2_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D2F2_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D2F2_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D2F2_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D2F2_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F2_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F2_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F2_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F2_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D2F2_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D2F2_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D2F2_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D2F2_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D2F2_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D2F2_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D2F2_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D2F2_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D2F2_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D2F2_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D2F2_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D2F2_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D2F2_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D2F2_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D2F2_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D2F2_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D2F2_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D2F2_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D2F2_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D2F2_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D2F2_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D2F2_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D2F2_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D2F2_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D2F2_CAP_PTR__CAP_PTR_MASK 0xff
#define D2F2_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D2F2_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D2F2_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D2F2_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D2F2_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D2F2_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D2F2_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D2F2_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F2_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F2_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F2_PMI_CAP__VERSION_MASK 0x70000
#define D2F2_PMI_CAP__VERSION__SHIFT 0x10
#define D2F2_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D2F2_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D2F2_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D2F2_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D2F2_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D2F2_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D2F2_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D2F2_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D2F2_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D2F2_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D2F2_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D2F2_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D2F2_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D2F2_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D2F2_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D2F2_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D2F2_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D2F2_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D2F2_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D2F2_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D2F2_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D2F2_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D2F2_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D2F2_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D2F2_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D2F2_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D2F2_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D2F2_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D2F2_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D2F2_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D2F2_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D2F2_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F2_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F2_PCIE_CAP__VERSION_MASK 0xf0000
#define D2F2_PCIE_CAP__VERSION__SHIFT 0x10
#define D2F2_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D2F2_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D2F2_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D2F2_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D2F2_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D2F2_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D2F2_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D2F2_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D2F2_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D2F2_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D2F2_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D2F2_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D2F2_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D2F2_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D2F2_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D2F2_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D2F2_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D2F2_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D2F2_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D2F2_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D2F2_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D2F2_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D2F2_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D2F2_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D2F2_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D2F2_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D2F2_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D2F2_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D2F2_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D2F2_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D2F2_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D2F2_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D2F2_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D2F2_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D2F2_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D2F2_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D2F2_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D2F2_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D2F2_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D2F2_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D2F2_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D2F2_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D2F2_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D2F2_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D2F2_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D2F2_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D2F2_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D2F2_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D2F2_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D2F2_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D2F2_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D2F2_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D2F2_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D2F2_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D2F2_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D2F2_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D2F2_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D2F2_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D2F2_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D2F2_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D2F2_LINK_CAP__LINK_SPEED_MASK 0xf
#define D2F2_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D2F2_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D2F2_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D2F2_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D2F2_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D2F2_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D2F2_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D2F2_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D2F2_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D2F2_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D2F2_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D2F2_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D2F2_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D2F2_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D2F2_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D2F2_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D2F2_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D2F2_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D2F2_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D2F2_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D2F2_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D2F2_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D2F2_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D2F2_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D2F2_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D2F2_LINK_CNTL__LINK_DIS_MASK 0x10
#define D2F2_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D2F2_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D2F2_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D2F2_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D2F2_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D2F2_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D2F2_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D2F2_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D2F2_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D2F2_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D2F2_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D2F2_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D2F2_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D2F2_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D2F2_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D2F2_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D2F2_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D2F2_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D2F2_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D2F2_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D2F2_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D2F2_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D2F2_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D2F2_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D2F2_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D2F2_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D2F2_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D2F2_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D2F2_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D2F2_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D2F2_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D2F2_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D2F2_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D2F2_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D2F2_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D2F2_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D2F2_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D2F2_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D2F2_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D2F2_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D2F2_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D2F2_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D2F2_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D2F2_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D2F2_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D2F2_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D2F2_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D2F2_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D2F2_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D2F2_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D2F2_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D2F2_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D2F2_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D2F2_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D2F2_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D2F2_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D2F2_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D2F2_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D2F2_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D2F2_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D2F2_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D2F2_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D2F2_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D2F2_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D2F2_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D2F2_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D2F2_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D2F2_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D2F2_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D2F2_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D2F2_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D2F2_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D2F2_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D2F2_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D2F2_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D2F2_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D2F2_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D2F2_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D2F2_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D2F2_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D2F2_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D2F2_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D2F2_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D2F2_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D2F2_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D2F2_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D2F2_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D2F2_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D2F2_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D2F2_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D2F2_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D2F2_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D2F2_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D2F2_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D2F2_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D2F2_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D2F2_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D2F2_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D2F2_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D2F2_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D2F2_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D2F2_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D2F2_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D2F2_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D2F2_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D2F2_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D2F2_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D2F2_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D2F2_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D2F2_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D2F2_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D2F2_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D2F2_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D2F2_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D2F2_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D2F2_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D2F2_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D2F2_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D2F2_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D2F2_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D2F2_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D2F2_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D2F2_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D2F2_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D2F2_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D2F2_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D2F2_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D2F2_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D2F2_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D2F2_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D2F2_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D2F2_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D2F2_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D2F2_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D2F2_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D2F2_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D2F2_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D2F2_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D2F2_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D2F2_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D2F2_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D2F2_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D2F2_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D2F2_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D2F2_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D2F2_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D2F2_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D2F2_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D2F2_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D2F2_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D2F2_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D2F2_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D2F2_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D2F2_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D2F2_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D2F2_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D2F2_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D2F2_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D2F2_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D2F2_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D2F2_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D2F2_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D2F2_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D2F2_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D2F2_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D2F2_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D2F2_LINK_CAP2__RESERVED__SHIFT 0x9
#define D2F2_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D2F2_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D2F2_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D2F2_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D2F2_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D2F2_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D2F2_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D2F2_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D2F2_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D2F2_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D2F2_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D2F2_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D2F2_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D2F2_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D2F2_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D2F2_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D2F2_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D2F2_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D2F2_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D2F2_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D2F2_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D2F2_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D2F2_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D2F2_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D2F2_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D2F2_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D2F2_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D2F2_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D2F2_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D2F2_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F2_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F2_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F2_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D2F2_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D2F2_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D2F2_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D2F2_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D2F2_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D2F2_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D2F2_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D2F2_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D2F2_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D2F2_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D2F2_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D2F2_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D2F2_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D2F2_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D2F2_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D2F2_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D2F2_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D2F2_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D2F2_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F2_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F2_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D2F2_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D2F2_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D2F2_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D2F2_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D2F2_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F2_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F2_MSI_MAP_CAP__EN_MASK 0x10000
#define D2F2_MSI_MAP_CAP__EN__SHIFT 0x10
#define D2F2_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D2F2_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D2F2_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D2F2_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D2F2_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D2F2_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D2F2_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D2F2_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D2F2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D2F2_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D2F2_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D2F2_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D2F2_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D2F2_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D2F2_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D2F2_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D2F2_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D2F2_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D2F2_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D2F2_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D2F2_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D2F2_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D2F2_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D2F2_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F2_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F2_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D2F2_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D2F2_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D2F2_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D2F2_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D2F2_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F2_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F2_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F2_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F2_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F2_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F2_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F2_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F2_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F2_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F2_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F2_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F2_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F2_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F2_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F2_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F2_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F2_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F2_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F2_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F2_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F2_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F2_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F2_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F2_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F2_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F2_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F2_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F2_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F2_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F2_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F2_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F2_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F2_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F2_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F2_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F2_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F2_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F2_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F2_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F2_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F2_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F2_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F2_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F2_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F2_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F2_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F2_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F2_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D2F2_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D2F2_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D2F2_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D2F2_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D2F2_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D2F2_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D2F2_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D2F2_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D2F2_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D2F2_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D2F2_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D2F2_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D2F2_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D2F2_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D2F2_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D2F2_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D2F2_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D2F2_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D2F2_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D2F2_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D2F2_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D2F2_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D2F2_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D2F2_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D2F2_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D2F2_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D2F2_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D2F2_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D2F2_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D2F2_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D2F2_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D2F2_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D2F2_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D2F2_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D2F2_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D2F2_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D2F2_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D2F2_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D2F2_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D2F2_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D2F2_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D2F2_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D2F2_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D2F2_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D2F2_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D2F2_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D2F2_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D2F2_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D2F2_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D2F2_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D2F2_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D2F2_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D2F2_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D2F2_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D2F2_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D2F2_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D2F2_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D2F2_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D2F2_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D2F2_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D2F2_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D2F2_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D2F2_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D2F2_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D2F2_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D2F2_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D2F2_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D2F2_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D2F2_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D2F2_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D2F2_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D2F2_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D2F2_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D2F2_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D2F2_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D2F2_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D2F2_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D2F2_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D2F2_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D2F2_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D2F2_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D2F2_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D2F2_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D2F2_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D2F2_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D2F2_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D2F2_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D2F2_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D2F2_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D2F2_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D2F2_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D2F2_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D2F2_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D2F2_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D2F2_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D2F2_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D2F2_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D2F2_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D2F2_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D2F2_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D2F2_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D2F2_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D2F2_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D2F2_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D2F2_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D2F2_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D2F2_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D2F2_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D2F2_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D2F2_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D2F2_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D2F2_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D2F2_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D2F2_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D2F2_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D2F2_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D2F2_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D2F2_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D2F2_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D2F2_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D2F2_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D2F2_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D2F2_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D2F2_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D2F2_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D2F2_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D2F2_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D2F2_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D2F2_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D2F2_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D2F2_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D2F2_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D2F2_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D2F2_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D2F2_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D2F2_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D2F2_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D2F2_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D2F2_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D2F2_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D2F2_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D2F2_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D2F2_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D2F2_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D2F2_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D2F2_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F2_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F2_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F2_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define D2F2_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define D2F2_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define D2F2_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define D2F2_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define D2F2_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define D2F2_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define D2F2_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define D2F2_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define D2F2_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define D2F2_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define D2F2_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define D2F2_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define D2F2_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define D2F2_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define D2F2_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define D2F2_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x10000
#define D2F2_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x10
#define D2F2_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x20000
#define D2F2_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x11
#define D2F2_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x40000
#define D2F2_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x12
#define D2F2_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x80000
#define D2F2_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x13
#define D2F2_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x100000
#define D2F2_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x14
#define D2F2_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x200000
#define D2F2_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x15
#define D2F2_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x400000
#define D2F2_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x16
#define D2F2_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F2_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F2_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F2_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F2_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F2_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F2_PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define D2F2_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define D2F2_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define D2F2_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define D2F2_PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f0000
#define D2F2_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x10
#define D2F2_PCIE_MC_CNTL__MC_ENABLE_MASK 0x80000000
#define D2F2_PCIE_MC_CNTL__MC_ENABLE__SHIFT 0x1f
#define D2F2_PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define D2F2_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define D2F2_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define D2F2_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define D2F2_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define D2F2_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define D2F2_PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define D2F2_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define D2F2_PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define D2F2_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define D2F2_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define D2F2_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define D2F2_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define D2F2_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define D2F2_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define D2F2_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define D2F2_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define D2F2_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define D2F2_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE_MASK 0x3f
#define D2F2_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE__SHIFT 0x0
#define D2F2_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0_MASK 0xffffffc0
#define D2F2_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0__SHIFT 0x6
#define D2F2_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1_MASK 0xffffffff
#define D2F2_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1__SHIFT 0x0
#define D2F3_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D2F3_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D2F3_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D2F3_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D2F3_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D2F3_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D2F3_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D2F3_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D2F3_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D2F3_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D2F3_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D2F3_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D2F3_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D2F3_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D2F3_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D2F3_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D2F3_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D2F3_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D2F3_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D2F3_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D2F3_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D2F3_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D2F3_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D2F3_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D2F3_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D2F3_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D2F3_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D2F3_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D2F3_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D2F3_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D2F3_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D2F3_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D2F3_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D2F3_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D2F3_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D2F3_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D2F3_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D2F3_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D2F3_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D2F3_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D2F3_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D2F3_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D2F3_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D2F3_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D2F3_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D2F3_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D2F3_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D2F3_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D2F3_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D2F3_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D2F3_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D2F3_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D2F3_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D2F3_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D2F3_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D2F3_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D2F3_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D2F3_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D2F3_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D2F3_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D2F3_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D2F3_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D2F3_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D2F3_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D2F3_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D2F3_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D2F3_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D2F3_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D2F3_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D2F3_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D2F3_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D2F3_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D2F3_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D2F3_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D2F3_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D2F3_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D2F3_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D2F3_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D2F3_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D2F3_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D2F3_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D2F3_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D2F3_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D2F3_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D2F3_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D2F3_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D2F3_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D2F3_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D2F3_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D2F3_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D2F3_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D2F3_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D2F3_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D2F3_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D2F3_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D2F3_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D2F3_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D2F3_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D2F3_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D2F3_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D2F3_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D2F3_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D2F3_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D2F3_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D2F3_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D2F3_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D2F3_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D2F3_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D2F3_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D2F3_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D2F3_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D2F3_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D2F3_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D2F3_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D2F3_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D2F3_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D2F3_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D2F3_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D2F3_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D2F3_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D2F3_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D2F3_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D2F3_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D2F3_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D2F3_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D2F3_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D2F3_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D2F3_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D2F3_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D2F3_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D2F3_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D2F3_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D2F3_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D2F3_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D2F3_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D2F3_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D2F3_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D2F3_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D2F3_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D2F3_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D2F3_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D2F3_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D2F3_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D2F3_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D2F3_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D2F3_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D2F3_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D2F3_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D2F3_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D2F3_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D2F3_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D2F3_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D2F3_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D2F3_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D2F3_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D2F3_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D2F3_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D2F3_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D2F3_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D2F3_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D2F3_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D2F3_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D2F3_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D2F3_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D2F3_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D2F3_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D2F3_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D2F3_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D2F3_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D2F3_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D2F3_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D2F3_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D2F3_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D2F3_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D2F3_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D2F3_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D2F3_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D2F3_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D2F3_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D2F3_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D2F3_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D2F3_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D2F3_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D2F3_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D2F3_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D2F3_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D2F3_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D2F3_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D2F3_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D2F3_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D2F3_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D2F3_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D2F3_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D2F3_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D2F3_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D2F3_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D2F3_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D2F3_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D2F3_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D2F3_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D2F3_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D2F3_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D2F3_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D2F3_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D2F3_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D2F3_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D2F3_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D2F3_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D2F3_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D2F3_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D2F3_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D2F3_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D2F3_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D2F3_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D2F3_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D2F3_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D2F3_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D2F3_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D2F3_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D2F3_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D2F3_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D2F3_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D2F3_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D2F3_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D2F3_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D2F3_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D2F3_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D2F3_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D2F3_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D2F3_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D2F3_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D2F3_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D2F3_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D2F3_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D2F3_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D2F3_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D2F3_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D2F3_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D2F3_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D2F3_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D2F3_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D2F3_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D2F3_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D2F3_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D2F3_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D2F3_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D2F3_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D2F3_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D2F3_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D2F3_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D2F3_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D2F3_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D2F3_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D2F3_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D2F3_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D2F3_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D2F3_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D2F3_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D2F3_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D2F3_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D2F3_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D2F3_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D2F3_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D2F3_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D2F3_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D2F3_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D2F3_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D2F3_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D2F3_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D2F3_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D2F3_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D2F3_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D2F3_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D2F3_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D2F3_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D2F3_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D2F3_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D2F3_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D2F3_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D2F3_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D2F3_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D2F3_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D2F3_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D2F3_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D2F3_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D2F3_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D2F3_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D2F3_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D2F3_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D2F3_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D2F3_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D2F3_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D2F3_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D2F3_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D2F3_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D2F3_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D2F3_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D2F3_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D2F3_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D2F3_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D2F3_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D2F3_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D2F3_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D2F3_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D2F3_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D2F3_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D2F3_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D2F3_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D2F3_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D2F3_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D2F3_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D2F3_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D2F3_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D2F3_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D2F3_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D2F3_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D2F3_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D2F3_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D2F3_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D2F3_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D2F3_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D2F3_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D2F3_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D2F3_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D2F3_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D2F3_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D2F3_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D2F3_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D2F3_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D2F3_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D2F3_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D2F3_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D2F3_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D2F3_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D2F3_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D2F3_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D2F3_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D2F3_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D2F3_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D2F3_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D2F3_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D2F3_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D2F3_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D2F3_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D2F3_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D2F3_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D2F3_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D2F3_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D2F3_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D2F3_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D2F3_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D2F3_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D2F3_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D2F3_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D2F3_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D2F3_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D2F3_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D2F3_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D2F3_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D2F3_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D2F3_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D2F3_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D2F3_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D2F3_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D2F3_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D2F3_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D2F3_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D2F3_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D2F3_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D2F3_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D2F3_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D2F3_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D2F3_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D2F3_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D2F3_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D2F3_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D2F3_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D2F3_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D2F3_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D2F3_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D2F3_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D2F3_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D2F3_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D2F3_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D2F3_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D2F3_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D2F3_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D2F3_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D2F3_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D2F3_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D2F3_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D2F3_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D2F3_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D2F3_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D2F3_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D2F3_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D2F3_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D2F3_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D2F3_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D2F3_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D2F3_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D2F3_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D2F3_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D2F3_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D2F3_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D2F3_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D2F3_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D2F3_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D2F3_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D2F3_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D2F3_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D2F3_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D2F3_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D2F3_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D2F3_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D2F3_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D2F3_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D2F3_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D2F3_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D2F3_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D2F3_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D2F3_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D2F3_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D2F3_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D2F3_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D2F3_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D2F3_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D2F3_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D2F3_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D2F3_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D2F3_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D2F3_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D2F3_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D2F3_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D2F3_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D2F3_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D2F3_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D2F3_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D2F3_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D2F3_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D2F3_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D2F3_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D2F3_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D2F3_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D2F3_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D2F3_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D2F3_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D2F3_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D2F3_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D2F3_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D2F3_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D2F3_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D2F3_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D2F3_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D2F3_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D2F3_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D2F3_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D2F3_COMMAND__AD_STEPPING_MASK 0x80
#define D2F3_COMMAND__AD_STEPPING__SHIFT 0x7
#define D2F3_COMMAND__SERR_EN_MASK 0x100
#define D2F3_COMMAND__SERR_EN__SHIFT 0x8
#define D2F3_COMMAND__FAST_B2B_EN_MASK 0x200
#define D2F3_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D2F3_COMMAND__INT_DIS_MASK 0x400
#define D2F3_COMMAND__INT_DIS__SHIFT 0xa
#define D2F3_STATUS__INT_STATUS_MASK 0x80000
#define D2F3_STATUS__INT_STATUS__SHIFT 0x13
#define D2F3_STATUS__CAP_LIST_MASK 0x100000
#define D2F3_STATUS__CAP_LIST__SHIFT 0x14
#define D2F3_STATUS__PCI_66_EN_MASK 0x200000
#define D2F3_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F3_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F3_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F3_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F3_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F3_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F3_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F3_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F3_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F3_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F3_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F3_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F3_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F3_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D2F3_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F3_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F3_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F3_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D2F3_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D2F3_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D2F3_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D2F3_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D2F3_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D2F3_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D2F3_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D2F3_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D2F3_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D2F3_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D2F3_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D2F3_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D2F3_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D2F3_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D2F3_HEADER__HEADER_TYPE__SHIFT 0x10
#define D2F3_HEADER__DEVICE_TYPE_MASK 0x800000
#define D2F3_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D2F3_BIST__BIST_COMP_MASK 0xf000000
#define D2F3_BIST__BIST_COMP__SHIFT 0x18
#define D2F3_BIST__BIST_STRT_MASK 0x40000000
#define D2F3_BIST__BIST_STRT__SHIFT 0x1e
#define D2F3_BIST__BIST_CAP_MASK 0x80000000
#define D2F3_BIST__BIST_CAP__SHIFT 0x1f
#define D2F3_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D2F3_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D2F3_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D2F3_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D2F3_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D2F3_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D2F3_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D2F3_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D2F3_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D2F3_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D2F3_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D2F3_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D2F3_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D2F3_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D2F3_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D2F3_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D2F3_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D2F3_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D2F3_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D2F3_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F3_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F3_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F3_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F3_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F3_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F3_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F3_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F3_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F3_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F3_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F3_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F3_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F3_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D2F3_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F3_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F3_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F3_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D2F3_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D2F3_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D2F3_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D2F3_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F3_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F3_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F3_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F3_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D2F3_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D2F3_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D2F3_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D2F3_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D2F3_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D2F3_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D2F3_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D2F3_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D2F3_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D2F3_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D2F3_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D2F3_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D2F3_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D2F3_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D2F3_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D2F3_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D2F3_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D2F3_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D2F3_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D2F3_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D2F3_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D2F3_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D2F3_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D2F3_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D2F3_CAP_PTR__CAP_PTR_MASK 0xff
#define D2F3_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D2F3_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D2F3_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D2F3_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D2F3_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D2F3_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D2F3_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D2F3_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F3_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F3_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F3_PMI_CAP__VERSION_MASK 0x70000
#define D2F3_PMI_CAP__VERSION__SHIFT 0x10
#define D2F3_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D2F3_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D2F3_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D2F3_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D2F3_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D2F3_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D2F3_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D2F3_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D2F3_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D2F3_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D2F3_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D2F3_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D2F3_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D2F3_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D2F3_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D2F3_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D2F3_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D2F3_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D2F3_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D2F3_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D2F3_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D2F3_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D2F3_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D2F3_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D2F3_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D2F3_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D2F3_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D2F3_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D2F3_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D2F3_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D2F3_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D2F3_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F3_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F3_PCIE_CAP__VERSION_MASK 0xf0000
#define D2F3_PCIE_CAP__VERSION__SHIFT 0x10
#define D2F3_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D2F3_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D2F3_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D2F3_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D2F3_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D2F3_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D2F3_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D2F3_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D2F3_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D2F3_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D2F3_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D2F3_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D2F3_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D2F3_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D2F3_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D2F3_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D2F3_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D2F3_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D2F3_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D2F3_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D2F3_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D2F3_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D2F3_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D2F3_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D2F3_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D2F3_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D2F3_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D2F3_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D2F3_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D2F3_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D2F3_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D2F3_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D2F3_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D2F3_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D2F3_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D2F3_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D2F3_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D2F3_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D2F3_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D2F3_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D2F3_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D2F3_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D2F3_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D2F3_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D2F3_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D2F3_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D2F3_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D2F3_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D2F3_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D2F3_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D2F3_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D2F3_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D2F3_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D2F3_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D2F3_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D2F3_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D2F3_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D2F3_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D2F3_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D2F3_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D2F3_LINK_CAP__LINK_SPEED_MASK 0xf
#define D2F3_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D2F3_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D2F3_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D2F3_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D2F3_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D2F3_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D2F3_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D2F3_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D2F3_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D2F3_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D2F3_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D2F3_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D2F3_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D2F3_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D2F3_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D2F3_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D2F3_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D2F3_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D2F3_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D2F3_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D2F3_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D2F3_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D2F3_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D2F3_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D2F3_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D2F3_LINK_CNTL__LINK_DIS_MASK 0x10
#define D2F3_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D2F3_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D2F3_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D2F3_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D2F3_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D2F3_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D2F3_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D2F3_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D2F3_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D2F3_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D2F3_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D2F3_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D2F3_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D2F3_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D2F3_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D2F3_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D2F3_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D2F3_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D2F3_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D2F3_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D2F3_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D2F3_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D2F3_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D2F3_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D2F3_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D2F3_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D2F3_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D2F3_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D2F3_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D2F3_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D2F3_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D2F3_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D2F3_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D2F3_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D2F3_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D2F3_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D2F3_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D2F3_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D2F3_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D2F3_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D2F3_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D2F3_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D2F3_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D2F3_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D2F3_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D2F3_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D2F3_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D2F3_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D2F3_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D2F3_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D2F3_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D2F3_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D2F3_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D2F3_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D2F3_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D2F3_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D2F3_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D2F3_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D2F3_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D2F3_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D2F3_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D2F3_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D2F3_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D2F3_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D2F3_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D2F3_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D2F3_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D2F3_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D2F3_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D2F3_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D2F3_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D2F3_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D2F3_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D2F3_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D2F3_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D2F3_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D2F3_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D2F3_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D2F3_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D2F3_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D2F3_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D2F3_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D2F3_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D2F3_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D2F3_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D2F3_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D2F3_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D2F3_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D2F3_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D2F3_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D2F3_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D2F3_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D2F3_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D2F3_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D2F3_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D2F3_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D2F3_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D2F3_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D2F3_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D2F3_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D2F3_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D2F3_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D2F3_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D2F3_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D2F3_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D2F3_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D2F3_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D2F3_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D2F3_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D2F3_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D2F3_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D2F3_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D2F3_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D2F3_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D2F3_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D2F3_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D2F3_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D2F3_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D2F3_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D2F3_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D2F3_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D2F3_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D2F3_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D2F3_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D2F3_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D2F3_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D2F3_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D2F3_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D2F3_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D2F3_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D2F3_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D2F3_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D2F3_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D2F3_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D2F3_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D2F3_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D2F3_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D2F3_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D2F3_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D2F3_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D2F3_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D2F3_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D2F3_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D2F3_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D2F3_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D2F3_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D2F3_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D2F3_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D2F3_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D2F3_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D2F3_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D2F3_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D2F3_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D2F3_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D2F3_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D2F3_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D2F3_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D2F3_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D2F3_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D2F3_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D2F3_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D2F3_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D2F3_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D2F3_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D2F3_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D2F3_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D2F3_LINK_CAP2__RESERVED__SHIFT 0x9
#define D2F3_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D2F3_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D2F3_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D2F3_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D2F3_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D2F3_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D2F3_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D2F3_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D2F3_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D2F3_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D2F3_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D2F3_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D2F3_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D2F3_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D2F3_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D2F3_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D2F3_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D2F3_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D2F3_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D2F3_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D2F3_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D2F3_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D2F3_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D2F3_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D2F3_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D2F3_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D2F3_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D2F3_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D2F3_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D2F3_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F3_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F3_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F3_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D2F3_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D2F3_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D2F3_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D2F3_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D2F3_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D2F3_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D2F3_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D2F3_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D2F3_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D2F3_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D2F3_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D2F3_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D2F3_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D2F3_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D2F3_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D2F3_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D2F3_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D2F3_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D2F3_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F3_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F3_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D2F3_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D2F3_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D2F3_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D2F3_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D2F3_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F3_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F3_MSI_MAP_CAP__EN_MASK 0x10000
#define D2F3_MSI_MAP_CAP__EN__SHIFT 0x10
#define D2F3_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D2F3_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D2F3_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D2F3_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D2F3_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D2F3_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D2F3_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D2F3_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D2F3_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D2F3_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D2F3_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D2F3_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D2F3_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D2F3_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D2F3_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D2F3_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D2F3_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D2F3_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D2F3_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D2F3_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D2F3_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D2F3_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D2F3_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D2F3_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F3_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F3_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D2F3_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D2F3_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D2F3_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D2F3_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D2F3_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F3_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F3_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F3_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F3_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F3_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F3_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F3_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F3_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F3_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F3_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F3_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F3_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F3_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F3_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F3_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F3_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F3_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F3_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F3_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F3_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F3_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F3_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F3_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F3_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F3_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F3_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F3_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F3_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F3_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F3_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F3_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F3_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F3_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F3_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F3_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F3_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F3_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F3_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F3_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F3_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F3_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F3_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F3_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F3_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F3_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F3_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F3_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F3_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D2F3_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D2F3_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D2F3_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D2F3_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D2F3_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D2F3_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D2F3_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D2F3_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D2F3_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D2F3_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D2F3_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D2F3_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D2F3_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D2F3_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D2F3_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D2F3_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D2F3_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D2F3_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D2F3_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D2F3_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D2F3_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D2F3_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D2F3_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D2F3_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D2F3_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D2F3_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D2F3_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D2F3_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D2F3_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D2F3_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D2F3_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D2F3_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D2F3_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D2F3_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D2F3_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D2F3_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D2F3_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D2F3_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D2F3_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D2F3_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D2F3_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D2F3_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D2F3_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D2F3_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D2F3_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D2F3_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D2F3_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D2F3_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D2F3_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D2F3_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D2F3_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D2F3_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D2F3_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D2F3_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D2F3_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D2F3_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D2F3_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D2F3_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D2F3_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D2F3_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D2F3_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D2F3_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D2F3_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D2F3_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D2F3_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D2F3_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D2F3_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D2F3_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D2F3_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D2F3_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D2F3_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D2F3_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D2F3_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D2F3_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D2F3_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D2F3_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D2F3_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D2F3_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D2F3_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D2F3_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D2F3_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D2F3_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D2F3_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D2F3_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D2F3_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D2F3_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D2F3_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D2F3_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D2F3_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D2F3_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D2F3_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D2F3_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D2F3_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D2F3_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D2F3_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D2F3_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D2F3_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D2F3_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D2F3_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D2F3_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D2F3_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D2F3_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D2F3_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D2F3_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D2F3_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D2F3_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D2F3_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D2F3_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D2F3_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D2F3_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D2F3_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D2F3_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D2F3_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D2F3_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D2F3_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D2F3_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D2F3_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D2F3_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D2F3_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D2F3_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D2F3_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D2F3_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D2F3_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D2F3_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D2F3_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D2F3_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D2F3_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D2F3_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D2F3_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D2F3_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D2F3_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D2F3_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D2F3_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D2F3_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D2F3_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D2F3_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D2F3_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D2F3_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D2F3_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D2F3_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D2F3_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D2F3_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D2F3_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D2F3_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D2F3_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D2F3_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F3_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F3_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F3_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define D2F3_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define D2F3_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define D2F3_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define D2F3_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define D2F3_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define D2F3_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define D2F3_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define D2F3_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define D2F3_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define D2F3_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define D2F3_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define D2F3_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define D2F3_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define D2F3_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define D2F3_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define D2F3_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x10000
#define D2F3_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x10
#define D2F3_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x20000
#define D2F3_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x11
#define D2F3_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x40000
#define D2F3_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x12
#define D2F3_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x80000
#define D2F3_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x13
#define D2F3_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x100000
#define D2F3_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x14
#define D2F3_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x200000
#define D2F3_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x15
#define D2F3_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x400000
#define D2F3_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x16
#define D2F3_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F3_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F3_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F3_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F3_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F3_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F3_PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define D2F3_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define D2F3_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define D2F3_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define D2F3_PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f0000
#define D2F3_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x10
#define D2F3_PCIE_MC_CNTL__MC_ENABLE_MASK 0x80000000
#define D2F3_PCIE_MC_CNTL__MC_ENABLE__SHIFT 0x1f
#define D2F3_PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define D2F3_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define D2F3_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define D2F3_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define D2F3_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define D2F3_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define D2F3_PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define D2F3_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define D2F3_PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define D2F3_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define D2F3_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define D2F3_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define D2F3_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define D2F3_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define D2F3_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define D2F3_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define D2F3_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define D2F3_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define D2F3_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE_MASK 0x3f
#define D2F3_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE__SHIFT 0x0
#define D2F3_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0_MASK 0xffffffc0
#define D2F3_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0__SHIFT 0x6
#define D2F3_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1_MASK 0xffffffff
#define D2F3_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1__SHIFT 0x0
#define D2F4_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D2F4_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D2F4_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D2F4_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D2F4_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D2F4_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D2F4_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D2F4_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D2F4_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D2F4_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D2F4_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D2F4_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D2F4_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D2F4_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D2F4_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D2F4_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D2F4_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D2F4_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D2F4_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D2F4_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D2F4_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D2F4_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D2F4_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D2F4_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D2F4_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D2F4_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D2F4_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D2F4_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D2F4_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D2F4_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D2F4_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D2F4_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D2F4_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D2F4_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D2F4_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D2F4_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D2F4_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D2F4_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D2F4_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D2F4_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D2F4_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D2F4_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D2F4_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D2F4_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D2F4_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D2F4_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D2F4_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D2F4_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D2F4_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D2F4_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D2F4_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D2F4_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D2F4_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D2F4_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D2F4_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D2F4_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D2F4_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D2F4_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D2F4_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D2F4_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D2F4_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D2F4_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D2F4_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D2F4_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D2F4_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D2F4_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D2F4_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D2F4_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D2F4_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D2F4_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D2F4_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D2F4_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D2F4_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D2F4_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D2F4_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D2F4_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D2F4_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D2F4_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D2F4_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D2F4_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D2F4_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D2F4_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D2F4_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D2F4_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D2F4_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D2F4_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D2F4_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D2F4_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D2F4_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D2F4_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D2F4_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D2F4_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D2F4_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D2F4_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D2F4_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D2F4_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D2F4_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D2F4_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D2F4_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D2F4_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D2F4_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D2F4_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D2F4_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D2F4_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D2F4_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D2F4_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D2F4_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D2F4_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D2F4_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D2F4_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D2F4_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D2F4_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D2F4_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D2F4_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D2F4_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D2F4_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D2F4_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D2F4_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D2F4_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D2F4_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D2F4_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D2F4_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D2F4_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D2F4_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D2F4_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D2F4_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D2F4_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D2F4_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D2F4_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D2F4_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D2F4_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D2F4_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D2F4_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D2F4_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D2F4_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D2F4_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D2F4_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D2F4_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D2F4_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D2F4_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D2F4_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D2F4_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D2F4_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D2F4_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D2F4_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D2F4_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D2F4_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D2F4_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D2F4_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D2F4_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D2F4_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D2F4_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D2F4_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D2F4_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D2F4_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D2F4_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D2F4_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D2F4_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D2F4_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D2F4_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D2F4_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D2F4_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D2F4_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D2F4_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D2F4_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D2F4_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D2F4_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D2F4_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D2F4_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D2F4_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D2F4_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D2F4_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D2F4_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D2F4_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D2F4_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D2F4_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D2F4_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D2F4_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D2F4_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D2F4_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D2F4_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D2F4_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D2F4_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D2F4_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D2F4_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D2F4_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D2F4_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D2F4_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D2F4_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D2F4_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D2F4_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D2F4_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D2F4_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D2F4_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D2F4_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D2F4_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D2F4_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D2F4_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D2F4_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D2F4_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D2F4_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D2F4_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D2F4_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D2F4_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D2F4_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D2F4_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D2F4_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D2F4_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D2F4_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D2F4_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D2F4_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D2F4_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D2F4_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D2F4_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D2F4_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D2F4_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D2F4_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D2F4_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D2F4_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D2F4_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D2F4_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D2F4_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D2F4_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D2F4_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D2F4_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D2F4_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D2F4_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D2F4_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D2F4_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D2F4_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D2F4_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D2F4_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D2F4_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D2F4_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D2F4_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D2F4_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D2F4_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D2F4_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D2F4_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D2F4_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D2F4_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D2F4_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D2F4_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D2F4_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D2F4_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D2F4_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D2F4_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D2F4_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D2F4_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D2F4_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D2F4_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D2F4_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D2F4_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D2F4_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D2F4_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D2F4_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D2F4_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D2F4_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D2F4_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D2F4_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D2F4_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D2F4_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D2F4_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D2F4_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D2F4_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D2F4_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D2F4_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D2F4_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D2F4_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D2F4_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D2F4_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D2F4_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D2F4_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D2F4_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D2F4_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D2F4_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D2F4_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D2F4_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D2F4_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D2F4_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D2F4_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D2F4_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D2F4_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D2F4_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D2F4_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D2F4_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D2F4_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D2F4_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D2F4_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D2F4_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D2F4_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D2F4_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D2F4_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D2F4_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D2F4_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D2F4_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D2F4_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D2F4_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D2F4_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D2F4_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D2F4_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D2F4_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D2F4_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D2F4_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D2F4_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D2F4_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D2F4_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D2F4_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D2F4_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D2F4_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D2F4_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D2F4_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D2F4_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D2F4_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D2F4_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D2F4_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D2F4_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D2F4_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D2F4_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D2F4_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D2F4_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D2F4_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D2F4_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D2F4_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D2F4_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D2F4_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D2F4_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D2F4_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D2F4_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D2F4_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D2F4_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D2F4_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D2F4_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D2F4_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D2F4_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D2F4_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D2F4_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D2F4_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D2F4_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D2F4_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D2F4_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D2F4_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D2F4_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D2F4_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D2F4_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D2F4_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D2F4_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D2F4_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D2F4_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D2F4_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D2F4_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D2F4_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D2F4_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D2F4_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D2F4_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D2F4_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D2F4_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D2F4_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D2F4_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D2F4_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D2F4_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D2F4_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D2F4_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D2F4_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D2F4_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D2F4_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D2F4_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D2F4_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D2F4_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D2F4_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D2F4_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D2F4_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D2F4_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D2F4_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D2F4_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D2F4_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D2F4_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D2F4_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D2F4_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D2F4_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D2F4_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D2F4_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D2F4_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D2F4_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D2F4_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D2F4_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D2F4_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D2F4_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D2F4_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D2F4_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D2F4_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D2F4_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D2F4_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D2F4_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D2F4_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D2F4_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D2F4_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D2F4_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D2F4_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D2F4_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D2F4_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D2F4_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D2F4_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D2F4_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D2F4_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D2F4_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D2F4_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D2F4_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D2F4_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D2F4_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D2F4_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D2F4_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D2F4_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D2F4_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D2F4_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D2F4_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D2F4_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D2F4_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D2F4_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D2F4_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D2F4_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D2F4_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D2F4_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D2F4_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D2F4_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D2F4_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D2F4_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D2F4_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D2F4_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D2F4_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D2F4_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D2F4_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D2F4_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D2F4_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D2F4_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D2F4_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D2F4_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D2F4_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D2F4_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D2F4_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D2F4_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D2F4_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D2F4_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D2F4_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D2F4_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D2F4_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D2F4_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D2F4_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D2F4_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D2F4_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D2F4_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D2F4_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D2F4_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D2F4_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D2F4_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D2F4_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D2F4_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D2F4_COMMAND__AD_STEPPING_MASK 0x80
#define D2F4_COMMAND__AD_STEPPING__SHIFT 0x7
#define D2F4_COMMAND__SERR_EN_MASK 0x100
#define D2F4_COMMAND__SERR_EN__SHIFT 0x8
#define D2F4_COMMAND__FAST_B2B_EN_MASK 0x200
#define D2F4_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D2F4_COMMAND__INT_DIS_MASK 0x400
#define D2F4_COMMAND__INT_DIS__SHIFT 0xa
#define D2F4_STATUS__INT_STATUS_MASK 0x80000
#define D2F4_STATUS__INT_STATUS__SHIFT 0x13
#define D2F4_STATUS__CAP_LIST_MASK 0x100000
#define D2F4_STATUS__CAP_LIST__SHIFT 0x14
#define D2F4_STATUS__PCI_66_EN_MASK 0x200000
#define D2F4_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F4_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F4_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F4_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F4_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F4_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F4_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F4_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F4_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F4_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F4_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F4_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F4_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F4_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D2F4_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F4_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F4_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F4_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D2F4_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D2F4_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D2F4_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D2F4_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D2F4_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D2F4_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D2F4_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D2F4_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D2F4_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D2F4_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D2F4_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D2F4_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D2F4_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D2F4_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D2F4_HEADER__HEADER_TYPE__SHIFT 0x10
#define D2F4_HEADER__DEVICE_TYPE_MASK 0x800000
#define D2F4_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D2F4_BIST__BIST_COMP_MASK 0xf000000
#define D2F4_BIST__BIST_COMP__SHIFT 0x18
#define D2F4_BIST__BIST_STRT_MASK 0x40000000
#define D2F4_BIST__BIST_STRT__SHIFT 0x1e
#define D2F4_BIST__BIST_CAP_MASK 0x80000000
#define D2F4_BIST__BIST_CAP__SHIFT 0x1f
#define D2F4_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D2F4_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D2F4_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D2F4_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D2F4_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D2F4_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D2F4_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D2F4_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D2F4_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D2F4_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D2F4_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D2F4_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D2F4_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D2F4_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D2F4_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D2F4_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D2F4_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D2F4_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D2F4_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D2F4_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F4_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F4_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F4_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F4_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F4_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F4_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F4_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F4_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F4_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F4_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F4_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F4_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F4_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D2F4_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F4_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F4_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F4_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D2F4_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D2F4_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D2F4_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D2F4_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F4_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F4_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F4_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F4_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D2F4_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D2F4_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D2F4_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D2F4_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D2F4_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D2F4_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D2F4_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D2F4_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D2F4_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D2F4_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D2F4_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D2F4_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D2F4_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D2F4_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D2F4_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D2F4_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D2F4_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D2F4_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D2F4_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D2F4_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D2F4_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D2F4_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D2F4_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D2F4_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D2F4_CAP_PTR__CAP_PTR_MASK 0xff
#define D2F4_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D2F4_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D2F4_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D2F4_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D2F4_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D2F4_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D2F4_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D2F4_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F4_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F4_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F4_PMI_CAP__VERSION_MASK 0x70000
#define D2F4_PMI_CAP__VERSION__SHIFT 0x10
#define D2F4_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D2F4_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D2F4_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D2F4_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D2F4_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D2F4_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D2F4_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D2F4_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D2F4_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D2F4_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D2F4_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D2F4_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D2F4_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D2F4_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D2F4_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D2F4_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D2F4_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D2F4_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D2F4_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D2F4_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D2F4_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D2F4_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D2F4_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D2F4_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D2F4_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D2F4_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D2F4_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D2F4_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D2F4_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D2F4_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D2F4_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D2F4_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F4_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F4_PCIE_CAP__VERSION_MASK 0xf0000
#define D2F4_PCIE_CAP__VERSION__SHIFT 0x10
#define D2F4_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D2F4_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D2F4_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D2F4_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D2F4_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D2F4_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D2F4_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D2F4_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D2F4_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D2F4_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D2F4_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D2F4_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D2F4_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D2F4_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D2F4_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D2F4_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D2F4_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D2F4_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D2F4_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D2F4_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D2F4_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D2F4_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D2F4_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D2F4_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D2F4_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D2F4_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D2F4_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D2F4_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D2F4_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D2F4_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D2F4_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D2F4_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D2F4_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D2F4_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D2F4_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D2F4_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D2F4_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D2F4_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D2F4_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D2F4_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D2F4_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D2F4_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D2F4_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D2F4_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D2F4_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D2F4_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D2F4_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D2F4_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D2F4_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D2F4_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D2F4_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D2F4_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D2F4_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D2F4_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D2F4_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D2F4_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D2F4_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D2F4_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D2F4_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D2F4_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D2F4_LINK_CAP__LINK_SPEED_MASK 0xf
#define D2F4_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D2F4_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D2F4_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D2F4_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D2F4_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D2F4_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D2F4_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D2F4_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D2F4_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D2F4_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D2F4_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D2F4_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D2F4_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D2F4_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D2F4_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D2F4_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D2F4_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D2F4_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D2F4_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D2F4_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D2F4_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D2F4_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D2F4_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D2F4_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D2F4_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D2F4_LINK_CNTL__LINK_DIS_MASK 0x10
#define D2F4_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D2F4_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D2F4_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D2F4_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D2F4_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D2F4_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D2F4_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D2F4_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D2F4_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D2F4_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D2F4_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D2F4_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D2F4_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D2F4_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D2F4_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D2F4_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D2F4_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D2F4_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D2F4_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D2F4_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D2F4_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D2F4_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D2F4_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D2F4_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D2F4_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D2F4_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D2F4_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D2F4_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D2F4_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D2F4_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D2F4_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D2F4_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D2F4_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D2F4_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D2F4_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D2F4_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D2F4_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D2F4_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D2F4_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D2F4_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D2F4_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D2F4_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D2F4_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D2F4_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D2F4_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D2F4_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D2F4_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D2F4_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D2F4_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D2F4_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D2F4_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D2F4_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D2F4_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D2F4_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D2F4_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D2F4_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D2F4_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D2F4_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D2F4_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D2F4_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D2F4_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D2F4_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D2F4_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D2F4_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D2F4_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D2F4_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D2F4_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D2F4_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D2F4_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D2F4_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D2F4_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D2F4_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D2F4_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D2F4_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D2F4_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D2F4_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D2F4_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D2F4_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D2F4_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D2F4_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D2F4_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D2F4_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D2F4_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D2F4_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D2F4_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D2F4_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D2F4_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D2F4_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D2F4_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D2F4_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D2F4_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D2F4_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D2F4_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D2F4_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D2F4_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D2F4_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D2F4_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D2F4_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D2F4_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D2F4_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D2F4_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D2F4_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D2F4_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D2F4_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D2F4_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D2F4_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D2F4_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D2F4_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D2F4_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D2F4_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D2F4_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D2F4_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D2F4_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D2F4_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D2F4_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D2F4_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D2F4_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D2F4_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D2F4_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D2F4_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D2F4_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D2F4_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D2F4_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D2F4_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D2F4_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D2F4_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D2F4_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D2F4_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D2F4_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D2F4_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D2F4_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D2F4_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D2F4_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D2F4_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D2F4_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D2F4_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D2F4_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D2F4_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D2F4_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D2F4_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D2F4_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D2F4_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D2F4_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D2F4_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D2F4_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D2F4_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D2F4_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D2F4_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D2F4_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D2F4_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D2F4_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D2F4_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D2F4_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D2F4_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D2F4_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D2F4_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D2F4_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D2F4_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D2F4_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D2F4_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D2F4_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D2F4_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D2F4_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D2F4_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D2F4_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D2F4_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D2F4_LINK_CAP2__RESERVED__SHIFT 0x9
#define D2F4_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D2F4_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D2F4_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D2F4_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D2F4_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D2F4_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D2F4_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D2F4_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D2F4_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D2F4_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D2F4_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D2F4_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D2F4_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D2F4_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D2F4_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D2F4_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D2F4_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D2F4_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D2F4_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D2F4_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D2F4_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D2F4_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D2F4_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D2F4_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D2F4_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D2F4_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D2F4_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D2F4_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D2F4_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D2F4_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F4_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F4_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F4_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D2F4_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D2F4_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D2F4_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D2F4_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D2F4_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D2F4_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D2F4_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D2F4_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D2F4_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D2F4_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D2F4_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D2F4_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D2F4_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D2F4_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D2F4_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D2F4_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D2F4_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D2F4_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D2F4_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F4_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F4_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D2F4_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D2F4_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D2F4_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D2F4_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D2F4_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F4_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F4_MSI_MAP_CAP__EN_MASK 0x10000
#define D2F4_MSI_MAP_CAP__EN__SHIFT 0x10
#define D2F4_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D2F4_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D2F4_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D2F4_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D2F4_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D2F4_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D2F4_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D2F4_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D2F4_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D2F4_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D2F4_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D2F4_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D2F4_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D2F4_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D2F4_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D2F4_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D2F4_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D2F4_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D2F4_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D2F4_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D2F4_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D2F4_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D2F4_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D2F4_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F4_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F4_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D2F4_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D2F4_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D2F4_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D2F4_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D2F4_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F4_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F4_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F4_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F4_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F4_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F4_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F4_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F4_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F4_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F4_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F4_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F4_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F4_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F4_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F4_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F4_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F4_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F4_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F4_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F4_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F4_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F4_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F4_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F4_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F4_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F4_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F4_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F4_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F4_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F4_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F4_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F4_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F4_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F4_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F4_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F4_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F4_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F4_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F4_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F4_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F4_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F4_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F4_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F4_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F4_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F4_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F4_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F4_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D2F4_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D2F4_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D2F4_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D2F4_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D2F4_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D2F4_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D2F4_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D2F4_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D2F4_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D2F4_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D2F4_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D2F4_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D2F4_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D2F4_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D2F4_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D2F4_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D2F4_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D2F4_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D2F4_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D2F4_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D2F4_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D2F4_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D2F4_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D2F4_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D2F4_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D2F4_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D2F4_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D2F4_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D2F4_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D2F4_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D2F4_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D2F4_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D2F4_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D2F4_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D2F4_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D2F4_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D2F4_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D2F4_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D2F4_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D2F4_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D2F4_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D2F4_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D2F4_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D2F4_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D2F4_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D2F4_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D2F4_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D2F4_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D2F4_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D2F4_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D2F4_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D2F4_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D2F4_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D2F4_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D2F4_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D2F4_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D2F4_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D2F4_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D2F4_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D2F4_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D2F4_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D2F4_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D2F4_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D2F4_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D2F4_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D2F4_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D2F4_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D2F4_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D2F4_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D2F4_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D2F4_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D2F4_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D2F4_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D2F4_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D2F4_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D2F4_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D2F4_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D2F4_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D2F4_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D2F4_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D2F4_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D2F4_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D2F4_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D2F4_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D2F4_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D2F4_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D2F4_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D2F4_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D2F4_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D2F4_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D2F4_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D2F4_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D2F4_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D2F4_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D2F4_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D2F4_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D2F4_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D2F4_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D2F4_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D2F4_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D2F4_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D2F4_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D2F4_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D2F4_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D2F4_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D2F4_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D2F4_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D2F4_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D2F4_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D2F4_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D2F4_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D2F4_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D2F4_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D2F4_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D2F4_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D2F4_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D2F4_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D2F4_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D2F4_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D2F4_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D2F4_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D2F4_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D2F4_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D2F4_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D2F4_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D2F4_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D2F4_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D2F4_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D2F4_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D2F4_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D2F4_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D2F4_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D2F4_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D2F4_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D2F4_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D2F4_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D2F4_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D2F4_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D2F4_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D2F4_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D2F4_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D2F4_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D2F4_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D2F4_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D2F4_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D2F4_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F4_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F4_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F4_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define D2F4_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define D2F4_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define D2F4_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define D2F4_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define D2F4_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define D2F4_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define D2F4_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define D2F4_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define D2F4_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define D2F4_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define D2F4_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define D2F4_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define D2F4_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define D2F4_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define D2F4_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define D2F4_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x10000
#define D2F4_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x10
#define D2F4_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x20000
#define D2F4_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x11
#define D2F4_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x40000
#define D2F4_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x12
#define D2F4_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x80000
#define D2F4_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x13
#define D2F4_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x100000
#define D2F4_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x14
#define D2F4_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x200000
#define D2F4_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x15
#define D2F4_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x400000
#define D2F4_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x16
#define D2F4_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F4_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F4_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F4_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F4_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F4_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F4_PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define D2F4_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define D2F4_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define D2F4_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define D2F4_PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f0000
#define D2F4_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x10
#define D2F4_PCIE_MC_CNTL__MC_ENABLE_MASK 0x80000000
#define D2F4_PCIE_MC_CNTL__MC_ENABLE__SHIFT 0x1f
#define D2F4_PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define D2F4_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define D2F4_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define D2F4_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define D2F4_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define D2F4_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define D2F4_PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define D2F4_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define D2F4_PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define D2F4_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define D2F4_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define D2F4_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define D2F4_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define D2F4_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define D2F4_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define D2F4_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define D2F4_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define D2F4_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define D2F4_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE_MASK 0x3f
#define D2F4_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE__SHIFT 0x0
#define D2F4_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0_MASK 0xffffffc0
#define D2F4_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0__SHIFT 0x6
#define D2F4_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1_MASK 0xffffffff
#define D2F4_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1__SHIFT 0x0
#define D2F5_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D2F5_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D2F5_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D2F5_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D2F5_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D2F5_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D2F5_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D2F5_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D2F5_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D2F5_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D2F5_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D2F5_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D2F5_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D2F5_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D2F5_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D2F5_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D2F5_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D2F5_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D2F5_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D2F5_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D2F5_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D2F5_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D2F5_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D2F5_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D2F5_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D2F5_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D2F5_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D2F5_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D2F5_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D2F5_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D2F5_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D2F5_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D2F5_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D2F5_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D2F5_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D2F5_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D2F5_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D2F5_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D2F5_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D2F5_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D2F5_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D2F5_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D2F5_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D2F5_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D2F5_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D2F5_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D2F5_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D2F5_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D2F5_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D2F5_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D2F5_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D2F5_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D2F5_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D2F5_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D2F5_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D2F5_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D2F5_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D2F5_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D2F5_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D2F5_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D2F5_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D2F5_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D2F5_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D2F5_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D2F5_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D2F5_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D2F5_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D2F5_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D2F5_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D2F5_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D2F5_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D2F5_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D2F5_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D2F5_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D2F5_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D2F5_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D2F5_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D2F5_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D2F5_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D2F5_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D2F5_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D2F5_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D2F5_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D2F5_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D2F5_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D2F5_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D2F5_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D2F5_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D2F5_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D2F5_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D2F5_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D2F5_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D2F5_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D2F5_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D2F5_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D2F5_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D2F5_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D2F5_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D2F5_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D2F5_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D2F5_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D2F5_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D2F5_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D2F5_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D2F5_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D2F5_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D2F5_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D2F5_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D2F5_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D2F5_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D2F5_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D2F5_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D2F5_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D2F5_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D2F5_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D2F5_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D2F5_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D2F5_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D2F5_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D2F5_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D2F5_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D2F5_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D2F5_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D2F5_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D2F5_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D2F5_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D2F5_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D2F5_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D2F5_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D2F5_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D2F5_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D2F5_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D2F5_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D2F5_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D2F5_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D2F5_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D2F5_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D2F5_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D2F5_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D2F5_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D2F5_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D2F5_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D2F5_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D2F5_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D2F5_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D2F5_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D2F5_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D2F5_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D2F5_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D2F5_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D2F5_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D2F5_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D2F5_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D2F5_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D2F5_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D2F5_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D2F5_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D2F5_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D2F5_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D2F5_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D2F5_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D2F5_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D2F5_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D2F5_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D2F5_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D2F5_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D2F5_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D2F5_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D2F5_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D2F5_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D2F5_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D2F5_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D2F5_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D2F5_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D2F5_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D2F5_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D2F5_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D2F5_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D2F5_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D2F5_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D2F5_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D2F5_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D2F5_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D2F5_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D2F5_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D2F5_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D2F5_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D2F5_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D2F5_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D2F5_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D2F5_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D2F5_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D2F5_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D2F5_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D2F5_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D2F5_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D2F5_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D2F5_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D2F5_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D2F5_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D2F5_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D2F5_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D2F5_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D2F5_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D2F5_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D2F5_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D2F5_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D2F5_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D2F5_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D2F5_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D2F5_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D2F5_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D2F5_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D2F5_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D2F5_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D2F5_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D2F5_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D2F5_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D2F5_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D2F5_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D2F5_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D2F5_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D2F5_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D2F5_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D2F5_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D2F5_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D2F5_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D2F5_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D2F5_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D2F5_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D2F5_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D2F5_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D2F5_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D2F5_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D2F5_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D2F5_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D2F5_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D2F5_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D2F5_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D2F5_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D2F5_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D2F5_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D2F5_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D2F5_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D2F5_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D2F5_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D2F5_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D2F5_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D2F5_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D2F5_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D2F5_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D2F5_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D2F5_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D2F5_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D2F5_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D2F5_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D2F5_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D2F5_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D2F5_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D2F5_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D2F5_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D2F5_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D2F5_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D2F5_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D2F5_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D2F5_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D2F5_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D2F5_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D2F5_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D2F5_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D2F5_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D2F5_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D2F5_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D2F5_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D2F5_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D2F5_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D2F5_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D2F5_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D2F5_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D2F5_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D2F5_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D2F5_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D2F5_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D2F5_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D2F5_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D2F5_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D2F5_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D2F5_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D2F5_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D2F5_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D2F5_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D2F5_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D2F5_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D2F5_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D2F5_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D2F5_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D2F5_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D2F5_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D2F5_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D2F5_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D2F5_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D2F5_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D2F5_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D2F5_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D2F5_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D2F5_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D2F5_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D2F5_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D2F5_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D2F5_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D2F5_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D2F5_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D2F5_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D2F5_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D2F5_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D2F5_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D2F5_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D2F5_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D2F5_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D2F5_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D2F5_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D2F5_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D2F5_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D2F5_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D2F5_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D2F5_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D2F5_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D2F5_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D2F5_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D2F5_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D2F5_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D2F5_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D2F5_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D2F5_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D2F5_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D2F5_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D2F5_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D2F5_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D2F5_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D2F5_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D2F5_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D2F5_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D2F5_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D2F5_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D2F5_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D2F5_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D2F5_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D2F5_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D2F5_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D2F5_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D2F5_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D2F5_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D2F5_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D2F5_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D2F5_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D2F5_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D2F5_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D2F5_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D2F5_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D2F5_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D2F5_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D2F5_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D2F5_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D2F5_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D2F5_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D2F5_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D2F5_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D2F5_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D2F5_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D2F5_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D2F5_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D2F5_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D2F5_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D2F5_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D2F5_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D2F5_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D2F5_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D2F5_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D2F5_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D2F5_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D2F5_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D2F5_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D2F5_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D2F5_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D2F5_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D2F5_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D2F5_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D2F5_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D2F5_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D2F5_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D2F5_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D2F5_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D2F5_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D2F5_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D2F5_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D2F5_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D2F5_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D2F5_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D2F5_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D2F5_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D2F5_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D2F5_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D2F5_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D2F5_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D2F5_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D2F5_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D2F5_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D2F5_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D2F5_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D2F5_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D2F5_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D2F5_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D2F5_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D2F5_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D2F5_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D2F5_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D2F5_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D2F5_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D2F5_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D2F5_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D2F5_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D2F5_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D2F5_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D2F5_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D2F5_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D2F5_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D2F5_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D2F5_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D2F5_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D2F5_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D2F5_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D2F5_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D2F5_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D2F5_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D2F5_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D2F5_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D2F5_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D2F5_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D2F5_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D2F5_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D2F5_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D2F5_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D2F5_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D2F5_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D2F5_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D2F5_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D2F5_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D2F5_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D2F5_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D2F5_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D2F5_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D2F5_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D2F5_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D2F5_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D2F5_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D2F5_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D2F5_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D2F5_COMMAND__AD_STEPPING_MASK 0x80
#define D2F5_COMMAND__AD_STEPPING__SHIFT 0x7
#define D2F5_COMMAND__SERR_EN_MASK 0x100
#define D2F5_COMMAND__SERR_EN__SHIFT 0x8
#define D2F5_COMMAND__FAST_B2B_EN_MASK 0x200
#define D2F5_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D2F5_COMMAND__INT_DIS_MASK 0x400
#define D2F5_COMMAND__INT_DIS__SHIFT 0xa
#define D2F5_STATUS__INT_STATUS_MASK 0x80000
#define D2F5_STATUS__INT_STATUS__SHIFT 0x13
#define D2F5_STATUS__CAP_LIST_MASK 0x100000
#define D2F5_STATUS__CAP_LIST__SHIFT 0x14
#define D2F5_STATUS__PCI_66_EN_MASK 0x200000
#define D2F5_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F5_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F5_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F5_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F5_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F5_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F5_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F5_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F5_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F5_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F5_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F5_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F5_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F5_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D2F5_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F5_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F5_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F5_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D2F5_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D2F5_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D2F5_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D2F5_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D2F5_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D2F5_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D2F5_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D2F5_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D2F5_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D2F5_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D2F5_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D2F5_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D2F5_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D2F5_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D2F5_HEADER__HEADER_TYPE__SHIFT 0x10
#define D2F5_HEADER__DEVICE_TYPE_MASK 0x800000
#define D2F5_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D2F5_BIST__BIST_COMP_MASK 0xf000000
#define D2F5_BIST__BIST_COMP__SHIFT 0x18
#define D2F5_BIST__BIST_STRT_MASK 0x40000000
#define D2F5_BIST__BIST_STRT__SHIFT 0x1e
#define D2F5_BIST__BIST_CAP_MASK 0x80000000
#define D2F5_BIST__BIST_CAP__SHIFT 0x1f
#define D2F5_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D2F5_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D2F5_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D2F5_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D2F5_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D2F5_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D2F5_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D2F5_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D2F5_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D2F5_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D2F5_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D2F5_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D2F5_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D2F5_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D2F5_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D2F5_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D2F5_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D2F5_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D2F5_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D2F5_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D2F5_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D2F5_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D2F5_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D2F5_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D2F5_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D2F5_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D2F5_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D2F5_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D2F5_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D2F5_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D2F5_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D2F5_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D2F5_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D2F5_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D2F5_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D2F5_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D2F5_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D2F5_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D2F5_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D2F5_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D2F5_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F5_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F5_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F5_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D2F5_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D2F5_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D2F5_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D2F5_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D2F5_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D2F5_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D2F5_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D2F5_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D2F5_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D2F5_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D2F5_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D2F5_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D2F5_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D2F5_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D2F5_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D2F5_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D2F5_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D2F5_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D2F5_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D2F5_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D2F5_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D2F5_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D2F5_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D2F5_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D2F5_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D2F5_CAP_PTR__CAP_PTR_MASK 0xff
#define D2F5_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D2F5_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D2F5_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D2F5_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D2F5_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D2F5_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D2F5_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D2F5_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F5_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F5_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F5_PMI_CAP__VERSION_MASK 0x70000
#define D2F5_PMI_CAP__VERSION__SHIFT 0x10
#define D2F5_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D2F5_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D2F5_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D2F5_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D2F5_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D2F5_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D2F5_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D2F5_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D2F5_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D2F5_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D2F5_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D2F5_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D2F5_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D2F5_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D2F5_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D2F5_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D2F5_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D2F5_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D2F5_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D2F5_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D2F5_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D2F5_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D2F5_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D2F5_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D2F5_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D2F5_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D2F5_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D2F5_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D2F5_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D2F5_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D2F5_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D2F5_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F5_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F5_PCIE_CAP__VERSION_MASK 0xf0000
#define D2F5_PCIE_CAP__VERSION__SHIFT 0x10
#define D2F5_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D2F5_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D2F5_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D2F5_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D2F5_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D2F5_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D2F5_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D2F5_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D2F5_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D2F5_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D2F5_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D2F5_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D2F5_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D2F5_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D2F5_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D2F5_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D2F5_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D2F5_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D2F5_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D2F5_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D2F5_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D2F5_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D2F5_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D2F5_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D2F5_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D2F5_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D2F5_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D2F5_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D2F5_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D2F5_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D2F5_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D2F5_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D2F5_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D2F5_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D2F5_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D2F5_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D2F5_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D2F5_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D2F5_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D2F5_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D2F5_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D2F5_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D2F5_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D2F5_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D2F5_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D2F5_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D2F5_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D2F5_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D2F5_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D2F5_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D2F5_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D2F5_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D2F5_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D2F5_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D2F5_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D2F5_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D2F5_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D2F5_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D2F5_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D2F5_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D2F5_LINK_CAP__LINK_SPEED_MASK 0xf
#define D2F5_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D2F5_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D2F5_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D2F5_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D2F5_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D2F5_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D2F5_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D2F5_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D2F5_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D2F5_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D2F5_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D2F5_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D2F5_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D2F5_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D2F5_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D2F5_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D2F5_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D2F5_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D2F5_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D2F5_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D2F5_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D2F5_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D2F5_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D2F5_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D2F5_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D2F5_LINK_CNTL__LINK_DIS_MASK 0x10
#define D2F5_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D2F5_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D2F5_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D2F5_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D2F5_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D2F5_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D2F5_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D2F5_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D2F5_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D2F5_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D2F5_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D2F5_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D2F5_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D2F5_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D2F5_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D2F5_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D2F5_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D2F5_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D2F5_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D2F5_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D2F5_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D2F5_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D2F5_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D2F5_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D2F5_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D2F5_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D2F5_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D2F5_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D2F5_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D2F5_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D2F5_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D2F5_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D2F5_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D2F5_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D2F5_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D2F5_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D2F5_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D2F5_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D2F5_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D2F5_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D2F5_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D2F5_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D2F5_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D2F5_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D2F5_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D2F5_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D2F5_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D2F5_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D2F5_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D2F5_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D2F5_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D2F5_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D2F5_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D2F5_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D2F5_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D2F5_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D2F5_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D2F5_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D2F5_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D2F5_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D2F5_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D2F5_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D2F5_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D2F5_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D2F5_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D2F5_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D2F5_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D2F5_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D2F5_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D2F5_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D2F5_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D2F5_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D2F5_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D2F5_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D2F5_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D2F5_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D2F5_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D2F5_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D2F5_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D2F5_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D2F5_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D2F5_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D2F5_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D2F5_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D2F5_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D2F5_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D2F5_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D2F5_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D2F5_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D2F5_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D2F5_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D2F5_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D2F5_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D2F5_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D2F5_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D2F5_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D2F5_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D2F5_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D2F5_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D2F5_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D2F5_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D2F5_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D2F5_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D2F5_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D2F5_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D2F5_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D2F5_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D2F5_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D2F5_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D2F5_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D2F5_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D2F5_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D2F5_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D2F5_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D2F5_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D2F5_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D2F5_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D2F5_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D2F5_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D2F5_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D2F5_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D2F5_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D2F5_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D2F5_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D2F5_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D2F5_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D2F5_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D2F5_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D2F5_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D2F5_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D2F5_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D2F5_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D2F5_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D2F5_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D2F5_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D2F5_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D2F5_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D2F5_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D2F5_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D2F5_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D2F5_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D2F5_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D2F5_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D2F5_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D2F5_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D2F5_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D2F5_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D2F5_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D2F5_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D2F5_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D2F5_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D2F5_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D2F5_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D2F5_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D2F5_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D2F5_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D2F5_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D2F5_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D2F5_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D2F5_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D2F5_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D2F5_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D2F5_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D2F5_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D2F5_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D2F5_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D2F5_LINK_CAP2__RESERVED__SHIFT 0x9
#define D2F5_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D2F5_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D2F5_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D2F5_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D2F5_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D2F5_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D2F5_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D2F5_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D2F5_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D2F5_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D2F5_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D2F5_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D2F5_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D2F5_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D2F5_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D2F5_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D2F5_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D2F5_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D2F5_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D2F5_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D2F5_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D2F5_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D2F5_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D2F5_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D2F5_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D2F5_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D2F5_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D2F5_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D2F5_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D2F5_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D2F5_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F5_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F5_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D2F5_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D2F5_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D2F5_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D2F5_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D2F5_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D2F5_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D2F5_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D2F5_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D2F5_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D2F5_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D2F5_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D2F5_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D2F5_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D2F5_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D2F5_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D2F5_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D2F5_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D2F5_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D2F5_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F5_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F5_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D2F5_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D2F5_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D2F5_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D2F5_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D2F5_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D2F5_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D2F5_MSI_MAP_CAP__EN_MASK 0x10000
#define D2F5_MSI_MAP_CAP__EN__SHIFT 0x10
#define D2F5_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D2F5_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D2F5_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D2F5_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D2F5_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D2F5_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D2F5_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D2F5_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D2F5_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D2F5_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D2F5_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D2F5_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D2F5_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D2F5_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D2F5_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D2F5_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D2F5_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D2F5_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D2F5_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D2F5_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D2F5_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D2F5_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D2F5_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D2F5_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F5_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F5_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D2F5_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D2F5_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D2F5_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D2F5_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D2F5_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F5_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F5_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F5_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F5_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F5_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F5_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F5_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F5_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F5_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F5_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F5_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F5_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F5_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F5_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F5_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F5_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F5_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F5_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F5_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F5_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F5_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F5_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F5_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F5_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F5_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D2F5_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D2F5_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D2F5_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D2F5_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D2F5_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D2F5_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D2F5_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D2F5_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D2F5_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D2F5_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D2F5_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D2F5_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D2F5_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D2F5_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D2F5_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D2F5_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D2F5_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D2F5_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D2F5_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D2F5_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D2F5_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D2F5_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D2F5_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D2F5_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D2F5_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D2F5_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D2F5_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D2F5_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D2F5_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D2F5_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D2F5_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D2F5_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D2F5_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D2F5_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D2F5_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D2F5_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D2F5_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D2F5_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D2F5_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D2F5_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D2F5_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D2F5_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D2F5_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D2F5_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D2F5_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D2F5_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D2F5_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D2F5_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D2F5_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D2F5_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D2F5_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D2F5_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D2F5_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D2F5_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D2F5_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D2F5_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D2F5_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D2F5_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D2F5_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D2F5_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D2F5_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D2F5_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D2F5_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D2F5_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D2F5_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D2F5_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D2F5_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D2F5_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D2F5_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D2F5_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D2F5_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D2F5_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D2F5_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D2F5_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D2F5_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D2F5_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D2F5_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D2F5_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D2F5_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D2F5_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D2F5_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D2F5_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D2F5_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D2F5_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D2F5_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D2F5_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D2F5_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D2F5_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D2F5_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D2F5_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D2F5_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D2F5_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D2F5_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D2F5_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D2F5_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D2F5_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D2F5_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D2F5_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D2F5_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D2F5_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D2F5_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D2F5_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D2F5_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D2F5_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D2F5_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D2F5_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D2F5_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D2F5_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D2F5_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D2F5_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D2F5_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D2F5_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D2F5_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D2F5_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D2F5_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D2F5_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D2F5_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D2F5_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D2F5_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D2F5_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D2F5_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D2F5_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D2F5_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D2F5_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D2F5_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D2F5_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D2F5_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D2F5_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D2F5_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D2F5_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D2F5_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D2F5_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D2F5_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D2F5_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D2F5_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D2F5_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D2F5_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D2F5_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D2F5_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D2F5_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D2F5_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D2F5_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D2F5_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D2F5_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D2F5_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D2F5_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D2F5_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D2F5_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D2F5_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D2F5_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D2F5_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D2F5_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D2F5_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D2F5_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D2F5_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D2F5_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D2F5_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D2F5_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D2F5_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D2F5_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D2F5_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D2F5_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D2F5_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D2F5_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D2F5_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D2F5_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D2F5_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D2F5_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D2F5_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D2F5_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D2F5_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D2F5_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define D2F5_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define D2F5_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define D2F5_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define D2F5_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define D2F5_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define D2F5_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define D2F5_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define D2F5_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define D2F5_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define D2F5_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define D2F5_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define D2F5_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define D2F5_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define D2F5_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define D2F5_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define D2F5_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x10000
#define D2F5_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x10
#define D2F5_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x20000
#define D2F5_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x11
#define D2F5_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x40000
#define D2F5_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x12
#define D2F5_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x80000
#define D2F5_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x13
#define D2F5_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x100000
#define D2F5_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x14
#define D2F5_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x200000
#define D2F5_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x15
#define D2F5_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x400000
#define D2F5_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x16
#define D2F5_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D2F5_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D2F5_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D2F5_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D2F5_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D2F5_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D2F5_PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define D2F5_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define D2F5_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define D2F5_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define D2F5_PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f0000
#define D2F5_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x10
#define D2F5_PCIE_MC_CNTL__MC_ENABLE_MASK 0x80000000
#define D2F5_PCIE_MC_CNTL__MC_ENABLE__SHIFT 0x1f
#define D2F5_PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define D2F5_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define D2F5_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define D2F5_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define D2F5_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define D2F5_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define D2F5_PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define D2F5_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define D2F5_PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define D2F5_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define D2F5_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define D2F5_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define D2F5_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define D2F5_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define D2F5_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define D2F5_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define D2F5_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define D2F5_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define D2F5_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE_MASK 0x3f
#define D2F5_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_SIZE__SHIFT 0x0
#define D2F5_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0_MASK 0xffffffc0
#define D2F5_PCIE_MC_OVERLAY_BAR0__MC_OVERLAY_BAR_0__SHIFT 0x6
#define D2F5_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1_MASK 0xffffffff
#define D2F5_PCIE_MC_OVERLAY_BAR1__MC_OVERLAY_BAR_1__SHIFT 0x0
#define D3F1_PCIE_PORT_INDEX__PCIE_INDEX_MASK 0xff
#define D3F1_PCIE_PORT_INDEX__PCIE_INDEX__SHIFT 0x0
#define D3F1_PCIE_PORT_DATA__PCIE_DATA_MASK 0xffffffff
#define D3F1_PCIE_PORT_DATA__PCIE_DATA__SHIFT 0x0
#define D3F1_PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define D3F1_PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define D3F1_PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define D3F1_PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define D3F1_PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define D3F1_PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define D3F1_PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define D3F1_PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define D3F1_PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define D3F1_PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define D3F1_PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define D3F1_PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define D3F1_PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define D3F1_PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define D3F1_PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define D3F1_PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define D3F1_PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define D3F1_PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define D3F1_PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define D3F1_PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define D3F1_PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define D3F1_PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define D3F1_PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define D3F1_PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define D3F1_PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define D3F1_PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define D3F1_PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define D3F1_PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define D3F1_PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define D3F1_PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define D3F1_PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define D3F1_PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define D3F1_PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define D3F1_PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define D3F1_PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define D3F1_PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define D3F1_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define D3F1_PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define D3F1_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define D3F1_PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define D3F1_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define D3F1_PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define D3F1_PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define D3F1_PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define D3F1_PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define D3F1_PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define D3F1_PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define D3F1_PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define D3F1_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define D3F1_PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define D3F1_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define D3F1_PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define D3F1_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define D3F1_PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define D3F1_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define D3F1_PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define D3F1_PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define D3F1_PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define D3F1_PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define D3F1_PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define D3F1_PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define D3F1_PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define D3F1_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define D3F1_PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define D3F1_PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define D3F1_PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define D3F1_PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define D3F1_PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define D3F1_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define D3F1_PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define D3F1_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define D3F1_PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define D3F1_PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define D3F1_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define D3F1_PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define D3F1_PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define D3F1_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define D3F1_PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define D3F1_PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define D3F1_PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define D3F1_PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define D3F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define D3F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define D3F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define D3F1_PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define D3F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define D3F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define D3F1_PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define D3F1_PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define D3F1_PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define D3F1_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define D3F1_PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define D3F1_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define D3F1_PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define D3F1_PCIE_FC_P__PD_CREDITS_MASK 0xff
#define D3F1_PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define D3F1_PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define D3F1_PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define D3F1_PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define D3F1_PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define D3F1_PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define D3F1_PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define D3F1_PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define D3F1_PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define D3F1_PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define D3F1_PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define D3F1_PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define D3F1_PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define D3F1_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define D3F1_PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define D3F1_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define D3F1_PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define D3F1_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define D3F1_PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define D3F1_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define D3F1_PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define D3F1_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define D3F1_PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define D3F1_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define D3F1_PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define D3F1_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define D3F1_PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define D3F1_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define D3F1_PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define D3F1_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define D3F1_PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define D3F1_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define D3F1_PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define D3F1_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define D3F1_PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define D3F1_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define D3F1_PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define D3F1_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define D3F1_PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define D3F1_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define D3F1_PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define D3F1_PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define D3F1_PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define D3F1_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define D3F1_PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define D3F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define D3F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define D3F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define D3F1_PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define D3F1_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define D3F1_PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define D3F1_PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define D3F1_PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define D3F1_PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define D3F1_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define D3F1_PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define D3F1_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define D3F1_PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define D3F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define D3F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define D3F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define D3F1_PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define D3F1_PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define D3F1_PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define D3F1_PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define D3F1_PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define D3F1_PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define D3F1_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define D3F1_PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define D3F1_PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define D3F1_PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define D3F1_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define D3F1_PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define D3F1_PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define D3F1_PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define D3F1_PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define D3F1_PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define D3F1_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define D3F1_PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define D3F1_PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define D3F1_PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define D3F1_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define D3F1_PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define D3F1_PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define D3F1_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define D3F1_PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define D3F1_PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define D3F1_PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define D3F1_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define D3F1_PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define D3F1_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define D3F1_PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define D3F1_PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define D3F1_PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define D3F1_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define D3F1_PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define D3F1_PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define D3F1_PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define D3F1_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define D3F1_PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define D3F1_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define D3F1_PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define D3F1_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define D3F1_PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define D3F1_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define D3F1_PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define D3F1_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define D3F1_PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define D3F1_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define D3F1_PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define D3F1_PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define D3F1_PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define D3F1_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define D3F1_PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define D3F1_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define D3F1_PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define D3F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define D3F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define D3F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define D3F1_PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define D3F1_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define D3F1_PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define D3F1_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define D3F1_PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define D3F1_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define D3F1_PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define D3F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define D3F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define D3F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define D3F1_PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define D3F1_PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define D3F1_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define D3F1_PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define D3F1_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define D3F1_PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define D3F1_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define D3F1_PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define D3F1_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define D3F1_PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define D3F1_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define D3F1_PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define D3F1_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define D3F1_PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define D3F1_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define D3F1_PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define D3F1_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define D3F1_PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define D3F1_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define D3F1_PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define D3F1_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define D3F1_PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define D3F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define D3F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define D3F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define D3F1_PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define D3F1_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define D3F1_PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define D3F1_PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define D3F1_PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define D3F1_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define D3F1_PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define D3F1_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define D3F1_PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define D3F1_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define D3F1_PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define D3F1_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define D3F1_PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define D3F1_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define D3F1_PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define D3F1_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define D3F1_PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define D3F1_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define D3F1_PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define D3F1_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define D3F1_PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define D3F1_PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define D3F1_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define D3F1_PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define D3F1_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define D3F1_PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define D3F1_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define D3F1_PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define D3F1_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define D3F1_PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define D3F1_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define D3F1_PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define D3F1_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define D3F1_PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define D3F1_PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define D3F1_PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define D3F1_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define D3F1_PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define D3F1_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define D3F1_PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define D3F1_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define D3F1_PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define D3F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define D3F1_PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define D3F1_PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define D3F1_PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define D3F1_PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define D3F1_PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define D3F1_PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define D3F1_PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define D3F1_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define D3F1_PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define D3F1_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define D3F1_PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define D3F1_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define D3F1_PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define D3F1_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define D3F1_PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define D3F1_PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define D3F1_PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define D3F1_PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define D3F1_PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define D3F1_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define D3F1_PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define D3F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define D3F1_PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define D3F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define D3F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define D3F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define D3F1_PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define D3F1_PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define D3F1_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define D3F1_PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define D3F1_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define D3F1_PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define D3F1_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define D3F1_PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define D3F1_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define D3F1_PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define D3F1_PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define D3F1_PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define D3F1_PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define D3F1_PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define D3F1_PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define D3F1_PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define D3F1_PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define D3F1_PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define D3F1_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define D3F1_PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define D3F1_PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define D3F1_PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define D3F1_PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define D3F1_PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define D3F1_PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define D3F1_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define D3F1_PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define D3F1_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define D3F1_PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define D3F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define D3F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define D3F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define D3F1_PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define D3F1_PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define D3F1_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define D3F1_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define D3F1_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define D3F1_PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define D3F1_PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define D3F1_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define D3F1_PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define D3F1_PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define D3F1_PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define D3F1_PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define D3F1_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define D3F1_PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define D3F1_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define D3F1_PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define D3F1_PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define D3F1_PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define D3F1_PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define D3F1_PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define D3F1_PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define D3F1_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define D3F1_PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define D3F1_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define D3F1_PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define D3F1_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define D3F1_PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define D3F1_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define D3F1_PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define D3F1_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define D3F1_PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define D3F1_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define D3F1_PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define D3F1_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define D3F1_PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define D3F1_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define D3F1_PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define D3F1_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define D3F1_PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define D3F1_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define D3F1_PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define D3F1_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define D3F1_PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define D3F1_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define D3F1_PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define D3F1_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define D3F1_PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define D3F1_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define D3F1_PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define D3F1_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define D3F1_PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define D3F1_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define D3F1_PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define D3F1_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define D3F1_PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define D3F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define D3F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define D3F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define D3F1_PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define D3F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define D3F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define D3F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define D3F1_PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define D3F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define D3F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define D3F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define D3F1_PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define D3F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define D3F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define D3F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define D3F1_PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define D3F1_PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define D3F1_PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define D3F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define D3F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define D3F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define D3F1_PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define D3F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define D3F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define D3F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define D3F1_PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define D3F1_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define D3F1_PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define D3F1_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define D3F1_PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define D3F1_VENDOR_ID__VENDOR_ID_MASK 0xffff
#define D3F1_VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define D3F1_DEVICE_ID__DEVICE_ID_MASK 0xffff0000
#define D3F1_DEVICE_ID__DEVICE_ID__SHIFT 0x10
#define D3F1_COMMAND__IO_ACCESS_EN_MASK 0x1
#define D3F1_COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define D3F1_COMMAND__MEM_ACCESS_EN_MASK 0x2
#define D3F1_COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define D3F1_COMMAND__BUS_MASTER_EN_MASK 0x4
#define D3F1_COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define D3F1_COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define D3F1_COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define D3F1_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define D3F1_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define D3F1_COMMAND__PAL_SNOOP_EN_MASK 0x20
#define D3F1_COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define D3F1_COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define D3F1_COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define D3F1_COMMAND__AD_STEPPING_MASK 0x80
#define D3F1_COMMAND__AD_STEPPING__SHIFT 0x7
#define D3F1_COMMAND__SERR_EN_MASK 0x100
#define D3F1_COMMAND__SERR_EN__SHIFT 0x8
#define D3F1_COMMAND__FAST_B2B_EN_MASK 0x200
#define D3F1_COMMAND__FAST_B2B_EN__SHIFT 0x9
#define D3F1_COMMAND__INT_DIS_MASK 0x400
#define D3F1_COMMAND__INT_DIS__SHIFT 0xa
#define D3F1_STATUS__INT_STATUS_MASK 0x80000
#define D3F1_STATUS__INT_STATUS__SHIFT 0x13
#define D3F1_STATUS__CAP_LIST_MASK 0x100000
#define D3F1_STATUS__CAP_LIST__SHIFT 0x14
#define D3F1_STATUS__PCI_66_EN_MASK 0x200000
#define D3F1_STATUS__PCI_66_EN__SHIFT 0x15
#define D3F1_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D3F1_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D3F1_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D3F1_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D3F1_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D3F1_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D3F1_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D3F1_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D3F1_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D3F1_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D3F1_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D3F1_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D3F1_STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x40000000
#define D3F1_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0x1e
#define D3F1_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D3F1_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D3F1_REVISION_ID__MINOR_REV_ID_MASK 0xf
#define D3F1_REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define D3F1_REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define D3F1_REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define D3F1_PROG_INTERFACE__PROG_INTERFACE_MASK 0xff00
#define D3F1_PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x8
#define D3F1_SUB_CLASS__SUB_CLASS_MASK 0xff0000
#define D3F1_SUB_CLASS__SUB_CLASS__SHIFT 0x10
#define D3F1_BASE_CLASS__BASE_CLASS_MASK 0xff000000
#define D3F1_BASE_CLASS__BASE_CLASS__SHIFT 0x18
#define D3F1_CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define D3F1_CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define D3F1_LATENCY__LATENCY_TIMER_MASK 0xff00
#define D3F1_LATENCY__LATENCY_TIMER__SHIFT 0x8
#define D3F1_HEADER__HEADER_TYPE_MASK 0x7f0000
#define D3F1_HEADER__HEADER_TYPE__SHIFT 0x10
#define D3F1_HEADER__DEVICE_TYPE_MASK 0x800000
#define D3F1_HEADER__DEVICE_TYPE__SHIFT 0x17
#define D3F1_BIST__BIST_COMP_MASK 0xf000000
#define D3F1_BIST__BIST_COMP__SHIFT 0x18
#define D3F1_BIST__BIST_STRT_MASK 0x40000000
#define D3F1_BIST__BIST_STRT__SHIFT 0x1e
#define D3F1_BIST__BIST_CAP_MASK 0x80000000
#define D3F1_BIST__BIST_CAP__SHIFT 0x1f
#define D3F1_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK 0xff
#define D3F1_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT 0x0
#define D3F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK 0xff00
#define D3F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT 0x8
#define D3F1_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK 0xff0000
#define D3F1_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT 0x10
#define D3F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK 0xff000000
#define D3F1_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT 0x18
#define D3F1_IO_BASE_LIMIT__IO_BASE_TYPE_MASK 0xf
#define D3F1_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT 0x0
#define D3F1_IO_BASE_LIMIT__IO_BASE_MASK 0xf0
#define D3F1_IO_BASE_LIMIT__IO_BASE__SHIFT 0x4
#define D3F1_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK 0xf00
#define D3F1_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT 0x8
#define D3F1_IO_BASE_LIMIT__IO_LIMIT_MASK 0xf000
#define D3F1_IO_BASE_LIMIT__IO_LIMIT__SHIFT 0xc
#define D3F1_SECONDARY_STATUS__CAP_LIST_MASK 0x100000
#define D3F1_SECONDARY_STATUS__CAP_LIST__SHIFT 0x14
#define D3F1_SECONDARY_STATUS__PCI_66_EN_MASK 0x200000
#define D3F1_SECONDARY_STATUS__PCI_66_EN__SHIFT 0x15
#define D3F1_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK 0x800000
#define D3F1_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT 0x17
#define D3F1_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x1000000
#define D3F1_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x18
#define D3F1_SECONDARY_STATUS__DEVSEL_TIMING_MASK 0x6000000
#define D3F1_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT 0x19
#define D3F1_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK 0x8000000
#define D3F1_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT 0x1b
#define D3F1_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK 0x10000000
#define D3F1_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT 0x1c
#define D3F1_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK 0x20000000
#define D3F1_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT 0x1d
#define D3F1_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK 0x40000000
#define D3F1_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT 0x1e
#define D3F1_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK 0x80000000
#define D3F1_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT 0x1f
#define D3F1_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK 0xf
#define D3F1_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT 0x0
#define D3F1_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK 0xfff0
#define D3F1_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT 0x4
#define D3F1_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK 0xf0000
#define D3F1_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT 0x10
#define D3F1_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK 0xfff00000
#define D3F1_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT 0x14
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK 0xf
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT 0x0
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK 0xfff0
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT 0x4
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK 0xf0000
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT 0x10
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK 0xfff00000
#define D3F1_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT 0x14
#define D3F1_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK 0xffffffff
#define D3F1_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT 0x0
#define D3F1_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK 0xffffffff
#define D3F1_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT 0x0
#define D3F1_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK 0xffff
#define D3F1_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT 0x0
#define D3F1_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK 0xffff0000
#define D3F1_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT 0x10
#define D3F1_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK 0x10000
#define D3F1_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT 0x10
#define D3F1_IRQ_BRIDGE_CNTL__SERR_EN_MASK 0x20000
#define D3F1_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT 0x11
#define D3F1_IRQ_BRIDGE_CNTL__ISA_EN_MASK 0x40000
#define D3F1_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT 0x12
#define D3F1_IRQ_BRIDGE_CNTL__VGA_EN_MASK 0x80000
#define D3F1_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT 0x13
#define D3F1_IRQ_BRIDGE_CNTL__VGA_DEC_MASK 0x100000
#define D3F1_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT 0x14
#define D3F1_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK 0x200000
#define D3F1_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT 0x15
#define D3F1_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK 0x400000
#define D3F1_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT 0x16
#define D3F1_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK 0x800000
#define D3F1_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT 0x17
#define D3F1_CAP_PTR__CAP_PTR_MASK 0xff
#define D3F1_CAP_PTR__CAP_PTR__SHIFT 0x0
#define D3F1_INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define D3F1_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define D3F1_INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff00
#define D3F1_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x8
#define D3F1_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK 0x1
#define D3F1_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT 0x0
#define D3F1_PMI_CAP_LIST__CAP_ID_MASK 0xff
#define D3F1_PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D3F1_PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D3F1_PMI_CAP__VERSION_MASK 0x70000
#define D3F1_PMI_CAP__VERSION__SHIFT 0x10
#define D3F1_PMI_CAP__PME_CLOCK_MASK 0x80000
#define D3F1_PMI_CAP__PME_CLOCK__SHIFT 0x13
#define D3F1_PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x200000
#define D3F1_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x15
#define D3F1_PMI_CAP__AUX_CURRENT_MASK 0x1c00000
#define D3F1_PMI_CAP__AUX_CURRENT__SHIFT 0x16
#define D3F1_PMI_CAP__D1_SUPPORT_MASK 0x2000000
#define D3F1_PMI_CAP__D1_SUPPORT__SHIFT 0x19
#define D3F1_PMI_CAP__D2_SUPPORT_MASK 0x4000000
#define D3F1_PMI_CAP__D2_SUPPORT__SHIFT 0x1a
#define D3F1_PMI_CAP__PME_SUPPORT_MASK 0xf8000000
#define D3F1_PMI_CAP__PME_SUPPORT__SHIFT 0x1b
#define D3F1_PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define D3F1_PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define D3F1_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define D3F1_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define D3F1_PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define D3F1_PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define D3F1_PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define D3F1_PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define D3F1_PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define D3F1_PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define D3F1_PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define D3F1_PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define D3F1_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define D3F1_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define D3F1_PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define D3F1_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define D3F1_PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define D3F1_PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define D3F1_PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define D3F1_PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D3F1_PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D3F1_PCIE_CAP__VERSION_MASK 0xf0000
#define D3F1_PCIE_CAP__VERSION__SHIFT 0x10
#define D3F1_PCIE_CAP__DEVICE_TYPE_MASK 0xf00000
#define D3F1_PCIE_CAP__DEVICE_TYPE__SHIFT 0x14
#define D3F1_PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x1000000
#define D3F1_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x18
#define D3F1_PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e000000
#define D3F1_PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x19
#define D3F1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define D3F1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define D3F1_DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define D3F1_DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define D3F1_DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define D3F1_DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define D3F1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define D3F1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define D3F1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define D3F1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define D3F1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define D3F1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define D3F1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define D3F1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define D3F1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define D3F1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define D3F1_DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define D3F1_DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define D3F1_DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define D3F1_DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define D3F1_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define D3F1_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define D3F1_DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define D3F1_DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define D3F1_DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define D3F1_DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define D3F1_DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define D3F1_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define D3F1_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define D3F1_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define D3F1_DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define D3F1_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define D3F1_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define D3F1_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define D3F1_DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define D3F1_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define D3F1_DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define D3F1_DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define D3F1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define D3F1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define D3F1_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK 0x8000
#define D3F1_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT 0xf
#define D3F1_DEVICE_STATUS__CORR_ERR_MASK 0x10000
#define D3F1_DEVICE_STATUS__CORR_ERR__SHIFT 0x10
#define D3F1_DEVICE_STATUS__NON_FATAL_ERR_MASK 0x20000
#define D3F1_DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x11
#define D3F1_DEVICE_STATUS__FATAL_ERR_MASK 0x40000
#define D3F1_DEVICE_STATUS__FATAL_ERR__SHIFT 0x12
#define D3F1_DEVICE_STATUS__USR_DETECTED_MASK 0x80000
#define D3F1_DEVICE_STATUS__USR_DETECTED__SHIFT 0x13
#define D3F1_DEVICE_STATUS__AUX_PWR_MASK 0x100000
#define D3F1_DEVICE_STATUS__AUX_PWR__SHIFT 0x14
#define D3F1_DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x200000
#define D3F1_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x15
#define D3F1_LINK_CAP__LINK_SPEED_MASK 0xf
#define D3F1_LINK_CAP__LINK_SPEED__SHIFT 0x0
#define D3F1_LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define D3F1_LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define D3F1_LINK_CAP__PM_SUPPORT_MASK 0xc00
#define D3F1_LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define D3F1_LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define D3F1_LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define D3F1_LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define D3F1_LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define D3F1_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define D3F1_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define D3F1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define D3F1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define D3F1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define D3F1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define D3F1_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define D3F1_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define D3F1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define D3F1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define D3F1_LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define D3F1_LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define D3F1_LINK_CNTL__PM_CONTROL_MASK 0x3
#define D3F1_LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define D3F1_LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define D3F1_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define D3F1_LINK_CNTL__LINK_DIS_MASK 0x10
#define D3F1_LINK_CNTL__LINK_DIS__SHIFT 0x4
#define D3F1_LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define D3F1_LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define D3F1_LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define D3F1_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define D3F1_LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define D3F1_LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define D3F1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define D3F1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define D3F1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define D3F1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define D3F1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define D3F1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define D3F1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define D3F1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define D3F1_LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf0000
#define D3F1_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x10
#define D3F1_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f00000
#define D3F1_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x14
#define D3F1_LINK_STATUS__LINK_TRAINING_MASK 0x8000000
#define D3F1_LINK_STATUS__LINK_TRAINING__SHIFT 0x1b
#define D3F1_LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x10000000
#define D3F1_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0x1c
#define D3F1_LINK_STATUS__DL_ACTIVE_MASK 0x20000000
#define D3F1_LINK_STATUS__DL_ACTIVE__SHIFT 0x1d
#define D3F1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x40000000
#define D3F1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0x1e
#define D3F1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x80000000
#define D3F1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0x1f
#define D3F1_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK 0x1
#define D3F1_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT 0x0
#define D3F1_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK 0x2
#define D3F1_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT 0x1
#define D3F1_SLOT_CAP__MRL_SENSOR_PRESENT_MASK 0x4
#define D3F1_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT 0x2
#define D3F1_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK 0x8
#define D3F1_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT 0x3
#define D3F1_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK 0x10
#define D3F1_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT 0x4
#define D3F1_SLOT_CAP__HOTPLUG_SURPRISE_MASK 0x20
#define D3F1_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT 0x5
#define D3F1_SLOT_CAP__HOTPLUG_CAPABLE_MASK 0x40
#define D3F1_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT 0x6
#define D3F1_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK 0x7f80
#define D3F1_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT 0x7
#define D3F1_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK 0x18000
#define D3F1_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT 0xf
#define D3F1_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK 0x20000
#define D3F1_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT 0x11
#define D3F1_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK 0x40000
#define D3F1_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT 0x12
#define D3F1_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK 0xfff80000
#define D3F1_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT 0x13
#define D3F1_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK 0x1
#define D3F1_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT 0x0
#define D3F1_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK 0x2
#define D3F1_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT 0x1
#define D3F1_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK 0x4
#define D3F1_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT 0x2
#define D3F1_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK 0x8
#define D3F1_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT 0x3
#define D3F1_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK 0x10
#define D3F1_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT 0x4
#define D3F1_SLOT_CNTL__HOTPLUG_INTR_EN_MASK 0x20
#define D3F1_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT 0x5
#define D3F1_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK 0xc0
#define D3F1_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT 0x6
#define D3F1_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK 0x300
#define D3F1_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT 0x8
#define D3F1_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK 0x400
#define D3F1_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT 0xa
#define D3F1_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK 0x800
#define D3F1_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT 0xb
#define D3F1_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK 0x1000
#define D3F1_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT 0xc
#define D3F1_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK 0x10000
#define D3F1_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT 0x10
#define D3F1_SLOT_STATUS__PWR_FAULT_DETECTED_MASK 0x20000
#define D3F1_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT 0x11
#define D3F1_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK 0x40000
#define D3F1_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT 0x12
#define D3F1_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK 0x80000
#define D3F1_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT 0x13
#define D3F1_SLOT_STATUS__COMMAND_COMPLETED_MASK 0x100000
#define D3F1_SLOT_STATUS__COMMAND_COMPLETED__SHIFT 0x14
#define D3F1_SLOT_STATUS__MRL_SENSOR_STATE_MASK 0x200000
#define D3F1_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT 0x15
#define D3F1_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK 0x400000
#define D3F1_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT 0x16
#define D3F1_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK 0x800000
#define D3F1_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT 0x17
#define D3F1_SLOT_STATUS__DL_STATE_CHANGED_MASK 0x1000000
#define D3F1_SLOT_STATUS__DL_STATE_CHANGED__SHIFT 0x18
#define D3F1_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK 0x1
#define D3F1_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT 0x0
#define D3F1_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK 0x2
#define D3F1_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT 0x1
#define D3F1_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK 0x4
#define D3F1_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT 0x2
#define D3F1_ROOT_CNTL__PM_INTERRUPT_EN_MASK 0x8
#define D3F1_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT 0x3
#define D3F1_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK 0x10
#define D3F1_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT 0x4
#define D3F1_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK 0x10000
#define D3F1_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT 0x10
#define D3F1_ROOT_STATUS__PME_REQUESTOR_ID_MASK 0xffff
#define D3F1_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT 0x0
#define D3F1_ROOT_STATUS__PME_STATUS_MASK 0x10000
#define D3F1_ROOT_STATUS__PME_STATUS__SHIFT 0x10
#define D3F1_ROOT_STATUS__PME_PENDING_MASK 0x20000
#define D3F1_ROOT_STATUS__PME_PENDING__SHIFT 0x11
#define D3F1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define D3F1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define D3F1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define D3F1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define D3F1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define D3F1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define D3F1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define D3F1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define D3F1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define D3F1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define D3F1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define D3F1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define D3F1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define D3F1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define D3F1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define D3F1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define D3F1_DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define D3F1_DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define D3F1_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define D3F1_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define D3F1_DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define D3F1_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define D3F1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define D3F1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define D3F1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define D3F1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define D3F1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define D3F1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define D3F1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define D3F1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define D3F1_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define D3F1_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define D3F1_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define D3F1_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define D3F1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define D3F1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define D3F1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define D3F1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define D3F1_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define D3F1_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define D3F1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define D3F1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define D3F1_DEVICE_CNTL2__LTR_EN_MASK 0x400
#define D3F1_DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define D3F1_DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define D3F1_DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define D3F1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define D3F1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define D3F1_DEVICE_STATUS2__RESERVED_MASK 0xffff0000
#define D3F1_DEVICE_STATUS2__RESERVED__SHIFT 0x10
#define D3F1_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define D3F1_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define D3F1_LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define D3F1_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define D3F1_LINK_CAP2__RESERVED_MASK 0xfffffe00
#define D3F1_LINK_CAP2__RESERVED__SHIFT 0x9
#define D3F1_LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define D3F1_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define D3F1_LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define D3F1_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define D3F1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define D3F1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define D3F1_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define D3F1_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define D3F1_LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define D3F1_LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define D3F1_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define D3F1_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define D3F1_LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define D3F1_LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define D3F1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define D3F1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define D3F1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x10000
#define D3F1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x10
#define D3F1_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x20000
#define D3F1_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x11
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x40000
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x12
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x80000
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x13
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x100000
#define D3F1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x14
#define D3F1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x200000
#define D3F1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x15
#define D3F1_SLOT_CAP2__RESERVED_MASK 0xffffffff
#define D3F1_SLOT_CAP2__RESERVED__SHIFT 0x0
#define D3F1_SLOT_CNTL2__RESERVED_MASK 0xffff
#define D3F1_SLOT_CNTL2__RESERVED__SHIFT 0x0
#define D3F1_SLOT_STATUS2__RESERVED_MASK 0xffff0000
#define D3F1_SLOT_STATUS2__RESERVED__SHIFT 0x10
#define D3F1_MSI_CAP_LIST__CAP_ID_MASK 0xff
#define D3F1_MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D3F1_MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D3F1_MSI_MSG_CNTL__MSI_EN_MASK 0x10000
#define D3F1_MSI_MSG_CNTL__MSI_EN__SHIFT 0x10
#define D3F1_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe0000
#define D3F1_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x11
#define D3F1_MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x700000
#define D3F1_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x14
#define D3F1_MSI_MSG_CNTL__MSI_64BIT_MASK 0x800000
#define D3F1_MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x17
#define D3F1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x1000000
#define D3F1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x18
#define D3F1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define D3F1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define D3F1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define D3F1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define D3F1_MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define D3F1_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define D3F1_MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define D3F1_MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define D3F1_SSID_CAP_LIST__CAP_ID_MASK 0xff
#define D3F1_SSID_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_SSID_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D3F1_SSID_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D3F1_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define D3F1_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define D3F1_SSID_CAP__SUBSYSTEM_ID_MASK 0xffff0000
#define D3F1_SSID_CAP__SUBSYSTEM_ID__SHIFT 0x10
#define D3F1_MSI_MAP_CAP_LIST__CAP_ID_MASK 0xff
#define D3F1_MSI_MAP_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_MSI_MAP_CAP_LIST__NEXT_PTR_MASK 0xff00
#define D3F1_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define D3F1_MSI_MAP_CAP__EN_MASK 0x10000
#define D3F1_MSI_MAP_CAP__EN__SHIFT 0x10
#define D3F1_MSI_MAP_CAP__FIXD_MASK 0x20000
#define D3F1_MSI_MAP_CAP__FIXD__SHIFT 0x11
#define D3F1_MSI_MAP_CAP__CAP_TYPE_MASK 0xf8000000
#define D3F1_MSI_MAP_CAP__CAP_TYPE__SHIFT 0x1b
#define D3F1_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK 0xfff00000
#define D3F1_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT 0x14
#define D3F1_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK 0xffffffff
#define D3F1_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT 0x0
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D3F1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define D3F1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define D3F1_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define D3F1_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define D3F1_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define D3F1_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define D3F1_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D3F1_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D3F1_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D3F1_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D3F1_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D3F1_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define D3F1_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define D3F1_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define D3F1_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define D3F1_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define D3F1_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define D3F1_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define D3F1_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define D3F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define D3F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define D3F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define D3F1_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define D3F1_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define D3F1_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define D3F1_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define D3F1_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define D3F1_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x10000
#define D3F1_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x10
#define D3F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D3F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D3F1_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D3F1_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D3F1_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D3F1_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D3F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D3F1_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D3F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D3F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D3F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D3F1_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D3F1_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D3F1_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D3F1_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D3F1_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D3F1_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D3F1_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D3F1_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D3F1_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D3F1_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D3F1_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D3F1_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D3F1_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D3F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define D3F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define D3F1_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define D3F1_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define D3F1_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define D3F1_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define D3F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define D3F1_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define D3F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define D3F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define D3F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define D3F1_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define D3F1_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define D3F1_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define D3F1_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define D3F1_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define D3F1_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define D3F1_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define D3F1_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define D3F1_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define D3F1_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x10000
#define D3F1_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x10
#define D3F1_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x20000
#define D3F1_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x11
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D3F1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D3F1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define D3F1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define D3F1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define D3F1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D3F1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D3F1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define D3F1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define D3F1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define D3F1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define D3F1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define D3F1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define D3F1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define D3F1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define D3F1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define D3F1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define D3F1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define D3F1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define D3F1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define D3F1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define D3F1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define D3F1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define D3F1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define D3F1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define D3F1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define D3F1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define D3F1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define D3F1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define D3F1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define D3F1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define D3F1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define D3F1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define D3F1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define D3F1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define D3F1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define D3F1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define D3F1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define D3F1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define D3F1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define D3F1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define D3F1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define D3F1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define D3F1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define D3F1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define D3F1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define D3F1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define D3F1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define D3F1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define D3F1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define D3F1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define D3F1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define D3F1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define D3F1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define D3F1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define D3F1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define D3F1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define D3F1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define D3F1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define D3F1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define D3F1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define D3F1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define D3F1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define D3F1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define D3F1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define D3F1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define D3F1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define D3F1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define D3F1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define D3F1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define D3F1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define D3F1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define D3F1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define D3F1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define D3F1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define D3F1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define D3F1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define D3F1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define D3F1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define D3F1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define D3F1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define D3F1_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define D3F1_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define D3F1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define D3F1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define D3F1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define D3F1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define D3F1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define D3F1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define D3F1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define D3F1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define D3F1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define D3F1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define D3F1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define D3F1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define D3F1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define D3F1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define D3F1_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define D3F1_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define D3F1_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define D3F1_PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define D3F1_PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define D3F1_PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define D3F1_PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define D3F1_PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define D3F1_PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define D3F1_PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define D3F1_PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define D3F1_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK 0x1
#define D3F1_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT 0x0
#define D3F1_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK 0x2
#define D3F1_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT 0x1
#define D3F1_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK 0x4
#define D3F1_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT 0x2
#define D3F1_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK 0x1
#define D3F1_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT 0x0
#define D3F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK 0x2
#define D3F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT 0x1
#define D3F1_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK 0x4
#define D3F1_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT 0x2
#define D3F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK 0x8
#define D3F1_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT 0x3
#define D3F1_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK 0x10
#define D3F1_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT 0x4
#define D3F1_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK 0x20
#define D3F1_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT 0x5
#define D3F1_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK 0x40
#define D3F1_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT 0x6
#define D3F1_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK 0xf8000000
#define D3F1_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT 0x1b
#define D3F1_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK 0xffff
#define D3F1_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT 0x0
#define D3F1_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK 0xffff0000
#define D3F1_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT 0x10
#define D3F1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define D3F1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define D3F1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define D3F1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define D3F1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define D3F1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define D3F1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define D3F1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define D3F1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define D3F1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define D3F1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define D3F1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define D3F1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define D3F1_PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define D3F1_PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define D3F1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define D3F1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define D3F1_PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define D3F1_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf0000
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x10
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x700000
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x14
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf000000
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x18
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x70000000
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x1c
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x80000000
#define D3F1_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0x1f
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define D3F1_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define D3F1_PCIE_LANE_14_EQUALIZ