--- src/io/io_openssl.c.orig	2010-03-20 14:13:15 UTC
+++ src/io/io_openssl.c
@@ -96,10 +96,22 @@ static DH *get_dh512()
     DH *dh;
 
     if ((dh=DH_new()) == NULL) return(NULL);
+#if OPENSSL_VERSION_NUMBER >= 0x10100005L
+    BIGNUM *p, *g;
+
+    p=BN_bin2bn(dh512_p,sizeof(dh512_p),NULL);
+    g=BN_bin2bn(dh512_g,sizeof(dh512_g),NULL);
+    if (p == NULL || g == NULL) {
+        BN_free(p); BN_free(g);
+        DH_free(dh); return(NULL);
+    } else
+        DH_set0_pqg(dh, p, NULL, g);
+#else
     dh->p=BN_bin2bn(dh512_p,sizeof(dh512_p),NULL);
     dh->g=BN_bin2bn(dh512_g,sizeof(dh512_g),NULL);
     if ((dh->p == NULL) || (dh->g == NULL))
             { DH_free(dh); return(NULL); }
+#endif
     return(dh);
 }
 /* END AUTOGENERATED */
